/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.admin.verifier.tests.StaticTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.WebModule;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebModuleTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext configContext) {
        Result result = super.getInitializedResult();
        try {
            Server server = (Server)configContext.getRootConfigBean();
            result.passed("Test Passed : ");
            Applications applications = server.getApplications();
            WebModule[] webModuleArray = applications.getWebModule();
            for (int i = 0; i < webModuleArray.length; ++i) {
                File file = new File(webModuleArray[i].getLocation());
                try {
                    if (file.exists()) {
                        result.passed("Test Passed ****");
                        continue;
                    }
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidDir", "Web Module location directory for " + webModuleArray[i].getName() + " is not valid", new Object[]{webModuleArray[i].getName()}));
                    continue;
                }
                catch (SecurityException securityException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".SecurityManagerExist", "Security Manager Exists, not possible to access Web Module location"));
                }
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
            result.failed("Exception : " + exception.getMessage());
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        Object object = configContextEvent.getObject();
        Result result = new Result();
        String string = configContextEvent.getBeanName();
        if (string != null) {
            String string2 = configContextEvent.getName();
            return this.testSave(string2, (String)object);
        }
        WebModule webModule = (WebModule)object;
        String string3 = webModule.getName();
        if (!StaticTest.checkObjectName(string3, result)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidWebModule", "Web Module Name Invalid"));
            return result;
        }
        result.passed(this.smh.getLocalString(this.getClass().getName() + ".validObj", "Valid Object Name"));
        String string4 = webModule.getLocation();
        File file = new File(string4);
        try {
            if (file.exists()) {
                result.passed("Test Passed ****");
            } else {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidDir1", "Web Module location directory is not valid"));
            }
        }
        catch (SecurityException securityException) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".SecurityManagerExist", "Security Manager Exists, not possible to access Web Module location"));
        }
        return result;
    }

    public Result testSave(String string, String string2) {
        Result result = new Result();
        result.passed("Passed **");
        if (string.equals(ServerTags.LOCATION)) {
            File file = new File(string2);
            try {
                if (file.exists()) {
                    result.passed("Test Passed ****");
                } else {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidDir1", "Web Module location directory is not valid"));
                }
            }
            catch (SecurityException securityException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".SecurityManagerExist", "Security Manager Exists, not possible to access Web Module location"));
            }
            return result;
        }
        if (string.equals(ServerTags.AVAILABILITY_ENABLED)) {
            try {
                if (string2.equals("true") || string2.equals("false")) {
                    result.passed("Passed ***");
                } else {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".availabilityEnabled", "Availability Enabled value should either be true or false "));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

