/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.MdbContainer;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MdbContainerTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext configContext) {
        Result result;
        block17: {
            result = super.getInitializedResult();
            try {
                String string;
                Server server = (Server)configContext.getRootConfigBean();
                MdbContainer mdbContainer = server.getMdbContainer();
                try {
                    string = mdbContainer.getSteadyPoolSize();
                    if (Integer.parseInt(string) < 0) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyPoolNegative", "Steady Pool size cannot be negative number"));
                    } else {
                        result.passed("Passed **");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyPoolInvalid", "Steady Pool Size : invalid number"));
                }
                try {
                    string = mdbContainer.getMaxPoolSize();
                    if (Integer.parseInt(string) < 0) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxPoolNegative", "Max Pool size cannot be negative number"));
                    } else {
                        result.passed("Passed **");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxPoolInvalid", "Max Pool Size : invalid number"));
                }
                try {
                    string = mdbContainer.getPoolResizeQuantity();
                    if (Integer.parseInt(string) < 0) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".resizeQtyNegative", "Pool Resize Qty cannot be negative number"));
                    } else {
                        result.passed("Passed **");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".resizeQtyInvalid", "Pool Resize  Qty : invalid number"));
                }
                try {
                    string = mdbContainer.getIdleTimeoutInSeconds();
                    if (Integer.parseInt(string) < 0) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".idleTimeoutNegative", "Idle Timeout in Seconds cannot be negative number"));
                        break block17;
                    }
                    result.passed("Passed **");
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".idleTimeoutInvalid", "Idle Timeout in Seconds : invalid number"));
                }
            }
            catch (Exception exception) {
                _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
                result.failed("Exception : " + exception.getMessage());
            }
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        Object object = configContextEvent.getObject();
        ConfigContext configContext = configContextEvent.getConfigContext();
        Result result = new Result();
        result.passed("Passed ** ");
        String string = configContextEvent.getBeanName();
        if (string != null) {
            String string2 = configContextEvent.getName();
            if (string2 != null && object != null) {
                result = this.validateAttribute(string2, (String)object);
            }
            return result;
        }
        return result;
    }

    public Result validateAttribute(String string, String string2) {
        Result result = new Result();
        boolean bl = false;
        result.passed("Passed **");
        if (string.equals(ServerTags.STEADY_POOL_SIZE)) {
            try {
                if (Integer.parseInt(string2) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyPoolNegative", "Steady Pool size cannot be negative number"));
                    bl = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyPoolInvalid", "Steady Pool Size : invalid number"));
                bl = true;
            }
        }
        if (string.equals(ServerTags.MAX_POOL_SIZE)) {
            try {
                if (Integer.parseInt(string2) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxPoolNegative", "Max Pool size cannot be negative number"));
                    bl = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxPoolInvalid", "Max Pool Size : invalid number"));
                bl = true;
            }
        }
        if (string.equals(ServerTags.POOL_RESIZE_QUANTITY)) {
            try {
                if (Integer.parseInt(string2) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".resizeQtyNegative", "Pool Resize Qty cannot be negative number"));
                    bl = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".resizeQtyInvalid", "Pool Resize  Qty : invalid number"));
                bl = true;
            }
        }
        if (string.equals(ServerTags.IDLE_TIMEOUT_IN_SECONDS)) {
            try {
                if (Integer.parseInt(string2) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".idleTimeoutNegative", "Idle Timeout in Seconds cannot be negative number"));
                    bl = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".idleTimeoutInvalid", "Idle Timeout in Seconds : invalid number"));
                bl = true;
            }
        }
        if (bl) {
            result.setStatus(1);
        }
        return result;
    }
}

