/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.admin.verifier.tests.StaticTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.JmsService;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmsServiceTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext configContext) {
        Result result;
        block9: {
            result = super.getInitializedResult();
            try {
                Server server = (Server)configContext.getRootConfigBean();
                JmsService jmsService = server.getJmsService();
                String string = jmsService.getPort();
                try {
                    if (StaticTest.isPortValid(Integer.parseInt(string))) {
                        result.passed(this.smh.getLocalString(this.getClass().getName() + ".validPort", "Valid Port"));
                    } else {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidJmsPort", "Invalid JMSService Port - " + string, new Object[]{string}));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidJmsPort", "Invalid JMSService Port - " + string, new Object[]{string}));
                }
                try {
                    String string2 = jmsService.getInitTimeoutInSeconds();
                    if (Integer.parseInt(string2) < 0) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".initTimeoutNegative", "Init Timeout cannot be negative number"));
                        break block9;
                    }
                    result.passed("** Passed ** ");
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".initTimeoutInvalid", "Init Timeout : invalid number"));
                }
            }
            catch (Exception exception) {
                _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
                result.failed("Exception : " + exception.getMessage());
            }
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        Result result = new Result();
        Object object = configContextEvent.getObject();
        String string = configContextEvent.getBeanName();
        if (string != null) {
            String string2 = configContextEvent.getName();
            return this.testSave(string2, (String)object);
        }
        JmsService jmsService = (JmsService)object;
        String string3 = jmsService.getPort();
        try {
            if (StaticTest.isPortValid(Integer.parseInt(string3))) {
                result.passed(this.smh.getLocalString(this.getClass().getName() + ".validPort", "Valid Port"));
            } else {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidJmsPort", "Invalid JMSService Port - " + string3, new Object[]{string3}));
            }
        }
        catch (NumberFormatException numberFormatException) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidJmsPortNum", "Invalid JMSService Port Number : " + string3, new Object[]{string3}));
        }
        return result;
    }

    public Result testSave(String string, String string2) {
        Result result = new Result();
        result.passed("Passed");
        if (string.equals(ServerTags.PORT)) {
            try {
                if (StaticTest.isPortValid(Integer.parseInt(string2))) {
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".validPort", "Valid Port"));
                } else {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidPort", "Invalid Port"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".badNum", "Bad Number"));
            }
        }
        if (string.equals(ServerTags.INIT_TIMEOUT_IN_SECONDS)) {
            try {
                if (Integer.parseInt(string2) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".initTimeoutNegative", "Init Timeout cannot be negative number"));
                } else {
                    result.passed("Passed **");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".initTimeoutInvalid", "Init Timeout : invalid number"));
            }
        }
        return result;
    }
}

