/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.admin.verifier.tests.StaticTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.JmsResource;
import com.iplanet.ias.config.serverbeans.Resources;
import com.iplanet.ias.config.serverbeans.Server;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmsResourceTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext configContext) {
        Result result = super.getInitializedResult();
        try {
            Server server = (Server)configContext.getRootConfigBean();
            Resources resources = server.getResources();
            JmsResource[] jmsResourceArray = resources.getJmsResource();
            for (int i = 0; i < jmsResourceArray.length; ++i) {
                String string = jmsResourceArray[i].getResType();
                if (string.equals("javax.jms.Topic") || string.equals("javax.jms.Queue") || string.equals("javax.jms.TopicConnectionFactory") || string.equals("javax.jms.QueueConnectionFactory")) {
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".validResource", "Passed : Valid resource type " + string + " for " + jmsResourceArray[i].getJndiName(), new Object[]{string, jmsResourceArray[i].getJndiName()}));
                    continue;
                }
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidResource", "Invalid Resource-Type " + string + " for " + jmsResourceArray[i].getJndiName(), new Object[]{string, jmsResourceArray[i].getJndiName()}));
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
            result.failed("Exception : " + exception.getMessage());
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        Result result = new Result();
        Object object = configContextEvent.getObject();
        String string = configContextEvent.getBeanName();
        if (string != null) {
            result.passed(this.smh.getLocalString(this.getClass().getName() + ".saveTo", "Save to be implemented"));
            return result;
        }
        JmsResource jmsResource = (JmsResource)object;
        String string2 = jmsResource.getJndiName();
        if (!StaticTest.checkObjectName(string2, result)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidJndi", "JMS Destination Jndi-Name Invalid "));
            return result;
        }
        result.passed(this.smh.getLocalString(this.getClass().getName() + ".validObj", "Valid Object Name"));
        String string3 = jmsResource.getResType();
        if (string3.equals("javax.jms.Topic") || string3.equals("javax.jms.Queue") || string3.equals("javax.jms.TopicConnectionFactory") || string3.equals("javax.jms.QueueConnectionFactory")) {
            result.passed(this.smh.getLocalString(this.getClass().getName() + ".validResource", "Passed : Valid resource type"));
        } else {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidResource", "Invalid Resource Type"));
        }
        return result;
    }
}

