/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.admin.verifier.tests.StaticTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.IiopListener;
import com.iplanet.ias.config.serverbeans.IiopService;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IiopListenerTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext configContext) {
        Result result = super.getInitializedResult();
        try {
            int n;
            Server server = (Server)configContext.getRootConfigBean();
            IiopService iiopService = server.getIiopService();
            IiopListener[] iiopListenerArray = iiopService.getIiopListener();
            int n2 = 0;
            for (n = 0; n < iiopListenerArray.length; ++n) {
                if (!iiopListenerArray[n].isEnabled()) continue;
                ++n2;
            }
            for (n = 0; n < iiopListenerArray.length; ++n) {
                String string = iiopListenerArray[n].getAddress();
                String string2 = iiopListenerArray[n].getPort();
                try {
                    if (!StaticTest.isPortValid(Integer.parseInt(string2))) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidIIOP", "Invalid IIOP Listener Port - " + string2, new Object[]{string2}));
                    } else {
                        result.passed(this.smh.getLocalString(this.getClass().getName() + ".validIIOP", "valid IIOP Listener Port"));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invlaidIIOPPort", "Port Number - " + string2 + " : Invalid", new Object[]{string2}));
                }
                if (string != null && string.equals("")) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".nullIP", "Host IP cannot be null String"));
                }
                try {
                    InetAddress.getByName(string).getHostName();
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".validIIOP", "valid IIOP Listener Port"));
                    continue;
                }
                catch (UnknownHostException unknownHostException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".hostNotResolvable", "Host name not resolvable - " + string, new Object[]{string}));
                }
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
            result.failed("Exception : " + exception.getMessage());
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        Result result = new Result();
        Object object = configContextEvent.getObject();
        String string = configContextEvent.getChoice();
        ConfigContext configContext = configContextEvent.getConfigContext();
        String string2 = configContextEvent.getBeanName();
        if (string2 != null) {
            return this.testSave(configContextEvent.getName(), configContextEvent.getObject());
        }
        IiopListener iiopListener = (IiopListener)object;
        String string3 = iiopListener.getId();
        if (!StaticTest.checkObjectName(string3, result)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidIIOPId", "IIOP Listener ID Invalid "));
            return result;
        }
        result.passed(this.smh.getLocalString(this.getClass().getName() + ".validObject", "Valid Object Name"));
        String string4 = iiopListener.getAddress();
        String string5 = iiopListener.getPort();
        if (string.equals("ADD")) {
            try {
                Server server = (Server)configContext.getRootConfigBean();
                IiopService iiopService = server.getIiopService();
                IiopListener[] iiopListenerArray = iiopService.getIiopListener();
                int n = 0;
                for (int i = 0; i < iiopListenerArray.length; ++i) {
                    if (!iiopListenerArray[i].isEnabled()) continue;
                    ++n;
                }
            }
            catch (Exception exception) {
                result.failed("Exception occured " + exception.getMessage());
            }
        }
        try {
            if (string5 != null && !string5.equals("")) {
                if (!StaticTest.isPortValid(Integer.parseInt(string5))) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidIIOP", "Invalid IIOP Listener Port - " + string5, new Object[]{string5}));
                    return result;
                }
                result.passed(this.smh.getLocalString(this.getClass().getName() + ".validIIOP", "valid IIOP Listener Port"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invlaidIIOPPort", "Port Number - " + string5 + " : Invalid", new Object[]{string5}));
            return result;
        }
        try {
            InetAddress.getByName(string4).getHostName();
            result.passed(this.smh.getLocalString(this.getClass().getName() + ".validIIOPIP", "Valid IIOP Listener IP"));
        }
        catch (UnknownHostException unknownHostException) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".hostNotResolvable", "Host name not resolvable - " + string4, new Object[]{string4}));
            return result;
        }
        return result;
    }

    public Result testSave(String string, Object object) {
        Result result = new Result();
        result.passed("Passed **");
        if (string.equals(ServerTags.ADDRESS)) {
            try {
                InetAddress.getByName((String)object).getHostName();
                result.passed(this.smh.getLocalString(this.getClass().getName() + ".validHTTPID", "Valid Http Listener IP Address"));
            }
            catch (UnknownHostException unknownHostException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".hostNotResolvable", "Host name not resolvable - " + (String)object, new Object[]{(String)object}));
            }
        }
        String string2 = (String)object;
        if (string.equals(ServerTags.PORT)) {
            try {
                if (!StaticTest.isPortValid(Integer.parseInt(string2))) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidIIOP", "Invalid IIOP Listener Port - " + string2, new Object[]{string2}));
                } else {
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".validIIOP", "valid IIOP Listener Port"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invlaidIIOPPort", "Port Number - " + string2 + " : Invalid", new Object[]{string2}));
            }
        }
        return result;
    }
}

