/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.admin.verifier.tests.StaticTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.AvailabilityService;
import com.iplanet.ias.config.serverbeans.IiopEndpoint;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IiopEndpointTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext configContext) {
        Result result = super.getInitializedResult();
        try {
            Server server = (Server)configContext.getRootConfigBean();
            AvailabilityService availabilityService = server.getAvailabilityService();
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
            result.failed("Exception : " + exception.getMessage());
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        Result result = new Result();
        Object object = configContextEvent.getObject();
        String string = configContextEvent.getChoice();
        ConfigContext configContext = configContextEvent.getConfigContext();
        String string2 = configContextEvent.getBeanName();
        if (string2 != null) {
            return this.testSave(configContextEvent.getName(), configContextEvent.getObject());
        }
        IiopEndpoint iiopEndpoint = (IiopEndpoint)object;
        String string3 = iiopEndpoint.getHost();
        String string4 = iiopEndpoint.getPort();
        try {
            if (string4 != null && !string4.equals("")) {
                if (!StaticTest.isPortValid(Integer.parseInt(string4))) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidIIOP", "Invalid IIOP Endpoint Port - " + string4, new Object[]{string4}));
                    return result;
                }
                result.passed(this.smh.getLocalString(this.getClass().getName() + ".validIIOP", "valid IIOP Endpoint Port"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidIIOPPort", "Port Number - " + string4 + " : Invalid", new Object[]{string4}));
            return result;
        }
        try {
            InetAddress.getByName(string3).getHostName();
            result.passed(this.smh.getLocalString(this.getClass().getName() + ".validIIOPEndpointIP", "Valid IIOP Endpoint IP"));
        }
        catch (UnknownHostException unknownHostException) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".hostNotResolvable", "Host name not resolvable - " + string3, new Object[]{string3}));
            return result;
        }
        return result;
    }

    public Result testSave(String string, Object object) {
        String string2;
        Result result = new Result();
        result.passed("Passed **");
        if (string.equals(ServerTags.ID) && ((string2 = (String)object) == null || string2.equals(""))) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".idIsNull", "IIOP Endpoint ID cannot be set to null"));
        }
        if (string.equals(ServerTags.HOST)) {
            string2 = (String)object;
            if (string2 == null || string2.equals("")) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".hostIsNull", "IIOP Endpoint Host cannot be set to null"));
                return result;
            }
            try {
                InetAddress.getByName((String)object).getHostName();
                result.passed(this.smh.getLocalString(this.getClass().getName() + ".validIIOPEndpointIP", "Valid IIOP Endpoint IP Address"));
            }
            catch (UnknownHostException unknownHostException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".hostNotResolvable", "Host name not resolvable - " + (String)object, new Object[]{(String)object}));
            }
        }
        string2 = (String)object;
        if (string.equals(ServerTags.PORT)) {
            try {
                if (!StaticTest.isPortValid(Integer.parseInt(string2))) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidIIOP", "Invalid IIOP Endpoint Port - " + string2, new Object[]{string2}));
                } else {
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".validIIOP", "valid IIOP Endpoint Port"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidIIOPPort", "Port Number - " + string2 + " : Invalid", new Object[]{string2}));
            }
        }
        return result;
    }
}

