/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.Acl;
import com.iplanet.ias.config.serverbeans.HttpService;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpServiceTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext configContext) {
        Result result = super.getInitializedResult();
        try {
            Server server = (Server)configContext.getRootConfigBean();
            HttpService httpService = server.getHttpService();
            String string = httpService.getQosMetricsIntervalInSeconds();
            String string2 = httpService.getQosRecomputeTimeIntervalInMillis();
            try {
                if (string != null) {
                    Long.parseLong(string);
                }
                result.passed(this.smh.getLocalString(this.getClass().getName() + ".validQOSMetric", "Http Service QOS Metric Interval in Seconds Valid " + string, new Object[]{string}));
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidQOSMetric", "Http Service QOS Metric Interval in Seconds invalid number - " + string, new Object[]{string}));
            }
            try {
                if (string2 != null) {
                    Long.parseLong(string2);
                }
                result.passed(this.smh.getLocalString(this.getClass().getName() + ".validQOSRecompute", "Http Service QOS Recompute time interval in millis Valid"));
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidQOSRecompute", "Http Service QOS Recompute time Interval in millis Invalid - " + string2, new Object[]{string2}));
            }
            Acl[] aclArray = httpService.getAcl();
            for (int i = 0; i < aclArray.length; ++i) {
                String string3 = aclArray[i].getFile();
                File file = new File(string3);
                try {
                    if (file.exists()) {
                        result.passed(this.smh.getLocalString(this.getClass().getName() + ".validACl", "Acl File Valid - " + string3, new Object[]{string3}));
                        continue;
                    }
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidACl", "Acl File Invalid - " + string3, new Object[]{string3}));
                    continue;
                }
                catch (SecurityException securityException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotAccessACL", "Acl File Not able to access - " + string3, new Object[]{string3}));
                }
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
            result.failed("Exception : " + exception.getMessage());
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        Object object = configContextEvent.getObject();
        Result result = new Result();
        String string = configContextEvent.getBeanName();
        result.passed("Passed***");
        if (string != null) {
            String string2 = configContextEvent.getName();
            result = this.testSave(string2, (String)object);
            return result;
        }
        HttpService httpService = (HttpService)object;
        String string3 = httpService.getQosMetricsIntervalInSeconds();
        String string4 = httpService.getQosRecomputeTimeIntervalInMillis();
        try {
            if (string3 != null) {
                Long.parseLong(string3);
            }
            result.passed(this.smh.getLocalString(this.getClass().getName() + ".validQOS", "QOS Metric Interval Valid Number : Passed"));
        }
        catch (NumberFormatException numberFormatException) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidQOS", "QOS Metric Interval Invalid Number " + string3, new Object[]{string3}));
        }
        try {
            if (string4 != null) {
                Long.parseLong(string4);
            }
            result.passed(this.smh.getLocalString(this.getClass().getName() + ".validQOSRecompute1", "QOS Recompute Interval Valid : Passed"));
        }
        catch (NumberFormatException numberFormatException) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidQOSRecompute1", " QOS Recompute time Interval Invalid Number " + string4, new Object[]{string4}));
        }
        Acl[] aclArray = httpService.getAcl();
        for (int i = 0; i < aclArray.length; ++i) {
            String string5 = aclArray[i].getFile();
            File file = new File(string5);
            try {
                if (file.exists()) {
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".aclPassed", "Acl File Valid - " + string5 + ": Passed", new Object[]{string5}));
                    continue;
                }
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".aclFailed", "Acl File Invalid - " + string5 + ": Failed", new Object[]{string5}));
                continue;
            }
            catch (SecurityException securityException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".aclFailed1", "Acl File Not able to access " + string5 + ": Failed", new Object[]{string5}));
            }
        }
        return result;
    }

    public Result testSave(String string, String string2) {
        Result result = new Result();
        result.passed("passed ** ");
        if (string.equals(ServerTags.QOS_METRICS_INTERVAL_IN_SECONDS)) {
            try {
                if (string2 != null) {
                    Long.parseLong(string2);
                }
                result.passed(this.smh.getLocalString(this.getClass().getName() + ".validQOS", "QOS Metrics Interval Valid Number "));
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidQOS", "QOS Metrics Interval Invalid Number " + string2, new Object[]{string2}));
            }
        }
        if (string.equals(ServerTags.QOS_RECOMPUTE_TIME_INTERVAL_IN_MILLIS)) {
            try {
                if (string2 != null) {
                    Long.parseLong(string2);
                }
                result.passed(this.smh.getLocalString(this.getClass().getName() + ".validQOSRecompute1", "QOS Recompute Time Interval Valid Number"));
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidQOSRecompute1", "QOS Recompute Time Interval Invalid Number " + string2, new Object[]{string2}));
            }
        }
        return result;
    }
}

