/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.admin.verifier.tests.StaticTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.HttpListener;
import com.iplanet.ias.config.serverbeans.HttpService;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.VirtualServer;
import com.iplanet.ias.config.serverbeans.VirtualServerClass;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpListenerTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    private static final String DELIMITER = ",";
    protected HttpListener thisListener;

    public Result check(ConfigContext configContext) {
        Result result = super.getInitializedResult();
        try {
            Server server = (Server)configContext.getRootConfigBean();
            HttpService httpService = server.getHttpService();
            HttpListener[] httpListenerArray = httpService.getHttpListener();
            String string = null;
            String string2 = null;
            for (int i = 0; i < httpListenerArray.length; ++i) {
                string = httpListenerArray[i].getPort();
                string2 = httpListenerArray[i].getAddress();
                try {
                    if (StaticTest.isPortValid(Integer.parseInt(string))) {
                        result.passed(this.smh.getLocalString(this.getClass().getName() + ".validHTTPPort", "HttpListener Port is valid - " + string, new Object[]{string}));
                    } else {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidHTTPPort", "Http Listener Port is Invalid - " + string, new Object[]{string}));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidHTTPPortNumber", "Invalid Number for Http Listener Port - " + string, new Object[]{string}));
                }
                try {
                    if (string2 == null || string2.equals("")) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".nullHTTPAddress", "Http Address cannot be Null"));
                        return result;
                    }
                    if (StaticTest.checkAddress(string2)) {
                        InetAddress.getByName(string2).getHostName();
                    }
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".validIP", "Valid Http Listener IP"));
                    continue;
                }
                catch (UnknownHostException unknownHostException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidIP", "Host name of Http Listener not resolvable - " + string2, new Object[]{string2}));
                }
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
            result.failed("Exception : " + exception.getMessage());
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        String string;
        HttpListener httpListener;
        Result result = new Result();
        Object object = configContextEvent.getObject();
        ConfigContext configContext = configContextEvent.getConfigContext();
        String string2 = configContextEvent.getBeanName();
        if (string2 != null) {
            String string3 = configContextEvent.getName();
            result = this.testSave(string3, (String)object, configContext);
            return result;
        }
        this.thisListener = httpListener = (HttpListener)object;
        if (configContextEvent.getChoice().equals("DELETE")) {
            try {
                Server server = (Server)configContext.getRootConfigBean();
                HttpService httpService = server.getHttpService();
                VirtualServerClass virtualServerClass = httpService.getVirtualServerClassById("defaultclass");
                VirtualServer[] virtualServerArray = virtualServerClass.getVirtualServer();
                for (int i = 0; virtualServerArray != null && i < virtualServerArray.length; ++i) {
                    String string4 = virtualServerArray[i].getHttpListeners();
                    if (string4 == null) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, DELIMITER);
                    StringBuffer stringBuffer = new StringBuffer("");
                    String string5 = "";
                    while (stringTokenizer.hasMoreTokens()) {
                        string5 = stringTokenizer.nextToken();
                        if (!string5.equals(this.thisListener.getId())) continue;
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".referencedListener", "This listener is being referenced by some virtual server. Please remove the reference and try again."));
                        return result;
                    }
                }
                result.passed(this.smh.getLocalString(this.getClass().getName() + ".integrityPassed", "Test passed for referential integrity"));
            }
            catch (Exception exception) {
                result.failed("Exception Caught : " + exception.getMessage());
            }
            return result;
        }
        String string6 = httpListener.getId();
        if (!StaticTest.checkObjectName(string6, result)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidListenerID", "Http Listener ID Invalid"));
            return result;
        }
        result.passed(this.smh.getLocalString(this.getClass().getName() + ".validObjName", "Valid Object Name"));
        try {
            if (!StaticTest.isPortValid(Integer.parseInt(httpListener.getPort()))) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidPortNumber", "Invalid Port Number"));
                return result;
            }
            result.passed("passed ***");
            string = httpListener.getPort();
            if (configContextEvent.getChoice().equals("ADD") && this.isPortUsed(string, configContext, result)) {
                return result;
            }
        }
        catch (NumberFormatException numberFormatException) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".numberFmtExc", "Number Format Exception"));
            return result;
        }
        string = httpListener.getAddress();
        try {
            if (string == null || string.equals("")) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".nullHTTPAddr", "Http Address cannot be Null value"));
                return result;
            }
            if (StaticTest.checkAddress(string)) {
                InetAddress.getByName(string).getHostName();
            }
            result.passed(this.smh.getLocalString(this.getClass().getName() + ".validIP", "Valid Http Listener IP Address"));
        }
        catch (UnknownHostException unknownHostException) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".hostNotResolvable", "Host name not resolvable - " + string, new Object[]{string}));
            return result;
        }
        String string7 = httpListener.getDefaultVirtualServer();
        try {
            Server server = (Server)configContext.getRootConfigBean();
            boolean bl = this.checkVSExists(string7, server);
            if (bl) {
                result.passed(this.smh.getLocalString(this.getClass().getName() + ".serverFound", "Virtual Server found in vs class"));
            } else {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".serverNotFound", "Virtual Server not found in vs class"));
            }
        }
        catch (Exception exception) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".serverNotAvailable", "Virtual Server specified not available"));
        }
        return result;
    }

    public Result testSave(String string, String string2, ConfigContext configContext) {
        Result result = new Result();
        result.passed("Passed ");
        if (string.equals(ServerTags.ADDRESS)) {
            try {
                if (string2 == null || string2.equals("")) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".nullHTTPAddr", "Http Address cannot be Null"));
                    return result;
                }
                if (StaticTest.checkAddress(string2)) {
                    InetAddress.getByName(string2).getHostName();
                }
                result.passed(this.smh.getLocalString(this.getClass().getName() + ".validIP", "Valid Http Listener IP Address"));
            }
            catch (UnknownHostException unknownHostException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".hostNotResolvable", "Host name not resolvable - " + string2, new Object[]{string2}));
            }
        }
        if (string.equals(ServerTags.PORT)) {
            try {
                if (StaticTest.isPortValid(Integer.parseInt(string2))) {
                    result.passed("passed ***");
                } else {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidPortNumber", "Invalid Port Number"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".numberFmtExc", "Number Format Exception"));
            }
        }
        return result;
    }

    private boolean checkVSExists(String string, Server server) {
        boolean bl = false;
        VirtualServerClass[] virtualServerClassArray = server.getHttpService().getVirtualServerClass();
        for (int i = 0; i < virtualServerClassArray.length; ++i) {
            VirtualServer[] virtualServerArray = virtualServerClassArray[i].getVirtualServer();
            for (int j = 0; j < virtualServerArray.length; ++j) {
                if (!string.equals(virtualServerArray[j].getId())) continue;
                bl = true;
                return bl;
            }
        }
        return bl;
    }

    public boolean isPortUsed(String string, ConfigContext configContext, Result result) {
        result.passed("...");
        boolean bl = false;
        try {
            Server server = (Server)configContext.getRootConfigBean();
            HttpListener[] httpListenerArray = server.getHttpService().getHttpListener();
            for (int i = 0; i < httpListenerArray.length; ++i) {
                if (this.thisListener.getId().equals(httpListenerArray[i].getId()) || !string.equals(httpListenerArray[i].getPort()) || !this.thisListener.getAddress().equals(httpListenerArray[i].getAddress())) continue;
                bl = true;
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".portInUSe", "Port Already In Use by : " + httpListenerArray[i].getId(), new Object[]{httpListenerArray[i].getId()}));
                break;
            }
        }
        catch (Exception exception) {
            result.failed("Exception Caught : " + exception.getMessage());
        }
        return bl;
    }
}

