/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.snmp;

import com.iplanet.ias.admin.common.domains.registry.DomainEntry;
import com.iplanet.ias.admin.common.domains.registry.DomainRegistry;
import com.iplanet.ias.admin.common.domains.registry.DomainRegistryException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

public class ExtractDomainRoots {
    public String[] getAllDomainRoots() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = null;
        try {
            DomainRegistry domainRegistry = DomainRegistry.newInstance();
            Iterator iterator = domainRegistry.iterator();
            while (iterator.hasNext()) {
                DomainEntry domainEntry = (DomainEntry)iterator.next();
                vector.addElement(domainEntry.getRoot().getPath());
            }
            stringArray = new String[vector.size()];
            stringArray = vector.toArray(stringArray);
        }
        catch (DomainRegistryException domainRegistryException) {
            System.err.println("ExtractDomainRoots: Exception caught, while parsing the domain registry");
            domainRegistryException.printStackTrace();
        }
        return stringArray;
    }

    public void writeDomainInfo(String[] stringArray) {
        String string = new String("/tmp/appserv_domainInfo.txt");
        try {
            File file = new File(string);
            FileWriter fileWriter = new FileWriter(file);
            for (int i = 0; i < stringArray.length; ++i) {
                fileWriter.write(stringArray[i]);
                fileWriter.write("\n");
                System.out.println(stringArray[i]);
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("ExtractDomainRoots: IOException caught while writing domain information to file");
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("ExtractDomainRoots: Exception caught while writing domain information to file");
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        ExtractDomainRoots extractDomainRoots = new ExtractDomainRoots();
        String[] stringArray2 = extractDomainRoots.getAllDomainRoots();
        extractDomainRoots.writeDomainInfo(stringArray2);
    }
}

