/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.meta;

import com.iplanet.ias.admin.server.core.jmx.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class MBeanInfoBuilder {
    public static final String kSetterPrefix = "set";
    public static final String kGetterPrefix = "get";
    private Class mClass = null;
    private MBeanOperationInfo[] mOperations = null;
    private MBeanAttributeInfo[] mAttributes = null;
    private MBeanConstructorInfo[] mConstructors = null;
    private MBeanNotificationInfo[] mNotifications = null;
    private MBeanInfo mMBeanInfo = null;

    public MBeanInfoBuilder(Class clazz) throws IntrospectionException {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this.mClass = clazz;
        this.createOperations();
        this.createConstructors();
        this.createAttributes();
        this.createMBeanInfo();
        this.createNotifications();
    }

    public MBeanInfoBuilder(String string) {
    }

    public MBeanInfoBuilder(String string, ClassLoader classLoader) {
    }

    public MBeanOperationInfo[] getMBeanOperations() {
        return this.mOperations;
    }

    public MBeanConstructorInfo[] getMBeanConstructors() {
        return this.mConstructors;
    }

    public MBeanInfo getMBeanInfo() {
        return this.mMBeanInfo;
    }

    public MBeanAttributeInfo[] getMBeanAttributes() {
        return this.mAttributes;
    }

    private void createOperations() {
        Vector<String> vector = new Vector<String>();
        vector.add("java.lang.Object");
        vector.add("com.iplanet.ias.admin.server.core.mbean.config.AdminBase");
        Introspector introspector = new Introspector(this.mClass);
        Method[] methodArray = introspector.getCallableInstanceMethods(vector);
        Vector<MBeanOperationInfo> vector2 = new Vector<MBeanOperationInfo>();
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            boolean bl = string.startsWith(kGetterPrefix);
            boolean bl2 = string.startsWith(kSetterPrefix);
            if (bl || bl2) continue;
            vector2.add(new MBeanOperationInfo(string, methodArray[i]));
        }
        this.mOperations = new MBeanOperationInfo[vector2.size()];
        vector2.toArray(this.mOperations);
    }

    private void createConstructors() {
        Constructor<?>[] constructorArray = this.mClass.getConstructors();
        this.mConstructors = new MBeanConstructorInfo[constructorArray.length];
        for (int i = 0; i < constructorArray.length; ++i) {
            MBeanConstructorInfo mBeanConstructorInfo;
            String string = constructorArray[i].getName();
            this.mConstructors[i] = mBeanConstructorInfo = new MBeanConstructorInfo(string, constructorArray[i]);
        }
    }

    private void createNotifications() {
    }

    private void createMBeanInfo() {
        this.mMBeanInfo = new MBeanInfo(this.mClass.getName(), this.mClass.getName(), this.mAttributes, this.mConstructors, this.mOperations, this.mNotifications);
    }

    private void createAttributes() throws IntrospectionException {
        Vector<MBeanAttributeInfo> vector = new Vector<MBeanAttributeInfo>();
        Method[] methodArray = new Introspector(this.mClass).getDeclaredConcretePublicMethods();
        Method[] methodArray2 = this.getGetters(methodArray);
        Method[] methodArray3 = this.getSetters(methodArray);
        for (int i = 0; i < methodArray2.length; ++i) {
            MBeanAttributeInfo mBeanAttributeInfo = null;
            String string = methodArray2[i].getName();
            String string2 = this.getAttributeNameFromGetter(string);
            Method method = this.findAttrIn(string2, methodArray2);
            Method method2 = this.findAttrIn(string2, methodArray3);
            boolean bl = method != null;
            boolean bl2 = method2 != null;
            boolean bl3 = false;
            mBeanAttributeInfo = new MBeanAttributeInfo(string2, null, string2, bl, bl2, bl3);
            vector.add(mBeanAttributeInfo);
        }
        this.mAttributes = new MBeanAttributeInfo[vector.size()];
        vector.toArray(this.mAttributes);
    }

    private Method[] getGetters(Method[] methodArray) {
        Vector<Method> vector = new Vector<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            if (!string.startsWith(kGetterPrefix)) continue;
            vector.add(methodArray[i]);
        }
        Method[] methodArray2 = new Method[vector.size()];
        return vector.toArray(methodArray2);
    }

    private Method[] getSetters(Method[] methodArray) {
        Vector<Method> vector = new Vector<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            if (!string.startsWith(kSetterPrefix)) continue;
            vector.add(methodArray[i]);
        }
        Method[] methodArray2 = new Method[vector.size()];
        return vector.toArray(methodArray2);
    }

    private String getAttributeNameFromGetter(String string) {
        int n = string.indexOf(kGetterPrefix);
        int n2 = n + kGetterPrefix.length();
        return string.substring(n2);
    }

    private Method findAttrIn(String string, Method[] methodArray) {
        Method method = null;
        boolean bl = false;
        for (int i = 0; i < methodArray.length; ++i) {
            String string2 = methodArray[i].getName();
            if (!string2.endsWith(string)) continue;
            method = methodArray[i];
            break;
        }
        return method;
    }
}

