/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.meta;

import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.util.i18n.StringManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class MBeanEasyConfig {
    private static StringManager localStrings = StringManager.getManager(MBeanEasyConfig.class);
    static final String DESCR_LINE_DELIMITER = ",";
    static final String STRINGSOUREC_FILENAME = "MBeanConfig.properties";
    static final String EXCEPTION_LINE_EMPTY = localStrings.getString("admin.server.core.mbean.meta.empty_description_line");
    static final String EXCEPTION_WRONG_LINE_FORMAT = localStrings.getString("admin.server.core.mbean.meta.wrong_fields_number_in_description_line");
    static final String EXCEPTION_NAME_FLD_EMPTY = localStrings.getString("admin.server.core.mbean.meta.empty_name_in_description_line");
    static final String EXCEPTION_CLASSNAME_FLD_EMPTY = localStrings.getString("admin.server.core.mbean.meta.empty_classname_in_description_line");
    static final String EXCEPTION_UNKNOWN_RWTYPE = localStrings.getString("admin.server.core.mbean.meta.unknown_rw_type_in_description_line");
    static final String EXCEPTION_UNKNOWN_IMPACT_TYPE = localStrings.getString("admin.server.core.mbean.meta.unknown_impact_type_in_description");
    static final String EXCEPTION_OPER_NOT_FOUND = localStrings.getString("admin.server.core.mbean.meta.unfound_operation_in_bean_class");
    static final String EXCEPTION_WRONG_PARAM_FORMAT = localStrings.getString("admin.server.core.mbean.meta.wrong_operation_parameter_in_description");
    static final String EXCEPTION_WRONG_PARAM_DIM = localStrings.getString("admin.server.core.mbean.meta.wrong_operation_parameter_dimension_in_description");
    static final String EXCEPTION_WRONG_PARAM_CLASS = localStrings.getString("admin.server.core.mbean.meta.wrong_parameter_attribute_class_in_description");
    static final String EXCEPTION_EMPTY_PARAM_TYPE = localStrings.getString("admin.server.core.mbean.meta.empty_parameter_attribute_type_in_description_line");
    static final String TYPE_INFO = "INFO";
    static final String TYPE_ACTION = "ACTION";
    static final String TYPE_ACTION_INFO = "ACTION_INFO";
    static final String TYPE_UNKNOWN = "UNKNOWN";
    private MBeanAttributeInfo[] m_attrs = new MBeanAttributeInfo[0];
    private MBeanConstructorInfo[] m_cstrs = new MBeanConstructorInfo[0];
    private MBeanOperationInfo[] m_opers = new MBeanOperationInfo[0];
    private MBeanNotificationInfo[] m_notfs = new MBeanNotificationInfo[0];
    private Class m_beanClass = null;
    private String m_descr = null;
    static Object[][] convTable = new Object[][]{{"byte", "B", Byte.TYPE, "java.lang.Byte"}, {"char", "C", Character.TYPE, "java.lang.Character"}, {"double", "D", Double.TYPE, "java.lang.Double"}, {"float", "F", Float.TYPE, "java.lang.Float"}, {"int", "I", Integer.TYPE, "java.lang.Integer"}, {"long", "J", Long.TYPE, "java.lang.Long"}, {"short", "S", Short.TYPE, "java.lang.Short"}, {"boolean", "Z", Boolean.TYPE, "java.lang.Boolean"}, {"void", "V", Void.TYPE, "?"}};

    public MBeanEasyConfig(Class clazz, String[] stringArray, String[] stringArray2, String string) throws MBeanConfigException {
        this.m_beanClass = clazz;
        this.m_descr = string;
        if (this.m_descr == null || this.m_descr.length() == 0) {
            this.m_descr = "" + MBeanEasyConfig.getPureClassName(clazz) + ".mbean";
        }
        this.m_attrs = MBeanEasyConfig.createAttributesInfo(this.m_beanClass, stringArray);
        this.m_cstrs = MBeanEasyConfig.createConstructorsInfo(this.m_beanClass, null);
        this.m_opers = MBeanEasyConfig.createOperationsInfo(this.m_beanClass, stringArray2);
    }

    public static MBeanAttributeInfo[] createAttributesInfo(Class clazz, String[] stringArray) throws MBeanConfigException {
        if (stringArray == null || stringArray.length < 1) {
            return new MBeanAttributeInfo[0];
        }
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[stringArray.length];
        String string = MBeanEasyConfig.getPureClassName(clazz);
        for (int i = 0; i < stringArray.length; ++i) {
            mBeanAttributeInfoArray[i] = MBeanEasyConfig.parseAttributeDescrLine(string, stringArray[i]);
        }
        return mBeanAttributeInfoArray;
    }

    public static MBeanOperationInfo[] createOperationsInfo(Class clazz, String[] stringArray) throws MBeanConfigException {
        if (clazz == null) {
            return new MBeanOperationInfo[0];
        }
        if (stringArray == null || stringArray.length < 1) {
            return new MBeanOperationInfo[0];
        }
        ArrayList<MBeanOperationInfo> arrayList = new ArrayList<MBeanOperationInfo>();
        for (int i = 0; i < stringArray.length; ++i) {
            MBeanOperationInfo[] mBeanOperationInfoArray = MBeanEasyConfig.parseOperationDescrLine(clazz, stringArray[i]);
            for (int j = 0; j < mBeanOperationInfoArray.length; ++j) {
                arrayList.add(mBeanOperationInfoArray[j]);
            }
        }
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[arrayList.size()];
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            mBeanOperationInfoArray[i] = (MBeanOperationInfo)arrayList.get(i);
        }
        return mBeanOperationInfoArray;
    }

    public static MBeanConstructorInfo[] createConstructorsInfo(Class clazz, String string) {
        Object object;
        if (clazz == null) {
            return new MBeanConstructorInfo[0];
        }
        if (string == null) {
            object = MBeanEasyConfig.getPureClassName(clazz) + ".constructor";
            string = MBeanEasyConfig.getResourceString(object, object);
        }
        object = clazz.getConstructors();
        MBeanConstructorInfo[] mBeanConstructorInfoArray = new MBeanConstructorInfo[((Constructor<?>[])object).length];
        for (int i = 0; i < ((Constructor<?>[])object).length; ++i) {
            mBeanConstructorInfoArray[i] = new MBeanConstructorInfo(string, object[i]);
        }
        return mBeanConstructorInfoArray;
    }

    public MBeanInfo getMBeanInfo() {
        if (this.m_beanClass == null) {
            return null;
        }
        return new MBeanInfo(this.m_beanClass.getName(), this.m_descr, this.m_attrs, this.m_cstrs, this.m_opers, this.m_notfs);
    }

    public void setMBeanDescription(String string) {
        this.m_descr = string;
    }

    public void setAttributesInfo(MBeanAttributeInfo[] mBeanAttributeInfoArray) {
        if (mBeanAttributeInfoArray == null) {
            mBeanAttributeInfoArray = new MBeanAttributeInfo[]{};
        }
        this.m_attrs = mBeanAttributeInfoArray;
    }

    public void setOperationsInfo(MBeanConstructorInfo[] mBeanConstructorInfoArray) {
        if (mBeanConstructorInfoArray == null) {
            mBeanConstructorInfoArray = new MBeanConstructorInfo[]{};
        }
        this.m_cstrs = mBeanConstructorInfoArray;
    }

    public void setOperationsInfo(MBeanOperationInfo[] mBeanOperationInfoArray) {
        if (mBeanOperationInfoArray == null) {
            mBeanOperationInfoArray = new MBeanOperationInfo[]{};
        }
        this.m_opers = mBeanOperationInfoArray;
    }

    public void setNotificationsInfo(MBeanNotificationInfo[] mBeanNotificationInfoArray) {
        if (mBeanNotificationInfoArray == null) {
            mBeanNotificationInfoArray = new MBeanNotificationInfo[]{};
        }
        this.m_notfs = mBeanNotificationInfoArray;
    }

    public static Object convertStringValueToProperType(String string, String string2) throws MBeanConfigException {
        if (string == null) {
            return null;
        }
        try {
            Class clazz = MBeanEasyConfig.getPrimitiveClass(string2);
            if (clazz != null || (clazz = MBeanEasyConfig.getRelatedPrimitiveClass(string2)) != null) {
                if (clazz == Byte.TYPE) {
                    return new Byte(string);
                }
                if (clazz == Character.TYPE) {
                    return new Character(string.charAt(0));
                }
                if (clazz == Double.TYPE) {
                    return new Double(string);
                }
                if (clazz == Float.TYPE) {
                    return new Float(string);
                }
                if (clazz == Integer.TYPE) {
                    return new Integer(string);
                }
                if (clazz == Long.TYPE) {
                    return new Long(string);
                }
                if (clazz == Short.TYPE) {
                    return new Short(string);
                }
                if (clazz == Boolean.TYPE) {
                    return new Boolean(string);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string3 = localStrings.getString("admin.server.core.mbean.meta.convertstringvaluetopropertype_wrong_argument_type", illegalArgumentException.getMessage());
            throw new MBeanConfigException(string3);
        }
        return string;
    }

    private static MBeanAttributeInfo parseAttributeDescrLine(String string, String string2) throws MBeanConfigException {
        boolean bl = false;
        boolean bl2 = false;
        if (string2 == null) {
            String string3 = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_exception_line_empty", EXCEPTION_LINE_EMPTY);
            throw new MBeanConfigException(string3);
        }
        String[] stringArray = MBeanEasyConfig.getLineFields(string2, 4);
        if (stringArray.length < 3 || stringArray.length > 4) {
            String string4 = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_WRONG_LINE_FORMAT, string2);
            throw new MBeanConfigException(string4);
        }
        String string5 = stringArray[0];
        if (string5.length() == 0) {
            String string6 = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_NAME_FLD_EMPTY, string2);
            throw new MBeanConfigException(string6);
        }
        String string7 = stringArray[1];
        if (string7.length() == 0) {
            String string8 = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_CLASSNAME_FLD_EMPTY, string2);
            throw new MBeanConfigException(string8);
        }
        string7 = MBeanEasyConfig.convertTypeToSignatureClass(string7).getName();
        String string9 = stringArray[2];
        if (string9.equals("R")) {
            bl = true;
        } else if (string9.equals("W")) {
            bl2 = true;
        } else if (string9.equals("RW") || string9.equals("WR")) {
            bl2 = true;
            bl = true;
        } else {
            String string10 = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_UNKNOWN_RWTYPE, string2);
            throw new MBeanConfigException(string10);
        }
        String string11 = string + "." + string5 + ".attribute";
        String string12 = stringArray.length < 4 || stringArray[3].length() == 0 ? MBeanEasyConfig.getResourceString(string11, string11) : MBeanEasyConfig.getResourceString(stringArray[3], string11);
        return new MBeanAttributeInfo(string5, string7, string12, bl, bl2, false);
    }

    private static MBeanOperationInfo[] parseOperationDescrLine(Class clazz, String string) throws MBeanConfigException {
        Method method;
        int n;
        if (string == null) {
            String string2 = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_exception_line_empty", EXCEPTION_LINE_EMPTY);
            throw new MBeanConfigException(string2);
        }
        int n2 = string.indexOf(40);
        if (n2 <= 0 || n2 == string.length() - 1) {
            String string3 = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_WRONG_PARAM_FORMAT, string);
            throw new MBeanConfigException(string3);
        }
        String string4 = string.substring(0, n2).trim();
        if (string4.length() == 0) {
            String string5 = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_NAME_FLD_EMPTY, string);
            throw new MBeanConfigException(string5);
        }
        int n3 = string.indexOf(41, n2 + 1);
        if (n3 <= 0) {
            String string6 = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_WRONG_PARAM_FORMAT, string);
            throw new MBeanConfigException(string6);
        }
        Object[] objectArray = MBeanEasyConfig.decomposeParametersDescription(string.substring(n2 + 1, n3));
        String[] stringArray = MBeanEasyConfig.getLineFields(string.substring(n3), 3);
        if (stringArray.length < 2) {
            String string7 = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_WRONG_LINE_FORMAT, string);
            throw new MBeanConfigException(string7);
        }
        String string8 = stringArray[1];
        if (string8.equals(TYPE_INFO)) {
            n = 0;
        } else if (string8.equals(TYPE_ACTION)) {
            n = 1;
        } else if (string8.equals(TYPE_ACTION_INFO)) {
            n = 2;
        } else if (string8.equals(TYPE_UNKNOWN)) {
            n = 3;
        } else {
            String string9 = localStrings.getString("admin.server.core.mbean.meta.parseattributedescrline_wrong_exception_format", EXCEPTION_UNKNOWN_IMPACT_TYPE, string);
            throw new MBeanConfigException(string9);
        }
        String string10 = MBeanEasyConfig.getPureClassName(clazz);
        String string11 = string10 + "." + string4 + ".operation";
        String string12 = stringArray.length < 3 || stringArray[2].length() == 0 ? MBeanEasyConfig.getResourceString(string11, string11) : MBeanEasyConfig.getResourceString(stringArray[2], string11);
        Class[] classArray = new Class[objectArray.length / 3];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = (Class)objectArray[i * 3];
        }
        try {
            method = clazz.getMethod(string4, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string13 = localStrings.getString("admin.server.core.mbean.meta.parseoperationdescrline_wrong_exception_format", EXCEPTION_OPER_NOT_FOUND, string);
            throw new MBeanConfigException(string13);
        }
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            String string14;
            String string15 = (String)objectArray[i * 3 + 1];
            if (string15 == null) {
                string15 = "";
            }
            if ((string14 = (String)objectArray[i * 3 + 2]) == null) {
                string14 = string15.length() > 0 ? string10 + "." + string4 + "." + string15 + ".parameter" : "";
            }
            mBeanParameterInfoArray[i] = new MBeanParameterInfo(string15, classArray[i].getName(), string14);
        }
        return new MBeanOperationInfo[]{new MBeanOperationInfo(string4, string12, mBeanParameterInfoArray, method.getReturnType().getName(), n)};
    }

    private static String[] getLineFields(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = 100;
        if (string == null || string.length() == 0 || n == 0) {
            return null;
        }
        while (n3 > 0 && n > arrayList.size() && n2 < string.length()) {
            n3 = string.indexOf(DESCR_LINE_DELIMITER, n2);
            if (n3 < 0) {
                arrayList.add(string.substring(n2).trim());
            } else {
                arrayList.add(string.substring(n2, n3).trim());
            }
            n2 = n3 + 1;
            if (n3 != string.length()) continue;
            arrayList.add("");
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    static String getResourceString(String string, String string2) {
        return string;
    }

    private static Method[] getMethodsForName(Class clazz, String string) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Method[] methodArray = clazz.getMethods();
        if (methodArray == null) {
            return null;
        }
        for (int i = 0; i < methodArray.length; ++i) {
            if (!string.equals(methodArray[i].getName())) continue;
            arrayList.add(methodArray[i]);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Method[] methodArray2 = new Method[arrayList.size()];
        for (int i = 0; i < methodArray2.length; ++i) {
            methodArray2[i] = (Method)arrayList.get(i);
        }
        return methodArray2;
    }

    /*
     * Loose catch block
     */
    private static Class convertTypeToSignatureClass(String string) throws MBeanConfigException {
        block11: {
            int n = (string = string.trim()).indexOf("[");
            if (n == 0 || string.length() == 0) {
                String string2 = localStrings.getString("admin.server.core.mbean.meta.converttypetosignatureclass_wrong_exception_format", EXCEPTION_EMPTY_PARAM_TYPE, string);
                throw new MBeanConfigException(string2);
            }
            if (n > 0) {
                String string3 = string.substring(0, n).trim();
                if (string3.length() == 0) {
                    String string4 = localStrings.getString("admin.server.core.mbean.meta.converttypetosignatureclass_wrong_exception_format", EXCEPTION_EMPTY_PARAM_TYPE, string);
                    throw new MBeanConfigException(string4);
                }
                String string5 = MBeanEasyConfig.getPrimitiveCode(string3);
                if (string5 == null) {
                    if (string3.indexOf(46) < 0) {
                        string3 = "java.lang." + string3;
                    }
                    return Class.forName(MBeanEasyConfig.getArrayPrefix(string, n) + "L" + string3 + ";");
                }
                return Class.forName(MBeanEasyConfig.getArrayPrefix(string, n) + string5);
            }
            Class clazz = MBeanEasyConfig.getPrimitiveClass(string);
            if (clazz == null) break block11;
            return clazz;
            {
                catch (ClassNotFoundException classNotFoundException) {
                    String string6 = localStrings.getString("admin.server.core.mbean.meta.converttypetosignatureclass_wrong_exception_format", EXCEPTION_WRONG_PARAM_CLASS, string);
                    throw new MBeanConfigException(string6);
                }
            }
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (string.indexOf(46) > 0) {
                String string7 = localStrings.getString("admin.server.core.mbean.meta.converttypetosignatureclass_wrong_exception_format", EXCEPTION_WRONG_PARAM_CLASS, string);
                throw new MBeanConfigException(string7);
            }
            return Class.forName("java.lang." + string);
        }
    }

    private static String getArrayPrefix(String string, int n) throws MBeanConfigException {
        String string2 = "";
        int n2 = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '[') {
                string2 = string2 + "[";
            } else if (string.charAt(n) == ']') {
                ++n2;
            }
            ++n;
        }
        if (string2.length() != n2) {
            String string3 = localStrings.getString("admin.server.core.mbean.meta.getarrayprefix_wrong_exception_format", EXCEPTION_WRONG_PARAM_DIM, string);
            throw new MBeanConfigException(string3);
        }
        return string2;
    }

    private static Object findConvTableElemByType(String string, int n) {
        for (int i = 0; i < convTable.length; ++i) {
            if (!string.equals((String)convTable[i][0])) continue;
            return convTable[i][n];
        }
        return null;
    }

    private static Object findConvTableElemByAssoClassName(String string, int n) {
        for (int i = 0; i < convTable.length; ++i) {
            if (!string.equals((String)convTable[i][3])) continue;
            return convTable[i][n];
        }
        return null;
    }

    private static String getPrimitiveCode(String string) {
        return (String)MBeanEasyConfig.findConvTableElemByType(string, 1);
    }

    private static Class getPrimitiveClass(String string) {
        return (Class)MBeanEasyConfig.findConvTableElemByType(string, 2);
    }

    private static Class getRelatedPrimitiveClass(String string) {
        return (Class)MBeanEasyConfig.findConvTableElemByAssoClassName(string, 2);
    }

    private static Object[] decomposeParametersDescription(String string) throws MBeanConfigException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        int n2 = 100;
        int n3 = (string = string.trim()).length();
        if (n3 == 0) {
            return new Object[0];
        }
        while (n < n3) {
            int n4 = string.indexOf(44, n);
            if (n4 < 0) {
                n4 = n3;
            }
            if ((n2 = string.indexOf(32, n)) > n4) {
                n2 = n4;
            }
            if (n2 < 0) {
                arrayList.add(MBeanEasyConfig.convertTypeToSignatureClass(string.substring(n)));
                n2 = n4;
            } else {
                arrayList.add(MBeanEasyConfig.convertTypeToSignatureClass(string.substring(n, n2)));
            }
            for (n = n2 + 1; n < n4 && string.charAt(n) == ' '; ++n) {
            }
            if (n >= n4) {
                arrayList.add(null);
                arrayList.add(null);
                if (n == n4) {
                    ++n;
                }
                while (n < n3 && string.charAt(n) == ' ') {
                    ++n;
                }
                continue;
            }
            n2 = string.indexOf(32, n);
            if (n2 > n4) {
                n2 = n4;
            }
            if (n2 < 0) {
                arrayList.add(string.substring(n).trim());
                n2 = n4;
            } else {
                arrayList.add(string.substring(n, n2).trim());
            }
            for (n = n2 + 1; n < n4 && string.charAt(n) == ' '; ++n) {
            }
            if (n >= n4) {
                arrayList.add(null);
                if (n == n4) {
                    ++n;
                }
                while (n < n3 && string.charAt(n) == ' ') {
                    ++n;
                }
                continue;
            }
            n2 = string.indexOf(44, n);
            if (n2 < 0) {
                arrayList.add(string.substring(n).trim());
                n2 = n3;
            } else {
                arrayList.add(string.substring(n, n2).trim());
            }
            for (n = n2 + 1; n < n3 && string.charAt(n) == ' '; ++n) {
            }
        }
        Object[] objectArray = new Object[arrayList.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = arrayList.get(i);
        }
        return objectArray;
    }

    private static String getPureClassName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }
}

