/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config.naming;

import com.iplanet.ias.admin.common.Name;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.server.core.mbean.config.naming.ConfigMBeanNamingInfo;
import com.iplanet.ias.admin.server.core.mbean.config.naming.MBeanNamingDescriptor;
import com.iplanet.ias.admin.server.core.mbean.config.naming.MBeansDescriptions;
import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigBeansFactory;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.instance.InstanceEnvironment;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class ConfigMBeansNaming
extends MBeansDescriptions {
    static MBeanNamingDescriptor[] m_mbeanDescr = ConfigMBeansNaming.initConfigMBeanNaming();
    public static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final String MSG_FINDNAMINDESCRIPTOR_FAILED = "mbean.config.findnamingdescriptor_failed";
    private static final String MSG_MALFORMED_DOTTED_NAME = "mbean.config.malformed_dotted_name";
    private static final String MSG_EXCEPTION_DURING_LIST_NAMES = "mbean.config.list_names_failed";

    static MBeanNamingDescriptor findNamingDescriptorByType(String string) {
        try {
            for (int i = 0; i < m_mbeanDescr.length; ++i) {
                if (!string.equals(m_mbeanDescr[i].getType())) continue;
                return m_mbeanDescr[i];
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.FINE, MSG_FINDNAMINDESCRIPTOR_FAILED, exception);
        }
        return null;
    }

    static MBeanNamingDescriptor findNamingDescriptor(String string) {
        try {
            Name name = new Name(string);
            for (int i = 0; i < m_mbeanDescr.length; ++i) {
                if (!m_mbeanDescr[i].isDottedPatternMatch(name)) continue;
                return m_mbeanDescr[i];
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.FINE, MSG_FINDNAMINDESCRIPTOR_FAILED, exception);
        }
        return null;
    }

    static MBeanNamingDescriptor findNamingDescriptor(ObjectName objectName) {
        try {
            Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
            for (int i = 0; i < m_mbeanDescr.length; ++i) {
                if (!m_mbeanDescr[i].isObjectNamePatternMatch(hashtable)) continue;
                return m_mbeanDescr[i];
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.FINE, MSG_FINDNAMINDESCRIPTOR_FAILED, exception);
        }
        return null;
    }

    public static String[] findNameContinuation(String string, String string2) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        int n = -1;
        Name name = null;
        int n2 = 0;
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string);
        try {
            name = new Name(string2);
            n2 = name.getNumParts();
        }
        catch (Exception exception) {
            sLogger.log(Level.FINE, MSG_MALFORMED_DOTTED_NAME, exception);
            return new String[0];
        }
        for (int i = 0; i < m_mbeanDescr.length; ++i) {
            object = m_mbeanDescr[i].getDottedTokens();
            if (object == null) continue;
            for (int j = 0; j < ((Object[][])object).length; ++j) {
                if (!MBeanNamingDescriptor.isDottedPatternMatch(name, object[j], false) || ((Object)object[j]).length <= n2) continue;
                if (!(object[j][n2] instanceof String)) {
                    if (((Object)object[j]).length != n2 + 1) continue;
                    n = i;
                    continue;
                }
                hashSet.add(string2 + "." + object[j][n2]);
            }
        }
        String string3 = null;
        if (n >= 0) {
            try {
                object = new ConfigMBeanNamingInfo(string2 + ".fake");
                string3 = ((ConfigMBeanNamingInfo)object).getXPath();
            }
            catch (Exception exception) {
                sLogger.log(Level.FINE, MSG_EXCEPTION_DURING_LIST_NAMES, exception);
            }
        }
        if (string3 != null) {
            object = null;
            String string4 = null;
            if ((string3 = string3.trim()).length() > 0 && string3.endsWith("]")) {
                int n3 = string3.lastIndexOf(64) + 1;
                int n4 = string3.indexOf(61, n3);
                if (n3 > 0 && n4 > n3) {
                    object = string3.substring(n3, n4).trim();
                    n4 = string3.lastIndexOf(91);
                    if (n4 > 0 && n4 < n3 && (n4 = (string3 = string3.substring(0, n4)).lastIndexOf(47)) > 0 && n4 < string3.length() - 2) {
                        string4 = string3.substring(n4 + 1).trim();
                        string3 = string3.substring(0, n4);
                    }
                }
            }
            if (object != null && string4 != null) {
                try {
                    String string5 = instanceEnvironment.getBackupConfigFilePath();
                    ConfigContext configContext = ConfigFactory.createConfigContext(string5);
                    ConfigBean configBean = ConfigBeansFactory.getConfigBeanByXPath(configContext, string3);
                    ConfigBean[] configBeanArray = configBean.getChildBeansByName(string4);
                    for (int i = 0; i < configBeanArray.length; ++i) {
                        String string6 = configBeanArray[i].getAttributeValue((String)object);
                        if (string6 == null) continue;
                        hashSet.add(string2 + "." + string6);
                    }
                }
                catch (ConfigException configException) {
                    sLogger.log(Level.FINE, MSG_EXCEPTION_DURING_LIST_NAMES, configException);
                }
                catch (NullPointerException nullPointerException) {
                    sLogger.log(Level.FINE, MSG_EXCEPTION_DURING_LIST_NAMES, nullPointerException);
                }
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private static synchronized MBeanNamingDescriptor[] initConfigMBeanNaming() {
        MBeanNamingDescriptor[] mBeanNamingDescriptorArray = null;
        try {
            mBeanNamingDescriptorArray = new MBeanNamingDescriptor[mbean_descriptions.length];
            for (int i = 0; i < mbean_descriptions.length; ++i) {
                mBeanNamingDescriptorArray[i] = new MBeanNamingDescriptor(mbean_descriptions[i]);
            }
        }
        catch (MBeanConfigException mBeanConfigException) {
            // empty catch block
        }
        return mBeanNamingDescriptorArray;
    }

    public static void main(String[] stringArray) {
        ConfigMBeansNaming.testDottedName("myInstance.http-listener.myListener");
        ConfigMBeansNaming.testDottedName("myInstance.http-listener");
        ConfigMBeansNaming.testDottedName("myInstance.http-server");
        ConfigMBeansNaming.testDottedName("myInstance.http-server.mymy");
        ConfigMBeansNaming.testDottedName("myInstance.http-listeners.myListener");
        ConfigMBeansNaming.testDottedName("myInstance.http-serve");
        ConfigMBeansNaming.testDottedName("myInstance.http-server.http-listener.myListener");
        try {
            ConfigMBeansNaming.testObjectName(new ObjectName("ias:type=http-listener,instance-name=myServer,name=myListener"));
            ConfigMBeansNaming.testObjectName(new ObjectName("ias:type=http-listener,instance-name=myServer,name=myListener,chtoto=to"));
            ConfigMBeansNaming.testObjectName(new ObjectName("ias:type=http-service,instance-name=myServer,name=jhgv"));
            ConfigMBeansNaming.testObjectName(new ObjectName("ias:type=http-service,server-instances=myServer"));
            ConfigMBeansNaming.testObjectName(new ObjectName("ias:type=http-service,instance-name=myServer"));
            ConfigMBeansNaming.testObjectName(new ObjectName("ias:name=myListener,instance-name=myServer,type=http-listener"));
        }
        catch (Throwable throwable) {
            ConfigMBeansNaming.print(">>>>>>EXCEPTION: " + throwable);
            throwable.printStackTrace();
        }
    }

    private static void print(String string) {
        System.out.println(string);
    }

    private static void testDottedName(String string) {
        try {
            ConfigMBeansNaming.print("\n\n\n>>>>>>test for dotted name: " + string);
            ConfigMBeanNamingInfo configMBeanNamingInfo = new ConfigMBeanNamingInfo(string);
            ConfigMBeansNaming.print("       ConfigMBeanNamingInfo =" + configMBeanNamingInfo);
            ConfigMBeansNaming.print("       ObjectName =" + configMBeanNamingInfo.getObjectName());
            ConfigMBeansNaming.print("       XPath      =" + configMBeanNamingInfo.getXPath());
        }
        catch (Throwable throwable) {
            ConfigMBeansNaming.print(">>>>>>EXCEPTION: " + throwable);
        }
    }

    private static void testObjectName(ObjectName objectName) {
        try {
            ConfigMBeansNaming.print("\n\n\n>>>>>>test for object name: " + objectName);
            ConfigMBeanNamingInfo configMBeanNamingInfo = new ConfigMBeanNamingInfo(objectName);
            ConfigMBeansNaming.print("       ConfigMBeanNamingInfo =" + configMBeanNamingInfo);
            ConfigMBeansNaming.print("       ObjectName =" + configMBeanNamingInfo.getObjectName());
            ConfigMBeansNaming.print("       XPath      =" + configMBeanNamingInfo.getXPath());
        }
        catch (Throwable throwable) {
            ConfigMBeansNaming.print(">>>>>>EXCEPTION: " + throwable);
            throwable.printStackTrace();
        }
    }
}

