/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config.naming;

import com.iplanet.ias.admin.common.MalformedNameException;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.server.core.mbean.config.ConfigMBeanBase;
import com.iplanet.ias.admin.server.core.mbean.config.naming.ConfigMBeansNaming;
import com.iplanet.ias.admin.server.core.mbean.config.naming.MBeanNamingDescriptor;
import com.iplanet.ias.util.i18n.StringManager;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ConfigMBeanNamingInfo {
    String[] m_ids = null;
    MBeanNamingDescriptor m_descr = null;
    private static StringManager localStrings = StringManager.getManager(ConfigMBeanNamingInfo.class);

    public ConfigMBeanNamingInfo(String string, String[] stringArray) throws MBeanConfigException {
        this(string, stringArray, true);
    }

    public ConfigMBeanNamingInfo(String string, String[] stringArray, boolean bl) throws MBeanConfigException {
        this.m_descr = ConfigMBeansNaming.findNamingDescriptorByType(string);
        if (this.m_descr == null) {
            String string2 = localStrings.getString("admin.server.core.mbean.config.naming.mbeannamingdescriptor_not_found_for_type", string);
            throw new MBeanConfigException(string2);
        }
        if (bl) {
            int n;
            int n2 = n = stringArray == null ? 0 : stringArray.length;
            if (this.m_descr.getParmListSize() != n) {
                String string3 = localStrings.getString("admin.server.core.mbean.config.naming.wrong_parameters_array_size", string);
                throw new MBeanConfigException(string3);
            }
        }
        this.m_ids = stringArray;
    }

    public ConfigMBeanNamingInfo(String string) throws MBeanConfigException, MalformedNameException {
        this.m_descr = ConfigMBeansNaming.findNamingDescriptor(string);
        if (this.m_descr == null) {
            String string2 = localStrings.getString("admin.server.core.mbean.config.naming.mbeannamingdescriptor_not_found_for_dotted_name", string);
            throw new MBeanConfigException(string2);
        }
        this.m_ids = this.m_descr.extractParmList(string);
    }

    public ConfigMBeanNamingInfo(ObjectName objectName) throws MBeanConfigException {
        this.m_descr = ConfigMBeansNaming.findNamingDescriptor(objectName);
        if (this.m_descr == null) {
            String string = localStrings.getString("admin.server.core.mbean.config.naming.mbeannamingdescriptor_not_found_for_object_name", objectName);
            throw new MBeanConfigException(string);
        }
        this.m_ids = this.m_descr.extractParmList(objectName);
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        return this.m_descr.createObjectName(this.m_ids);
    }

    public String[] getLocationParams() {
        return this.m_ids;
    }

    public String getXPath() {
        return this.m_descr.createXPath(this.m_ids);
    }

    public int getMode() {
        return this.m_descr.getMode();
    }

    public boolean isModeConfig() {
        int n = this.m_descr.getMode();
        return (n & 1) != 0;
    }

    public boolean isModeMonitorable() {
        int n = this.m_descr.getMode();
        return (n & 2) != 0;
    }

    public ConfigMBeanBase constructConfigMBean() throws MBeanConfigException {
        ConfigMBeanBase configMBeanBase;
        String string = "com.iplanet.ias.admin.server.core.mbean.config." + this.m_descr.getMBeanClassName();
        try {
            Class<?> clazz = Class.forName(string);
            configMBeanBase = (ConfigMBeanBase)clazz.newInstance();
        }
        catch (Exception exception) {
            String string2 = localStrings.getString("admin.server.core.mbean.config.naming.mbeannamingdescriptor_couldnot_create_mbean_class", string);
            throw new MBeanConfigException(string2);
        }
        configMBeanBase.initialize(this);
        return configMBeanBase;
    }

    public String getServerInstanceName() throws MBeanConfigException {
        if (this.m_ids == null || this.m_ids.length == 0) {
            String string = localStrings.getString("admin.server.core.mbean.config.naming.wrong_parameters_array_size", this.m_descr.getType());
            throw new MBeanConfigException(string);
        }
        return this.m_ids[0];
    }
}

