/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.common.EntityStatus;
import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.common.exception.J2EEWebModuleException;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.server.core.mbean.config.ConfigMBeanBase;
import com.iplanet.ias.admin.server.core.mbean.config.ModulesXMLHelper;
import com.iplanet.ias.config.serverbeans.ServerTags;
import javax.management.Attribute;

public class ManagedStandaloneJ2EEWebModule
extends ConfigMBeanBase
implements ConfigAttributeName.StandaloneWebModule {
    private static final String[][] MAPLIST = new String[][]{{"name", "@" + ServerTags.NAME}, {"contextRoot", "@" + ServerTags.CONTEXT_ROOT}, {"location", "@" + ServerTags.LOCATION}, {"virtualServers", "@" + ServerTags.VIRTUAL_SERVERS}, {"enabled", "@" + ServerTags.ENABLED}, {"description", "@" + PSEUDO_ATTR_DESCRIPTION}, {"availabilityEnabled", "@" + ServerTags.AVAILABILITY_ENABLED}};
    private static final String[] ATTRIBUTES = new String[]{"name, String,     R", "contextRoot, String,     RW", "location, String,     RW", "virtualServers, String,     RW", "enabled, boolean,    RW", "description, String,     RW", "availabilityEnabled,String,    RW"};
    private static final String[] OPERATIONS = new String[]{"getStatus(),   INFO", "enable(),      ACTION", "disable(),     ACTION"};

    public ManagedStandaloneJ2EEWebModule() throws MBeanConfigException {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    public ManagedStandaloneJ2EEWebModule(String string, String string2) throws MBeanConfigException {
        this();
        this.initialize("standalone-web-module", new String[]{string, string2});
    }

    public EntityStatus getStatus() throws J2EEWebModuleException {
        EntityStatus entityStatus = null;
        try {
            boolean bl = (Boolean)this.getAttribute("enabled");
            entityStatus = new EntityStatus();
            if (bl) {
                entityStatus.setEnabled();
            } else {
                entityStatus.setDisabled();
            }
        }
        catch (Exception exception) {
            sLogger.throwing(this.getClass().getName(), "getStatus", exception);
            throw new J2EEWebModuleException(exception.getMessage());
        }
        return entityStatus;
    }

    public void disable() throws J2EEWebModuleException {
        try {
            this.setAttribute(new Attribute("enabled", new Boolean(false)));
            super.getConfigContext().flush();
        }
        catch (Exception exception) {
            sLogger.throwing(this.getClass().getName(), "disable", exception);
            throw new J2EEWebModuleException(exception.getMessage());
        }
    }

    public void enable() throws J2EEWebModuleException {
        try {
            this.setAttribute(new Attribute("enabled", new Boolean(true)));
            super.getConfigContext().flush();
        }
        catch (Exception exception) {
            sLogger.throwing(this.getClass().getName(), "enable", exception);
            throw new J2EEWebModuleException(exception.getMessage());
        }
    }

    public String[] getServlets() throws J2EEWebModuleException {
        try {
            String string = (String)this.getAttribute("location");
            return ModulesXMLHelper.getServletsForWebModule(string, null);
        }
        catch (Exception exception) {
            sLogger.throwing(this.getClass().getName(), "getServlets", exception);
            throw new J2EEWebModuleException(exception.getMessage());
        }
    }
}

