/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.common.InitConfFileBean;
import com.iplanet.ias.admin.common.MBeanServerFactory;
import com.iplanet.ias.admin.common.ObjectNameHelper;
import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.RequestID;
import com.iplanet.ias.admin.common.ServerInstanceStatus;
import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFResourceException;
import com.iplanet.ias.admin.common.exception.AFRuntimeStoreException;
import com.iplanet.ias.admin.common.exception.ControlException;
import com.iplanet.ias.admin.common.exception.DeploymentException;
import com.iplanet.ias.admin.common.exception.IllegalStateException;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.common.exception.PortInUseException;
import com.iplanet.ias.admin.common.exception.ServerInstanceException;
import com.iplanet.ias.admin.event.AdminEvent;
import com.iplanet.ias.admin.event.AdminEventCache;
import com.iplanet.ias.admin.event.AdminEventMulticaster;
import com.iplanet.ias.admin.event.AdminEventResult;
import com.iplanet.ias.admin.event.ApplicationDeployEvent;
import com.iplanet.ias.admin.event.ConfigChangeEvent;
import com.iplanet.ias.admin.event.ModuleDeployEvent;
import com.iplanet.ias.admin.server.core.AdminService;
import com.iplanet.ias.admin.server.core.ManualChangeManager;
import com.iplanet.ias.admin.server.core.channel.AdminChannel;
import com.iplanet.ias.admin.server.core.channel.RMIClient;
import com.iplanet.ias.admin.server.core.mbean.config.ConfigMBeanBase;
import com.iplanet.ias.admin.server.core.mbean.config.ManagedJ2EEApplication;
import com.iplanet.ias.admin.server.core.mbean.config.ManagedStandaloneJ2EEEjbJarModule;
import com.iplanet.ias.admin.server.core.mbean.config.Resource;
import com.iplanet.ias.admin.server.core.mbean.config.ResourcesXMLParser;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.admin.util.StringValidator;
import com.iplanet.ias.admin.util.Validator;
import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigBeansFactory;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.AvailabilityService;
import com.iplanet.ias.config.serverbeans.ConnectorModule;
import com.iplanet.ias.config.serverbeans.CustomResource;
import com.iplanet.ias.config.serverbeans.EjbModule;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.ExternalJndiResource;
import com.iplanet.ias.config.serverbeans.HttpListener;
import com.iplanet.ias.config.serverbeans.HttpService;
import com.iplanet.ias.config.serverbeans.IiopCluster;
import com.iplanet.ias.config.serverbeans.IiopEndpoint;
import com.iplanet.ias.config.serverbeans.IiopServerInstance;
import com.iplanet.ias.config.serverbeans.J2eeApplication;
import com.iplanet.ias.config.serverbeans.JavaConfig;
import com.iplanet.ias.config.serverbeans.JdbcConnectionPool;
import com.iplanet.ias.config.serverbeans.JdbcResource;
import com.iplanet.ias.config.serverbeans.JmsResource;
import com.iplanet.ias.config.serverbeans.LifecycleModule;
import com.iplanet.ias.config.serverbeans.MailResource;
import com.iplanet.ias.config.serverbeans.PersistenceManagerFactoryResource;
import com.iplanet.ias.config.serverbeans.Resources;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.ServerXPathHelper;
import com.iplanet.ias.config.serverbeans.WebModule;
import com.iplanet.ias.deployment.backend.DeployableObjectType;
import com.iplanet.ias.deployment.backend.Deployer;
import com.iplanet.ias.deployment.backend.DeployerFactory;
import com.iplanet.ias.deployment.backend.DeploymentCommand;
import com.iplanet.ias.deployment.backend.DeploymentRequest;
import com.iplanet.ias.installer.core.installConfig;
import com.iplanet.ias.instance.InstanceDefinition;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.ServerManager;
import com.iplanet.ias.license.IASLicense;
import com.iplanet.ias.security.auth.realm.file.FileRealm;
import com.iplanet.ias.security.util.IASSecurityException;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.net.NetUtils;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ManagedServerInstance
extends ConfigMBeanBase
implements ConfigAttributeName.Server {
    private HostAndPort mHostAndPort = null;
    private int mStartMode = 1;
    private String mInstanceName = null;
    private boolean mAutoStart = false;
    public static final Logger sLogger;
    private static final int APPLICATION_DEPLOYED = 1;
    private static final int APPLICATION_UNDEPLOYED = 2;
    private static final int APPLICATION_REDEPLOYED = 3;
    private static final int MODULE_DEPLOYED = 4;
    private static final int MODULE_UNDEPLOYED = 5;
    private static final int MODULE_REDEPLOYED = 6;
    private static final int CONFIG_CHANGED = 7;
    private static final String[][] MAPLIST;
    private static final String[] ATTRIBUTES;
    private static final String[] OPERATIONS;
    private static final int TIME_OUT_SECONDS = 120;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ManagedServerInstance() throws MBeanConfigException {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    public ManagedServerInstance(String string, HostAndPort hostAndPort, boolean bl) throws PortInUseException, MBeanConfigException {
        this();
        this.initialize("server-instance", new String[]{string});
        if (string == null || hostAndPort == null) {
            throw new IllegalArgumentException();
        }
        this.mInstanceName = string;
        this.mHostAndPort = hostAndPort;
        this.mAutoStart = bl;
    }

    public RequestID start() throws ControlException {
        return this.start(false, null);
    }

    public RequestID start(String[] stringArray) throws ControlException {
        return this.start(false, stringArray);
    }

    public RequestID start(boolean bl, String[] stringArray) throws ControlException {
        try {
            Object object;
            if (this.getInstanceStatusCode() == 0) {
                String string = localStrings.getString("admin.server.core.mbean.config.cannot_start_already_running");
                throw new IllegalStateException(string);
            }
            IASLicense.checkCurrent(true);
            if (bl) {
                this.mStartMode = 0;
            } else if (this.isDebug()) {
                this.setDebug(false);
                this.setDebugOptions(null);
                super.getConfigContext().flush();
                this.applyConfigChanges();
            }
            if (bl) {
                object = "?";
                try {
                    object = String.valueOf(this.getDebugPort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sLogger.log(Level.INFO, "mbean.start_instance_debug", new Object[]{this.mInstanceName, object});
            } else {
                sLogger.log(Level.INFO, "mbean.start_instance", this.mInstanceName);
            }
            object = new InstanceDefinition(this.mInstanceName, this.mHostAndPort.getPort());
            ServerManager.instance().startServerInstance((InstanceDefinition)object, stringArray);
            sLogger.log(Level.INFO, "mbean.check_start_instance", this.mInstanceName);
            long l = 240000L;
            long l2 = 2000L;
            long l3 = System.currentTimeMillis();
            long l4 = System.currentTimeMillis();
            boolean bl2 = false;
            while (!bl2 && this.getInstanceStatusCode() != 0) {
                Thread.sleep(l2);
                l4 = System.currentTimeMillis();
                bl2 = l4 - l3 >= l;
            }
            if (bl2) {
                Object object2;
                sLogger.log(Level.INFO, "mbean.start_instance_timeout", this.mInstanceName);
                try {
                    object2 = new Long(l / 1000L);
                    this.stop(((Long)object2).intValue());
                }
                catch (ControlException controlException) {
                    String string = localStrings.getString("admin.server.core.mbean.config.timeout_reached_server_stopping_exception", this.mInstanceName);
                }
                object2 = localStrings.getString("admin.server.core.mbean.config.timeout_reached_server_starting_exception", this.mInstanceName);
                throw new ControlException((String)object2);
            }
            sLogger.log(Level.INFO, "mbean.start_instance_success", this.mInstanceName);
        }
        catch (Exception exception) {
            sLogger.log(Level.SEVERE, "mbean.start_instance_failed", this.mInstanceName);
            sLogger.log(Level.SEVERE, "mbean.start_instance_failed_details", exception);
            throw new ControlException(exception.getMessage());
        }
        return null;
    }

    public int startInDebugMode(String[] stringArray) throws ControlException {
        int n = -1;
        try {
            boolean bl = false;
            IASLicense.checkCurrent(true);
            if (!this.isDebug()) {
                this.setDebug(true);
                bl = true;
            }
            if ((n = this.getDebugPort()) == -1) {
                n = NetUtils.getFreePort();
                if (n == 0) {
                    sLogger.log(Level.SEVERE, "general.free_port_failed");
                    String string = localStrings.getString("admin.server.core.mbean.config.no_free_port");
                    throw new Exception(string);
                }
                this.setDebugPort(n);
                bl = true;
            }
            if (bl) {
                super.getConfigContext().flush();
                this.applyConfigChanges();
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.set_debug_failed", exception);
            throw new ControlException(exception.getLocalizedMessage());
        }
        this.start(true, stringArray);
        return n;
    }

    public int startInDebugMode() throws ControlException {
        return this.startInDebugMode(null);
    }

    public String[] getSecurityPasswordTokens() throws ControlException {
        try {
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(this.mInstanceName);
            String string = instanceEnvironment.getSecurityPasswordsFilePath();
            File file = new File(string);
            if (file.exists()) {
                return null;
            }
            InitConfFileBean initConfFileBean = new InitConfFileBean();
            initConfFileBean.initialise(this.mInstanceName, false);
            String string2 = initConfFileBean.get_mag_var("Security");
            if (string2.equalsIgnoreCase("on")) {
                InstanceDefinition instanceDefinition = new InstanceDefinition(this.mInstanceName, this.mHostAndPort.getPort());
                return ServerManager.instance().getSecurityTokensForInstance(instanceDefinition);
            }
            return null;
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.security_check_failed", exception);
            throw new ControlException(exception.getMessage());
        }
    }

    public RequestID restart() throws ControlException {
        Object object;
        RequestID requestID = null;
        final RMIClient rMIClient = AdminChannel.getRMIClient(this.mInstanceName);
        if (rMIClient.getInstanceStatusCode() != 0) {
            String string = localStrings.getString("admin.server.core.mbean.config.instance_not_running_cannot_restart");
            throw new IllegalStateException(string);
        }
        try {
            IASLicense.checkCurrent(true);
            sLogger.log(Level.INFO, "mbean.restart_instance", this.mInstanceName);
            object = new InstanceDefinition(this.mInstanceName, this.getHostAndPort().getPort());
            ServerManager.instance().restartServerInstance((InstanceDefinition)object);
            int n = 3;
            for (int i = 0; rMIClient.getInstanceStatusCode() != 3 && i < n; ++i) {
                Thread.currentThread();
                Thread.sleep(5000L);
            }
        }
        catch (Exception exception) {
            throw new ControlException(exception.getMessage());
        }
        object = new ManagedInstanceTimer(120, 0, new TimerCallback(){

            public boolean check() throws Exception {
                return rMIClient.getInstanceStatusCode() == 0;
            }
        });
        ((ManagedInstanceTimer)object).run();
        if (rMIClient.getInstanceStatusCode() != 0) {
            String string = localStrings.getString("admin.server.core.mbean.config.timeout_while_restarting_server");
            try {
                this.stop(120);
            }
            catch (ControlException controlException) {
                string = string + localStrings.getString("admin.server.core.mbean.config.server_stop_exception");
            }
            throw new ControlException(string + this.mInstanceName);
        }
        return requestID;
    }

    public void stop(int n) throws ControlException {
        if (this.getInstanceStatusCode() == 3) {
            String string = localStrings.getString("admin.server.core.mbean.config.not_running_cannot_stop");
            throw new IllegalStateException(string);
        }
        try {
            sLogger.log(Level.INFO, "mbean.stop_instance", this.mInstanceName);
            InstanceDefinition instanceDefinition = new InstanceDefinition(this.mInstanceName, this.mHostAndPort.getPort());
            ServerManager.instance().stopServerInstance(instanceDefinition);
            sLogger.log(Level.INFO, "mbean.check_stop_instance", this.mInstanceName);
            long l = n * 1000;
            long l2 = 2000L;
            long l3 = System.currentTimeMillis();
            long l4 = System.currentTimeMillis();
            boolean bl = false;
            while (!bl && this.getInstanceStatusCode() != 3) {
                Thread.sleep(l2);
                l4 = System.currentTimeMillis();
                bl = l4 - l3 >= l;
            }
            if (bl) {
                sLogger.log(Level.INFO, "mbean.stop_instance_timeout", this.mInstanceName);
                String string = localStrings.getString("admin.server.core.mbean.config.timeout_while_stopping_server", this.mInstanceName);
                throw new ControlException(string);
            }
            sLogger.log(Level.INFO, "mbean.stop_instance_success", this.mInstanceName);
        }
        catch (Exception exception) {
            sLogger.log(Level.SEVERE, "mbean.stop_instance_failed", this.mInstanceName);
            throw new ControlException(exception.getMessage());
        }
    }

    public boolean deployJ2EEApplication(String string, String string2, boolean bl, String string3, boolean bl2, boolean bl3, boolean bl4) throws DeploymentException {
        this.testDeployedFile(string, false);
        return this.deployJ2EEApplicationArchiveOrDirectory(string, string2, bl, string3, bl2, bl3, bl4, null);
    }

    public boolean deployJ2EEApplication(String string, String string2, boolean bl, String string3, boolean bl2, boolean bl3, boolean bl4, String string4) throws DeploymentException {
        this.testDeployedFile(string, false);
        return this.deployJ2EEApplicationArchiveOrDirectory(string, string2, bl, string3, bl2, bl3, bl4, string4);
    }

    public boolean deployJ2EEApplicationDirectory(String string, String string2, boolean bl, String string3, boolean bl2, boolean bl3, boolean bl4) throws DeploymentException {
        this.testDeployedFile(string, true);
        return this.deployJ2EEApplicationArchiveOrDirectory(string, string2, bl, string3, bl2, bl3, bl4, null);
    }

    public boolean deployJ2EEApplicationDirectory(String string, String string2, boolean bl, String string3, boolean bl2, boolean bl3, boolean bl4, String string4) throws DeploymentException {
        this.testDeployedFile(string, true);
        return this.deployJ2EEApplicationArchiveOrDirectory(string, string2, bl, string3, bl2, bl3, bl4, string4);
    }

    private boolean deployJ2EEApplicationArchiveOrDirectory(String string, String string2, boolean bl, String string3, boolean bl2, boolean bl3, boolean bl4, String string4) throws DeploymentException {
        boolean bl5 = true;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        sLogger.log(Level.FINE, "mbean.begin_deploy", string);
        File file = new File(string);
        int n = 1;
        try {
            boolean bl6 = this.isAppExists(string2, 1001);
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(this.mInstanceName);
            DeploymentRequest deploymentRequest = new DeploymentRequest(instanceEnvironment, DeployableObjectType.APP, DeploymentCommand.DEPLOY);
            deploymentRequest.setFileSource(file);
            deploymentRequest.setName(string2);
            deploymentRequest.setForced(bl2);
            deploymentRequest.setVerifying(bl3);
            deploymentRequest.setPrecompileJSP(bl4);
            Properties properties = new Properties();
            properties.put(ServerTags.ENABLED, String.valueOf(bl));
            if (string4 != null) {
                properties.put(ServerTags.AVAILABILITY_ENABLED, string4);
            }
            if (string3 != null) {
                properties.put(ServerTags.VIRTUAL_SERVERS, string3);
            }
            deploymentRequest.setOptionalAttributes(properties);
            Deployer deployer = DeployerFactory.getDeployer(deploymentRequest);
            deployer.doRequest();
            String string5 = deploymentRequest.getName();
            this.registerApplicationMBean(string5);
            this.setDeployDirOwner(deploymentRequest, instanceEnvironment);
            n = bl6 && bl2 ? 3 : 1;
            bl5 = this.multicastEvent(n, string2);
            deployer.cleanup();
        }
        catch (Exception exception) {
            if (n == 1) {
                sLogger.log(Level.WARNING, "mbean.deploy_failed", exception);
            } else {
                sLogger.log(Level.WARNING, "mbean.redeploy_failed", exception);
            }
            throw new DeploymentException(exception.getMessage());
        }
        finally {
            this.deleteFile(string);
        }
        return bl5;
    }

    public boolean undeployJ2EEApplication(String string) throws DeploymentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        boolean bl = true;
        sLogger.log(Level.FINE, "mbean.begin_undeploy", string);
        try {
            DeploymentRequest deploymentRequest = new DeploymentRequest(new InstanceEnvironment(this.mInstanceName), DeployableObjectType.APP, DeploymentCommand.UNDEPLOY);
            deploymentRequest.setName(string);
            Deployer deployer = DeployerFactory.getDeployer(deploymentRequest);
            deployer.doRequest();
            bl = this.multicastEvent(2, string);
            deployer.cleanup();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.undeploy_failed", exception);
            throw new DeploymentException(exception.getMessage());
        }
        return bl;
    }

    public boolean deployJ2EEModule(String string, boolean bl) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public boolean deployEJBJarModule(String string, String string2, boolean bl, boolean bl2) throws DeploymentException {
        this.testDeployedFile(string, false);
        return this.deployEJBJarModuleArchiveOrDirectory(string, string2, bl, bl2, null);
    }

    public boolean deployEJBJarModule(String string, String string2, boolean bl, boolean bl2, String string3) throws DeploymentException {
        this.testDeployedFile(string, false);
        return this.deployEJBJarModuleArchiveOrDirectory(string, string2, bl, bl2, string3);
    }

    public boolean deployEJBJarModuleDirectory(String string, String string2, boolean bl, boolean bl2) throws DeploymentException {
        this.testDeployedFile(string, true);
        return this.deployEJBJarModuleArchiveOrDirectory(string, string2, bl, bl2, null);
    }

    public boolean deployEJBJarModuleDirectory(String string, String string2, boolean bl, boolean bl2, String string3) throws DeploymentException {
        this.testDeployedFile(string, true);
        return this.deployEJBJarModuleArchiveOrDirectory(string, string2, bl, bl2, string3);
    }

    private boolean deployEJBJarModuleArchiveOrDirectory(String string, String string2, boolean bl, boolean bl2, String string3) throws DeploymentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        boolean bl3 = true;
        sLogger.log(Level.FINE, "mbean.begin_deploy", string);
        File file = new File(string);
        int n = 4;
        try {
            boolean bl4 = this.isAppExists(string2, 1003);
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(this.mInstanceName);
            DeploymentRequest deploymentRequest = new DeploymentRequest(instanceEnvironment, DeployableObjectType.EJB, DeploymentCommand.DEPLOY);
            deploymentRequest.setFileSource(file);
            deploymentRequest.setName(string2);
            deploymentRequest.setForced(bl);
            deploymentRequest.setVerifying(bl2);
            Properties properties = new Properties();
            properties.put(ServerTags.ENABLED, String.valueOf(true));
            if (string3 != null) {
                properties.put(ServerTags.AVAILABILITY_ENABLED, string3);
            }
            deploymentRequest.setOptionalAttributes(properties);
            Deployer deployer = DeployerFactory.getDeployer(deploymentRequest);
            deployer.doRequest();
            this.setDeployDirOwner(deploymentRequest, instanceEnvironment);
            String string4 = deploymentRequest.getName();
            n = bl4 && bl ? 6 : 4;
            bl3 = this.multicastEvent(n, string2, "ejb");
            this.registerEJBModuleMBean(string4);
            deployer.cleanup();
        }
        catch (Exception exception) {
            if (n == 4) {
                sLogger.log(Level.WARNING, "mbean.deploy_failed", exception);
            } else {
                sLogger.log(Level.WARNING, "mbean.redeploy_failed", exception);
            }
            throw new DeploymentException(exception.getMessage());
        }
        finally {
            this.deleteFile(string);
        }
        return bl3;
    }

    public boolean deployWarModule(String string, String string2, String string3, boolean bl, String string4, boolean bl2, boolean bl3, boolean bl4) throws DeploymentException {
        this.testDeployedFile(string, false);
        return this.deployWarModuleArchiveOrDirectory(string, string2, string3, bl, string4, bl2, bl3, bl4, null);
    }

    public boolean deployWarModule(String string, String string2, String string3, boolean bl, String string4, boolean bl2, boolean bl3, boolean bl4, String string5) throws DeploymentException {
        this.testDeployedFile(string, false);
        return this.deployWarModuleArchiveOrDirectory(string, string2, string3, bl, string4, bl2, bl3, bl4, string5);
    }

    public boolean deployWarModuleDirectory(String string, String string2, String string3, boolean bl, String string4, boolean bl2, boolean bl3, boolean bl4) throws DeploymentException {
        this.testDeployedFile(string, true);
        return this.deployWarModuleArchiveOrDirectory(string, string2, string3, bl, string4, bl2, bl3, bl4, null);
    }

    public boolean deployWarModuleDirectory(String string, String string2, String string3, boolean bl, String string4, boolean bl2, boolean bl3, boolean bl4, String string5) throws DeploymentException {
        this.testDeployedFile(string, true);
        return this.deployWarModuleArchiveOrDirectory(string, string2, string3, bl, string4, bl2, bl3, bl4, string5);
    }

    private boolean deployWarModuleArchiveOrDirectory(String string, String string2, String string3, boolean bl, String string4, boolean bl2, boolean bl3, boolean bl4, String string5) throws DeploymentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        boolean bl5 = true;
        sLogger.log(Level.FINE, "mbean.begin_deploy", string);
        File file = new File(string);
        int n = 4;
        try {
            boolean bl6 = this.isAppExists(string2, 1002);
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(this.mInstanceName);
            DeploymentRequest deploymentRequest = new DeploymentRequest(instanceEnvironment, DeployableObjectType.WEB, DeploymentCommand.DEPLOY);
            deploymentRequest.setFileSource(file);
            deploymentRequest.setName(string2);
            deploymentRequest.setContextRoot(string3);
            deploymentRequest.setForced(bl2);
            deploymentRequest.setVerifying(bl3);
            deploymentRequest.setPrecompileJSP(bl4);
            Properties properties = new Properties();
            properties.put(ServerTags.ENABLED, String.valueOf(bl));
            if (string4 != null) {
                properties.put(ServerTags.VIRTUAL_SERVERS, string4);
            }
            if (string5 != null) {
                properties.put(ServerTags.AVAILABILITY_ENABLED, string5);
            }
            deploymentRequest.setOptionalAttributes(properties);
            Deployer deployer = DeployerFactory.getDeployer(deploymentRequest);
            deployer.doRequest();
            this.setDeployDirOwner(deploymentRequest, instanceEnvironment);
            String string6 = deploymentRequest.getName();
            n = bl6 && bl2 ? 6 : 4;
            bl5 = this.multicastEvent(n, string2, "web");
            this.registerWebModuleMBean(string6);
            deployer.cleanup();
        }
        catch (Exception exception) {
            if (n == 4) {
                sLogger.log(Level.WARNING, "mbean.deploy_failed", exception);
            } else {
                sLogger.log(Level.WARNING, "mbean.redeploy_failed", exception);
            }
            throw new DeploymentException(exception.getMessage());
        }
        finally {
            this.deleteFile(string);
        }
        return bl5;
    }

    public boolean deployConnectorModule(String string, String string2, boolean bl, boolean bl2) throws DeploymentException {
        this.testDeployedFile(string, false);
        return this.deployConnectorModuleArchiveOrDirectory(string, string2, bl, bl2);
    }

    public boolean deployConnectorModuleDirectory(String string, String string2, boolean bl, boolean bl2) throws DeploymentException {
        this.testDeployedFile(string, true);
        return this.deployConnectorModuleArchiveOrDirectory(string, string2, bl, bl2);
    }

    private boolean deployConnectorModuleArchiveOrDirectory(String string, String string2, boolean bl, boolean bl2) throws DeploymentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        boolean bl3 = true;
        sLogger.log(Level.FINE, "mbean.begin_deploy", string);
        File file = new File(string);
        int n = 4;
        try {
            boolean bl4 = this.isAppExists(string2, 1004);
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(this.mInstanceName);
            DeploymentRequest deploymentRequest = new DeploymentRequest(instanceEnvironment, DeployableObjectType.CONN, DeploymentCommand.DEPLOY);
            deploymentRequest.setFileSource(file);
            deploymentRequest.setName(string2);
            deploymentRequest.setForced(bl);
            deploymentRequest.setVerifying(bl2);
            Deployer deployer = DeployerFactory.getDeployer(deploymentRequest);
            deployer.doRequest();
            this.setDeployDirOwner(deploymentRequest, instanceEnvironment);
            String string3 = deploymentRequest.getName();
            n = bl4 && bl ? 6 : 4;
            bl3 = this.multicastEvent(n, string2, "connector");
            this.registerConnectorModuleMBean(string3);
            deployer.cleanup();
        }
        catch (Exception exception) {
            if (n == 4) {
                sLogger.log(Level.WARNING, "mbean.deploy_failed", exception);
            } else {
                sLogger.log(Level.WARNING, "mbean.redeploy_failed", exception);
            }
            throw new DeploymentException(exception.getMessage());
        }
        finally {
            this.deleteFile(string);
        }
        return bl3;
    }

    public boolean undeployModule(String string, int n) throws DeploymentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (n != 1003 && n != 1002 && n != 1004) {
            throw new DeploymentException("");
        }
        boolean bl = true;
        sLogger.log(Level.FINE, "mbean.begin_undeploy", string);
        try {
            DeployableObjectType deployableObjectType = null;
            switch (n) {
                case 1003: {
                    deployableObjectType = DeployableObjectType.EJB;
                    break;
                }
                case 1002: {
                    deployableObjectType = DeployableObjectType.WEB;
                    break;
                }
                case 1004: {
                    deployableObjectType = DeployableObjectType.CONN;
                }
            }
            DeploymentRequest deploymentRequest = new DeploymentRequest(new InstanceEnvironment(this.mInstanceName), deployableObjectType, DeploymentCommand.UNDEPLOY);
            deploymentRequest.setName(string);
            Deployer deployer = DeployerFactory.getDeployer(deploymentRequest);
            deployer.doRequest();
            bl = this.multicastEvent(5, string, this.getModuleTypeString(n));
            deployer.cleanup();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.undeploy_failed", exception);
            throw new DeploymentException(exception.getMessage());
        }
        return bl;
    }

    public String[] getDeployedJ2EEApplications() throws ServerInstanceException {
        String[] stringArray = new String[]{};
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Applications applications = (Applications)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_APPLICATIONS);
            J2eeApplication[] j2eeApplicationArray = applications.getJ2eeApplication();
            if (j2eeApplicationArray != null) {
                stringArray = new String[j2eeApplicationArray.length];
                for (int i = 0; i < j2eeApplicationArray.length; ++i) {
                    stringArray[i] = j2eeApplicationArray[i].getName();
                }
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.list_failed", exception);
            throw new ServerInstanceException(exception.getLocalizedMessage());
        }
        return stringArray;
    }

    public String[] getDeployedJ2EEModules() throws ServerInstanceException {
        String string = localStrings.getString("admin.server.core.mbean.config.not_supported_yet");
        throw new UnsupportedOperationException(string);
    }

    public String[] getDeployedEJBModules() throws ServerInstanceException {
        String[] stringArray = new String[]{};
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Applications applications = (Applications)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_APPLICATIONS);
            EjbModule[] ejbModuleArray = applications.getEjbModule();
            if (ejbModuleArray != null) {
                stringArray = new String[ejbModuleArray.length];
                for (int i = 0; i < ejbModuleArray.length; ++i) {
                    stringArray[i] = ejbModuleArray[i].getName();
                }
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.list_failed", exception);
            throw new ServerInstanceException(exception.getLocalizedMessage());
        }
        return stringArray;
    }

    public String[] getDeployedWebModules() throws ServerInstanceException {
        String[] stringArray = new String[]{};
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Applications applications = (Applications)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_APPLICATIONS);
            WebModule[] webModuleArray = applications.getWebModule();
            if (webModuleArray != null) {
                stringArray = new String[webModuleArray.length];
                for (int i = 0; i < webModuleArray.length; ++i) {
                    stringArray[i] = webModuleArray[i].getName();
                }
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.list_failed", exception);
            throw new ServerInstanceException(exception.getLocalizedMessage());
        }
        return stringArray;
    }

    public String[] getDeployedConnectors() throws ServerInstanceException {
        String[] stringArray = new String[]{};
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Applications applications = (Applications)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_APPLICATIONS);
            ConnectorModule[] connectorModuleArray = applications.getConnectorModule();
            if (connectorModuleArray != null) {
                stringArray = new String[connectorModuleArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = connectorModuleArray[i].getName();
                }
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.list_failed", exception);
            throw new ServerInstanceException(exception.getLocalizedMessage());
        }
        return stringArray;
    }

    public String[] getEnabledJ2EEApplications() throws ServerInstanceException {
        return null;
    }

    public String[] getDisabledJ2EEApplications() throws ServerInstanceException {
        return null;
    }

    public String[] getEnabledJ2EEModules() throws ServerInstanceException {
        return null;
    }

    public String[] getDisabledJ2EEModules() throws ServerInstanceException {
        return null;
    }

    public void createResource(String string) throws AFResourceException {
        try {
            ResourcesXMLParser resourcesXMLParser = new ResourcesXMLParser(string);
            Iterator iterator = resourcesXMLParser.getResources();
            while (iterator.hasNext()) {
                String string2;
                String string3;
                String string4;
                String string5;
                Properties properties;
                Resource resource = (Resource)iterator.next();
                if (resource.getType() == 4) {
                    properties = resource.getAttributes();
                    string5 = properties.getProperty("jndi-name");
                    string4 = properties.getProperty("pool-name");
                    this.createJDBCResource(string5, string4);
                    this.addJDBCResourceAttribute(resource, properties, string5);
                    continue;
                }
                if (resource.getType() == 1) {
                    properties = resource.getAttributes();
                    string5 = properties.getProperty("jndi-name");
                    string4 = properties.getProperty("res-type");
                    this.createJMSResource(string5, string4);
                    this.addJMSResourceAttribute(resource, properties, string5);
                    continue;
                }
                if (resource.getType() == 7) {
                    properties = resource.getAttributes();
                    string5 = properties.getProperty("jndi-name");
                    string4 = properties.getProperty("jndi-lookup-name");
                    string3 = properties.getProperty("res-type");
                    string2 = properties.getProperty("factory-class");
                    this.createJNDIResource(string5, string4, string3, string2);
                    this.addJNDIResourceAttribute(resource, properties, string5);
                    continue;
                }
                if (resource.getType() == 3) {
                    properties = resource.getAttributes();
                    string5 = properties.getProperty("jndi-name");
                    this.createPersistenceManagerFactoryResource(string5);
                    this.addPersistenceManagerFactoryAttribute(resource, properties, string5);
                    continue;
                }
                if (resource.getType() == 2) {
                    properties = resource.getAttributes();
                    string5 = properties.getProperty("jndi-name");
                    string4 = properties.getProperty("host");
                    string3 = properties.getProperty("user");
                    string2 = properties.getProperty("from");
                    this.createJavaMailResource(string5, string4, string3, string2);
                    this.addJavaMailAttribute(resource, properties, string5);
                    continue;
                }
                if (resource.getType() == 6) {
                    properties = resource.getAttributes();
                    string5 = properties.getProperty("jndi-name");
                    string4 = properties.getProperty("res-type");
                    string3 = properties.getProperty("factory-class");
                    this.createCustomResource(string5, string4, string3);
                    this.addCustomResourceAttribute(resource, properties, string5);
                    continue;
                }
                if (resource.getType() != 5) continue;
                properties = resource.getAttributes();
                string5 = properties.getProperty("name");
                string4 = properties.getProperty("datasource-classname");
                this.createJDBCConnectionPool(string5, string4);
                this.addJDBCConnectionPoolAttribute(resource, properties, string5);
            }
        }
        catch (Exception exception) {
            throw new AFResourceException(exception.getMessage());
        }
    }

    public void createJDBCConnectionPool(String string, String string2) throws AFResourceException {
        ArgChecker.checkValid((Object)string, (String)"id", (Validator)StringValidator.getInstance());
        ArgChecker.checkValid((Object)string2, (String)"datasourceClassName", (Validator)StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.create_resource", string);
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            JdbcConnectionPool jdbcConnectionPool = new JdbcConnectionPool();
            jdbcConnectionPool.setName(string);
            jdbcConnectionPool.setDatasourceClassname(string2);
            resources.addJdbcConnectionPool(jdbcConnectionPool);
            configContext.flush();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.create_resource_failed", exception);
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    private void addJDBCConnectionPoolAttribute(Resource resource, Properties properties, String string) throws AFResourceException {
        try {
            ElementProperty[] elementPropertyArray;
            String string2;
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            JdbcConnectionPool jdbcConnectionPool = resources.getJdbcConnectionPoolByName(string);
            String string3 = properties.getProperty("steady-pool-size");
            String string4 = properties.getProperty("max-pool-size");
            String string5 = properties.getProperty("max-wait-time-in-millis");
            String string6 = properties.getProperty("pool-resize-quantity");
            String string7 = properties.getProperty("idle-timeout-in-seconds");
            String string8 = properties.getProperty("is-connection-validation-required");
            String string9 = properties.getProperty("connection-validation-method");
            String string10 = properties.getProperty("fail-all-connections");
            String string11 = properties.getProperty("validation-table-name");
            String string12 = properties.getProperty("res-type");
            String string13 = properties.getProperty("transaction-isolation-level");
            String string14 = properties.getProperty("is-isolation-level-guaranteed");
            if (string3 != null) {
                jdbcConnectionPool.setSteadyPoolSize(string3);
            }
            if (string4 != null) {
                jdbcConnectionPool.setMaxPoolSize(string4);
            }
            if (string5 != null) {
                jdbcConnectionPool.setMaxWaitTimeInMillis(string5);
            }
            if (string6 != null) {
                jdbcConnectionPool.setPoolResizeQuantity(string6);
            }
            if (string7 != null) {
                jdbcConnectionPool.setIdleTimeoutInSeconds(string7);
            }
            if (string8 != null) {
                jdbcConnectionPool.setIsConnectionValidationRequired(Boolean.valueOf(string8));
            }
            if (string9 != null) {
                jdbcConnectionPool.setConnectionValidationMethod(string9);
            }
            if (string10 != null) {
                jdbcConnectionPool.setFailAllConnections(Boolean.valueOf(string10));
            }
            if (string11 != null) {
                jdbcConnectionPool.setValidationTableName(string11);
            }
            if (string12 != null) {
                jdbcConnectionPool.setResType(string12);
            }
            if (string13 != null) {
                jdbcConnectionPool.setTransactionIsolationLevel(string13);
            }
            if (string14 != null) {
                jdbcConnectionPool.setIsIsolationLevelGuaranteed(Boolean.valueOf(string14));
            }
            if ((string2 = resource.getDescription()) != null) {
                jdbcConnectionPool.setDescription(string2);
            }
            if ((elementPropertyArray = resource.getElementProperty()) != null) {
                for (int i = 0; i < elementPropertyArray.length; ++i) {
                    jdbcConnectionPool.addElementProperty(elementPropertyArray[i]);
                }
            }
            configContext.flush();
        }
        catch (Exception exception) {
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    public void deleteJDBCConnectionPool(String string) throws AFResourceException {
        ArgChecker.checkValid((Object)string, (String)"poolName", (Validator)StringValidator.getInstance());
        sLogger.log(Level.FINE, "mbean.delele_jdbc_pool", string);
        try {
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            JdbcConnectionPool jdbcConnectionPool = resources.getJdbcConnectionPoolByName(string);
            if (jdbcConnectionPool == null) {
                String string2 = localStrings.getString("admin.server.core.mbean.config.no_such_resource", string);
                throw new Exception(string2);
            }
            resources.removeJdbcConnectionPool(jdbcConnectionPool);
            configContext.flush();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.delete_jdbc_pool_failed", exception);
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    public String[] listJDBCConnectionPools() throws AFException {
        String[] stringArray = null;
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            JdbcConnectionPool[] jdbcConnectionPoolArray = resources.getJdbcConnectionPool();
            if (jdbcConnectionPoolArray != null) {
                stringArray = new String[jdbcConnectionPoolArray.length];
                for (int i = 0; i < jdbcConnectionPoolArray.length; ++i) {
                    stringArray[i] = jdbcConnectionPoolArray[i].getName();
                }
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.list_failed", exception);
            throw new AFException(exception.getLocalizedMessage());
        }
        return stringArray;
    }

    public void createJDBCResource(String string, String string2) throws AFResourceException {
        ArgChecker.checkValid((Object)string, (String)"jndiName", (Validator)StringValidator.getInstance());
        ArgChecker.checkValid((Object)string2, (String)"poolName", (Validator)StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.create_resource", string);
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            JdbcResource jdbcResource = new JdbcResource();
            jdbcResource.setJndiName(string);
            jdbcResource.setPoolName(string2);
            resources.addJdbcResource(jdbcResource);
            configContext.flush();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.create_resource_failed", exception);
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    private void addJDBCResourceAttribute(Resource resource, Properties properties, String string) throws AFResourceException {
        try {
            String string2;
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            JdbcResource jdbcResource = resources.getJdbcResourceByJndiName(string);
            String string3 = properties.getProperty("enabled");
            if (string3 != null) {
                jdbcResource.setEnabled(Boolean.valueOf(string3));
            }
            if ((string2 = resource.getDescription()) != null) {
                jdbcResource.setDescription(string2);
            }
            configContext.flush();
        }
        catch (Exception exception) {
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    public void deleteJDBCResource(String string) throws AFResourceException {
        ArgChecker.checkValid((Object)string, (String)"jndiName", (Validator)StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.delete_resource", string);
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            JdbcResource jdbcResource = resources.getJdbcResourceByJndiName(string);
            if (jdbcResource == null) {
                String string2 = localStrings.getString("admin.server.core.mbean.config.no_such_resource", string);
                throw new Exception(string2);
            }
            resources.removeJdbcResource(jdbcResource);
            configContext.flush();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.delete_resource_failed", exception);
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    public String[] listJDBCResources() throws AFException {
        String[] stringArray = null;
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            JdbcResource[] jdbcResourceArray = resources.getJdbcResource();
            if (jdbcResourceArray != null) {
                stringArray = new String[jdbcResourceArray.length];
                for (int i = 0; i < jdbcResourceArray.length; ++i) {
                    stringArray[i] = jdbcResourceArray[i].getJndiName();
                }
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.list_failed", exception);
            throw new AFException(exception.getLocalizedMessage());
        }
        return stringArray;
    }

    public void createJavaMailResource(String string, String string2, String string3, String string4) throws AFResourceException {
        ArgChecker.checkValid((Object)string, (String)"jndiName", (Validator)StringValidator.getInstance());
        ArgChecker.checkValid((Object)string2, (String)"host", (Validator)StringValidator.getInstance());
        ArgChecker.checkValid((Object)string3, (String)"user", (Validator)StringValidator.getInstance());
        ArgChecker.checkValid((Object)string4, (String)"fromAddress", (Validator)StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.create_resource", string);
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            MailResource mailResource = new MailResource();
            mailResource.setJndiName(string);
            mailResource.setHost(string2);
            mailResource.setUser(string3);
            mailResource.setFrom(string4);
            mailResource.setEnabled(true);
            resources.addMailResource(mailResource);
            configContext.flush();
        }
        catch (Exception exception) {
            sLogger.log(Level.FINE, "mbean.create_resource_failed", exception);
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    private void addJavaMailAttribute(Resource resource, Properties properties, String string) throws AFResourceException {
        try {
            ElementProperty[] elementPropertyArray;
            String string2;
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            MailResource mailResource = resources.getMailResourceByJndiName(string);
            String string3 = properties.getProperty("store-protocol");
            String string4 = properties.getProperty("store-protocol-class");
            String string5 = properties.getProperty("transport-protocol");
            String string6 = properties.getProperty("transport-protocol-class");
            String string7 = properties.getProperty("debug");
            String string8 = properties.getProperty("enabled");
            if (string3 != null) {
                mailResource.setStoreProtocol(string3);
            }
            if (string4 != null) {
                mailResource.setStoreProtocolClass(string4);
            }
            if (string5 != null) {
                mailResource.setTransportProtocol(string5);
            }
            if (string6 != null) {
                mailResource.setTransportProtocolClass(string6);
            }
            if (string7 != null) {
                mailResource.setDebug(Boolean.valueOf(string7));
            }
            if (string8 != null) {
                mailResource.setEnabled(Boolean.valueOf(string8));
            }
            if ((string2 = resource.getDescription()) != null) {
                mailResource.setDescription(string2);
            }
            if ((elementPropertyArray = resource.getElementProperty()) != null) {
                for (int i = 0; i < elementPropertyArray.length; ++i) {
                    mailResource.addElementProperty(elementPropertyArray[i]);
                }
            }
            configContext.flush();
        }
        catch (Exception exception) {
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    public void deleteJavaMailResource(String string) throws AFResourceException {
        ArgChecker.checkValid((Object)string, (String)"jndiName", (Validator)StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.delete_resource", string);
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            MailResource mailResource = resources.getMailResourceByJndiName(string);
            if (mailResource == null) {
                String string2 = localStrings.getString("admin.server.core.mbean.config.no_such_resource", string);
                throw new Exception(string2);
            }
            resources.removeMailResource(mailResource);
            configContext.flush();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.delete_resource_failed", exception);
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    public String[] listJavaMailResources() throws AFException {
        String[] stringArray = null;
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            MailResource[] mailResourceArray = resources.getMailResource();
            if (mailResourceArray != null) {
                stringArray = new String[mailResourceArray.length];
                for (int i = 0; i < mailResourceArray.length; ++i) {
                    stringArray[i] = mailResourceArray[i].getJndiName();
                }
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.list_failed", exception);
            throw new AFException(exception.getLocalizedMessage());
        }
        return stringArray;
    }

    public void createJMSResource(String string, String string2) throws AFResourceException {
        ArgChecker.checkValid((Object)string, (String)"jndiName", (Validator)StringValidator.getInstance());
        ArgChecker.checkValid((Object)string2, (String)"resourceType", (Validator)StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.create_resource", string);
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            JmsResource jmsResource = new JmsResource();
            jmsResource.setJndiName(string);
            jmsResource.setResType(string2);
            jmsResource.setEnabled(true);
            resources.addJmsResource(jmsResource);
            configContext.flush();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.create_resource_failed", exception);
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    private void addJMSResourceAttribute(Resource resource, Properties properties, String string) throws AFResourceException {
        try {
            ElementProperty[] elementPropertyArray;
            String string2;
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            JmsResource jmsResource = resources.getJmsResourceByJndiName(string);
            String string3 = properties.getProperty("enabled");
            if (string3 != null) {
                jmsResource.setEnabled(Boolean.valueOf(string3));
            }
            if ((string2 = resource.getDescription()) != null) {
                jmsResource.setDescription(string2);
            }
            if ((elementPropertyArray = resource.getElementProperty()) != null) {
                for (int i = 0; i < elementPropertyArray.length; ++i) {
                    jmsResource.addElementProperty(elementPropertyArray[i]);
                }
            }
            configContext.flush();
        }
        catch (Exception exception) {
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    public void deleteJMSResource(String string) throws AFResourceException {
        ArgChecker.checkValid((Object)string, (String)"jndiName", (Validator)StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.delete_resource", string);
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            JmsResource jmsResource = resources.getJmsResourceByJndiName(string);
            if (jmsResource == null) {
                String string2 = localStrings.getString("admin.server.core.mbean.config.no_such_resource", string);
                throw new Exception(string2);
            }
            resources.removeJmsResource(jmsResource);
            configContext.flush();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.delete_resource_failed", exception);
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    public String[] listJMSResources() throws AFException {
        String[] stringArray = null;
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            JmsResource[] jmsResourceArray = resources.getJmsResource();
            if (jmsResourceArray != null) {
                stringArray = new String[jmsResourceArray.length];
                for (int i = 0; i < jmsResourceArray.length; ++i) {
                    stringArray[i] = jmsResourceArray[i].getJndiName();
                }
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.list_failed", exception);
            throw new AFException(exception.getLocalizedMessage());
        }
        return stringArray;
    }

    public void createJNDIResource(String string, String string2, String string3, String string4) throws AFResourceException {
        ArgChecker.checkValid((Object)string, (String)"jndiName", (Validator)StringValidator.getInstance());
        ArgChecker.checkValid((Object)string2, (String)"jndiLookupName", (Validator)StringValidator.getInstance());
        ArgChecker.checkValid((Object)string3, (String)"resourceType", (Validator)StringValidator.getInstance());
        ArgChecker.checkValid((Object)string4, (String)"factoryClass", (Validator)StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.create_resource", string);
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            ExternalJndiResource externalJndiResource = new ExternalJndiResource();
            externalJndiResource.setJndiName(string);
            externalJndiResource.setJndiLookupName(string2);
            externalJndiResource.setResType(string3);
            externalJndiResource.setFactoryClass(string4);
            externalJndiResource.setEnabled(true);
            resources.addExternalJndiResource(externalJndiResource);
            configContext.flush();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.create_resource_failed", exception);
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    private void addJNDIResourceAttribute(Resource resource, Properties properties, String string) throws AFResourceException {
        try {
            ElementProperty[] elementPropertyArray;
            String string2;
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            ExternalJndiResource externalJndiResource = resources.getExternalJndiResourceByJndiName(string);
            String string3 = properties.getProperty("enabled");
            if (string3 != null) {
                externalJndiResource.setEnabled(Boolean.valueOf(string3));
            }
            if ((string2 = resource.getDescription()) != null) {
                externalJndiResource.setDescription(string2);
            }
            if ((elementPropertyArray = resource.getElementProperty()) != null) {
                for (int i = 0; i < elementPropertyArray.length; ++i) {
                    externalJndiResource.addElementProperty(elementPropertyArray[i]);
                }
            }
            configContext.flush();
        }
        catch (Exception exception) {
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    public void deleteJNDIResource(String string) throws AFResourceException {
        ArgChecker.checkValid((Object)string, (String)"jndiName", (Validator)StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.delete_resource", string);
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            ExternalJndiResource externalJndiResource = resources.getExternalJndiResourceByJndiName(string);
            if (externalJndiResource == null) {
                String string2 = localStrings.getString("admin.server.core.mbean.config.no_such_resource", string);
                throw new Exception(string2);
            }
            resources.removeExternalJndiResource(externalJndiResource);
            configContext.flush();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.delete_resource_failed", exception);
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    public String[] listJNDIResources() throws AFException {
        String[] stringArray = null;
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            ExternalJndiResource[] externalJndiResourceArray = resources.getExternalJndiResource();
            if (externalJndiResourceArray != null) {
                stringArray = new String[externalJndiResourceArray.length];
                for (int i = 0; i < externalJndiResourceArray.length; ++i) {
                    stringArray[i] = externalJndiResourceArray[i].getJndiName();
                }
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.list_failed", exception);
            throw new AFException(exception.getLocalizedMessage());
        }
        return stringArray;
    }

    public void createPersistenceManagerFactoryResource(String string) throws AFResourceException {
        ArgChecker.checkValid((Object)string, (String)"jndiName", (Validator)StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.create_resource", string);
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            PersistenceManagerFactoryResource persistenceManagerFactoryResource = new PersistenceManagerFactoryResource();
            persistenceManagerFactoryResource.setJndiName(string);
            persistenceManagerFactoryResource.setEnabled(true);
            resources.addPersistenceManagerFactoryResource(persistenceManagerFactoryResource);
            configContext.flush();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.create_resource_failed", exception);
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    private void addPersistenceManagerFactoryAttribute(Resource resource, Properties properties, String string) throws AFResourceException {
        try {
            ElementProperty[] elementPropertyArray;
            String string2;
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            PersistenceManagerFactoryResource persistenceManagerFactoryResource = resources.getPersistenceManagerFactoryResourceByJndiName(string);
            String string3 = properties.getProperty("factory-class");
            String string4 = properties.getProperty("jdbc-resource-jndi-name");
            String string5 = properties.getProperty("enabled");
            if (string3 != null) {
                persistenceManagerFactoryResource.setFactoryClass(string3);
            }
            if (string4 != null) {
                persistenceManagerFactoryResource.setJdbcResourceJndiName(string4);
            }
            if (string5 != null) {
                persistenceManagerFactoryResource.setEnabled(Boolean.valueOf(string5));
            }
            if ((string2 = resource.getDescription()) != null) {
                persistenceManagerFactoryResource.setDescription(string2);
            }
            if ((elementPropertyArray = resource.getElementProperty()) != null) {
                for (int i = 0; i < elementPropertyArray.length; ++i) {
                    persistenceManagerFactoryResource.addElementProperty(elementPropertyArray[i]);
                }
            }
            configContext.flush();
        }
        catch (Exception exception) {
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    public void deletePersistenceManagerFactoryResource(String string) throws AFResourceException {
        ArgChecker.checkValid((Object)string, (String)"jndiName", (Validator)StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.delete_resource", string);
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            PersistenceManagerFactoryResource persistenceManagerFactoryResource = resources.getPersistenceManagerFactoryResourceByJndiName(string);
            if (persistenceManagerFactoryResource == null) {
                String string2 = localStrings.getString("admin.server.core.mbean.config.no_such_resource");
                throw new Exception(string2);
            }
            resources.removePersistenceManagerFactoryResource(persistenceManagerFactoryResource);
            configContext.flush();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.delete_resource_failed", exception);
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    public String[] listPersistenceManagerFactoryResources() throws AFException {
        String[] stringArray = null;
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            PersistenceManagerFactoryResource[] persistenceManagerFactoryResourceArray = resources.getPersistenceManagerFactoryResource();
            if (persistenceManagerFactoryResourceArray != null) {
                stringArray = new String[persistenceManagerFactoryResourceArray.length];
                for (int i = 0; i < persistenceManagerFactoryResourceArray.length; ++i) {
                    stringArray[i] = persistenceManagerFactoryResourceArray[i].getJndiName();
                }
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.list_failed", exception);
            throw new AFException(exception.getLocalizedMessage());
        }
        return stringArray;
    }

    public void createCustomResource(String string, String string2, String string3) throws AFResourceException {
        ArgChecker.checkValid((Object)string, (String)"jndiName", (Validator)StringValidator.getInstance());
        ArgChecker.checkValid((Object)string3, (String)"factoryClass", (Validator)StringValidator.getInstance());
        ArgChecker.checkValid((Object)string2, (String)"resourceType", (Validator)StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.create_resource", string);
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            CustomResource customResource = new CustomResource();
            customResource.setJndiName(string);
            customResource.setResType(string2);
            customResource.setFactoryClass(string3);
            customResource.setEnabled(true);
            resources.addCustomResource(customResource);
            configContext.flush();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.create_resource_failed", exception);
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    private void addCustomResourceAttribute(Resource resource, Properties properties, String string) throws AFResourceException {
        try {
            ElementProperty[] elementPropertyArray;
            String string2;
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            CustomResource customResource = resources.getCustomResourceByJndiName(string);
            String string3 = properties.getProperty("enabled");
            if (string3 != null) {
                customResource.setEnabled(Boolean.valueOf(string3));
            }
            if ((string2 = resource.getDescription()) != null) {
                customResource.setDescription(string2);
            }
            if ((elementPropertyArray = resource.getElementProperty()) != null) {
                for (int i = 0; i < elementPropertyArray.length; ++i) {
                    customResource.addElementProperty(elementPropertyArray[i]);
                }
            }
            configContext.flush();
        }
        catch (Exception exception) {
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    public void deleteCustomResource(String string) throws AFResourceException {
        ArgChecker.checkValid((Object)string, (String)"jndiName", (Validator)StringValidator.getInstance());
        try {
            sLogger.log(Level.FINE, "mbean.delete_resource", string);
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            CustomResource customResource = resources.getCustomResourceByJndiName(string);
            if (customResource == null) {
                String string2 = localStrings.getString("admin.server.core.mbean.config.no_such_resource", string);
                throw new Exception(string2);
            }
            resources.removeCustomResource(customResource);
            configContext.flush();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.delete_resource_failed", exception);
            throw new AFResourceException(exception.getLocalizedMessage());
        }
    }

    public String[] listCustomResources() throws AFException {
        String[] stringArray = null;
        try {
            sLogger.log(Level.FINE, "mbean.list_components");
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Resources resources = (Resources)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_RESOURCES);
            CustomResource[] customResourceArray = resources.getCustomResource();
            if (customResourceArray != null) {
                stringArray = new String[customResourceArray.length];
                for (int i = 0; i < customResourceArray.length; ++i) {
                    stringArray[i] = customResourceArray[i].getJndiName();
                }
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.list_failed", exception);
            throw new AFException(exception.getLocalizedMessage());
        }
        return stringArray;
    }

    public void setHttpPort(int n) {
    }

    public HostAndPort getHostAndPort() throws ServerInstanceException {
        HostAndPort hostAndPort = null;
        try {
            Server server = (Server)super.getBaseConfigBean();
            HttpService httpService = server.getHttpService();
            HttpListener[] httpListenerArray = httpService.getHttpListener();
            HttpListener httpListener = httpListenerArray[0];
            for (int i = 0; i < httpListenerArray.length; ++i) {
                if (!httpListenerArray[i].isEnabled()) continue;
                httpListener = httpListenerArray[i];
                break;
            }
            String string = httpListener.getPort();
            int n = Integer.parseInt(string);
            hostAndPort = new HostAndPort(httpListener.getServerName(), n);
        }
        catch (Exception exception) {
            throw new ServerInstanceException(exception.getLocalizedMessage());
        }
        return hostAndPort;
    }

    public int getHttpPort() {
        return 9000;
    }

    public ServerInstanceStatus getStatus() throws ControlException {
        int n = this.getInstanceStatusCode();
        ServerInstanceStatus serverInstanceStatus = new ServerInstanceStatus(n);
        if (this.isDebug()) {
            serverInstanceStatus.setDebug(true);
            try {
                serverInstanceStatus.setDebugPort(this.getDebugPort());
            }
            catch (Exception exception) {
                sLogger.finest("Problem with getting port:ManagedServerInstance:getStatus");
                throw new ControlException(exception.getLocalizedMessage());
            }
        }
        sLogger.exiting(this.getClass().getName(), "getStatus", serverInstanceStatus.getStatusString());
        return serverInstanceStatus;
    }

    public boolean isRestartNeeded() {
        RMIClient rMIClient;
        AdminEventCache adminEventCache = AdminEventCache.getInstance(this.mInstanceName);
        boolean bl = adminEventCache.isInstanceRestartNeeded();
        if (bl && !(rMIClient = AdminChannel.getRMIClient(this.mInstanceName)).isAlive()) {
            bl = false;
        }
        return bl;
    }

    private boolean isAlive() {
        boolean bl = false;
        RMIClient rMIClient = AdminChannel.getRMIClient(this.mInstanceName);
        bl = rMIClient.isAlive();
        return bl;
    }

    private int getInstanceStatusCode() {
        int n = 3;
        RMIClient rMIClient = AdminChannel.getRMIClient(this.mInstanceName);
        n = rMIClient.getInstanceStatusCode();
        return n;
    }

    public void reconfigure() {
    }

    public boolean isApplyNeeded() throws ServerInstanceException {
        return this.isApplyNeeded(true);
    }

    public boolean isApplyNeeded(boolean bl) throws ServerInstanceException {
        Object object;
        boolean bl2 = false;
        try {
            object = this.getConfigContext(this.mInstanceName);
            bl2 = object.isChanged();
        }
        catch (ConfigException configException) {
            throw new ServerInstanceException(configException.getMessage());
        }
        if (!bl2 && bl) {
            object = new InstanceEnvironment(this.mInstanceName);
            bl2 = ((InstanceEnvironment)object).hasCGIConfigFilesChanged();
            if (!bl2) {
                bl2 = ((InstanceEnvironment)object).hasRealmsKeyConfFileChanged();
            }
            if (!bl2) {
                bl2 = ((InstanceEnvironment)object).hasVirtualServerConfFileChanged();
            }
        }
        return bl2;
    }

    public boolean overwriteConfigChanges() throws ServerInstanceException {
        try {
            return this.applyChanges(true);
        }
        catch (AFRuntimeStoreException aFRuntimeStoreException) {
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(this.mInstanceName);
            if (instanceEnvironment.canReloadManualXmlChanges()) {
                try {
                    instanceEnvironment.useManualServerXmlChanges();
                    this.reloadAfterChange(instanceEnvironment);
                }
                catch (ConfigException configException) {
                    // empty catch block
                }
                return true;
            }
            throw aFRuntimeStoreException;
        }
    }

    public boolean applyConfigChanges() throws ServerInstanceException {
        return this.applyChanges(false);
    }

    private boolean applyChanges(boolean bl) throws ServerInstanceException {
        boolean bl2 = false;
        try {
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(this.mInstanceName);
            boolean bl3 = instanceEnvironment.hasInitOrObjConfFileChanged() || instanceEnvironment.hasRealmsKeyConfFileChanged() || instanceEnvironment.hasVirtualServerConfFileChanged();
            boolean bl4 = instanceEnvironment.hasMimeConfFileChanged();
            instanceEnvironment.applyChangesFromBackup(bl);
            bl2 = this.sendNotificationOnApply(bl3, bl4);
        }
        catch (ConfigException configException) {
            throw new ServerInstanceException(configException.getMessage());
        }
        return bl2;
    }

    public boolean canApplyConfigChanges() throws ConfigException {
        boolean bl = false;
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment(this.mInstanceName);
        boolean bl2 = bl = !ManualChangeManager.hasHotChanged(this.mInstanceName);
        if (!bl && instanceEnvironment.canReloadManualXmlChanges()) {
            instanceEnvironment.useManualServerXmlChanges();
            this.reloadAfterChange(instanceEnvironment);
            boolean bl3 = instanceEnvironment.restartRequired();
            if (bl3) {
                AdminEventCache adminEventCache = AdminEventCache.getInstance(this.mInstanceName);
                adminEventCache.setRestartNeeded(true);
            }
            return true;
        }
        return bl;
    }

    void reloadAfterChange(InstanceEnvironment instanceEnvironment) throws ConfigException {
        MBeanServer mBeanServer = MBeanServerFactory.getMBeanServer();
        ObjectName[] objectNameArray = ObjectNameHelper.getInstanceRelatedMBeans((MBeanServer)mBeanServer, (String)this.mInstanceName);
        for (int i = 0; i < objectNameArray.length; ++i) {
            try {
                mBeanServer.unregisterMBean(objectNameArray[i]);
                continue;
            }
            catch (Exception exception) {
                sLogger.log(Level.WARNING, "Exception: ", exception);
            }
        }
        String string = instanceEnvironment.getBackupConfigFilePath();
        ConfigFactory.removeConfigContext(string);
    }

    public boolean useManualConfigChanges() throws ServerInstanceException {
        boolean bl = false;
        try {
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(this.mInstanceName);
            instanceEnvironment.useManualConfigChanges();
            this.reloadAfterChange(instanceEnvironment);
            bl = instanceEnvironment.restartRequired();
            if (bl) {
                AdminEventCache adminEventCache = AdminEventCache.getInstance(this.mInstanceName);
                adminEventCache.setRestartNeeded(true);
            }
        }
        catch (ConfigException configException) {
            throw new ServerInstanceException(configException.getMessage());
        }
        return bl;
    }

    public void startMonitor() {
    }

    public String[] getMonitorableComponentNames() {
        return null;
    }

    public void stopMonitor() {
    }

    public void createLifeCycleModule(String string, String string2) throws AFException {
        ArgChecker.checkValid((Object)string, (String)"moduleName", (Validator)StringValidator.getInstance());
        ArgChecker.checkValid((Object)string2, (String)"className", (Validator)StringValidator.getInstance());
        try {
            sLogger.log(Level.FINEST, "mbean.create_lifecycle", string);
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Applications applications = (Applications)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_APPLICATIONS);
            LifecycleModule lifecycleModule = new LifecycleModule();
            lifecycleModule.setName(string);
            lifecycleModule.setClassName(string2);
            lifecycleModule.setEnabled(true);
            applications.addLifecycleModule(lifecycleModule);
            configContext.flush();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.create_lifecycle_failed", exception);
            throw new AFException(exception.getMessage());
        }
    }

    public void deleteLifeCycleModule(String string) throws AFException {
        ArgChecker.checkValid((Object)string, (String)"moduleName", (Validator)StringValidator.getInstance());
        try {
            sLogger.log(Level.FINEST, "mbean.delete_lifecycle", string);
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Applications applications = (Applications)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_APPLICATIONS);
            LifecycleModule lifecycleModule = applications.getLifecycleModuleByName(string);
            applications.removeLifecycleModule(lifecycleModule);
            configContext.flush();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.delete_lifecycle_failed", exception);
            throw new AFException(exception.getMessage());
        }
    }

    public String[] listLifeCycleModules() throws AFException {
        String[] stringArray = new String[]{};
        try {
            sLogger.log(Level.FINEST, "mbean.list_components");
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Applications applications = (Applications)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_APPLICATIONS);
            LifecycleModule[] lifecycleModuleArray = applications.getLifecycleModule();
            if (lifecycleModuleArray != null && lifecycleModuleArray.length > 0) {
                stringArray = new String[lifecycleModuleArray.length];
                for (int i = 0; i < lifecycleModuleArray.length; ++i) {
                    stringArray[i] = lifecycleModuleArray[i].getName();
                }
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.list_failed", exception);
            throw new AFException(exception.getMessage());
        }
        return stringArray;
    }

    public String getClientStubJarLocation(String string, int n) throws AFException {
        ArgChecker.checkValid((Object)string, (String)"appName", (Validator)StringValidator.getInstance());
        if (n != 1001 && n != 1003) {
            String string2 = localStrings.getString("admin.server.core.mbean.config.expected_application_type");
            throw new AFException(string2);
        }
        String string3 = null;
        try {
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            Applications applications = (Applications)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_APPLICATIONS);
            String string4 = null;
            switch (n) {
                case 1001: {
                    J2eeApplication j2eeApplication = applications.getJ2eeApplicationByName(string);
                    string4 = j2eeApplication.getLocation();
                    break;
                }
                case 1003: {
                    EjbModule ejbModule = applications.getEjbModuleByName(string);
                    string4 = ejbModule.getLocation();
                }
            }
            string3 = string4 + File.separator + string + "Client.jar";
            sLogger.log(Level.INFO, "mbean.cl_jar_loc", string3);
        }
        catch (Exception exception) {
            throw new AFException(exception.getLocalizedMessage());
        }
        return string3;
    }

    public void postRegister(Boolean bl) {
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        ObjectName objectName2 = null;
        objectName2 = new ObjectName("ias:type=serverinstance, name=");
        return objectName2;
    }

    public void postDeregister() {
    }

    public void preDeregister() throws Exception {
    }

    private void registerApplicationMBean(String string) throws MBeanException {
        ObjectName objectName = ObjectNames.getApplicationObjectName((String)this.mInstanceName, (String)string);
        MBeanServer mBeanServer = MBeanServerFactory.getMBeanServer();
        if (!mBeanServer.isRegistered(objectName)) {
            try {
                ManagedJ2EEApplication managedJ2EEApplication = new ManagedJ2EEApplication(this.mInstanceName, string);
                mBeanServer.registerMBean(managedJ2EEApplication, objectName);
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                ExceptionUtil.ignoreException((Exception)instanceAlreadyExistsException);
            }
            catch (Exception exception) {
                throw new MBeanException(exception);
            }
        }
    }

    private void registerEJBModuleMBean(String string) throws MBeanException {
        ObjectName objectName = ObjectNames.getEjbModuleObjectName((String)this.mInstanceName, (String)string);
        MBeanServer mBeanServer = MBeanServerFactory.getMBeanServer();
        if (!mBeanServer.isRegistered(objectName)) {
            try {
                ManagedStandaloneJ2EEEjbJarModule managedStandaloneJ2EEEjbJarModule = new ManagedStandaloneJ2EEEjbJarModule(this.mInstanceName, string);
                mBeanServer.registerMBean(managedStandaloneJ2EEEjbJarModule, objectName);
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                ExceptionUtil.ignoreException((Exception)instanceAlreadyExistsException);
            }
            catch (Exception exception) {
                throw new MBeanException(exception);
            }
        }
    }

    private void registerWebModuleMBean(String string) {
        ObjectName objectName = ObjectNames.getWebModuleObjectName((String)this.mInstanceName, (String)string);
        MBeanServer mBeanServer = MBeanServerFactory.getMBeanServer();
        if (!mBeanServer.isRegistered(objectName)) {
            // empty if block
        }
    }

    private void registerConnectorModuleMBean(String string) {
        ObjectName objectName = ObjectNames.getConnectorModuleObjectName((String)this.mInstanceName, (String)string);
        MBeanServer mBeanServer = MBeanServerFactory.getMBeanServer();
        if (!mBeanServer.isRegistered(objectName)) {
            // empty if block
        }
    }

    ConfigContext getConfigContext(String string) throws ConfigException {
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string);
        String string2 = instanceEnvironment.getBackupConfigFilePath();
        ConfigContext configContext = ConfigFactory.createConfigContext(string2);
        return configContext;
    }

    private String getModuleTypeString(int n) {
        String string = null;
        switch (n) {
            case 1003: {
                string = "ejb";
                break;
            }
            case 1002: {
                string = "web";
                break;
            }
            case 1004: {
                string = "connector";
            }
        }
        return string;
    }

    private boolean multicastEvent(int n, String string) {
        return this.multicastEvent(n, string, null);
    }

    private boolean multicastEvent(int n, String string, String string2) {
        String string3 = this.getInstanceName();
        AdminEvent adminEvent = null;
        if (n == 1) {
            adminEvent = new ApplicationDeployEvent(string3, string, "deploy");
        } else if (n == 2) {
            adminEvent = new ApplicationDeployEvent(string3, string, "undeploy");
        } else if (n == 3) {
            adminEvent = new ApplicationDeployEvent(string3, string, "redeploy");
        } else if (n == 4) {
            adminEvent = new ModuleDeployEvent(string3, string, string2, "deploy");
        } else if (n == 5) {
            adminEvent = new ModuleDeployEvent(string3, string, string2, "undeploy");
        } else if (n == 6) {
            adminEvent = new ModuleDeployEvent(string3, string, string2, "redeploy");
        } else if (n == 7) {
            adminEvent = new ConfigChangeEvent(string3, null);
        } else {
            String string4 = localStrings.getString("admin.server.core.mbean.config.no_such_event", new Integer(n));
            throw new RuntimeException(string4);
        }
        if (adminEvent instanceof ApplicationDeployEvent || adminEvent instanceof ModuleDeployEvent) {
            AdminEventCache.populateConfigChange(this.getConfigContext(), adminEvent);
        }
        if (this.getInstanceStatusCode() != 0) {
            sLogger.log(Level.INFO, "mbean.inst_down_skip_event", this.mInstanceName);
            return true;
        }
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.log(Level.FINEST, "mbean.event_sent", adminEvent.getEventInfo());
        } else {
            sLogger.log(Level.INFO, "mbean.send_event", adminEvent.toString());
        }
        AdminEventResult adminEventResult = AdminEventMulticaster.multicastEvent(adminEvent);
        sLogger.log(Level.INFO, "mbean.event_res", adminEventResult.getResultCode());
        sLogger.log(Level.FINE, "mbean.event_reply", adminEventResult.getAllMessagesAsString());
        boolean bl = true;
        if (!"success".equals(adminEventResult.getResultCode())) {
            bl = false;
            AdminEventCache adminEventCache = AdminEventCache.getInstance(this.mInstanceName);
            adminEventCache.setRestartNeeded(true);
        }
        return bl;
    }

    public String getInstanceName() {
        return this.mInstanceName;
    }

    private boolean sendNotificationOnApply(boolean bl, boolean bl2) throws ConfigException {
        ConfigContext configContext = this.getConfigContext(this.mInstanceName);
        AdminEventCache adminEventCache = AdminEventCache.getInstance(this.mInstanceName);
        ArrayList arrayList = configContext.getConfigChangeList();
        configContext.resetConfigChangeList();
        adminEventCache.processConfigChangeList(arrayList, bl, bl2);
        ArrayList arrayList2 = adminEventCache.getAndResetCachedEvents();
        if (this.getInstanceStatusCode() != 0) {
            sLogger.log(Level.INFO, "mbean.inst_down_skip_event", this.mInstanceName);
            return false;
        }
        boolean bl3 = adminEventCache.isInstanceRestartNeeded();
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            AdminEvent adminEvent = (AdminEvent)iterator.next();
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.log(Level.FINEST, "mbean.event_sent", adminEvent.getEventInfo());
            } else {
                sLogger.log(Level.INFO, "mbean.send_event", adminEvent.toString());
            }
            AdminEventResult adminEventResult = AdminEventMulticaster.multicastEvent(adminEvent);
            sLogger.log(Level.FINE, "mbean.event_res", adminEventResult.getResultCode());
            sLogger.log(Level.FINEST, "mbean.event_reply", adminEventResult.getAllMessagesAsString());
            if ("success".equals(adminEventResult.getResultCode())) continue;
            bl3 = true;
            adminEventCache.setRestartNeeded(true);
            sLogger.log(Level.WARNING, "mbean.notif_failed");
        }
        return bl3;
    }

    private void deleteFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            File file2 = file.getParentFile();
            File file3 = new File(AdminService.getAdminService().getTempDirPath(), this.mInstanceName);
            if (file3 != null && file3.equals(file2)) {
                boolean bl = file.delete();
                if (bl) {
                    sLogger.log(Level.FINE, "mbean.delete_temp_file_ok", string);
                } else {
                    sLogger.log(Level.INFO, "mbean.delete_temp_file_failed", string);
                }
            }
        }
    }

    private boolean isAppExists(String string, int n) {
        ConfigBean configBean = null;
        try {
            ConfigContext configContext = super.getConfigContext();
            Applications applications = (Applications)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_APPLICATIONS);
            if (applications != null) {
                switch (n) {
                    case 1001: {
                        configBean = applications.getJ2eeApplicationByName(string);
                        break;
                    }
                    case 1003: {
                        configBean = applications.getEjbModuleByName(string);
                        break;
                    }
                    case 1002: {
                        configBean = applications.getWebModuleByName(string);
                        break;
                    }
                    case 1004: {
                        configBean = applications.getConnectorModuleByName(string);
                    }
                }
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "appexists failed", exception);
        }
        return configBean != null;
    }

    private final boolean isDebug() {
        boolean bl = false;
        try {
            JavaConfig javaConfig = this.getJavaConfigBean();
            String string = javaConfig.getAttributeValue(ServerTags.DEBUG_ENABLED);
            if (string != null) {
                bl = Boolean.valueOf(string);
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.is_debug_failed", exception);
        }
        return bl;
    }

    private final void setDebug(boolean bl) throws Exception {
        JavaConfig javaConfig = this.getJavaConfigBean();
        String string = String.valueOf(bl);
        javaConfig.setAttributeValue(ServerTags.DEBUG_ENABLED, string);
    }

    private final void setDebugOptions(String string) throws Exception {
        JavaConfig javaConfig = this.getJavaConfigBean();
        javaConfig.setAttributeValue(ServerTags.DEBUG_OPTIONS, string);
    }

    private final String getDebugOptions() throws Exception {
        JavaConfig javaConfig = this.getJavaConfigBean();
        return javaConfig.getAttributeValue(ServerTags.DEBUG_OPTIONS);
    }

    private final String getDefaultDebugOptions() throws Exception {
        return JavaConfig.getDefaultAttributeValue(ServerTags.DEBUG_OPTIONS);
    }

    private final int getDebugPort() throws Exception {
        String string;
        int n;
        int n2 = -1;
        String string2 = this.getDebugOptions();
        if (string2 != null && (n = string2.indexOf("-Xrunjdwp")) >= 0 && (n = (string = string2.substring(n)).indexOf("address=")) >= 0) {
            String string3 = string.substring(n);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "=, ");
            stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            n2 = Integer.parseInt(string4);
        }
        return n2;
    }

    private final void setDebugPort(int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getDefaultDebugOptions();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2);
            if (string2.startsWith("-Xrunjdwp")) {
                stringBuffer.append(",address=" + n);
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(' ');
        }
        string = stringBuffer.toString();
        string = string + " -Xnoagent -Djava.compiler=NONE";
        sLogger.log(Level.INFO, "mbean.debug_options", string);
        this.setDebugOptions(string);
    }

    private final JavaConfig getJavaConfigBean() throws Exception {
        Server server = (Server)super.getBaseConfigBean();
        if (!$assertionsDisabled && server == null) {
            throw new AssertionError();
        }
        JavaConfig javaConfig = server.getJavaConfig();
        javaConfig.setConfigContext(super.getConfigContext());
        return javaConfig;
    }

    public String[] getCertNicknames() throws Exception {
        String[] stringArray = new String[]{};
        String string = System.getProperty("java.home");
        String string2 = System.getProperty("file.separator");
        String string3 = System.getProperty("java.class.path");
        String string4 = this.getInstanceName();
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string4);
        String string5 = instanceEnvironment.getConfigDirPath();
        try {
            String string6;
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(string + string2 + "bin" + string2 + "java" + " ");
            stringBuffer.append("-classpath " + string3 + " ");
            stringBuffer.append("com.iplanet.ias.admin.server.core.mbean.config.CertOps ");
            stringBuffer.append("ListCertNickNames ");
            stringBuffer.append(string5 + " ");
            sLogger.log(Level.FINE, "ManagedServerInstance: about to exec " + stringBuffer.toString());
            Process process = Runtime.getRuntime().exec(stringBuffer.toString());
            InputStream inputStream = process.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string6 = bufferedReader.readLine()) != null) {
                if (!string6.startsWith("CertNickName")) continue;
                arrayList.add(string6);
            }
            process.waitFor();
            if (process.exitValue() != 0) {
                sLogger.log(Level.WARNING, "Encountered exception while trying to exec CertOps");
                throw new Exception("Encountered exception while trying to exec CertOps");
            }
            if (arrayList.size() < 1) {
                return stringArray;
            }
            stringArray = new String[arrayList.size()];
            string6 = null;
            int n = -1;
            for (int i = 0; i < arrayList.size(); ++i) {
                string6 = (String)arrayList.get(i);
                stringArray[i] = string6.substring("CertNickName".length() + 1);
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "exception while trying to retrieve certs", exception);
            throw exception;
        }
        return stringArray;
    }

    private FileRealm getInstanceRealmKeyFile() throws MBeanConfigException {
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment(this.mInstanceName);
        try {
            return new FileRealm(instanceEnvironment.getBackupRealmsKeyFilePath());
        }
        catch (BadRealmException badRealmException) {
            throw new MBeanConfigException(badRealmException.getMessage());
        }
        catch (NoSuchRealmException noSuchRealmException) {
            throw new MBeanConfigException(noSuchRealmException.getMessage());
        }
    }

    private void saveInstanceRealmKeyFile(FileRealm fileRealm) throws MBeanConfigException {
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment(this.mInstanceName);
        try {
            fileRealm.writeKeyFile(instanceEnvironment.getBackupRealmsKeyFilePath());
        }
        catch (IOException iOException) {
            throw new MBeanConfigException(iOException.getMessage());
        }
    }

    private String[] convertEnumerationToStringArray(Enumeration enumeration) {
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getUserNames() throws MBeanConfigException {
        FileRealm fileRealm = this.getInstanceRealmKeyFile();
        try {
            return this.convertEnumerationToStringArray(fileRealm.getUserNames());
        }
        catch (BadRealmException badRealmException) {
            throw new MBeanConfigException(badRealmException.getMessage());
        }
    }

    public String[] getGroupNames() throws MBeanConfigException {
        FileRealm fileRealm = this.getInstanceRealmKeyFile();
        try {
            return this.convertEnumerationToStringArray(fileRealm.getGroupNames());
        }
        catch (BadRealmException badRealmException) {
            throw new MBeanConfigException(badRealmException.getMessage());
        }
    }

    public String[] getUserGroupNames(String string) throws MBeanConfigException {
        FileRealm fileRealm = this.getInstanceRealmKeyFile();
        try {
            return this.convertEnumerationToStringArray(fileRealm.getGroupNames(string));
        }
        catch (NoSuchUserException noSuchUserException) {
            throw new MBeanConfigException(noSuchUserException.getMessage());
        }
    }

    public void addUser(String string, String string2, String[] stringArray) throws MBeanConfigException {
        FileRealm fileRealm = this.getInstanceRealmKeyFile();
        try {
            fileRealm.addUser(string, string2, stringArray);
            this.saveInstanceRealmKeyFile(fileRealm);
        }
        catch (BadRealmException badRealmException) {
            throw new MBeanConfigException(badRealmException.getMessage());
        }
        catch (IASSecurityException iASSecurityException) {
            throw new MBeanConfigException(iASSecurityException.getMessage());
        }
    }

    public void removeUser(String string) throws MBeanConfigException {
        FileRealm fileRealm = this.getInstanceRealmKeyFile();
        try {
            fileRealm.removeUser(string);
            this.saveInstanceRealmKeyFile(fileRealm);
        }
        catch (NoSuchUserException noSuchUserException) {
            throw new MBeanConfigException(noSuchUserException.getMessage());
        }
    }

    public void updateUser(String string, String string2, String[] stringArray) throws MBeanConfigException {
        FileRealm fileRealm = this.getInstanceRealmKeyFile();
        try {
            fileRealm.updateUser(string, string, string2, stringArray);
            this.saveInstanceRealmKeyFile(fileRealm);
        }
        catch (BadRealmException badRealmException) {
            throw new MBeanConfigException(badRealmException.getMessage());
        }
        catch (NoSuchUserException noSuchUserException) {
            throw new MBeanConfigException(noSuchUserException.getMessage());
        }
        catch (IASSecurityException iASSecurityException) {
            throw new MBeanConfigException(iASSecurityException.getMessage());
        }
    }

    private void testDeployedFile(String string, boolean bl) throws DeploymentException {
        if (string == null) {
            String string2 = localStrings.getString("admin.server.core.mbean.config.deploy_null_name");
            throw new DeploymentException(string2);
        }
        File file = new File(string);
        if (bl && !file.isDirectory()) {
            String string3 = localStrings.getString("admin.server.core.mbean.config.deploy_not_directory", string);
            throw new DeploymentException(string3);
        }
        if (!bl && !file.isFile()) {
            String string4 = localStrings.getString("admin.server.core.mbean.config.deploy_not_file", string);
            throw new DeploymentException(string4);
        }
    }

    public String getInstanceRoot() {
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment(this.mInstanceName);
        return instanceEnvironment.getInstanceDirPath();
    }

    private void setDeployDirOwner(DeploymentRequest deploymentRequest, InstanceEnvironment instanceEnvironment) {
        try {
            String string = instanceEnvironment.getInstanceUser();
            File file = deploymentRequest.getDeployedDirectory();
            this.chownDir(file, string);
            File file2 = deploymentRequest.getStubsDirectory();
            this.chownDir(file2, string);
            File file3 = deploymentRequest.getJSPDirectory();
            this.chownDir(file3, string);
        }
        catch (Throwable throwable) {
            sLogger.log(Level.WARNING, "mbean.deploy_chown_failed", throwable.getMessage());
            sLogger.log(Level.FINE, "general.unexpected_exception", throwable);
        }
    }

    private void chownDir(File file, String string) {
        if (file == null || string == null || string.trim().equals("")) {
            return;
        }
        String string2 = null;
        installConfig installConfig2 = new installConfig();
        string2 = installConfig2.chownDir(file.getAbsolutePath(), string);
        if (string2 != null) {
            sLogger.log(Level.WARNING, string2);
        }
    }

    public void createIIOPEndpoint(String string, String string2, String string3, String string4) throws AFException {
        try {
            IiopServerInstance iiopServerInstance;
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            AvailabilityService availabilityService = (AvailabilityService)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_AVAILABILITY_SERVICE);
            if (availabilityService == null) {
                String string5 = localStrings.getString("admin.server.core.mbean.config.availability_service_does_not_exist");
                throw new Exception(string5);
            }
            IiopCluster iiopCluster = availabilityService.getIiopCluster();
            if (iiopCluster == null) {
                iiopCluster = new IiopCluster();
                availabilityService.setIiopCluster(iiopCluster);
            }
            IiopEndpoint iiopEndpoint = new IiopEndpoint();
            if (string2 != null) {
                iiopEndpoint.setId(string2);
            }
            if (string3 != null) {
                iiopEndpoint.setHost(string3);
            }
            if (string4 != null) {
                iiopEndpoint.setPort(string4);
            }
            if ((iiopServerInstance = iiopCluster.getIiopServerInstanceByName(string)) == null) {
                iiopServerInstance = new IiopServerInstance();
                iiopServerInstance.setName(string);
                iiopCluster.addIiopServerInstance(iiopServerInstance);
            }
            if (iiopEndpoint != null) {
                iiopServerInstance.addIiopEndpoint(iiopEndpoint);
            }
            configContext.flush();
        }
        catch (Exception exception) {
            throw new AFException(exception.getLocalizedMessage());
        }
    }

    public void deleteIIOPEndpoint(String string, String string2) throws AFException {
        try {
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            AvailabilityService availabilityService = (AvailabilityService)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_AVAILABILITY_SERVICE);
            if (availabilityService == null) {
                String string3 = localStrings.getString("admin.server.core.mbean.config.availability_service_does_not_exist");
                throw new Exception(string3);
            }
            IiopCluster iiopCluster = availabilityService.getIiopCluster();
            if (iiopCluster == null) {
                String string4 = localStrings.getString("admin.server.core.mbean.config.iiop_cluster_does_not_exist");
                throw new Exception(string4);
            }
            IiopServerInstance iiopServerInstance = iiopCluster.getIiopServerInstanceByName(string);
            if (iiopServerInstance == null) {
                String string5 = localStrings.getString("admin.server.core.mbean.config.iiop_server_instance_does_not_exist");
                throw new Exception(string5);
            }
            if (string2 != null) {
                if (iiopServerInstance.getIiopEndpointById(string2) == null) {
                    String string6 = localStrings.getString("admin.server.core.mbean.config.iiop_endpoint_does_not_exists", string2);
                    throw new Exception(string6);
                }
                iiopServerInstance.removeIiopEndpoint(iiopServerInstance.getIiopEndpointById(string2));
                IiopEndpoint[] iiopEndpointArray = iiopServerInstance.getIiopEndpoint();
                if (iiopEndpointArray == null || iiopEndpointArray.length <= 0) {
                    iiopCluster.removeIiopServerInstance(iiopServerInstance);
                }
            } else {
                iiopCluster.removeIiopServerInstance(iiopServerInstance);
            }
            configContext.flush();
        }
        catch (Exception exception) {
            throw new AFException(exception.getLocalizedMessage());
        }
    }

    public void deleteIIOPCluster() throws AFException {
        try {
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            AvailabilityService availabilityService = (AvailabilityService)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_AVAILABILITY_SERVICE);
            if (availabilityService == null) {
                String string = localStrings.getString("admin.server.core.mbean.config.availability_service_does_not_exist");
                throw new Exception(string);
            }
            IiopCluster iiopCluster = availabilityService.getIiopCluster();
            if (iiopCluster == null) {
                String string = localStrings.getString("admin.server.core.mbean.config.iiop_cluster_does_not_exist");
                throw new Exception(string);
            }
            availabilityService.removeIiopCluster(iiopCluster);
            configContext.flush();
        }
        catch (Exception exception) {
            throw new AFException(exception.getLocalizedMessage());
        }
    }

    public String getIIOPClusterConfig() throws AFException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            IiopServerInstance[] iiopServerInstanceArray;
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            AvailabilityService availabilityService = (AvailabilityService)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_AVAILABILITY_SERVICE);
            if (availabilityService == null) {
                String string = localStrings.getString("admin.server.core.mbean.config.availability_service_does_not_exist");
                throw new Exception(string);
            }
            IiopCluster iiopCluster = availabilityService.getIiopCluster();
            if (iiopCluster == null) {
                String string = localStrings.getString("admin.server.core.mbean.config.iiop_cluster_does_not_exist");
                throw new Exception(string);
            }
            if (iiopCluster != null && (iiopServerInstanceArray = iiopCluster.getIiopServerInstance()) != null && iiopServerInstanceArray.length > 0) {
                for (int i = 0; i < iiopServerInstanceArray.length; ++i) {
                    if (i == 0) {
                        stringBuffer.append("IIOP Server Instance: ");
                    } else {
                        stringBuffer.append("\nIIOP Server Instance: ");
                    }
                    stringBuffer.append(iiopServerInstanceArray[i].getName());
                    IiopEndpoint[] iiopEndpointArray = iiopServerInstanceArray[i].getIiopEndpoint();
                    if (iiopEndpointArray == null || iiopEndpointArray.length <= 0) continue;
                    for (int j = 0; j < iiopEndpointArray.length; ++j) {
                        stringBuffer.append("\n \tIIOP Endpoint Id: ");
                        stringBuffer.append(iiopEndpointArray[j].getId());
                        stringBuffer.append(", Host:");
                        stringBuffer.append(iiopEndpointArray[j].getHost());
                        stringBuffer.append(", Port:");
                        stringBuffer.append(iiopEndpointArray[j].getPort());
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new AFException(exception.getLocalizedMessage());
        }
        return stringBuffer.toString();
    }

    public String[] getIIOPClusterInstances() throws AFException {
        String[] stringArray = null;
        try {
            IiopServerInstance[] iiopServerInstanceArray;
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            AvailabilityService availabilityService = (AvailabilityService)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_AVAILABILITY_SERVICE);
            if (availabilityService == null) {
                String string = localStrings.getString("admin.server.core.mbean.config.availability_service_does_not_exist");
                throw new Exception(string);
            }
            IiopCluster iiopCluster = availabilityService.getIiopCluster();
            if (iiopCluster == null) {
                String string = localStrings.getString("admin.server.core.mbean.config.iiop_cluster_does_not_exist");
                throw new Exception(string);
            }
            if (iiopCluster != null && (iiopServerInstanceArray = iiopCluster.getIiopServerInstance()) != null) {
                stringArray = new String[iiopServerInstanceArray.length];
                for (int i = 0; i < iiopServerInstanceArray.length; ++i) {
                    stringArray[i] = iiopServerInstanceArray[i].getName();
                }
            }
        }
        catch (Exception exception) {
            throw new AFException(exception.getLocalizedMessage());
        }
        return stringArray;
    }

    public String[] getIiopInstanceEndPoints(String string) throws AFException {
        String[] stringArray = null;
        IiopEndpoint[] iiopEndpointArray = null;
        try {
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            AvailabilityService availabilityService = (AvailabilityService)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_AVAILABILITY_SERVICE);
            if (availabilityService == null) {
                String string2 = localStrings.getString("admin.server.core.mbean.config.availability_service_does_not_exist");
                throw new Exception(string2);
            }
            IiopCluster iiopCluster = availabilityService.getIiopCluster();
            if (iiopCluster == null) {
                String string3 = localStrings.getString("admin.server.core.mbean.config.iiop_cluster_does_not_exist");
                throw new Exception(string3);
            }
            if (iiopCluster != null) {
                IiopServerInstance iiopServerInstance = iiopCluster.getIiopServerInstanceByName(string);
                if (iiopServerInstance == null) {
                    String string4 = localStrings.getString("admin.server.core.mbean.config.iiop_server_instance_does_not_exist");
                    throw new Exception(string4);
                }
                iiopEndpointArray = iiopServerInstance.getIiopEndpoint();
                if (iiopEndpointArray != null) {
                    stringArray = new String[iiopEndpointArray.length];
                    for (int i = 0; i < iiopEndpointArray.length; ++i) {
                        stringArray[i] = iiopEndpointArray[i].getId();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new AFException(exception.getLocalizedMessage());
        }
        return stringArray;
    }

    public void deleteIIOPClusterInstance(String string) throws AFException {
        try {
            ConfigContext configContext = this.getConfigContext(this.mInstanceName);
            AvailabilityService availabilityService = (AvailabilityService)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_AVAILABILITY_SERVICE);
            if (availabilityService == null) {
                String string2 = localStrings.getString("admin.server.core.mbean.config.availability_service_does_not_exist");
                throw new Exception(string2);
            }
            IiopCluster iiopCluster = availabilityService.getIiopCluster();
            if (iiopCluster == null) {
                String string3 = localStrings.getString("admin.server.core.mbean.config.iiop_cluster_does_not_exist");
                throw new Exception(string3);
            }
            iiopCluster.removeIiopServerInstance(iiopCluster.getIiopServerInstanceByName(string));
            configContext.flush();
        }
        catch (Exception exception) {
            throw new AFException(exception.getLocalizedMessage());
        }
    }

    static {
        $assertionsDisabled = !ManagedServerInstance.class.desiredAssertionStatus();
        sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
        MAPLIST = new String[][]{{"name", "@" + ServerTags.NAME}, {"locale", "@" + ServerTags.LOCALE}, {"logRoot", "@" + ServerTags.LOG_ROOT}, {"sessionStore", "@" + ServerTags.SESSION_STORE}, {"applicationRoot", "@" + ServerTags.APPLICATION_ROOT}, {"appDynamicReloadEnabled", ServerTags.APPLICATIONS + "/" + "@" + ServerTags.DYNAMIC_RELOAD_ENABLED}, {"appReloadPollInterval", ServerTags.APPLICATIONS + "/" + "@" + ServerTags.DYNAMIC_RELOAD_POLL_INTERVAL_IN_SECONDS}};
        ATTRIBUTES = new String[]{"name, String,        R", "locale, String,        RW", "logRoot, String,        RW", "sessionStore, String,        RW", "applicationRoot, String,        RW", "appDynamicReloadEnabled, boolean,        RW", "appReloadPollInterval, int,            RW"};
        OPERATIONS = new String[]{"start(),  ACTION, ManagedServerInstance.start1.operation", "start(String[] passwords),  ACTION, ManagedServerInstance.start1.operation", "start(boolean debug, String[] passwords), ACTION, ManagedServerInstance.start2.operation", "startInDebugMode(), ACTION", "startInDebugMode(String[] passwords), ACTION", "restart(),  ACTION", "stop(int timeoutSeconds), ACTION", "deployJ2EEApplication(String archiveName, String appName, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP), ACTION", "deployJ2EEApplicationDirectory(String archiveName, String appName, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP), ACTION", "deployJ2EEApplication(String archiveName, String appName, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP, String availabilityEnabled), ACTION", "deployJ2EEApplicationDirectory(String archiveName, String appName, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP, String availabilityEnabled), ACTION", "deployEJBJarModule(String filePath, String moduleName, boolean forceDeploy, boolean bVerify), ACTION", "deployEJBJarModuleDirectory(String filePath, String moduleName, boolean forceDeploy, boolean bVerify), ACTION", "deployEJBJarModule(String filePath, String moduleName, boolean forceDeploy, boolean bVerify, String availabilityEnabled), ACTION", "deployEJBJarModuleDirectory(String filePath, String moduleName, boolean forceDeploy, boolean bVerify, String availabilityEnabled), ACTION", "deployWarModule(String filePath, String webAppName, String contextRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP), ACTION", "deployWarModuleDirectory(String filePath, String webAppName, String contextRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP), ACTION", "deployWarModule(String filePath, String webAppName, String contextRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP, String availabilityEnabled), ACTION", "deployWarModuleDirectory(String filePath, String webAppName, String contextRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP, String availabilityEnabled), ACTION", "deployConnectorModule(String filePath, String moduleName, boolean forceDeploy, boolean bVerify), ACTION", "deployConnectorModuleDirectory(String filePath, String moduleName, boolean forceDeploy, boolean bVerify), ACTION", "getDeployedJ2EEApplications(), INFO ", "getDeployedJ2EEModules(),      INFO ", "getEnabledJ2EEApplications(),  INFO ", "getDisabledJ2EEApplications(), INFO ", "getEnabledJ2EEModules(),       INFO ", "getDisabledJ2EEModules(),      INFO ", "setHttpPort(int port ),    ACTION ", "getHostAndPort(),  INFO ", "getHttpPort(),            INFO ", "getStatus(),              INFO ", "reconfigure(),            ACTION ", "startMonitor(),           ACTION ", "getMonitorableComponentNames(), INFO ", "stopMonitor(),            ACTION ", "postRegister(Boolean registrationDone), ACTION ", "preRegister(javax.management.MBeanServer server, javax.management.ObjectName name), ACTION ", "postDeregister(),         ACTION ", "preDeregister(),          ACTION ", "getCertNicknames(),       INFO ", "getInstanceRoot(),        INFO ", "getSecurityPasswordTokens(),       INFO ", "isRestartNeeded(),        INFO", "getUserNames(),        INFO", "getGroupNames(),        INFO", "getUserGroupNames(String userName),        INFO", "addUser(String userName, String password, String[] groupList),       INFO ", "removeUser(String userName),       INFO ", "updateUser(String userName, String password, String[] groupList),       INFO ", "createIIOPEndpoint(String instanceName, String id, String host, String port),       ACTION ", "deleteIIOPEndpoint(String instanceName, String endpointId),       ACTION ", "deleteIIOPCluster(),       ACTION ", "getIIOPClusterConfig(),       INFO ", "getIIOPClusterInstances(),       INFO ", "deleteIIOPClusterInstance(String instanceName),       ACTION ", "getIiopInstanceEndPoints(String instanceName),       INFO"};
        localStrings = StringManager.getManager(ManagedServerInstance.class);
    }

    static interface TimerCallback {
        public boolean check() throws Exception;
    }

    private static final class ManagedInstanceTimer
    implements Runnable {
        private final int timeOutSeconds;
        private final TimerCallback callBack;
        private final int startAfterSeconds;
        private boolean timeOutReached;
        private long startTime;

        ManagedInstanceTimer(int n, int n2, TimerCallback timerCallback) {
            this.timeOutSeconds = n;
            this.startAfterSeconds = n2;
            this.callBack = timerCallback;
            this.timeOutReached = false;
        }

        public void run() {
            this.startTime = System.currentTimeMillis();
            try {
                Thread.currentThread();
                Thread.sleep(this.startAfterSeconds * 1000);
                while (!this.timeOutReached() && !this.callBack.check()) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                        this.computeTimeOut();
                    }
                    catch (InterruptedException interruptedException) {
                        sLogger.warning(interruptedException.toString());
                        this.timeOutReached = true;
                    }
                }
            }
            catch (Exception exception) {
                sLogger.warning(exception.toString());
                this.timeOutReached = true;
            }
        }

        private boolean timeOutReached() {
            return this.timeOutReached;
        }

        private void computeTimeOut() {
            long l = System.currentTimeMillis();
            this.timeOutReached = l - this.startTime >= (long)(this.timeOutSeconds * 1000);
        }
    }
}

