/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.server.core.mbean.config.ConfigMBeanBase;
import com.iplanet.ias.admin.server.core.mbean.config.SslBase;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.IiopListener;
import com.iplanet.ias.config.serverbeans.IiopService;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.ServerXPathHelper;
import com.iplanet.ias.config.serverbeans.Ssl;
import com.iplanet.ias.config.serverbeans.SslClientConfig;
import com.iplanet.ias.util.i18n.StringManager;

public class ManagedORBComponent
extends ConfigMBeanBase
implements ConfigAttributeName.ORB {
    private static StringManager localStrings = StringManager.getManager(ManagedORBComponent.class);
    private static final String ORB_ATTRIBUTE = ServerTags.ORB + "/" + "@";
    private static final String[][] MAPLIST = new String[][]{{"msgSize", ORB_ATTRIBUTE + ServerTags.MESSAGE_FRAGMENT_SIZE}, {"steadyThreadPoolSize", ORB_ATTRIBUTE + ServerTags.STEADY_THREAD_POOL_SIZE}, {"maxThreadPoolSize", ORB_ATTRIBUTE + ServerTags.MAX_THREAD_POOL_SIZE}, {"maxConnections", ORB_ATTRIBUTE + ServerTags.MAX_CONNECTIONS}, {"idleThreadTimeout", ORB_ATTRIBUTE + ServerTags.IDLE_THREAD_TIMEOUT_IN_SECONDS}, {"log", ORB_ATTRIBUTE + ServerTags.LOG_LEVEL}, {"monitor", ORB_ATTRIBUTE + ServerTags.MONITORING_ENABLED}};
    private static final String[] ATTRIBUTES = new String[]{"msgSize, int,      RW", "steadyThreadPoolSize, int,      RW", "maxThreadPoolSize, int,      RW", "maxConnections, int,      RW", "idleThreadTimeout, int,      RW", "log, String,   RW", "monitor, boolean,  RW"};
    private static final String[] OPERATIONS = new String[]{"createORBListener(String id, String address, Integer port, Boolean enabled), ACTION", "deleteORBListener(String id), ACTION", "listORBListeners(), INFO", "createSsl(String certNickname, Boolean ssl2Enabled, String ssl2Ciphers, Boolean ssl3Enabled, String ssl3TlsCiphers, Boolean tlsEnabled, Boolean tlsRollbackEnabled, Boolean clientAuthEnabled), ACTION", "deleteSsl(), ACTION", "isSslCreated(), INFO"};

    public ManagedORBComponent() throws MBeanConfigException {
        Object[] objectArray = ManagedORBComponent.MergeAttributesWithAnotherMbean(MAPLIST, ATTRIBUTES, SslBase.MAPLIST, SslBase.ATTRIBUTES, ServerTags.SSL_CLIENT_CONFIG + "/" + ServerTags.SSL, null);
        this.setDescriptions((String[][])objectArray[0], (String[])objectArray[1], OPERATIONS);
    }

    public ManagedORBComponent(String string) throws MBeanConfigException {
        this();
        this.initialize("orb", new String[]{string});
    }

    public void createORBListener(String string, String string2, Integer n, Boolean bl) throws ConfigException {
        IiopListener iiopListener = new IiopListener();
        if (string != null) {
            iiopListener.setId(string);
        }
        if (string2 != null) {
            iiopListener.setAddress(string2);
        }
        if (n != null) {
            iiopListener.setPort(n.toString());
        }
        if (bl != null) {
            iiopListener.setEnabled(bl);
        }
        IiopService iiopService = (IiopService)this.getConfigBeanByXPath(ServerXPathHelper.getIIOPServiceXpath());
        iiopService.addIiopListener(iiopListener);
        this.getConfigContext().flush();
    }

    public void deleteORBListener(String string) throws ConfigException {
        IiopService iiopService = (IiopService)this.getConfigBeanByXPath(ServerXPathHelper.getIIOPServiceXpath());
        IiopListener iiopListener = iiopService.getIiopListenerById(string);
        if (iiopListener != null) {
            iiopService.removeIiopListener(iiopListener);
        }
        this.getConfigContext().flush();
    }

    public String[] listORBListeners() throws ConfigException {
        IiopService iiopService = (IiopService)this.getConfigBeanByXPath(ServerXPathHelper.getIIOPServiceXpath());
        IiopListener[] iiopListenerArray = iiopService.getIiopListener();
        String[] stringArray = new String[iiopListenerArray.length];
        for (int i = 0; i < iiopListenerArray.length; ++i) {
            stringArray[i] = iiopListenerArray[i].getId();
        }
        return stringArray;
    }

    public boolean isSslCreated() throws ConfigException {
        IiopService iiopService = (IiopService)this.getBaseConfigBean();
        SslClientConfig sslClientConfig = iiopService.getSslClientConfig();
        if (sslClientConfig == null) {
            return false;
        }
        return sslClientConfig.getSsl() != null;
    }

    public void deleteSsl() throws ConfigException {
        IiopService iiopService = (IiopService)this.getBaseConfigBean();
        iiopService.setSslClientConfig(null);
        this.getConfigContext().flush();
    }

    public void createSsl(String string, Boolean bl, String string2, Boolean bl2, String string3, Boolean bl3, Boolean bl4, Boolean bl5) throws ConfigException {
        if (this.isSslCreated()) {
            String string4 = localStrings.getString("admin.server.core.mbean.config.iiopservice_has_ssl_created");
            throw new ConfigException(string4);
        }
        IiopService iiopService = (IiopService)this.getBaseConfigBean();
        SslClientConfig sslClientConfig = iiopService.getSslClientConfig();
        if (sslClientConfig == null) {
            sslClientConfig = new SslClientConfig();
        }
        Ssl ssl = new Ssl();
        if (string != null) {
            ssl.setCertNickname(string);
        }
        if (string2 != null) {
            ssl.setSsl2Ciphers(string2);
        }
        if (string3 != null) {
            ssl.setSsl3TlsCiphers(string3);
        }
        if (bl != null) {
            ssl.setSsl2Enabled(bl);
        }
        if (bl2 != null) {
            ssl.setSsl3Enabled(bl2);
        }
        if (bl3 != null) {
            ssl.setTlsEnabled(bl3);
        }
        if (bl4 != null) {
            ssl.setTlsRollbackEnabled(bl4);
        }
        if (bl5 != null) {
            ssl.setClientAuthEnabled(bl5);
        }
        sslClientConfig.setSsl(ssl);
        iiopService.setSslClientConfig(sslClientConfig);
        this.getConfigContext().flush();
    }
}

