/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.server.core.mbean.config.ConfigMBeanBase;
import com.iplanet.ias.admin.server.core.mbean.config.HTTPQosBase;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.Acl;
import com.iplanet.ias.config.serverbeans.HttpListener;
import com.iplanet.ias.config.serverbeans.HttpQos;
import com.iplanet.ias.config.serverbeans.HttpService;
import com.iplanet.ias.config.serverbeans.Mime;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.ServerManager;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import java.io.File;
import java.io.Serializable;

public class ManagedHTTPService
extends ConfigMBeanBase
implements ConfigAttributeName.HTTPService {
    public static final String ACL_VERSION = "version 3.0;";
    private static final String[][] MAPLIST;
    private static final String[] ATTRIBUTES;
    private static final String[] OPERATIONS;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ManagedHTTPService() throws MBeanConfigException {
        Object[] objectArray = ManagedHTTPService.MergeAttributesWithAnotherMbean(MAPLIST, ATTRIBUTES, HTTPQosBase.MAPLIST, HTTPQosBase.ATTRIBUTES, ServerTags.HTTP_QOS, null);
        this.setDescriptions((String[][])objectArray[0], (String[])objectArray[1], OPERATIONS);
    }

    public ManagedHTTPService(String string) throws MBeanConfigException {
        this();
        this.initialize("httpservice", new String[]{string});
    }

    public void createHTTPListener(String string, String string2, Integer n, Boolean bl, String string3, Integer n2, Boolean bl2, Boolean bl3, String string4, String string5) throws ConfigException {
        HttpListener httpListener = new HttpListener();
        if (string != null) {
            httpListener.setId(string);
        }
        if (string2 != null) {
            httpListener.setAddress(string2);
        }
        if (n != null) {
            httpListener.setPort(n.toString());
        }
        if (bl != null) {
            httpListener.setEnabled(bl);
        }
        if (string3 != null) {
            httpListener.setFamily(string3);
        }
        if (n2 != null) {
            httpListener.setAcceptorThreads(n2.toString());
        }
        if (bl2 != null) {
            httpListener.setBlockingEnabled(bl2);
        }
        if (bl3 != null) {
            httpListener.setSecurityEnabled(bl3);
        }
        if (string4 != null) {
            httpListener.setDefaultVirtualServer(string4);
        }
        if (string5 != null) {
            httpListener.setServerName(string5);
        }
        HttpService httpService = (HttpService)this.getBaseConfigBean();
        httpService.addHttpListener(httpListener);
        this.getConfigContext().flush();
    }

    public void deleteHTTPListener(String string) throws ConfigException {
        HttpService httpService = (HttpService)this.getBaseConfigBean();
        HttpListener httpListener = httpService.getHttpListenerById(string);
        if (httpListener != null) {
            httpService.removeHttpListener(httpListener);
        }
        this.getConfigContext().flush();
    }

    public String[] listHTTPListeners() throws ConfigException {
        HttpService httpService = (HttpService)this.getBaseConfigBean();
        HttpListener[] httpListenerArray = httpService.getHttpListener();
        String[] stringArray = new String[httpListenerArray.length];
        for (int i = 0; i < httpListenerArray.length; ++i) {
            stringArray[i] = httpListenerArray[i].getId();
        }
        return stringArray;
    }

    public void createMime(String string, String string2) throws ConfigException {
        Mime mime = new Mime();
        if (string != null) {
            mime.setId(string);
        }
        if (string2 != null) {
            mime.setFile(string2);
        }
        HttpService httpService = (HttpService)this.getBaseConfigBean();
        httpService.addMime(mime);
        this.createMimeFile(string2);
        this.getConfigContext().flush();
    }

    public void deleteMime(String string) throws ConfigException {
        HttpService httpService = (HttpService)this.getBaseConfigBean();
        Mime mime = httpService.getMimeById(string);
        String string2 = mime.getFile();
        if (mime != null) {
            httpService.removeMime(mime);
            this.deleteMimeFile(string2);
        }
        this.getConfigContext().flush();
    }

    public String[] listMimes() throws ConfigException {
        HttpService httpService = (HttpService)this.getBaseConfigBean();
        Mime[] mimeArray = httpService.getMime();
        String[] stringArray = new String[mimeArray.length];
        for (int i = 0; i < mimeArray.length; ++i) {
            stringArray[i] = mimeArray[i].getId();
        }
        return stringArray;
    }

    public void createAcl(String string, String string2) throws ConfigException {
        Serializable serializable;
        Acl acl = new Acl();
        if (string != null) {
            acl.setId(string);
        }
        if (string2 != null) {
            acl.setFile(string2);
            try {
                serializable = new File(InstanceEnvironment.getTemplatesDirPath(), "template.acl");
                if (!($assertionsDisabled || serializable != null && ((File)serializable).exists())) {
                    throw new AssertionError();
                }
                File file = new File(string2);
                if (file.exists()) {
                    String string3 = localStrings.getString("admin.server.core.mbean.config.managedhttpservice_acl_file_exists", string2);
                    throw new ConfigException(string3);
                }
                FileUtils.copy((File)serializable, file);
            }
            catch (Exception exception) {
                if (exception instanceof ConfigException) {
                    throw (ConfigException)exception;
                }
                String string4 = localStrings.getString("admin.server.core.mbean.config.managedhttpservice_cannot_create_acl_file_excp", string2, exception.getMessage());
                throw new ConfigException(string4);
            }
        }
        serializable = (HttpService)this.getBaseConfigBean();
        ((HttpService)serializable).addAcl(acl, true, true);
        this.getConfigContext().flush();
    }

    public void deleteAcl(String string) throws ConfigException {
        HttpService httpService = (HttpService)this.getBaseConfigBean();
        Acl acl = httpService.getAclById(string);
        if (acl != null) {
            httpService.removeAcl(acl);
        }
        this.getConfigContext().flush();
    }

    public String[] listAcls() throws ConfigException {
        HttpService httpService = (HttpService)this.getBaseConfigBean();
        Acl[] aclArray = httpService.getAcl();
        String[] stringArray = new String[aclArray.length];
        for (int i = 0; i < aclArray.length; ++i) {
            stringArray[i] = aclArray[i].getId();
        }
        return stringArray;
    }

    public void createHttpQos(String string, Boolean bl, String string2, Boolean bl2) throws ConfigException {
        HttpQos httpQos = new HttpQos();
        if (string != null) {
            httpQos.setBandwidthLimit(string);
        }
        if (bl != null) {
            httpQos.setEnforceBandwidthLimit(bl);
        }
        if (string2 != null) {
            httpQos.setConnectionLimit(string2);
        }
        if (bl2 != null) {
            httpQos.setEnforceConnectionLimit(bl2);
        }
        HttpService httpService = (HttpService)this.getBaseConfigBean();
        httpService.setHttpQos(httpQos);
        this.getConfigContext().flush();
    }

    public boolean isHttpQosCreated() throws ConfigException {
        HttpService httpService = (HttpService)this.getBaseConfigBean();
        return httpService.getHttpQos() != null;
    }

    public void deleteHttpQos() throws ConfigException {
        HttpService httpService = (HttpService)this.getBaseConfigBean();
        httpService.setHttpQos(null);
        this.getConfigContext().flush();
    }

    private void createMimeFile(String string) throws ConfigException {
        String string2 = ServerManager.instance().getMimeTypesTemplateFilePath();
        String string3 = this.getServerInstanceName();
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string3);
        String string4 = instanceEnvironment.getBackupConfigDirPath() + File.separator + string;
        try {
            FileUtils.copy(string2, string4);
        }
        catch (Exception exception) {
            throw new ConfigException(exception.getMessage());
        }
    }

    private void deleteMimeFile(String string) throws ConfigException {
        String string2 = this.getServerInstanceName();
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string2);
        String string3 = instanceEnvironment.getBackupConfigDirPath() + File.separator + string;
        boolean bl = new File(string3).delete();
        if (!bl) {
            String string4 = localStrings.getString("admin.server.core.mbean.config.managedhttpservice_cannot_delete_path", string3);
            throw new ConfigException(string4);
        }
    }

    static {
        $assertionsDisabled = !ManagedHTTPService.class.desiredAssertionStatus();
        MAPLIST = new String[][]{{"qos-metrics-interval-in-seconds", "@" + ServerTags.QOS_METRICS_INTERVAL_IN_SECONDS}, {"qos-recompute-time-interval-in-millis", "@" + ServerTags.QOS_RECOMPUTE_TIME_INTERVAL_IN_MILLIS}, {"qos-enabled", "@" + ServerTags.QOS_ENABLED}};
        ATTRIBUTES = new String[]{"qos-metrics-interval-in-seconds, int,        RW", "qos-recompute-time-interval-in-millis, int,        RW", "qos-enabled, boolean,    RW"};
        OPERATIONS = new String[]{"createHTTPListener(String id, String address, Integer port, Boolean enabled, String family, Integer acceptorThreads, Boolean blockingEnabled, Boolean securityEnabled, String defaultVirtualServer, String serverName), ACTION", "deleteHTTPListener(String id), ACTION", "listHTTPListeners(), INFO", "createMime(String id, String file), ACTION", "deleteMime(String id), ACTION", "listMimes(), INFO", "createAcl(String id, String file), ACTION", "deleteAcl(String id), ACTION", "listAcls(), INFO", "createHttpQos(String bandwidthLimit, Boolean enforceBandwidthLimit, String connectionLimit, Boolean enforceConnectionLimit), ACTION", "deleteHttpQos(), ACTION", "isHttpQosCreated(), INFO"};
        localStrings = StringManager.getManager(ManagedHTTPService.class);
    }
}

