/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.common.exception.PortInUseException;
import com.iplanet.ias.admin.common.exception.ServerInstanceException;
import com.iplanet.ias.admin.server.core.mbean.config.ConfigMBeanBase;
import com.iplanet.ias.admin.server.core.mbean.config.ManagedServerInstance;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.HttpListener;
import com.iplanet.ias.config.serverbeans.HttpService;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.instance.InstanceEnvironment;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ManagedAdminServerInstance
extends ConfigMBeanBase {
    private static final String[][] MAPLIST = new String[][]{{"locale", "@" + ServerTags.LOCALE}};
    private static final String[] ATTRIBUTES = new String[]{"locale, String,        RW"};
    private static final String[] OPERATIONS = new String[]{"applyConfigChanges(), ACTION", "useManualConfigChanges(), ACTION", "getHostAndPort(),  INFO", "isApplyNeeded(), INFO", "getCertNicknames(), INFO", "isRestartNeeded(), INFO"};
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private ManagedServerInstance mDelegate;
    private boolean mRestartNeeded = false;

    public ManagedAdminServerInstance() throws MBeanConfigException {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
        this.initialize("server-instance", new String[]{"admin-server"});
    }

    public boolean applyConfigChanges() throws ServerInstanceException {
        try {
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment("admin-server");
            instanceEnvironment.applyServerXmlChanges(true);
            this.initDelegate();
            ConfigContext configContext = this.mDelegate.getConfigContext("admin-server");
            configContext.resetConfigChangeList();
            this.mRestartNeeded = true;
        }
        catch (ConfigException configException) {
            _logger.log(Level.INFO, "mbean.config.admin.apply_failed", configException.getLocalizedMessage());
            _logger.log(Level.FINEST, configException.getMessage(), configException);
            throw new ServerInstanceException(configException.getLocalizedMessage());
        }
        return this.mRestartNeeded;
    }

    public boolean canApplyConfigChanges() {
        boolean bl = false;
        try {
            this.initDelegate();
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment("admin-server");
            if (instanceEnvironment.hasHotXmlChanged()) {
                if (instanceEnvironment.canReloadManualXmlChanges()) {
                    instanceEnvironment.useManualServerXmlChanges();
                    this.mDelegate.reloadAfterChange(instanceEnvironment);
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        catch (Exception exception) {
            _logger.log(Level.INFO, "mbean.config.admin.canapply_failed", exception.getLocalizedMessage());
            _logger.log(Level.FINEST, exception.getLocalizedMessage(), exception);
        }
        return bl;
    }

    public boolean useManualConfigChanges() throws ServerInstanceException {
        try {
            this.initDelegate();
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment("admin-server");
            instanceEnvironment.useManualServerXmlChanges();
            this.mDelegate.reloadAfterChange(instanceEnvironment);
            this.mRestartNeeded = true;
        }
        catch (ConfigException configException) {
            _logger.log(Level.INFO, "mbean.config.admin.usemanual_failed", configException.getMessage());
            _logger.log(Level.FINEST, configException.getMessage(), configException);
            throw new ServerInstanceException(configException.getLocalizedMessage());
        }
        return this.mRestartNeeded;
    }

    public boolean isApplyNeeded(boolean bl) throws ServerInstanceException {
        return this.isApplyNeeded();
    }

    public boolean isApplyNeeded() throws ServerInstanceException {
        boolean bl = false;
        try {
            this.initDelegate();
            ConfigContext configContext = this.mDelegate.getConfigContext("admin-server");
            bl = configContext.isChanged();
        }
        catch (ConfigException configException) {
            _logger.log(Level.INFO, "mbean.config.admin.applyneeded_failed", configException.getMessage());
            _logger.log(Level.FINEST, configException.getMessage(), configException);
            throw new ServerInstanceException(configException.getLocalizedMessage());
        }
        return bl;
    }

    public boolean isRestartNeeded() throws ServerInstanceException {
        return this.mRestartNeeded;
    }

    public HostAndPort getHostAndPort() throws ServerInstanceException {
        return this.getHttpListenerHostPort();
    }

    private synchronized void initDelegate() throws ServerInstanceException {
        if (this.mDelegate != null) {
            return;
        }
        try {
            HostAndPort hostAndPort = this.getHttpListenerHostPort();
            this.mDelegate = new ManagedServerInstance("admin-server", hostAndPort, false);
        }
        catch (ServerInstanceException serverInstanceException) {
            throw serverInstanceException;
        }
        catch (PortInUseException portInUseException) {
        }
        catch (Exception exception) {
            throw new ServerInstanceException(exception.getLocalizedMessage());
        }
    }

    private HostAndPort getHttpListenerHostPort() throws ServerInstanceException {
        HostAndPort hostAndPort = null;
        try {
            Server server = (Server)super.getBaseConfigBean();
            HttpService httpService = server.getHttpService();
            HttpListener[] httpListenerArray = httpService.getHttpListener();
            HttpListener httpListener = httpListenerArray[0];
            for (int i = 0; i < httpListenerArray.length; ++i) {
                if (!httpListenerArray[i].isEnabled()) continue;
                httpListener = httpListenerArray[i];
                break;
            }
            String string = httpListener.getPort();
            int n = Integer.parseInt(string);
            hostAndPort = new HostAndPort("localhost", n);
        }
        catch (Exception exception) {
            throw new ServerInstanceException(exception.getLocalizedMessage());
        }
        return hostAndPort;
    }

    public String[] getCertNicknames() throws Exception {
        String[] stringArray = new String[]{};
        String string = System.getProperty("java.home");
        String string2 = System.getProperty("file.separator");
        String string3 = System.getProperty("java.class.path");
        String string4 = "admin-server";
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string4);
        String string5 = instanceEnvironment.getConfigDirPath();
        try {
            String string6;
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(string + string2 + "bin" + string2 + "java" + " ");
            stringBuffer.append("-classpath " + string3 + " ");
            stringBuffer.append("com.iplanet.ias.admin.server.core.mbean.config.CertOps ");
            stringBuffer.append("ListCertNickNames ");
            stringBuffer.append(string5 + " ");
            Process process = Runtime.getRuntime().exec(stringBuffer.toString());
            InputStream inputStream = process.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string6 = bufferedReader.readLine()) != null) {
                if (!string6.startsWith("CertNickName")) continue;
                arrayList.add(string6);
            }
            process.waitFor();
            if (process.exitValue() != 0) {
                sLogger.log(Level.WARNING, "Encountered exception while trying to exec CertOps");
                throw new Exception("Encountered exception while trying to exec CertOps");
            }
            if (arrayList.size() < 1) {
                return stringArray;
            }
            stringArray = new String[arrayList.size()];
            string6 = null;
            int n = -1;
            for (int i = 0; i < arrayList.size(); ++i) {
                string6 = (String)arrayList.get(i);
                stringArray[i] = string6.substring("CertNickName".length() + 1);
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "exception while trying to retrieve certs", exception);
            throw exception;
        }
        return stringArray;
    }
}

