/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.config.serverbeans.IiopListener;
import com.iplanet.ias.config.serverbeans.IiopService;
import com.iplanet.ias.config.serverbeans.Server;
import com.sun.logging.LogDomains;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public final class ConfigBeanIntrospector {
    private static final Logger sLogger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    public static Object instantiate(Class clazz, Object[] objectArray) throws Exception {
        ArgChecker.checkValid((Object)clazz, (String)"bean");
        ArgChecker.checkValid((Object)objectArray, (String)"params");
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        Constructor constructor = clazz.getConstructor(classArray);
        Object t = constructor.newInstance(objectArray);
        return t;
    }

    public static boolean isAttributeSupported(Class clazz, String string) {
        boolean bl = false;
        try {
            PropertyDescriptor propertyDescriptor = ConfigBeanIntrospector.getPropertyDescriptor(clazz, string);
            bl = propertyDescriptor != null;
        }
        catch (Exception exception) {
            sLogger.throwing(ConfigBeanIntrospector.class.getName(), "isAttributeSupported", exception);
            bl = false;
        }
        return bl;
    }

    public static boolean isAttributeReadable(Class clazz, String string) {
        boolean bl = false;
        try {
            Method method = ConfigBeanIntrospector.getGetter(clazz, string);
            bl = method != null;
        }
        catch (Exception exception) {
            sLogger.throwing(ConfigBeanIntrospector.class.getName(), "isAttributeReadable", exception);
            bl = false;
        }
        return bl;
    }

    public static boolean isAttributeWritable(Class clazz, String string) {
        boolean bl = false;
        try {
            Method method = ConfigBeanIntrospector.getSetter(clazz, string);
            bl = method != null;
        }
        catch (Exception exception) {
            sLogger.throwing(ConfigBeanIntrospector.class.getName(), "isAttributeWritable", exception);
            bl = false;
        }
        return bl;
    }

    public static Object invokeGetter(Object object, String string) throws Exception {
        ArgChecker.checkValid((Object)object, (String)"target");
        ArgChecker.checkValid((Object)string, (String)"attributeName");
        Object object2 = null;
        Class<?> clazz = object.getClass();
        Method method = ConfigBeanIntrospector.getGetter(clazz, string);
        if (method != null) {
            object2 = method.invoke(object, null);
        }
        return object2;
    }

    public static void invokeSetter(Object object, String string, Object object2) throws Exception {
        ArgChecker.checkValid((Object)object, (String)"target");
        ArgChecker.checkValid((Object)string, (String)"attributeName");
        Class<?> clazz = object.getClass();
        Method method = ConfigBeanIntrospector.getSetter(clazz, string);
        if (method != null) {
            method.invoke(object, object2);
        }
    }

    private static Method getGetter(Class clazz, String string) throws Exception {
        Method method = null;
        PropertyDescriptor propertyDescriptor = ConfigBeanIntrospector.getPropertyDescriptor(clazz, string);
        if (propertyDescriptor != null) {
            method = propertyDescriptor.getReadMethod();
        }
        return method;
    }

    private static Method getSetter(Class clazz, String string) throws Exception {
        Method method = null;
        PropertyDescriptor propertyDescriptor = ConfigBeanIntrospector.getPropertyDescriptor(clazz, string);
        if (propertyDescriptor != null) {
            method = propertyDescriptor.getWriteMethod();
        }
        return method;
    }

    private static PropertyDescriptor getPropertyDescriptor(Class clazz, String string) throws Exception {
        PropertyDescriptor propertyDescriptor = null;
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor2 = propertyDescriptorArray[i];
            if (!propertyDescriptor2.getName().equals(string)) continue;
            propertyDescriptor = propertyDescriptor2;
            break;
        }
        return propertyDescriptor;
    }

    public static void main(String[] stringArray) throws Exception {
        ConfigContext configContext = ConfigFactory.createConfigContext("/u/ramakant/server.xml", true);
        IiopListener iiopListener = null;
        Server server = (Server)configContext.getRootConfigBean();
        IiopService iiopService = server.getIiopService();
        iiopListener = iiopService.getIiopListenerById("orb-listener-1");
        Object object = ConfigBeanIntrospector.invokeGetter(iiopListener, "id");
        sLogger.info(object.toString());
        try {
            ConfigBeanIntrospector.invokeGetter(iiopListener, "abcd");
        }
        catch (Exception exception) {
            sLogger.info("OK " + exception.getMessage());
        }
        ConfigBeanIntrospector.invokeSetter(iiopListener, "id", "surya10");
        ConfigBeanIntrospector.invokeSetter(iiopListener, "port", new Integer(8888).toString());
        configContext.flush(true);
    }
}

