/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.jmx.storage;

import com.iplanet.ias.admin.common.ObjectNameHelper;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.server.core.mbean.config.GenericConfigurator;
import com.iplanet.ias.admin.server.core.mbean.config.ServerController;
import com.iplanet.ias.admin.server.core.mbean.config.naming.ConfigMBeanNamingInfo;
import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigBeansFactory;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.ServerManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class PersistenceChecker {
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    public Object findElement(ObjectName objectName) {
        Object object = null;
        String string = ObjectNameHelper.getType((ObjectName)objectName);
        String string2 = ObjectNameHelper.getServerInstanceName((ObjectName)objectName);
        if (string != null) {
            object = string.equals("controller") ? new ServerController() : (string.equals("configurator") ? new GenericConfigurator() : (string.equals("server-instance") ? this.findServerInstance(string2) : this.findGenericConfigBean(objectName, string2)));
        } else {
            _logger.log(Level.FINE, "mbean.config.admin.unknown_mbean_type", objectName.toString());
        }
        return object;
    }

    private Object findServerInstance(String string) {
        ServerManager serverManager = ServerManager.instance();
        Server server = null;
        boolean bl = string.equals("admin-server");
        if (!serverManager.instanceExists(string) && !bl) {
            return null;
        }
        try {
            ConfigContext configContext = this.getConfigContext(string);
            server = ServerBeansFactory.getServerBean(configContext);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return server;
    }

    private Object findGenericConfigBean(ObjectName objectName, String string) {
        ConfigBean configBean = null;
        ConfigMBeanNamingInfo configMBeanNamingInfo = null;
        try {
            configMBeanNamingInfo = new ConfigMBeanNamingInfo(objectName);
        }
        catch (MBeanConfigException mBeanConfigException) {
            _logger.log(Level.FINE, "mbean.config.admin.naming_not_found", new Object[]{objectName.toString(), mBeanConfigException.getLocalizedMessage()});
        }
        if (configMBeanNamingInfo != null) {
            String string2 = configMBeanNamingInfo.getXPath();
            try {
                ConfigContext configContext = this.getConfigContext(string);
                configBean = ConfigBeansFactory.getConfigBeanByXPath(configContext, string2);
            }
            catch (Exception exception) {
                _logger.log(Level.FINE, "mbean.config.admin.config_bean_not_found", new Object[]{string2, exception.getLocalizedMessage()});
            }
        }
        return configBean;
    }

    private ConfigContext getConfigContext(String string) throws ConfigException {
        String string2 = new InstanceEnvironment(string).getBackupConfigFilePath();
        return ConfigFactory.createConfigContext(string2);
    }
}

