/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.jmx;

import com.iplanet.ias.admin.server.core.jmx.Introspector;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;

public class MBeanIntrospector
extends Introspector {
    private boolean mIsStandard;
    private boolean mIsDynamic;
    private Class mMBeanInterfaceClass;

    public MBeanIntrospector(Class clazz) throws NotCompliantMBeanException {
        super(clazz);
        this.checkBasic(clazz);
        this.checkMBeanType(clazz);
        this.checkCompliance();
    }

    public boolean isStandardMBean() {
        return this.mIsStandard;
    }

    public boolean isDynamicMBean() {
        return this.mIsDynamic;
    }

    public Class getMBeanInterfaceClass() {
        return this.mMBeanInterfaceClass;
    }

    public boolean isSupported(String string, Class[] classArray) {
        boolean bl = false;
        try {
            Method method = this.mMBeanInterfaceClass.getMethod(string, classArray);
            bl = method != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private void checkBasic(Class clazz) throws NotCompliantMBeanException {
        if (!this.isInstantiableJavaClass(clazz)) {
            throw new NotCompliantMBeanException();
        }
    }

    private void checkMBeanType(Class clazz) {
        Class clazz2;
        boolean bl = this.isStandard(clazz);
        boolean bl2 = this.isDynamic(clazz);
        if (!bl && !bl2 && (clazz2 = clazz.getSuperclass()) != null && clazz2 != Object.class) {
            this.checkMBeanType(clazz2);
        }
        if (bl) {
            this.mIsStandard = true;
            this.setStandardMBeanInterface(clazz);
        }
        if (bl2) {
            this.mIsDynamic = true;
            this.setDynamicMBeanInterface();
        }
    }

    private void checkCompliance() throws NotCompliantMBeanException {
        if (!this.mIsStandard && !this.mIsDynamic || this.mIsStandard && this.mIsDynamic) {
            throw new NotCompliantMBeanException();
        }
    }

    private void setStandardMBeanInterface(Class clazz) {
        String string = this.deriveStandardMBeanIntfClassName(clazz);
        this.mMBeanInterfaceClass = this.getImplementedMBeanClass(clazz, string);
    }

    private void setDynamicMBeanInterface() {
        this.mMBeanInterfaceClass = DynamicMBean.class;
    }

    private boolean isStandard(Class clazz) {
        boolean bl = false;
        String string = this.deriveStandardMBeanIntfClassName(clazz);
        if (this.getImplementedMBeanClass(clazz, string) != null) {
            bl = true;
        }
        return bl;
    }

    private boolean isDynamic(Class clazz) {
        boolean bl = false;
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            if (classArray[i] != (class$javax$management$DynamicMBean == null ? MBeanIntrospector.class$("javax.management.DynamicMBean") : class$javax$management$DynamicMBean)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isInstantiableJavaClass(Class clazz) {
        boolean bl = false;
        if (!clazz.isPrimitive() && !clazz.isArray()) {
            int n = clazz.getModifiers();
            boolean bl2 = Modifier.isInterface(n);
            boolean bl3 = Modifier.isAbstract(n);
            bl = !bl2 && !bl3;
        }
        return bl;
    }

    private String deriveStandardMBeanIntfClassName(Class clazz) {
        String string = this.truncateClassName(clazz);
        return string + "MBean";
    }

    private String truncateClassName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        string = string.substring(n + 1);
        return string;
    }

    private Class getImplementedMBeanClass(Class clazz, String string) {
        Class<?> clazz2 = null;
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            String string2 = this.truncateClassName(classArray[i]);
            if (!string2.equals(string)) continue;
            clazz2 = classArray[i];
            break;
        }
        return clazz2;
    }

    private final String convertToCamelCase(String string) {
        String string2 = "";
        char c = string.charAt(0);
        string2 = string2 + Character.toUpperCase(c);
        if (string.length() > 1) {
            string2 = string2 + string.substring(1);
        }
        return string2;
    }
}

