/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.jmx;

import com.iplanet.ias.admin.common.CombinedPatternMatcher;
import com.iplanet.ias.admin.common.ObjectNameHelper;
import com.iplanet.ias.admin.server.core.jmx.IRepository;
import com.iplanet.ias.admin.server.core.jmx.storage.MBeanManufacturer;
import com.iplanet.ias.admin.server.core.jmx.storage.PersistenceChecker;
import com.sun.logging.LogDomains;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class DomainRepository
implements IRepository {
    private static final Logger sLogger = LogDomains.getLogger("javax.enterprise.system.tools.admin");
    private Hashtable mDomainTable = new Hashtable();

    public boolean contains(ObjectName objectName) {
        return this.find(objectName) != null;
    }

    public int getCount(String string) {
        return ((Hashtable)this.mDomainTable.get(string)).size();
    }

    public Object find(ObjectName objectName) {
        Hashtable hashtable;
        Object var2_2 = null;
        if (objectName != null && !objectName.isPattern() && !objectName.isPropertyPattern() && (hashtable = this.findRepository(objectName)) != null) {
            var2_2 = hashtable.get(objectName);
        }
        return var2_2;
    }

    public Object findPersistent(ObjectName objectName) {
        boolean bl;
        Hashtable hashtable;
        Object object = null;
        Object object2 = null;
        if (objectName != null && !objectName.isPattern() && !objectName.isPropertyPattern() && (hashtable = this.findRepository(objectName)) != null) {
            object2 = hashtable.get(objectName);
        }
        object = !(bl = ObjectNameHelper.isMonitorMBean((ObjectName)objectName)) ? this.findInPersistentStore(objectName, object2) : object2;
        return object;
    }

    public boolean add(ObjectName objectName, Object object) {
        boolean bl;
        Hashtable hashtable = this.findRepository(objectName);
        String string = objectName.getDomain();
        boolean bl2 = false;
        boolean bl3 = bl = hashtable == null;
        if (bl) {
            hashtable = this.addNewDomain(string);
            hashtable.put(objectName, object);
            bl2 = true;
        } else {
            boolean bl4;
            boolean bl5 = bl4 = hashtable.get(objectName) == null;
            if (bl4) {
                hashtable.put(objectName, object);
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean remove(ObjectName objectName) {
        Object v;
        Hashtable hashtable = this.findRepository(objectName);
        boolean bl = false;
        if (hashtable != null && (v = hashtable.remove(objectName)) != null) {
            bl = true;
        }
        return bl;
    }

    private Hashtable findRepository(ObjectName objectName) {
        String string = objectName.getDomain();
        return (Hashtable)this.mDomainTable.get(string);
    }

    private Hashtable addNewDomain(String string) {
        Hashtable hashtable = new Hashtable();
        this.mDomainTable.put(string, hashtable);
        return hashtable;
    }

    public int getTotalCount() {
        int n = 0;
        Iterator iterator = this.mDomainTable.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Hashtable hashtable = (Hashtable)this.mDomainTable.get(string);
            n += hashtable.size();
        }
        return n;
    }

    public Set getAllMBeans() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.mDomainTable.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Hashtable hashtable = (Hashtable)this.mDomainTable.get(string);
            hashSet.addAll(hashtable.keySet());
        }
        return hashSet;
    }

    public Set query(ObjectName objectName) {
        HashSet<ObjectName> hashSet = null;
        Set set = null;
        String string = null;
        Hashtable<String, String> hashtable = null;
        if (objectName != null) {
            hashSet = new HashSet<ObjectName>();
            if (!objectName.isPattern()) {
                if (this.contains(objectName)) {
                    hashSet.add(objectName);
                }
            } else {
                set = this.getAllMBeans();
                string = objectName.getDomain();
                hashtable = objectName.getKeyPropertyList();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Hashtable<String, String> hashtable2;
                    boolean bl;
                    ObjectName objectName2 = (ObjectName)iterator.next();
                    String string2 = objectName2.getDomain();
                    boolean bl2 = this.matchDomain(string, string2);
                    if (!bl2 || !(bl = this.matchPropertiesWithPattern(hashtable, hashtable2 = objectName2.getKeyPropertyList()))) continue;
                    hashSet.add(objectName2);
                }
            }
        }
        return hashSet;
    }

    private boolean matchPropertiesWithPattern(Hashtable hashtable, Hashtable hashtable2) {
        boolean bl = true;
        Iterator iterator = hashtable.keySet().iterator();
        while (bl && iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashtable.get(string);
            String string3 = (String)hashtable2.get(string);
            bl = string2.equals(string3);
        }
        return bl;
    }

    private boolean matchDomain(String string, String string2) {
        CombinedPatternMatcher combinedPatternMatcher = new CombinedPatternMatcher(string, string2);
        return combinedPatternMatcher.matches();
    }

    private Object findInPersistentStore(ObjectName objectName, Object object) {
        String string = ObjectNameHelper.getType((ObjectName)objectName);
        if (string.equals("controller") || string.equals("configurator")) {
            return object;
        }
        PersistenceChecker persistenceChecker = new PersistenceChecker();
        Object object2 = persistenceChecker.findElement(objectName);
        Object object3 = null;
        if (object2 != null) {
            if (object != null) {
                object3 = object;
            } else {
                MBeanManufacturer mBeanManufacturer = new MBeanManufacturer(objectName, object2);
                object3 = mBeanManufacturer.createMBeanInstance();
                this.add(objectName, object3);
            }
        } else {
            object3 = null;
            if (object != null) {
                this.remove(objectName);
            }
        }
        return object3;
    }
}

