/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.jmx;

import com.iplanet.ias.admin.common.ObjectNameHelper;
import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFRuntimeException;
import com.iplanet.ias.admin.common.exception.AFRuntimeStoreException;
import com.iplanet.ias.admin.event.AdminEventCache;
import com.iplanet.ias.admin.server.core.AdminService;
import com.iplanet.ias.admin.server.core.jmx.InitException;
import com.iplanet.ias.admin.server.core.jmx.MBeanServerImpl;
import com.iplanet.ias.util.i18n.StringManager;
import java.io.ObjectInputStream;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public class ASMBeanServerImpl
extends MBeanServerImpl {
    public static final String HOT_CONFIG_METHOD_NAME = "canApplyConfigChanges";
    public static final String FORCE_APPLY_METHOD_NAME = "overwriteConfigChanges";
    public static final String APPLY_METHOD_NAME = "applyConfigChanges";
    public static final String USE_MANUAL_METHOD_NAME = "useManualConfigChanges";
    public static final String GET_HOST_AND_PORT_METHOD_NAME = "getHostAndPort";
    private static MBeanServer sInstance = null;
    private static boolean kDynamicMBeansOnly = true;
    private static String kGetMBeanInfoMethodName = "getMBeanInfo";
    private static String kAllMBeansPattern = "*";
    private static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static StringManager localStrings = StringManager.getManager(ASMBeanServerImpl.class);

    protected ASMBeanServerImpl(String string) throws InitException {
        super(string);
        this.initialize();
    }

    protected ASMBeanServerImpl() throws InitException {
        this("DefaultDomain");
    }

    public static MBeanServer getMBeanServerInstance() throws InitException {
        if (sInstance == null) {
            sInstance = new ASMBeanServerImpl();
        }
        return sInstance;
    }

    private void initialize() throws InitException {
        try {
            ObjectName objectName = ObjectNames.getControllerObjectName();
            ObjectName objectName2 = ObjectNames.getGenericConfiguratorObjectName();
            ObjectName[] objectNameArray = new ObjectName[]{objectName, objectName2};
            String string = "com.iplanet.ias.admin.server.core.mbean.config.ServerController";
            String string2 = "com.iplanet.ias.admin.server.core.mbean.config.GenericConfigurator";
            String[] stringArray = new String[]{string, string2};
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                Class<?> clazz = Class.forName(string3);
                Object obj = clazz.newInstance();
                ObjectInstance objectInstance = this.registerMBean(obj, objectNameArray[i]);
                String string4 = objectInstance.getObjectName().toString();
                if (AdminService.getAdminService().isAdminInstance()) {
                    sLogger.log(Level.INFO, "core.system_mbean_init_ok", string4);
                    continue;
                }
                sLogger.log(Level.FINEST, "core.system_mbean_init_ok", string4);
            }
        }
        catch (Exception exception) {
            throw new InitException(exception.getMessage());
        }
    }

    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return super.registerMBean(object, objectName);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceNotFoundException, MBeanException {
        Object object;
        Object object2;
        if (this.isInstanceMBean(objectName) && this.isConfigCheckRequired(string)) {
            this.checkHotConfigChanges(objectName);
        }
        if (FORCE_APPLY_METHOD_NAME.equals(string)) {
            object2 = ObjectNameHelper.getServerInstanceName((ObjectName)objectName);
            object = AdminEventCache.getInstance((String)object2);
            ((AdminEventCache)object).setRestartNeeded(true);
        }
        if ((object2 = this.mMBeanRepository.findPersistent(objectName)) == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        object = super.invoke(objectName, string, objectArray, stringArray);
        return object;
    }

    public Object getAttribute(ObjectName objectName, String string) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException {
        Object object;
        if (this.isInstanceMBean(objectName)) {
            this.checkHotConfigChanges(objectName);
        }
        if ((object = this.mMBeanRepository.findPersistent(objectName)) == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        Object object2 = super.getAttribute(objectName, string);
        return object2;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, InvalidAttributeValueException {
        Object object;
        if (this.isInstanceMBean(objectName)) {
            this.checkHotConfigChanges(objectName);
        }
        if ((object = this.mMBeanRepository.findPersistent(objectName)) == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        super.setAttribute(objectName, attribute);
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        super.unregisterMBean(objectName);
    }

    public Integer getMBeanCount() {
        return super.getMBeanCount();
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        return super.queryMBeans(objectName, queryExp);
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return super.getMBeanInfo(objectName);
    }

    public boolean isRegistered(ObjectName objectName) {
        return super.isRegistered(objectName);
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        super.addNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        super.addNotificationListener(objectName, objectName2, notificationFilter, object);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return super.createMBean(string, objectName);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return super.createMBean(string, objectName, objectName2);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return super.createMBean(string, objectName, objectArray, stringArray);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return super.createMBean(string, objectName, objectName2, objectArray, stringArray);
    }

    public ObjectInputStream deserialize(String string, byte[] byArray) throws OperationsException, ReflectionException {
        return super.deserialize(string, byArray);
    }

    public ObjectInputStream deserialize(ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException {
        return super.deserialize(objectName, byArray);
    }

    public ObjectInputStream deserialize(String string, ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return super.deserialize(string, objectName, byArray);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        this.checkHotConfigChanges(objectName);
        Object object = this.mMBeanRepository.findPersistent(objectName);
        if (object == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        return super.getAttributes(objectName, stringArray);
    }

    public String getDefaultDomain() {
        return super.getDefaultDomain();
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        return super.getObjectInstance(objectName);
    }

    public Object instantiate(String string) throws ReflectionException, MBeanException {
        return super.instantiate(string);
    }

    public Object instantiate(String string, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return super.instantiate(string, objectName);
    }

    public Object instantiate(String string, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException {
        return super.instantiate(string, objectArray, stringArray);
    }

    public Object instantiate(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return super.instantiate(string, objectName, objectArray, stringArray);
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        return super.isInstanceOf(objectName, string);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        return super.queryNames(objectName, queryExp);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        super.removeNotificationListener(objectName, objectName2);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        super.removeNotificationListener(objectName, notificationListener);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        this.checkHotConfigChanges(objectName);
        Object object = this.mMBeanRepository.findPersistent(objectName);
        if (object == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        return super.setAttributes(objectName, attributeList);
    }

    private void checkHotConfigChanges(ObjectName objectName) {
        try {
            String string = ObjectNameHelper.getServerInstanceName((ObjectName)objectName);
            ObjectName objectName2 = ObjectNames.getServerInstanceObjectName((String)string);
            Object object = this.invoke(objectName2, HOT_CONFIG_METHOD_NAME, null, null);
            if (object.equals(Boolean.FALSE)) {
                String string2 = localStrings.getString("admin.server.core.jmx.configuration_changed_apply_changes", string);
                throw new AFRuntimeStoreException(string2);
            }
        }
        catch (AFRuntimeStoreException aFRuntimeStoreException) {
            throw aFRuntimeStoreException;
        }
        catch (Exception exception) {
            String string = localStrings.getString("admin.server.core.jmx.bad_server_configuration");
            throw new AFRuntimeException(string);
        }
    }

    private boolean isInstanceMBean(ObjectName objectName) {
        return ObjectNameHelper.getServerInstanceName((ObjectName)objectName) != null;
    }

    private boolean isConfigCheckRequired(String string) {
        if (GET_HOST_AND_PORT_METHOD_NAME.equals(string)) {
            return false;
        }
        if (FORCE_APPLY_METHOD_NAME.equals(string)) {
            return false;
        }
        if (USE_MANUAL_METHOD_NAME.equals(string)) {
            return false;
        }
        if (HOT_CONFIG_METHOD_NAME.equals(string)) {
            return false;
        }
        return !"getMBeanInfo".equals(string);
    }
}

