/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.channel;

import com.iplanet.ias.admin.event.AdminEvent;
import com.iplanet.ias.admin.event.AdminEventResult;
import com.iplanet.ias.admin.server.core.channel.AdminChannel;
import com.iplanet.ias.admin.server.core.channel.RemoteAdminChannel;
import com.iplanet.ias.util.i18n.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RMIClient
implements Runnable {
    private File stubFile;
    private File seedFile;
    private long stubFileTs = 0L;
    private byte[] key;
    private RemoteAdminChannel stub;
    private boolean autoRefresh;
    private Thread autoRefreshThread;
    private long autoRefreshInterval;
    private static StringManager localStrings = StringManager.getManager(RMIClient.class);
    private static final String CLIENT_NULLARGS_ERRCODE = "channel.client_nullargs";
    private static final String CLIENT_NULLARGS_ERRMSG = localStrings.getString("admin.server.core.channel.attempt_initializing_channel_client_with_null_arguments");
    private static final String CLIENT_INIT_ERROR = "channel.client_init_error";
    private static final String EVENT_NOTIFY_ERROR = "channel.event_notify_error";
    private static final String EVENT_RENOTIFY_ERROR = "channel.event_renotify_error";
    private static final String AUTO_REFRESH_INTR = "channel.auto_refresh_intr";
    private static final String CHANNEL_COMM_ERROR = "channel.comm_error";
    static final String FILE_READ_ERROR = "channel.file_read_error";
    static final String SEED_FILE_OLDER = "channel.seed_file_older";
    static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final String INVALID_AUTO_REFRESH_INTERVAL = localStrings.getString("admin.server.core.channel.invalid_auto_refresh_interval");

    RMIClient(String string, String string2) {
        if (string == null || string2 == null) {
            RMIClient.warn(CLIENT_NULLARGS_ERRCODE);
            throw new IllegalArgumentException(CLIENT_NULLARGS_ERRMSG);
        }
        this.stubFile = new File(string);
        this.seedFile = new File(string2);
        if (this.stubFile.exists()) {
            this.stub = this.readStub();
        }
        if (AdminChannel.getClientAutoRefreshEnabled()) {
            this.startAutoRefreshThread(AdminChannel.getClientAutoRefreshInterval());
        }
    }

    public RMIClient(boolean bl, String string, String string2) {
        if (!bl) {
            logger.setLevel(Level.SEVERE);
        }
        if (string == null || string2 == null) {
            throw new IllegalArgumentException(CLIENT_NULLARGS_ERRMSG);
        }
        this.stubFile = new File(string);
        this.seedFile = new File(string2);
        if (this.stubFile.exists()) {
            this.stub = this.readStub();
        }
    }

    void startAutoRefreshThread(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException(INVALID_AUTO_REFRESH_INTERVAL);
        }
        this.autoRefresh = true;
        this.autoRefreshInterval = l;
        if (this.autoRefreshThread != null && this.autoRefreshThread.isAlive()) {
            return;
        }
        this.autoRefreshThread = new Thread(this);
        this.autoRefreshThread.start();
    }

    void stopAutoRefreshThread() {
        this.autoRefresh = false;
    }

    public void run() {
        while (this.autoRefresh) {
            try {
                Thread.sleep(this.autoRefreshInterval);
            }
            catch (InterruptedException interruptedException) {
                RMIClient.warn(AUTO_REFRESH_INTR);
                this.autoRefresh = false;
            }
            if (!this.autoRefresh) continue;
            this.checkServerStatus();
        }
    }

    public AdminEventResult sendNotification(AdminEvent adminEvent) {
        boolean bl = true;
        AdminEventResult adminEventResult = null;
        if (this.stub != null) {
            try {
                adminEventResult = this.stub.sendNotification(this.key, adminEvent);
                bl = false;
            }
            catch (ServerException serverException) {
                if (serverException.detail != null && (serverException.detail instanceof IllegalArgumentException || serverException.detail instanceof SecurityException)) {
                    bl = false;
                    RMIClient.warn(EVENT_NOTIFY_ERROR);
                    RMIClient.debug(serverException.detail);
                } else {
                    if (serverException.detail != null) {
                        RMIClient.debug(serverException.detail);
                    }
                    RMIClient.debug(serverException);
                }
            }
            catch (RemoteException remoteException) {
                if (remoteException.detail != null) {
                    RMIClient.debug(remoteException.detail);
                }
                RMIClient.debug(remoteException);
            }
        }
        if (bl) {
            boolean bl2 = this.checkServerStatus();
            if (this.stub != null && bl2) {
                try {
                    adminEventResult = this.stub.sendNotification(this.key, adminEvent);
                }
                catch (RemoteException remoteException) {
                    RMIClient.warn(EVENT_RENOTIFY_ERROR);
                    if (remoteException.detail != null) {
                        RMIClient.debug(remoteException.detail);
                    }
                    RMIClient.debug(remoteException);
                }
            }
        }
        if (adminEventResult == null) {
            adminEventResult = new AdminEventResult(adminEvent.getSequenceNumber());
            adminEventResult.setResultCode("transmission_error");
            if (this.stub == null) {
                adminEventResult.addMessage("Remote Stub is null");
            }
        }
        return adminEventResult;
    }

    public boolean isAlive() {
        return this.isAlive(false);
    }

    public boolean isAlive(boolean bl) {
        boolean bl2;
        if (bl) {
            bl2 = this.checkServerStatus();
        }
        bl2 = true;
        if (this.stub != null) {
            try {
                this.stub.pingServer(this.key);
            }
            catch (RemoteException remoteException) {
                RMIClient.debug(remoteException);
                bl2 = false;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public int getInstanceStatusCode() {
        boolean bl = this.checkServerStatus();
        int n = 3;
        if (this.stub != null) {
            try {
                n = this.stub.getServerStatusCode(this.key);
            }
            catch (RemoteException remoteException) {
                RMIClient.debug(CHANNEL_COMM_ERROR, this.stubFile.getName());
                if (remoteException.detail != null) {
                    RMIClient.trace(remoteException.detail);
                }
                RMIClient.trace(remoteException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                RMIClient.debug(CHANNEL_COMM_ERROR, this.stubFile.getName());
                RMIClient.trace(illegalArgumentException);
                byte[] byArray = null;
                try {
                    byArray = this.readSeed();
                }
                catch (IOException iOException) {
                    RMIClient.debug(FILE_READ_ERROR, this.seedFile.getName());
                    RMIClient.trace(iOException);
                }
                if (byArray != null) {
                    this.key = byArray;
                }
                throw illegalArgumentException;
            }
        }
        return n;
    }

    public boolean isRestartNeeded() {
        boolean bl = false;
        boolean bl2 = this.checkServerStatus();
        if (this.stub != null) {
            try {
                bl = this.stub.isRestartNeeded(this.key);
            }
            catch (RemoteException remoteException) {
                RMIClient.debug(CHANNEL_COMM_ERROR, this.stubFile.getName());
                if (remoteException.detail != null) {
                    RMIClient.trace(remoteException.detail);
                }
                RMIClient.trace(remoteException);
            }
        }
        return bl;
    }

    public void setRestartNeeded(boolean bl) {
        boolean bl2 = this.checkServerStatus();
        if (this.stub != null) {
            try {
                this.stub.setRestartNeeded(this.key, bl);
            }
            catch (RemoteException remoteException) {
                RMIClient.debug(CHANNEL_COMM_ERROR, this.stubFile.getName());
                if (remoteException.detail != null) {
                    RMIClient.trace(remoteException.detail);
                }
                RMIClient.trace(remoteException);
            }
        }
    }

    private boolean checkServerStatus() {
        boolean bl = false;
        if (this.stubFile.exists()) {
            long l = this.stubFile.lastModified();
            if (l > this.stubFileTs) {
                if (this.stubFile.canRead()) {
                    RemoteAdminChannel remoteAdminChannel = this.readStub();
                    if (remoteAdminChannel != null) {
                        bl = true;
                        this.stub = remoteAdminChannel;
                    }
                } else {
                    RMIClient.warn(FILE_READ_ERROR, this.stubFile.getName());
                }
            }
        } else if (this.stub != null) {
            this.stub = null;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private RemoteAdminChannel readStub() {
        block17: {
            var1_1 = null;
            var2_2 = null;
            try {
                this.stubFileTs = this.stubFile.lastModified();
                var2_2 = new FileInputStream(this.stubFile);
                var3_3 = new ObjectInputStream(var2_2);
                var1_1 = (RemoteAdminChannel)var3_3.readObject();
                var5_7 = null;
                ** if (var2_2 == null) goto lbl-1000
            }
            catch (Throwable var4_15) {
                var5_10 = null;
                if (var2_2 != null) {
                    try {
                        var2_2.close();
                    }
                    catch (IOException var6_14) {
                        // empty catch block
                    }
                }
                throw var4_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var2_2.close();
                }
                catch (IOException var6_11) {}
            }
lbl-1000:
            // 2 sources

            {
                break block17;
                catch (IOException var3_4) {
                    RMIClient.warn("channel.client_init_error");
                    RMIClient.debug(var3_4);
                    var5_8 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (IOException var6_12) {}
                    }
                    break block17;
                }
                catch (ClassNotFoundException var3_5) {
                    RMIClient.warn("channel.client_init_error");
                    RMIClient.debug(var3_5);
                    var5_9 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (IOException var6_13) {}
                    }
                }
            }
        }
        try {
            this.key = this.readSeed();
        }
        catch (IOException var3_6) {
            RMIClient.warn("channel.client_init_error");
            RMIClient.debug(var3_6);
            var1_1 = null;
        }
        if (var1_1 == null) {
            this.stubFileTs = 0L;
        }
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private byte[] readSeed() throws IOException {
        block15: {
            var1_1 = null;
            if (this.seedFile.exists() && this.seedFile.canRead()) {
                var2_2 = this.seedFile.lastModified();
                if (var2_2 >= this.stubFileTs) {
                    var4_4 = null;
                    try {
                        var4_4 = new FileInputStream(this.seedFile);
                        var1_1 = new byte[16];
                        var4_4.read(var1_1);
                        var7_5 = null;
                        ** if (var4_4 == null) goto lbl-1000
                    }
                    catch (Throwable var6_12) {
                        var7_7 = null;
                        if (var4_4 != null) {
                            try {
                                var4_4.close();
                            }
                            catch (IOException var8_10) {
                                // empty catch block
                            }
                        }
                        throw var6_12;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var4_4.close();
                        }
                        catch (IOException var8_8) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block15;
                        catch (IOException var5_11) {
                            RMIClient.warn("channel.key_read_error");
                            RMIClient.debug(var5_11);
                            var1_1 = null;
                            var7_6 = null;
                            if (var4_4 != null) {
                                try {
                                    var4_4.close();
                                }
                                catch (IOException var8_9) {}
                            }
                            break block15;
                        }
                    }
                }
                RMIClient.debug("channel.seed_file_older", new Long[]{new Long(var2_2), new Long(this.stubFileTs)});
            } else {
                RMIClient.warn("channel.key_read_error");
                RMIClient.debug("channel.file_read_error", this.seedFile.getName());
            }
        }
        if (var1_1 == null) {
            var2_3 = RMIClient.localStrings.getString("admin.server.core.channel.unable_initializing_key", this.seedFile);
            throw new IOException(var2_3);
        }
        return var1_1;
    }

    public boolean hasRestartedSince(long l) {
        return this.hasRestartedSince(l, false);
    }

    public boolean hasRestartedSince(long l, boolean bl) {
        boolean bl2;
        if (bl) {
            bl2 = this.checkServerStatus();
        }
        bl2 = false;
        if (this.stubFile != null && this.stubFileTs > l) {
            bl2 = true;
        }
        return bl2;
    }

    static void trace(Throwable throwable) {
        logger.log(Level.FINEST, throwable.getMessage(), throwable);
    }

    static void warn(String string) {
        logger.warning(string);
    }

    static void warn(String string, String string2) {
        logger.log(Level.WARNING, string, string2);
    }

    static void debug(String string) {
        logger.fine(string);
    }

    static void debug(String string, String string2) {
        logger.log(Level.FINE, string, string2);
    }

    static void debug(String string, Object[] objectArray) {
        logger.log(Level.FINE, string, objectArray);
    }

    static void debug(Throwable throwable) {
        logger.log(Level.FINE, throwable.getMessage(), throwable);
    }
}

