/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.channel;

import com.iplanet.ias.admin.event.AdminEvent;
import com.iplanet.ias.admin.event.AdminEventMulticaster;
import com.iplanet.ias.admin.event.AdminEventResult;
import com.iplanet.ias.admin.server.core.channel.AdminChannel;
import com.iplanet.ias.admin.server.core.channel.RemoteAdminChannel;
import com.iplanet.ias.util.i18n.StringManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;

public class AdminChannelServer
extends UnicastRemoteObject
implements RemoteAdminChannel {
    private String localAddress = null;
    private byte[] myKey;
    private int instanceStatus = 1;
    private boolean restartNeeded = false;
    private static final String CLIENT_HOST_NULL = "channel.client_host_null";
    private static final String LOCAL_ACCESS = "channel.local_access";
    private static final String ADDR_MISMATCH = "channel.addr_mismatch";
    private static final String NO_LOCAL_HOST = "channel.no_local_host";
    private static final String KEY_MISMATCH = "channel.key_mismatch";
    private static StringManager localStrings = StringManager.getManager(AdminChannelServer.class);

    public AdminChannelServer() throws RemoteException {
    }

    public AdminChannelServer(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        super(n, rMIClientSocketFactory, rMIServerSocketFactory);
    }

    public AdminEventResult sendNotification(byte[] byArray, AdminEvent adminEvent) throws RemoteException {
        if (!this.checkAccess()) {
            String string = localStrings.getString("admin.server.core.channel.unauthorized_access");
            throw new SecurityException(string);
        }
        if (!this.keyMatches(byArray)) {
            String string = localStrings.getString("admin.server.core.channel.invalid_key");
            throw new IllegalArgumentException(string);
        }
        return AdminEventMulticaster.multicastEvent(adminEvent);
    }

    public boolean pingServer(byte[] byArray) throws RemoteException {
        if (!this.checkAccess()) {
            String string = localStrings.getString("admin.server.core.channel.unauthorized_access");
            throw new SecurityException(string);
        }
        if (!this.keyMatches(byArray)) {
            String string = localStrings.getString("admin.server.core.channel.invalid_key");
            throw new IllegalArgumentException(string);
        }
        return true;
    }

    public int getServerStatusCode(byte[] byArray) throws RemoteException {
        if (!this.checkAccess()) {
            String string = localStrings.getString("admin.server.core.channel.unauthorized_access");
            throw new SecurityException(string);
        }
        if (!this.keyMatches(byArray)) {
            String string = localStrings.getString("admin.server.core.channel.invalid_key");
            throw new IllegalArgumentException(string);
        }
        return this.instanceStatus;
    }

    public boolean isRestartNeeded(byte[] byArray) throws RemoteException {
        if (!this.checkAccess()) {
            String string = localStrings.getString("admin.server.core.channel.unauthorized_access");
            throw new SecurityException(string);
        }
        if (!this.keyMatches(byArray)) {
            String string = localStrings.getString("admin.server.core.channel.invalid_key");
            throw new IllegalArgumentException(string);
        }
        return this.restartNeeded;
    }

    public void setRestartNeeded(byte[] byArray, boolean bl) throws RemoteException {
        if (!this.checkAccess()) {
            String string = localStrings.getString("admin.server.core.channel.unauthorized_access");
            throw new SecurityException(string);
        }
        if (!this.keyMatches(byArray)) {
            String string = localStrings.getString("admin.server.core.channel.invalid_key");
            throw new IllegalArgumentException(string);
        }
        this.restartNeeded = bl;
    }

    void setSharedInfo(byte[] byArray) {
        this.myKey = byArray;
    }

    RemoteStub getRemoteStub() throws NoSuchObjectException {
        return (RemoteStub)RemoteObject.toStub(this);
    }

    void setLocalAddress(InetAddress inetAddress) {
        this.localAddress = inetAddress.getHostAddress();
    }

    void setChannelStarting() {
        this.instanceStatus = 1;
    }

    void setChannelReady() {
        this.instanceStatus = 0;
    }

    void setChannelStopping() {
        this.instanceStatus = 2;
    }

    private boolean checkAccess() {
        boolean bl = true;
        String string = null;
        if ("high".equals(AdminChannel.getAccessLevel())) {
            boolean bl2 = true;
            try {
                string = this.getClientHost();
                if (string == null) {
                    AdminChannel.warn(CLIENT_HOST_NULL);
                    bl = false;
                    bl2 = false;
                }
            }
            catch (ServerNotActiveException serverNotActiveException) {
                AdminChannel.warn(LOCAL_ACCESS);
                AdminChannel.debug(serverNotActiveException);
                bl2 = false;
            }
            if (bl2) {
                bl = this.addressMatches(string);
            }
        }
        if (!bl) {
            AdminChannel.debug(ADDR_MISMATCH, new Object[]{string, this.getLocalAddress()});
        }
        return bl;
    }

    private boolean addressMatches(String string) {
        String string2 = this.getLocalAddress();
        if (string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    private String getLocalAddress() {
        if (this.localAddress == null) {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                AdminChannel.warn(NO_LOCAL_HOST);
                AdminChannel.debug(unknownHostException);
            }
            if (inetAddress != null) {
                this.localAddress = inetAddress.getHostAddress();
            }
        }
        return this.localAddress;
    }

    private boolean keyMatches(byte[] byArray) {
        boolean bl = true;
        if ("high".equals(AdminChannel.getKeyCheckLevel())) {
            bl = this.checkKeyLength(byArray);
            for (int i = 0; bl && i < 16; ++i) {
                if (byArray[i] == this.myKey[i]) continue;
                bl = false;
            }
        } else if ("medium".equals(AdminChannel.getKeyCheckLevel())) {
            bl = this.checkKeyLength(byArray);
        }
        if (!bl) {
            AdminChannel.debug(KEY_MISMATCH, new Object[]{new String(byArray), new String(this.myKey)});
        }
        return bl;
    }

    private boolean checkKeyLength(byte[] byArray) {
        return byArray.length == 16;
    }
}

