/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core;

import com.iplanet.ias.admin.server.core.ManualChangeManager;
import com.iplanet.ias.admin.server.core.ManualChangeStatus;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.ServerManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ManualChangeTracker {
    static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static int sleepPeriod = 120000;
    private static TrackerThread trackerThread = null;

    static void start() {
        logger.log(Level.INFO, "core.tracker_thread_starting");
        trackerThread = new TrackerThread();
        trackerThread.start();
    }

    static void stop() {
        trackerThread = null;
        logger.log(Level.INFO, "core.tracker_thread_stopping");
    }

    static /* synthetic */ int access$100() {
        return sleepPeriod;
    }

    private static class TrackerThread
    extends Thread {
        private static final int SLEEPTIME = ManualChangeTracker.access$100();

        private TrackerThread() {
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (thread == trackerThread) {
                try {
                    TrackerThread.sleep(SLEEPTIME);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    String[] stringArray = ServerManager.instance().getInstanceNames(false);
                    for (int i = 0; i < stringArray.length; ++i) {
                        try {
                            String string = stringArray[i];
                            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string);
                            ManualChangeStatus manualChangeStatus = new ManualChangeStatus();
                            manualChangeStatus.setObjectFileChanged(instanceEnvironment.hasHotObjectChanged());
                            manualChangeStatus.setInitFileChanged(instanceEnvironment.hasHotInitChanged());
                            manualChangeStatus.setRealmsKeyFileChanged(instanceEnvironment.hasHotRealmsKeyChanged());
                            manualChangeStatus.setServerXmlFileChanged(instanceEnvironment.hasHotXmlChanged());
                            manualChangeStatus.setMimeFileChanged(instanceEnvironment.hasHotMimeChanged());
                            manualChangeStatus.setVirtualServerConfFilesChanged(instanceEnvironment.hasHotVirtualServerConfChanged());
                            logger.log(Level.FINE, "Got Manual Change status for " + string);
                            logger.log(Level.FINEST, "-------------------------------------");
                            logger.log(Level.FINEST, manualChangeStatus.toString());
                            logger.log(Level.FINEST, "------------------------------------");
                            ManualChangeManager.addManualChangeStatus(string, manualChangeStatus);
                            TrackerThread.sleep(2000L);
                            continue;
                        }
                        catch (Exception exception) {
                            logger.log(Level.WARNING, "core.error_getting_manual_changes", exception);
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

