/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core;

import com.iplanet.ias.admin.audit.ASAuditEvent_Login;
import com.iplanet.ias.admin.audit.ASAuditEvent_Logout;
import com.iplanet.ias.admin.audit.ASAuditException;
import com.iplanet.ias.admin.audit.ASAuditService;
import com.iplanet.ias.admin.audit.ASAuditSession;
import com.iplanet.ias.admin.common.MBeanServerFactory;
import com.iplanet.ias.admin.common.domains.registry.ContactData;
import com.iplanet.ias.admin.common.domains.registry.ContactDataSet;
import com.iplanet.ias.admin.common.domains.registry.DomainEntry;
import com.iplanet.ias.admin.common.domains.registry.DomainRegistry;
import com.iplanet.ias.admin.common.domains.registry.DomainRegistryException;
import com.iplanet.ias.admin.event.AdminEventListenerRegistry;
import com.iplanet.ias.admin.event.WebConfigChangeEventListener;
import com.iplanet.ias.admin.monitor.GenericMonitorMBean;
import com.iplanet.ias.admin.monitor.MonitoringChannel;
import com.iplanet.ias.admin.server.core.ManualChangeTracker;
import com.iplanet.ias.admin.server.core.channel.AdminChannel;
import com.iplanet.ias.admin.server.core.jmx.ASMBeanServerImpl;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.HttpListener;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.ServerManager;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.util.io.FileUtils;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;

public class AdminService {
    public static final boolean ENABLE_PERFORMANCE_THREAD = true;
    public static final Logger sLogger = LogDomains.getLogger("javax.enterprise.system.tools.admin");
    private static AdminService adminService = null;
    private static String kTempDirNamePrefix = "s1astemp";
    private static String kGUITempDirName = "gui";
    private static String kTempDirNameSuffix = "" + (System.getProperty("com.sun.aas.instanceRoot") != null ? System.getProperty("com.sun.aas.instanceRoot").hashCode() : 0);
    private static int sMBeanServerID;
    public static final int kDefaultImpl = 0;
    private ServerContext context;
    private String mTempDirPath;
    private String mGUITempDirPath;
    private static final String ADMIN_JAVAROOT = "com.sun.aas.javaRoot";
    private static final String PLUGIN_JAVAROOT = "JAVA_HOME";

    AdminService() {
        sMBeanServerID = 0;
    }

    static void setAdminService(AdminService adminService) {
        AdminService.adminService = adminService;
    }

    public static AdminService getAdminService() {
        return adminService;
    }

    void init() throws ServerLifecycleException {
        MBeanServer mBeanServer = null;
        if (sMBeanServerID == 0) {
            try {
                mBeanServer = ASMBeanServerImpl.getMBeanServerInstance();
                MBeanServerFactory.initialize((Object)this, (MBeanServer)mBeanServer);
                if (this.isAdminInstance()) {
                    sLogger.log(Level.INFO, "core.mbs_init_ok");
                    this.createTimeStampFilesForInstances();
                    ManualChangeTracker.start();
                } else if (sLogger.isLoggable(Level.FINEST)) {
                    sLogger.log(Level.FINEST, "core.mbs_init_ok");
                }
                GenericMonitorMBean genericMonitorMBean = GenericMonitorMBean.getRoot();
                ObjectInstance objectInstance = mBeanServer.registerMBean(genericMonitorMBean, genericMonitorMBean.getObjectName());
                String string = objectInstance.getObjectName().toString();
                if (sLogger.isLoggable(Level.FINEST)) {
                    sLogger.log(Level.FINEST, "monitor.reg_root_mbean", string);
                }
            }
            catch (Throwable throwable) {
                if (this.isAdminInstance()) {
                    sLogger.log(Level.SEVERE, "core.mbs_init_exception", throwable);
                } else {
                    sLogger.log(Level.WARNING, "core.mbs_init_exception", throwable);
                }
                throw new ServerLifecycleException(throwable.getMessage());
            }
        }
    }

    void start() throws ServerLifecycleException {
        if (this.isAdminInstance()) {
            this.startAdminInstance();
        } else {
            this.startNormalInstance();
        }
    }

    void ready() throws ServerLifecycleException {
        if (this.isAdminInstance()) {
            this.readyAdminInstance();
        } else {
            this.readyNormalInstance();
        }
    }

    void stop() throws ServerLifecycleException {
        if (this.isAdminInstance()) {
            ManualChangeTracker.stop();
            this.stopAdminInstance();
        } else {
            this.stopNormalInstance();
        }
    }

    void destroy() throws ServerLifecycleException {
    }

    public ServerContext getContext() {
        return adminService == null ? null : AdminService.adminService.context;
    }

    void setContext(ServerContext serverContext) {
        this.context = serverContext;
    }

    public String getInstanceName() {
        return this.context == null ? null : this.context.getInstanceName();
    }

    public GenericMonitorMBean getRootMonitorMBean() {
        return GenericMonitorMBean.getRoot();
    }

    private void startAdminInstance() throws ServerLifecycleException {
        this.setAdminInstanceProperties();
        AdminChannel.createRMIChannel();
        AdminChannel.createSharedSecret();
        this.createTempDir();
        try {
            ASAuditSession aSAuditSession = ASAuditService.getAuditSession(ASAuditService.GLOBAL_AUDITSESS);
            ASAuditEvent_Login aSAuditEvent_Login = (ASAuditEvent_Login)aSAuditSession.getAuditEvent("com.iplanet.ias.admin.audit.ASAuditEvent_Login");
            aSAuditEvent_Login.putEvent(0);
        }
        catch (ASAuditException aSAuditException) {
            // empty catch block
        }
    }

    private void readyAdminInstance() throws ServerLifecycleException {
        AdminChannel.setRMIChannelReady();
        this.updateDomainRegistry();
    }

    private void stopAdminInstance() throws ServerLifecycleException {
        try {
            ASAuditSession aSAuditSession = ASAuditService.getAuditSession(ASAuditService.GLOBAL_AUDITSESS);
            ASAuditEvent_Logout aSAuditEvent_Logout = (ASAuditEvent_Logout)aSAuditSession.getAuditEvent("com.iplanet.ias.admin.audit.ASAuditEvent_Logout");
            aSAuditEvent_Logout.putEvent(0);
        }
        catch (ASAuditException aSAuditException) {
            // empty catch block
        }
        this.deleteTempDir();
        AdminChannel.destroyRMIChannel();
    }

    private void startNormalInstance() throws ServerLifecycleException {
        AdminChannel.createRMIChannel();
        AdminChannel.createSharedSecret();
        AdminEventListenerRegistry.addMonitoringEventListener(new MonitoringChannel());
        WebConfigChangeEventListener webConfigChangeEventListener = new WebConfigChangeEventListener();
        AdminEventListenerRegistry.addConfigChangeEventListener(webConfigChangeEventListener.getConfigChangeCategory(), webConfigChangeEventListener);
    }

    private void readyNormalInstance() throws ServerLifecycleException {
        AdminChannel.setRMIChannelReady();
    }

    private void stopNormalInstance() throws ServerLifecycleException {
        AdminChannel.destroyRMIChannel();
    }

    public boolean isAdminInstance() {
        return "admin-server".equals(this.context.getInstanceName());
    }

    private void createTimeStampFilesForInstances() {
        String[] stringArray = ServerManager.instance().getInstanceNames(true);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string = stringArray[i];
                InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string);
                instanceEnvironment.createTimeStampFiles();
                sLogger.log(Level.INFO, "core.ts_files_ok", string);
                continue;
            }
            catch (Exception exception) {
                sLogger.log(Level.WARNING, "core.ts_files_failed", exception);
            }
        }
    }

    public String getTempDirPath() {
        if (this.mTempDirPath == null) {
            this.createTempDir();
        }
        return this.mTempDirPath;
    }

    public String getGUITempDirPath() {
        if (this.mGUITempDirPath == null) {
            this.createTempDir();
        }
        return this.mGUITempDirPath;
    }

    private void createTempDir() {
        try {
            String string = ServerManager.instance().getDomainName();
            String string2 = System.getProperty("java.io.tmpdir");
            String string3 = kTempDirNamePrefix + string + "admin-server" + kTempDirNameSuffix;
            File file = new File(string2, string3);
            this.mTempDirPath = file.getCanonicalPath();
            File file2 = new File(this.mTempDirPath, kGUITempDirName);
            this.mGUITempDirPath = file2.getCanonicalPath();
            if (file.exists()) {
                sLogger.log(Level.FINEST, "core.tmp_folder_exists", this.mTempDirPath);
                return;
            }
            boolean bl = file.mkdirs();
            if (!bl) {
                sLogger.log(Level.WARNING, "core.tmp_folder_creation_failed", this.mTempDirPath);
            } else {
                sLogger.log(Level.FINEST, "core.tmp_folder_created_ok", this.mTempDirPath);
            }
            bl = file2.mkdirs();
            if (!bl) {
                sLogger.log(Level.WARNING, "core.gui_tmp_folder_creation_failed", this.mGUITempDirPath);
            } else {
                sLogger.log(Level.FINEST, "core.gui_tmp_folder_created_ok", this.mGUITempDirPath);
            }
        }
        catch (Throwable throwable) {
            sLogger.log(Level.WARNING, "core.tmp_folder_creation_failed", throwable);
        }
    }

    private void deleteTempDir() {
        try {
            FileUtils.whack(new File(this.mTempDirPath));
            sLogger.log(Level.FINEST, "core.tmp_folder_deleted_ok", this.mTempDirPath);
        }
        catch (Throwable throwable) {
            sLogger.log(Level.WARNING, "core.tmp_folder_deletion_failed", this.mTempDirPath);
        }
    }

    private void updateDomainRegistry() {
        try {
            String string = ServerManager.instance().getDomainName();
            DomainRegistry domainRegistry = DomainRegistry.newInstance();
            DomainEntry domainEntry = domainRegistry.getDomain(string);
            File file = domainEntry.getRoot();
            ContactDataSet contactDataSet = new ContactDataSet();
            Server server = this.context.getConfigBean();
            HttpListener[] httpListenerArray = server.getHttpService().getHttpListener();
            for (int i = 0; i < httpListenerArray.length; ++i) {
                HttpListener httpListener = httpListenerArray[i];
                contactDataSet.add((Object)new ContactData(httpListener.getServerName(), httpListener.getPort(), httpListener.isSecurityEnabled()));
            }
            DomainEntry domainEntry2 = new DomainEntry(string, file, contactDataSet);
            domainRegistry.reregisterDomain(domainEntry2);
        }
        catch (DomainRegistryException domainRegistryException) {
            sLogger.log(Level.WARNING, "core.domain_reregistration_failed");
            sLogger.log(Level.FINE, "core.domain_exception_occured", domainRegistryException);
        }
        catch (ConfigException configException) {
            sLogger.log(Level.WARNING, "core.domain_reregistration_failed");
            sLogger.log(Level.FINE, "core.config_exception_occured", configException);
        }
        catch (Throwable throwable) {
            sLogger.log(Level.WARNING, "core.domain_reregistration_failed");
            sLogger.log(Level.FINE, "general.unexpected_exception", throwable);
        }
    }

    private void setAdminInstanceProperties() {
        try {
            String string = System.getProperty(ADMIN_JAVAROOT);
            String string2 = System.getProperty(PLUGIN_JAVAROOT);
            if (string == null) {
                if (string2 != null) {
                    System.setProperty(ADMIN_JAVAROOT, string2);
                } else {
                    sLogger.log(Level.WARNING, "core.no_java_home");
                }
            }
        }
        catch (Throwable throwable) {
            sLogger.log(Level.WARNING, "core.set_admin_property_failed");
            sLogger.log(Level.FINE, "general.unexpected_exception", throwable);
        }
    }
}

