/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.monitor;

import com.iplanet.ias.admin.monitor.BaseMonitorMBean;
import com.iplanet.ias.admin.monitor.GenericMonitorMBean;
import com.iplanet.ias.admin.monitor.IMonitorable;
import com.iplanet.ias.admin.monitor.MonitoredObjectType;
import com.iplanet.ias.admin.server.core.AdminService;
import com.iplanet.ias.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.ObjectName;

public class MonitoringHelper {
    private static StringManager localStrings = StringManager.getManager(MonitoringHelper.class);
    static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    public static final String SYSTEM_ORB_NAME = "system";
    private static final HashMap userOrbNames = new HashMap();
    private static int orbNameUniquifier = 0;
    public static final String DEFAULT_USER_ORB_HINT = "user";
    private static final char COMMA = ',';
    private static final char SPACE = ' ';
    private static final char COLON = ':';
    private static final char EQUALS = '=';
    private static final String PURGE_MBEAN_FAILED = "monitor.purge_mbean_failed";
    private static final String PURGE_MBEAN_FAILED_TRACE = "monitor.purge_mbean_failed_trace";
    private static final String USER_ORB_MBEAN_NAME_USED = "monitor.user_orb_mbean_name_used";
    private static final String ORB_MBEAN_REGISTERED = "monitor.orb_mbean_registered";
    private static final String INVALID_USER_ORB_NAME_HINT = "monitor.invalid_user_orb_name_hint";

    public static ObjectName registerEJBMonitoringMBean(String string, String string2, String string3, MonitoredObjectType monitoredObjectType, BaseMonitorMBean baseMonitorMBean) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        BaseMonitorMBean baseMonitorMBean2 = MonitoringHelper.getLevelOneMBeanForSure(MonitoredObjectType.APPLICATION, string);
        BaseMonitorMBean baseMonitorMBean3 = MonitoringHelper.getMBeanForSure(baseMonitorMBean2, MonitoredObjectType.EJBMODULE, string2);
        baseMonitorMBean3.addChild(string3, monitoredObjectType, baseMonitorMBean);
        return baseMonitorMBean.getObjectName();
    }

    public static ObjectName getEJBMonitoringMBeanName(String string, String string2, String string3) throws InstanceNotFoundException {
        return MonitoringHelper.getEJBMonitoringMBean(string, string2, string3).getObjectName();
    }

    public static void unregisterEJBMonitoringMBean(String string, String string2, String string3) throws InstanceNotFoundException, MBeanRegistrationException {
        BaseMonitorMBean baseMonitorMBean = MonitoringHelper.getEJBModuleMBean(string, string2);
        BaseMonitorMBean baseMonitorMBean2 = baseMonitorMBean.getFirstChildByName(string3);
        baseMonitorMBean.removeChild(baseMonitorMBean2);
        MonitoringHelper.checkAndPurgeUnusedAppAndModule(string, baseMonitorMBean);
    }

    public static ObjectName registerEJBMonitoringMBean(String string, String string2, MonitoredObjectType monitoredObjectType, BaseMonitorMBean baseMonitorMBean) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        BaseMonitorMBean baseMonitorMBean2 = MonitoringHelper.getLevelOneMBeanForSure(MonitoredObjectType.STANDALONE_EJBMODULE, string);
        baseMonitorMBean2.addChild(string2, monitoredObjectType, baseMonitorMBean);
        return baseMonitorMBean.getObjectName();
    }

    public static ObjectName getEJBMonitoringMBeanName(String string, String string2) throws InstanceNotFoundException {
        return MonitoringHelper.getEJBMonitoringMBean(string, string2).getObjectName();
    }

    public static void unregisterEJBMonitoringMBean(String string, String string2) throws InstanceNotFoundException, MBeanRegistrationException {
        BaseMonitorMBean baseMonitorMBean = MonitoringHelper.getEJBModuleMBean(string);
        BaseMonitorMBean baseMonitorMBean2 = baseMonitorMBean.getFirstChildByName(string2);
        baseMonitorMBean.removeChild(baseMonitorMBean2);
        MonitoringHelper.checkAndPurgeUnusedLevelOneMBean(baseMonitorMBean);
    }

    public static void registerEJBMethodMonitoringMBean(ObjectName objectName, String string, BaseMonitorMBean baseMonitorMBean) throws InstanceNotFoundException, InstanceAlreadyExistsException, MBeanRegistrationException {
        BaseMonitorMBean baseMonitorMBean2 = MonitoringHelper.getMonitorMBean(objectName);
        baseMonitorMBean2.addChild(string, MonitoredObjectType.BEAN_METHOD, baseMonitorMBean);
    }

    public static ObjectName registerMonitoringMBean(String string, BaseMonitorMBean baseMonitorMBean) throws InstanceNotFoundException, MBeanRegistrationException {
        return null;
    }

    public static void unregisterMonitoringMBean(String string) throws InstanceNotFoundException, MBeanRegistrationException {
    }

    public static void registerSystemORBMonitoringMBean(BaseMonitorMBean baseMonitorMBean) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        MonitoringHelper.registerORBMonitoringMBean(SYSTEM_ORB_NAME, baseMonitorMBean);
    }

    public static void registerUserORBMonitoringMBean(String string, BaseMonitorMBean baseMonitorMBean) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        if (SYSTEM_ORB_NAME.equalsIgnoreCase(string)) {
            String string2 = localStrings.getString("admin.monitor.system_orb_name_used", string);
            throw new IllegalArgumentException(string2);
        }
        MonitoringHelper.registerORBMonitoringMBean(MonitoringHelper.getUserOrbMBeanName(string), baseMonitorMBean);
    }

    private static void registerORBMonitoringMBean(String string, BaseMonitorMBean baseMonitorMBean) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        if (AdminService.getAdminService() == null) {
            String string2 = localStrings.getString("admin.monitor.admin_service_not_inited");
            throw new IllegalStateException(string2);
        }
        BaseMonitorMBean baseMonitorMBean2 = MonitoringHelper.getLevelOneMBeanForSure(MonitoredObjectType.IIOP_SERVICE, MonitoredObjectType.IIOP_SERVICE.getTypeName());
        baseMonitorMBean2.addChild(string, MonitoredObjectType.ORB, baseMonitorMBean);
        logger.log(Level.FINEST, ORB_MBEAN_REGISTERED, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUserOrbMBeanName(String string) {
        if (string == null || string.trim().equals("") || string.equalsIgnoreCase(DEFAULT_USER_ORB_HINT) || string.indexOf(44) != -1 || string.indexOf(32) != -1 || string.indexOf(58) != -1 || string.indexOf(61) != -1) {
            logger.log(Level.FINEST, INVALID_USER_ORB_NAME_HINT, string);
            string = DEFAULT_USER_ORB_HINT + ++orbNameUniquifier;
        }
        HashMap hashMap = userOrbNames;
        synchronized (hashMap) {
            while (userOrbNames.containsKey(string)) {
                logger.log(Level.FINEST, USER_ORB_MBEAN_NAME_USED, string);
                string = string + ++orbNameUniquifier;
            }
            userOrbNames.put(string, string);
        }
        return string;
    }

    public static ObjectName registerMonitorable(String string, IMonitorable iMonitorable) throws InstanceNotFoundException, MBeanRegistrationException {
        return null;
    }

    public static void unregisterMonitorable(String string) throws InstanceNotFoundException, MBeanRegistrationException {
    }

    public static BaseMonitorMBean getMonitorMBean(ObjectName objectName) throws InstanceNotFoundException {
        BaseMonitorMBean baseMonitorMBean = MonitoringHelper.getMonitorMBeanOrNull(objectName);
        if (baseMonitorMBean == null) {
            String string = localStrings.getString("admin.monitor.mbean_with_name_not_found", objectName);
            throw new InstanceNotFoundException(string);
        }
        return baseMonitorMBean;
    }

    private static BaseMonitorMBean getMonitorMBeanOrNull(ObjectName objectName) {
        BaseMonitorMBean baseMonitorMBean = (BaseMonitorMBean)BaseMonitorMBean.objectNameMap.get(objectName);
        return baseMonitorMBean;
    }

    private static BaseMonitorMBean getEJBMonitoringMBean(String string, String string2, String string3) throws InstanceNotFoundException {
        ArrayList arrayList;
        Object object;
        BaseMonitorMBean baseMonitorMBean = null;
        BaseMonitorMBean baseMonitorMBean2 = MonitoringHelper.getLevelOneMBean(MonitoredObjectType.APPLICATION, string);
        if (baseMonitorMBean2 != null && (object = baseMonitorMBean2.getChildOrNull(MonitoredObjectType.EJBMODULE, string2)) != null && !(arrayList = ((BaseMonitorMBean)object).getChildList(string3)).isEmpty()) {
            baseMonitorMBean = (BaseMonitorMBean)arrayList.get(0);
        }
        if (baseMonitorMBean == null) {
            object = localStrings.getString("admin.monitor.no_mbean_for_appname_modulename_ejbname", string, string2, string3);
            throw new InstanceNotFoundException((String)object);
        }
        return baseMonitorMBean;
    }

    private static BaseMonitorMBean getEJBModuleMBean(String string, String string2) {
        BaseMonitorMBean baseMonitorMBean = null;
        BaseMonitorMBean baseMonitorMBean2 = MonitoringHelper.getLevelOneMBean(MonitoredObjectType.APPLICATION, string);
        if (baseMonitorMBean2 != null) {
            baseMonitorMBean = baseMonitorMBean2.getChildOrNull(MonitoredObjectType.EJBMODULE, string2);
        }
        return baseMonitorMBean;
    }

    private static BaseMonitorMBean getEJBMonitoringMBean(String string, String string2) throws InstanceNotFoundException {
        Object object;
        BaseMonitorMBean baseMonitorMBean = null;
        BaseMonitorMBean baseMonitorMBean2 = MonitoringHelper.getLevelOneMBean(MonitoredObjectType.STANDALONE_EJBMODULE, string);
        if (baseMonitorMBean2 != null && !((ArrayList)(object = baseMonitorMBean2.getChildList(string2))).isEmpty()) {
            baseMonitorMBean = (BaseMonitorMBean)((ArrayList)object).get(0);
        }
        if (baseMonitorMBean == null) {
            object = localStrings.getString("admin.monitor.no_mbean_for_standalonemodulename_ejbname", string, string2);
            throw new InstanceNotFoundException((String)object);
        }
        return baseMonitorMBean;
    }

    private static BaseMonitorMBean getEJBModuleMBean(String string) {
        return MonitoringHelper.getLevelOneMBean(MonitoredObjectType.STANDALONE_EJBMODULE, string);
    }

    private static BaseMonitorMBean getLevelOneMBean(MonitoredObjectType monitoredObjectType, String string) {
        GenericMonitorMBean genericMonitorMBean = GenericMonitorMBean.getRoot();
        return genericMonitorMBean.getChildOrNull(monitoredObjectType, string);
    }

    private static BaseMonitorMBean getLevelOneMBeanForSure(MonitoredObjectType monitoredObjectType, String string) {
        GenericMonitorMBean genericMonitorMBean = GenericMonitorMBean.getRoot();
        return MonitoringHelper.getMBeanForSure(genericMonitorMBean, monitoredObjectType, string);
    }

    private static BaseMonitorMBean getMBeanForSure(BaseMonitorMBean baseMonitorMBean, MonitoredObjectType monitoredObjectType, String string) {
        BaseMonitorMBean baseMonitorMBean2 = baseMonitorMBean.getChildOrNull(monitoredObjectType, string);
        if (baseMonitorMBean2 == null) {
            baseMonitorMBean2 = new GenericMonitorMBean();
            try {
                baseMonitorMBean.addChild(string, monitoredObjectType, baseMonitorMBean2);
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                baseMonitorMBean2 = baseMonitorMBean.getChildOrNull(monitoredObjectType, string);
                if (baseMonitorMBean2 == null) {
                    String string2 = localStrings.getString("admin.monitor.unable_getting_mbean", monitoredObjectType, string, baseMonitorMBean.getObjectName());
                    throw new RuntimeException(string2);
                }
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                String string3 = localStrings.getString("admin.monitor.rootcause_unable_to_register_mbean", monitoredObjectType, string, mBeanRegistrationException.getMessage());
                throw new RuntimeException(string3);
            }
        }
        return baseMonitorMBean2;
    }

    public static ObjectName registerTxnMonitoringMBean(BaseMonitorMBean baseMonitorMBean) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        GenericMonitorMBean.getRoot().addChild(MonitoredObjectType.TXNMGR.getTypeName(), MonitoredObjectType.TXNMGR, baseMonitorMBean);
        return baseMonitorMBean.getObjectName();
    }

    public static ObjectName registerJdbcPoolMonitoringMBean(String string, MonitoredObjectType monitoredObjectType, BaseMonitorMBean baseMonitorMBean) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        if (AdminService.getAdminService() != null) {
            BaseMonitorMBean baseMonitorMBean2 = MonitoringHelper.getLevelOneMBeanForSure(MonitoredObjectType.RESOURCES, "resources");
            baseMonitorMBean2.addChild(string, monitoredObjectType, baseMonitorMBean);
            return baseMonitorMBean.getObjectName();
        }
        return null;
    }

    public void unregisterJdbcPoolMonitoringMBean(MonitoredObjectType monitoredObjectType, String string) throws InstanceNotFoundException, MBeanRegistrationException {
        BaseMonitorMBean baseMonitorMBean = MonitoringHelper.getLevelOneMBean(MonitoredObjectType.RESOURCES, "resources");
        if (baseMonitorMBean != null) {
            baseMonitorMBean.removeChild(monitoredObjectType, string);
        }
    }

    private static void checkAndPurgeUnusedAppAndModule(String string, BaseMonitorMBean baseMonitorMBean) {
        if (baseMonitorMBean == null) {
            return;
        }
        BaseMonitorMBean baseMonitorMBean2 = MonitoringHelper.getLevelOneMBean(MonitoredObjectType.APPLICATION, string);
        boolean bl = MonitoringHelper.checkAndPurgeMBean(baseMonitorMBean2, baseMonitorMBean);
        if (bl) {
            MonitoringHelper.checkAndPurgeUnusedLevelOneMBean(baseMonitorMBean2);
        }
    }

    private static void checkAndPurgeUnusedLevelOneMBean(BaseMonitorMBean baseMonitorMBean) {
        if (baseMonitorMBean == null) {
            return;
        }
        GenericMonitorMBean genericMonitorMBean = GenericMonitorMBean.getRoot();
        boolean bl = MonitoringHelper.checkAndPurgeMBean(genericMonitorMBean, baseMonitorMBean);
    }

    private static boolean checkAndPurgeMBean(BaseMonitorMBean baseMonitorMBean, BaseMonitorMBean baseMonitorMBean2) {
        ArrayList arrayList;
        boolean bl = false;
        if (baseMonitorMBean2 != null && baseMonitorMBean != null && ((arrayList = baseMonitorMBean2.getChildList()) == null || arrayList.size() == 0)) {
            try {
                baseMonitorMBean.removeChild(baseMonitorMBean2);
                bl = true;
            }
            catch (Throwable throwable) {
                logger.log(Level.FINE, PURGE_MBEAN_FAILED, baseMonitorMBean2.getNodeType() + "/" + baseMonitorMBean2.getNodeName());
                logger.log(Level.FINEST, PURGE_MBEAN_FAILED_TRACE, throwable);
            }
        }
        return bl;
    }
}

