/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.monitor;

import com.iplanet.ias.admin.event.AdminEventCache;
import com.iplanet.ias.admin.event.AdminEventListenerException;
import com.iplanet.ias.admin.event.AdminEventMulticaster;
import com.iplanet.ias.admin.event.MonitoringEvent;
import com.iplanet.ias.admin.event.MonitoringEventListener;
import com.iplanet.ias.admin.monitor.GenericMonitorMBean;
import com.iplanet.ias.admin.monitor.MonitorCommand;
import com.iplanet.ias.admin.monitor.MonitoredObjectType;
import com.iplanet.ias.admin.server.core.AdminService;
import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;

public class MonitoringChannel
implements MonitoringEventListener {
    static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final String MON_INIT_ERROR = " monitor.channel_init_error";
    private static final String COMP_INIT_ERROR = "monitor.comp_init_error";
    private static StringManager localStrings = StringManager.getManager(MonitoringChannel.class);

    public MonitoringChannel() {
        try {
            this.initMonitoringEnabled();
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, MON_INIT_ERROR);
            logger.log(Level.FINE, throwable.getMessage(), throwable);
        }
    }

    public void startMonitoring(MonitoringEvent monitoringEvent) throws AdminEventListenerException {
        String string = monitoringEvent.getComponentName();
        MonitoredObjectType[] monitoredObjectTypeArray = this.getMonitoredObjectTypeList(string);
        GenericMonitorMBean genericMonitorMBean = GenericMonitorMBean.getRoot();
        genericMonitorMBean.startMonitoring(monitoredObjectTypeArray);
        MonitoredObjectType.setMonitoringEnabled(string, true);
    }

    public void stopMonitoring(MonitoringEvent monitoringEvent) throws AdminEventListenerException {
        String string = monitoringEvent.getComponentName();
        MonitoredObjectType[] monitoredObjectTypeArray = this.getMonitoredObjectTypeList(string);
        GenericMonitorMBean genericMonitorMBean = GenericMonitorMBean.getRoot();
        genericMonitorMBean.stopMonitoring(monitoredObjectTypeArray);
        MonitoredObjectType.setMonitoringEnabled(string, false);
    }

    public void getMonitoringData(MonitoringEvent monitoringEvent) throws AdminEventListenerException {
        this.executeMonitoringCommand(monitoringEvent);
    }

    public void listMonitorable(MonitoringEvent monitoringEvent) throws AdminEventListenerException {
        this.executeMonitoringCommand(monitoringEvent);
    }

    public void setMonitoringData(MonitoringEvent monitoringEvent) throws AdminEventListenerException {
        this.executeMonitoringCommand(monitoringEvent);
    }

    private void executeMonitoringCommand(MonitoringEvent monitoringEvent) throws AdminEventListenerException {
        MonitorCommand monitorCommand = null;
        Object object = monitoringEvent.getCommand();
        if (object == null || !(object instanceof MonitorCommand)) {
            String string = localStrings.getString("admin.monitor.invalid_monitoringevent_command");
            throw new AdminEventListenerException(string);
        }
        monitorCommand = (MonitorCommand)object;
        object = null;
        try {
            object = monitorCommand.runCommand();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            AdminEventMulticaster.notifyFailure(monitoringEvent, "mbean_not_found");
            throw new AdminEventListenerException(instanceNotFoundException.getMessage(), instanceNotFoundException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            AdminEventMulticaster.notifyFailure(monitoringEvent, "mbean_attr_not_found");
            throw new AdminEventListenerException(attributeNotFoundException.getMessage(), attributeNotFoundException);
        }
        catch (JMException jMException) {
            throw new AdminEventListenerException(jMException.getMessage(), jMException);
        }
        AdminEventMulticaster.addEventResultAttribute(monitoringEvent, "monitor.result", object);
    }

    private MonitoredObjectType[] getMonitoredObjectTypeList(String string) {
        MonitoredObjectType[] monitoredObjectTypeArray = new MonitoredObjectType[]{MonitoredObjectType.ROOT};
        if (ServerTags.EJB_CONTAINER.equals(string)) {
            monitoredObjectTypeArray = MonitoredObjectType.EJB_TYPES;
        } else if (ServerTags.MDB_CONTAINER.equals(string)) {
            monitoredObjectTypeArray = MonitoredObjectType.MDB_TYPES;
        } else if (ServerTags.ORB.equals(string)) {
            monitoredObjectTypeArray = MonitoredObjectType.ORB_TYPES;
        } else if (ServerTags.TRANSACTION_SERVICE.equals(string)) {
            monitoredObjectTypeArray = MonitoredObjectType.JTS_TYPES;
        }
        return monitoredObjectTypeArray;
    }

    private void initMonitoringEnabled() {
        this.initMonitoringEnabled(AdminEventCache.EJB_MON, ServerTags.EJB_CONTAINER);
        this.initMonitoringEnabled(AdminEventCache.MDB_MON, ServerTags.MDB_CONTAINER);
        this.initMonitoringEnabled(AdminEventCache.ORB_MON, ServerTags.ORB);
        this.initMonitoringEnabled(AdminEventCache.JTS_MON, ServerTags.TRANSACTION_SERVICE);
    }

    private void initMonitoringEnabled(String string, String string2) {
        try {
            ConfigContext configContext = AdminService.getAdminService().getContext().getConfigContext();
            ConfigBean configBean = configContext.exactLookup(string);
            String string3 = configBean.getAttributeValue(ServerTags.MONITORING_ENABLED);
            boolean bl = AdminEventCache.getServerXmlBooleanValue(string3);
            MonitoredObjectType.setMonitoringEnabled(string2, bl);
        }
        catch (ConfigException configException) {
            logger.log(Level.WARNING, COMP_INIT_ERROR, string2);
            logger.log(Level.FINE, configException.getMessage(), configException);
        }
    }
}

