/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.monitor;

import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.util.i18n.StringManager;
import java.util.HashMap;

public class MonitoredObjectType {
    private static final HashMap objectMap = new HashMap();
    public static final MonitoredObjectType ROOT = new MonitoredObjectType("root", true);
    public static final MonitoredObjectType APPLICATION = new MonitoredObjectType("application");
    public static final MonitoredObjectType EJBMODULE = new MonitoredObjectType("ejb-module");
    public static final MonitoredObjectType STANDALONE_EJBMODULE = new MonitoredObjectType("standalone-ejb-module");
    public static final MonitoredObjectType WEBMODULE = new MonitoredObjectType("web-module");
    public static final MonitoredObjectType STANDALONE_WEBMODULE = new MonitoredObjectType("standalone-web-module");
    public static final MonitoredObjectType STATELESS_BEAN = new MonitoredObjectType("stateless-session-bean");
    public static final MonitoredObjectType STATEFUL_BEAN = new MonitoredObjectType("stateful-session-bean");
    public static final MonitoredObjectType ENTITY_BEAN = new MonitoredObjectType("entity-bean");
    public static final MonitoredObjectType MESSAGE_DRIVEN_BEAN = new MonitoredObjectType("message-driven-bean");
    public static final MonitoredObjectType BEAN_POOL = new MonitoredObjectType("bean-pool", true);
    public static final MonitoredObjectType BEAN_CACHE = new MonitoredObjectType("bean-cache", true);
    public static final MonitoredObjectType BEAN_METHOD = new MonitoredObjectType("bean-method");
    public static final MonitoredObjectType HTTP_SERVER = new MonitoredObjectType("http-server", true);
    public static final MonitoredObjectType VIRTUAL_SERVER = new MonitoredObjectType("virtual-server", true);
    public static final MonitoredObjectType PROCESS = new MonitoredObjectType("process", true);
    public static final MonitoredObjectType TXNMGR = new MonitoredObjectType("transaction-service", true);
    public static final MonitoredObjectType IIOP_SERVICE = new MonitoredObjectType("iiop-service", true);
    public static final MonitoredObjectType ORB = new MonitoredObjectType("orb");
    public static final MonitoredObjectType ORB_CONNECTION = new MonitoredObjectType("orb-connection", true);
    public static final MonitoredObjectType ORB_THREAD_POOL = new MonitoredObjectType("orb-thread-pool", true);
    public static final MonitoredObjectType RESOURCES = new MonitoredObjectType("resources", true);
    public static final MonitoredObjectType JDBC_CONN_POOL = new MonitoredObjectType("jdbc-connection-pool", false);
    private String typeName;
    private boolean isSingleton;
    private int enableCount = 0;
    public static final MonitoredObjectType[] EJB_TYPES = new MonitoredObjectType[]{ROOT, APPLICATION, EJBMODULE, STANDALONE_EJBMODULE, STATELESS_BEAN, STATEFUL_BEAN, ENTITY_BEAN, BEAN_POOL, BEAN_CACHE, BEAN_METHOD};
    public static final MonitoredObjectType[] MDB_TYPES = new MonitoredObjectType[]{ROOT, APPLICATION, EJBMODULE, STANDALONE_EJBMODULE, MESSAGE_DRIVEN_BEAN, BEAN_POOL, BEAN_CACHE, BEAN_METHOD};
    public static final MonitoredObjectType[] ORB_TYPES = new MonitoredObjectType[]{ROOT, IIOP_SERVICE, ORB, ORB_CONNECTION, ORB_THREAD_POOL};
    public static final MonitoredObjectType[] JTS_TYPES = new MonitoredObjectType[]{ROOT, TXNMGR};
    private static boolean ejbMonitoringEnabled = false;
    private static boolean mdbMonitoringEnabled = false;
    private static boolean orbMonitoringEnabled = false;
    private static boolean jtsMonitoringEnabled = false;
    private static StringManager localStrings = StringManager.getManager(MonitoredObjectType.class);

    private MonitoredObjectType(String string) {
        this(string, false);
    }

    private MonitoredObjectType(String string, boolean bl) {
        this.typeName = string;
        this.isSingleton = bl;
        objectMap.put(this.typeName, this);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public String toString() {
        return this.typeName;
    }

    public boolean isMonitoringEnabled() {
        return this.enableCount > 0;
    }

    public static MonitoredObjectType getMonitoredObjectType(String string) {
        MonitoredObjectType monitoredObjectType = MonitoredObjectType.getMonitoredObjectTypeOrNull(string);
        if (monitoredObjectType == null) {
            String string2 = localStrings.getString("admin.monitor.unknown_type_name", string);
            throw new IllegalArgumentException(string2);
        }
        return monitoredObjectType;
    }

    static MonitoredObjectType getMonitoredObjectTypeOrNull(String string) {
        MonitoredObjectType monitoredObjectType = null;
        if (objectMap != null && string != null) {
            monitoredObjectType = (MonitoredObjectType)objectMap.get(string);
        }
        return monitoredObjectType;
    }

    private static synchronized void enableTypes(MonitoredObjectType[] monitoredObjectTypeArray) {
        int n = monitoredObjectTypeArray.length;
        for (int i = 0; i < n; ++i) {
            ++monitoredObjectTypeArray[i].enableCount;
        }
    }

    private static synchronized void disableTypes(MonitoredObjectType[] monitoredObjectTypeArray) {
        int n = monitoredObjectTypeArray.length;
        for (int i = 0; i < n; ++i) {
            if (monitoredObjectTypeArray[i].enableCount > 0) {
                --monitoredObjectTypeArray[i].enableCount;
                continue;
            }
            String string = localStrings.getString("admin.monitor.monitored_object_type_already_disabled", monitoredObjectTypeArray[i].toString());
            throw new IllegalStateException(string);
        }
    }

    public static void setEjbMonitoringEnabled(boolean bl) {
        ejbMonitoringEnabled = MonitoredObjectType.setMonitoringEnabled(EJB_TYPES, ejbMonitoringEnabled, bl);
    }

    public static void setMdbMonitoringEnabled(boolean bl) {
        mdbMonitoringEnabled = MonitoredObjectType.setMonitoringEnabled(MDB_TYPES, mdbMonitoringEnabled, bl);
    }

    public static void setOrbMonitoringEnabled(boolean bl) {
        orbMonitoringEnabled = MonitoredObjectType.setMonitoringEnabled(ORB_TYPES, orbMonitoringEnabled, bl);
    }

    public static void setJtsMonitoringEnabled(boolean bl) {
        jtsMonitoringEnabled = MonitoredObjectType.setMonitoringEnabled(JTS_TYPES, jtsMonitoringEnabled, bl);
    }

    static void setMonitoringEnabled(String string, boolean bl) {
        if (ServerTags.EJB_CONTAINER.equals(string)) {
            MonitoredObjectType.setEjbMonitoringEnabled(bl);
        } else if (ServerTags.MDB_CONTAINER.equals(string)) {
            MonitoredObjectType.setMdbMonitoringEnabled(bl);
        } else if (ServerTags.ORB.equals(string)) {
            MonitoredObjectType.setOrbMonitoringEnabled(bl);
        } else if (ServerTags.TRANSACTION_SERVICE.equals(string)) {
            MonitoredObjectType.setJtsMonitoringEnabled(bl);
        }
    }

    private static boolean setMonitoringEnabled(MonitoredObjectType[] monitoredObjectTypeArray, boolean bl, boolean bl2) {
        if (bl2 != bl) {
            bl = bl2;
            if (bl) {
                MonitoredObjectType.enableTypes(monitoredObjectTypeArray);
            } else {
                MonitoredObjectType.disableTypes(monitoredObjectTypeArray);
            }
        }
        return bl2;
    }
}

