/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.monitor;

import com.iplanet.ias.admin.monitor.BaseMonitorMBean;
import com.iplanet.ias.admin.monitor.MonitorCommand;
import com.iplanet.ias.admin.monitor.MonitoredObjectType;
import com.iplanet.ias.admin.monitor.MonitoringHelper;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class MonitorSetCommand
extends MonitorCommand {
    private String[] params;
    private static final String WILDCARD = "*";
    private String operationName;

    MonitorSetCommand(ObjectName objectName, MonitoredObjectType monitoredObjectType, String string, String[] stringArray) {
        this.objectName = objectName;
        if (monitoredObjectType != null) {
            this.monitoredObjectType = monitoredObjectType.getTypeName();
        }
        this.operationName = string;
        if (stringArray.length > 0) {
            this.params = stringArray;
        }
        if (WILDCARD.equals(string)) {
            throw new UnsupportedOperationException(BaseMonitorMBean.UNSUPPORTED_ERRMSG);
        }
    }

    Object runCommand() throws InstanceNotFoundException, ReflectionException, MBeanException {
        BaseMonitorMBean baseMonitorMBean = MonitoringHelper.getMonitorMBean(this.objectName);
        if (baseMonitorMBean == null) {
            throw new InstanceNotFoundException();
        }
        ArrayList arrayList = null;
        if (this.monitoredObjectType != null) {
            arrayList = baseMonitorMBean.getChildList(this.monitoredObjectType);
        } else {
            arrayList = new ArrayList();
            arrayList.add(baseMonitorMBean);
        }
        AttributeList attributeList = new AttributeList();
        Object object = baseMonitorMBean.invoke(this.operationName, this.params, null);
        Attribute attribute = new Attribute(this.operationName, object);
        attributeList.add(attribute);
        return attributeList;
    }
}

