/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.monitor;

import com.iplanet.ias.admin.monitor.GenericMonitorMBean;
import com.iplanet.ias.admin.monitor.IMonitorable;
import com.iplanet.ias.admin.monitor.MonitoredObjectType;
import com.iplanet.ias.admin.monitor.types.MonitoredAttributeType;
import com.iplanet.ias.admin.server.core.jmx.ASMBeanServerImpl;
import com.iplanet.ias.admin.server.core.jmx.InitException;
import com.iplanet.ias.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class BaseMonitorMBean
implements DynamicMBean,
IMonitorable {
    static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    static final HashMap objectNameMap = new HashMap();
    private String[] attrNames = null;
    private ObjectName objectName;
    private String nodeName;
    private String nodeType;
    protected Vector childList = new Vector();
    private static StringManager localStrings = StringManager.getManager(BaseMonitorMBean.class);
    protected static final String UNSUPPORTED_ERRCODE = localStrings.getString("admin.monitor.unsupported_mbean_monitor");
    protected static final String UNSUPPORTED_ERRMSG = localStrings.getString("admin.monitor.unsupported_action_on_monitoring_mbean");
    private static final String MON_OBJTYPE = "mclass";
    private static final String MON_OBJNAME = "name";
    private static final String NON_COMPLIANT_MBEAN = "monitor.non_compliant_mbean";
    private static final String MBS_INIT_ERROR = "monitor.mbs_init_error";

    protected void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    protected void setNodeName(String string) {
        this.nodeName = string;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    protected void setNodeType(String string) {
        this.nodeType = string;
    }

    public synchronized ObjectName addChild(String string, MonitoredObjectType monitoredObjectType, BaseMonitorMBean baseMonitorMBean) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        Object object;
        if (string == null || monitoredObjectType == null || baseMonitorMBean == null) {
            String string2 = string == null ? "Child Name (name); " : "";
            String string3 = monitoredObjectType == null ? "Child Type (type); " : "";
            String string4 = baseMonitorMBean == null ? "MBean (mBean); " : "";
            String string5 = localStrings.getString("admin.monitor.null_arguments", string2, string3, string4);
            throw new IllegalArgumentException(string5);
        }
        if (this.objectName == null || this.nodeName == null || this.nodeType == null) {
            String string6 = localStrings.getString("admin.monitor.monitoring_mbean_not_added_to_mbeantree");
            throw new IllegalStateException(string6);
        }
        boolean bl = false;
        int n = this.childList.size();
        for (int i = 0; i < n; ++i) {
            object = (BaseMonitorMBean)this.childList.elementAt(i);
            if (monitoredObjectType.isSingleton()) {
                if (!((BaseMonitorMBean)object).nodeType.equals(monitoredObjectType.getTypeName())) continue;
                bl = true;
                break;
            }
            if (!((BaseMonitorMBean)object).nodeType.equals(monitoredObjectType.getTypeName()) || !((BaseMonitorMBean)object).nodeName.equals(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            String string7 = localStrings.getString("admin.monitor.mbean_already_exists", monitoredObjectType, string);
            throw new InstanceAlreadyExistsException(string7);
        }
        if (monitoredObjectType.isSingleton()) {
            string = monitoredObjectType.getTypeName();
        }
        this.childList.add(baseMonitorMBean);
        baseMonitorMBean.setNodeName(string);
        baseMonitorMBean.setNodeType(monitoredObjectType.getTypeName());
        ObjectName objectName = BaseMonitorMBean.getChildObjectName(this.objectName, monitoredObjectType, string);
        baseMonitorMBean.setObjectName(objectName);
        object = BaseMonitorMBean.getMBeanServer();
        try {
            object.registerMBean(baseMonitorMBean, objectName);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            logger.log(Level.WARNING, NON_COMPLIANT_MBEAN, objectName);
            throw new MBeanRegistrationException(notCompliantMBeanException);
        }
        objectNameMap.put(objectName, baseMonitorMBean);
        if (monitoredObjectType.isMonitoringEnabled()) {
            baseMonitorMBean.startMonitoring();
        }
        return objectName;
    }

    private static ObjectName getChildObjectName(ObjectName objectName, MonitoredObjectType monitoredObjectType, String string) throws MBeanRegistrationException {
        Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
        Hashtable hashtable2 = (Hashtable)hashtable.clone();
        String string2 = hashtable.get(MON_OBJTYPE);
        String string3 = hashtable.get(MON_OBJNAME);
        hashtable2.put(string2, string3);
        hashtable2.put(MON_OBJTYPE, monitoredObjectType.getTypeName());
        hashtable2.put(MON_OBJNAME, string);
        ObjectName objectName2 = null;
        try {
            objectName2 = new ObjectName(objectName.getDomain(), hashtable2);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new MBeanRegistrationException(malformedObjectNameException, malformedObjectNameException.getMessage());
        }
        return objectName2;
    }

    public ArrayList getChildList() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.childList);
        return arrayList;
    }

    public ArrayList getChildList(MonitoredObjectType monitoredObjectType) {
        if (monitoredObjectType == null) {
            String string = localStrings.getString("admin.monitor.null_argument_mbean_type");
            throw new IllegalArgumentException(string);
        }
        ArrayList<BaseMonitorMBean> arrayList = new ArrayList<BaseMonitorMBean>();
        Iterator iterator = this.childList.iterator();
        while (iterator.hasNext()) {
            BaseMonitorMBean baseMonitorMBean = (BaseMonitorMBean)iterator.next();
            if (!baseMonitorMBean.nodeType.equals(monitoredObjectType.getTypeName())) continue;
            arrayList.add(baseMonitorMBean);
        }
        return arrayList;
    }

    public ArrayList getChildList(String string) {
        ArrayList<BaseMonitorMBean> arrayList = new ArrayList<BaseMonitorMBean>();
        Iterator iterator = this.childList.iterator();
        while (iterator.hasNext()) {
            BaseMonitorMBean baseMonitorMBean = (BaseMonitorMBean)iterator.next();
            if (!baseMonitorMBean.nodeName.equals(string)) continue;
            arrayList.add(baseMonitorMBean);
        }
        return arrayList;
    }

    public BaseMonitorMBean getChild(MonitoredObjectType monitoredObjectType, String string) throws InstanceNotFoundException {
        BaseMonitorMBean baseMonitorMBean = this.getChildOrNull(monitoredObjectType, string);
        if (baseMonitorMBean == null) {
            String string2 = localStrings.getString("admin.monitor.mbean_not_found", monitoredObjectType, string);
            throw new InstanceNotFoundException(string2);
        }
        return baseMonitorMBean;
    }

    BaseMonitorMBean getChildOrNull(MonitoredObjectType monitoredObjectType, String string) {
        if (monitoredObjectType == null) {
            String string2 = localStrings.getString("admin.monitor.monitored_object_type_null");
            throw new IllegalArgumentException(string2);
        }
        BaseMonitorMBean baseMonitorMBean = null;
        Iterator iterator = this.childList.iterator();
        while (iterator.hasNext()) {
            BaseMonitorMBean baseMonitorMBean2 = (BaseMonitorMBean)iterator.next();
            if (monitoredObjectType.isSingleton()) {
                if (!baseMonitorMBean2.nodeType.equals(monitoredObjectType.getTypeName())) continue;
                baseMonitorMBean = baseMonitorMBean2;
                continue;
            }
            if (!baseMonitorMBean2.nodeType.equals(monitoredObjectType.getTypeName()) || !baseMonitorMBean2.nodeName.equals(string)) continue;
            baseMonitorMBean = baseMonitorMBean2;
        }
        return baseMonitorMBean;
    }

    BaseMonitorMBean getFirstChildByName(String string) throws InstanceNotFoundException {
        ArrayList arrayList = this.getChildList(string);
        if (arrayList.isEmpty()) {
            String string2 = localStrings.getString("admin.monitor.child_mbean_not_available", string, this.objectName);
            throw new InstanceNotFoundException(string2);
        }
        return (BaseMonitorMBean)arrayList.get(0);
    }

    public synchronized void removeChild(MonitoredObjectType monitoredObjectType, String string) throws InstanceNotFoundException, MBeanRegistrationException {
        BaseMonitorMBean baseMonitorMBean = this.getChild(monitoredObjectType, string);
        this.removeChild(baseMonitorMBean);
    }

    synchronized void removeChild(BaseMonitorMBean baseMonitorMBean) throws InstanceNotFoundException, MBeanRegistrationException {
        BaseMonitorMBean.removeAllChild(baseMonitorMBean);
        this.childList.remove(baseMonitorMBean);
        objectNameMap.remove(baseMonitorMBean.objectName);
        MBeanServer mBeanServer = BaseMonitorMBean.getMBeanServer();
        mBeanServer.unregisterMBean(baseMonitorMBean.objectName);
    }

    private static void removeAllChild(BaseMonitorMBean baseMonitorMBean) throws InstanceNotFoundException, MBeanRegistrationException {
        Iterator iterator = baseMonitorMBean.childList.iterator();
        while (iterator.hasNext()) {
            BaseMonitorMBean baseMonitorMBean2 = (BaseMonitorMBean)iterator.next();
            BaseMonitorMBean.removeAllChild(baseMonitorMBean2);
            objectNameMap.remove(baseMonitorMBean2.objectName);
            MBeanServer mBeanServer = BaseMonitorMBean.getMBeanServer();
            mBeanServer.unregisterMBean(baseMonitorMBean2.objectName);
        }
        baseMonitorMBean.childList.removeAllElements();
    }

    private static MBeanServer getMBeanServer() {
        MBeanServer mBeanServer = null;
        try {
            mBeanServer = ASMBeanServerImpl.getMBeanServerInstance();
        }
        catch (InitException initException) {
            logger.log(Level.WARNING, MBS_INIT_ERROR);
            logger.log(Level.FINE, initException.getMessage(), initException);
            String string = localStrings.getString("admin.monitor.mbeanserver_not_found");
            throw new RuntimeException(string);
        }
        return mBeanServer;
    }

    public abstract Object getAttribute(String var1) throws AttributeNotFoundException;

    public abstract AttributeList getAttributes(String[] var1);

    public abstract MBeanInfo getMBeanInfo();

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        throw new UnsupportedOperationException(BaseMonitorMBean.getLocalString(UNSUPPORTED_ERRCODE, UNSUPPORTED_ERRMSG));
    }

    public final void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException(BaseMonitorMBean.getLocalString(UNSUPPORTED_ERRCODE, UNSUPPORTED_ERRMSG));
    }

    public final AttributeList setAttributes(AttributeList attributeList) {
        throw new UnsupportedOperationException(BaseMonitorMBean.getLocalString(UNSUPPORTED_ERRCODE, UNSUPPORTED_ERRMSG));
    }

    public abstract MonitoredAttributeType getAttributeType(String var1);

    public void startMonitoring() {
    }

    public void stopMonitoring() {
    }

    public abstract Map getMonitoringMetaData();

    public final Object getMonitoredAttributeValue(String string) {
        Object object = null;
        try {
            object = this.getAttribute(string);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        return object;
    }

    public final Map getMonitoredAttributeValues(Set set) {
        return null;
    }

    protected static MBeanInfo createMBeanInfo(Map map) {
        return BaseMonitorMBean.createMBeanInfo(map, new MBeanOperationInfo[0]);
    }

    protected static MBeanInfo createMBeanInfo(Map map, MBeanOperationInfo[] mBeanOperationInfoArray) {
        MBeanNotificationInfo[] mBeanNotificationInfoArray;
        MBeanConstructorInfo[] mBeanConstructorInfoArray;
        String string = GenericMonitorMBean.class.getName();
        String string2 = "Generic Monitoring MBean";
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[set.size()];
        int n = 0;
        while (iterator.hasNext()) {
            mBeanConstructorInfoArray = (String)iterator.next();
            mBeanNotificationInfoArray = ((MonitoredAttributeType)map.get(mBeanConstructorInfoArray)).getJavaTypeName();
            String string3 = "Monitored attribute " + (String)mBeanConstructorInfoArray;
            mBeanAttributeInfoArray[n] = new MBeanAttributeInfo((String)mBeanConstructorInfoArray, (String)mBeanNotificationInfoArray, string3, true, false, false);
            ++n;
        }
        mBeanConstructorInfoArray = new MBeanConstructorInfo[]{};
        mBeanNotificationInfoArray = new MBeanNotificationInfo[]{};
        return new MBeanInfo(string, string2, mBeanAttributeInfoArray, mBeanConstructorInfoArray, mBeanOperationInfoArray, mBeanNotificationInfoArray);
    }

    public String[] getAllAttributeNames() {
        return this.getAllAttributeNamesFromMBeanInfo();
    }

    private String[] getAllAttributeNamesFromMBeanInfo() {
        if (this.attrNames == null) {
            MBeanInfo mBeanInfo = this.getMBeanInfo();
            if (mBeanInfo == null) {
                String string = localStrings.getString("admin.monitor.null_mbean_info", this.getClass());
                throw new IllegalStateException(string);
            }
            MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
            if (mBeanAttributeInfoArray == null) {
                String string = localStrings.getString("admin.monitor.null_attribute_info_in_mbeaninfo", this.getClass());
                throw new IllegalStateException(string);
            }
            int n = mBeanAttributeInfoArray.length;
            this.attrNames = new String[n];
            for (int i = 0; i < n; ++i) {
                this.attrNames[i] = mBeanAttributeInfoArray[i].getName();
            }
        }
        return this.attrNames;
    }

    protected static Map createAttrNameTypeMap(Object[][] objectArray) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i = objectArray.length; i > 0; --i) {
            hashMap.put(objectArray[i - 1][0], objectArray[i - 1][1]);
        }
        return hashMap;
    }

    private static String getLocalString(String string, String string2) {
        return string2;
    }
}

