/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.event;

import com.iplanet.ias.admin.event.BaseDeployEvent;
import com.iplanet.ias.util.i18n.StringManager;

public class ResourceDeployEvent
extends BaseDeployEvent {
    public static final String RES_TYPE_CUSTOM = "custom";
    public static final String RES_TYPE_EXTERNAL_JNDI = "external-jndi";
    public static final String RES_TYPE_JDBC = "jdbc";
    public static final String RES_TYPE_MAIL = "mail";
    public static final String RES_TYPE_JMS = "jms";
    public static final String RES_TYPE_PMF = "pmf";
    public static final String RES_TYPE_JCP = "jcp";
    static final String eventType = ResourceDeployEvent.class.getName();
    private String resourceType;
    private boolean resourceExists = true;
    private boolean noOp = false;
    private static StringManager localStrings = StringManager.getManager(ResourceDeployEvent.class);

    public ResourceDeployEvent(String string, String string2, String string3, String string4) {
        super(eventType, string, "resource", string2, string4);
        this.setResourceType(string3);
        if ("deploy".equals(string4)) {
            this.resourceExists = false;
        }
    }

    public String getResourceName() {
        return this.getJ2EEComponentName();
    }

    public String getResourceType() {
        return this.resourceType;
    }

    private void setResourceType(String string) {
        boolean bl = false;
        if (RES_TYPE_CUSTOM.equals(string) || RES_TYPE_EXTERNAL_JNDI.equals(string) || RES_TYPE_JDBC.equals(string) || RES_TYPE_MAIL.equals(string) || RES_TYPE_JMS.equals(string) || RES_TYPE_PMF.equals(string) || RES_TYPE_JCP.equals(string)) {
            bl = true;
        }
        if (!bl) {
            String string2 = localStrings.getString("admin.event.invalid_resource_type", string);
            throw new IllegalArgumentException(string2);
        }
        this.resourceType = string;
    }

    private void setActionForAdd() {
        if (this.resourceExists) {
            String string = this.getAction();
            if ("undeploy".equals(string)) {
                this.setAction("redeploy");
            }
        } else if (this.noOp) {
            this.setAction("deploy");
            this.noOp = false;
        }
    }

    private void setActionForUpdate() {
    }

    private void setActionForDelete() {
        if (this.resourceExists) {
            String string = this.getAction();
            if (!"undeploy".equals(string)) {
                this.setAction("undeploy");
            }
        } else if (!this.noOp) {
            this.noOp = true;
        }
    }

    void setNewAction(String string) {
        if ("deploy".equals(string)) {
            this.setActionForAdd();
        } else if ("redeploy".equals(string)) {
            this.setActionForUpdate();
        } else if ("undeploy".equals(string)) {
            this.setActionForDelete();
        } else {
            String string2 = localStrings.getString("admin.event.illegal_new_action", string);
            throw new IllegalArgumentException(string2);
        }
    }

    boolean isNoOp() {
        return this.noOp;
    }

    public String toString() {
        return "ResourceDeployEvent -- " + this.getAction() + " " + this.resourceType + "/" + this.getJ2EEComponentName();
    }
}

