/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.event;

import com.iplanet.ias.admin.event.AdminEvent;
import com.iplanet.ias.config.ConfigChange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigChangeEvent
extends AdminEvent {
    static final String eventType = ConfigChangeEvent.class.getName();
    private boolean webCoreReconfigNeeded = false;
    private boolean initOrObjConfChanged = false;
    private HashMap matchMap;

    public ConfigChangeEvent(String string, ArrayList arrayList) {
        super(eventType, string);
        this.configChangeList = arrayList;
    }

    public ArrayList getConfigChangeList() {
        return this.configChangeList;
    }

    void setWebCoreReconfigNeeded(boolean bl) {
        this.webCoreReconfigNeeded = bl;
    }

    boolean isWebCoreReconfigNeeded() {
        return this.webCoreReconfigNeeded;
    }

    void setInitOrObjConfChanged(boolean bl) {
        this.initOrObjConfChanged = bl;
    }

    boolean isInitOrObjConfChanged() {
        return this.initOrObjConfChanged;
    }

    boolean matchXPathToPattern(Pattern pattern) {
        boolean bl = false;
        if (this.configChangeList == null) {
            return bl;
        }
        Iterator iterator = this.configChangeList.iterator();
        while (iterator.hasNext()) {
            Matcher matcher;
            ConfigChange configChange = (ConfigChange)iterator.next();
            String string = configChange.getXPath();
            if (string == null || !(bl = (matcher = pattern.matcher(string)).matches())) continue;
            this.setConfigChangeMatched(configChange);
        }
        return bl;
    }

    boolean isNoOp() {
        boolean bl = false;
        if (this.configChangeList == null && !this.webCoreReconfigNeeded) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConfigChangeMatched(ConfigChange configChange) {
        ConfigChangeEvent configChangeEvent = this;
        synchronized (configChangeEvent) {
            if (this.matchMap == null) {
                this.matchMap = new HashMap();
            }
        }
        this.matchMap.put(configChange, configChange);
    }

    boolean isAllXPathMatched() {
        boolean bl = true;
        if (this.configChangeList == null || this.matchMap == null) {
            bl = false;
            return bl;
        }
        Iterator iterator = this.configChangeList.iterator();
        while (iterator.hasNext()) {
            if (this.matchMap.containsKey(iterator.next())) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

