/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.event;

import com.iplanet.ias.admin.event.AdminEvent;
import com.iplanet.ias.admin.event.AdminEventListener;
import com.iplanet.ias.admin.event.AdminEventListenerException;
import com.iplanet.ias.admin.event.AdminEventResult;
import com.iplanet.ias.admin.event.ApplicationDeployEvent;
import com.iplanet.ias.admin.event.ApplicationDeployEventListener;
import com.iplanet.ias.admin.event.BaseDeployEvent;
import com.iplanet.ias.admin.event.BaseDeployEventListener;
import com.iplanet.ias.admin.event.ConfigChangeCategory;
import com.iplanet.ias.admin.event.ConfigChangeEvent;
import com.iplanet.ias.admin.event.ConfigChangeEventListener;
import com.iplanet.ias.admin.event.ModuleDeployEvent;
import com.iplanet.ias.admin.event.ModuleDeployEventListener;
import com.iplanet.ias.admin.event.MonitoringEvent;
import com.iplanet.ias.admin.event.MonitoringEventListener;
import com.iplanet.ias.admin.event.ResourceDeployEvent;
import com.iplanet.ias.admin.event.ResourceDeployEventListener;
import com.iplanet.ias.admin.event.ShutdownEvent;
import com.iplanet.ias.admin.server.core.AdminService;
import com.iplanet.ias.admin.server.core.channel.AdminChannel;
import com.iplanet.ias.admin.server.core.channel.RMIClient;
import com.iplanet.ias.admin.server.core.channel.ReconfigHelper;
import com.iplanet.ias.config.ConfigChange;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigUpdate;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.server.ServerContextImpl;
import com.iplanet.ias.util.i18n.StringManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.NotificationListener;

public class AdminEventMulticaster {
    static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static AdminEventMulticaster adminEventMulticaster = null;
    private HashMap listeners = new HashMap();
    private HashMap configCategoryList;
    private static StringManager localStrings = StringManager.getManager(AdminEventMulticaster.class);
    static final String MULTICAST_NOT_SUPPORTED = "event.multicast_not_supported";
    static final String HANDLER_INIT_ERROR = "event.handler_init_error";
    static final String HANDLER_ERROR = "event.handler_error";

    private AdminEventMulticaster() {
        this.listeners.put(AdminEvent.eventType, new ArrayList());
        this.listeners.put(ConfigChangeEvent.eventType, new ArrayList());
        this.listeners.put(MonitoringEvent.eventType, new ArrayList());
        this.listeners.put(ShutdownEvent.eventType, new ArrayList());
        this.listeners.put(BaseDeployEvent.eventType, new ArrayList());
        this.listeners.put(ApplicationDeployEvent.eventType, new ArrayList());
        this.listeners.put(ModuleDeployEvent.eventType, new ArrayList());
        this.listeners.put(ResourceDeployEvent.eventType, new ArrayList());
        this.listeners.put("javax.management.Notification", new ArrayList());
        this.configCategoryList = new HashMap();
    }

    static AdminEventMulticaster getInstance() {
        if (adminEventMulticaster == null) {
            adminEventMulticaster = AdminEventMulticaster.create();
        }
        return adminEventMulticaster;
    }

    private static synchronized AdminEventMulticaster create() {
        return new AdminEventMulticaster();
    }

    public static AdminEventResult multicastEvent(AdminEvent adminEvent) {
        AdminEventResult adminEventResult = null;
        AdminEventMulticaster adminEventMulticaster = AdminEventMulticaster.getInstance();
        if (AdminEventMulticaster.isLocal(adminEvent)) {
            AdminEventMulticaster.sendPreNotifyReconfigSignal(adminEvent);
            adminEventMulticaster.processEvent(adminEvent);
            AdminEventMulticaster.sendPostNotifyReconfigSignal(adminEvent);
            adminEventResult = AdminEventResult.getAdminEventResult(adminEvent);
            AdminEventResult.clearAdminEventResultFromCache(adminEvent);
        } else if (AdminService.getAdminService().isAdminInstance()) {
            RMIClient rMIClient = AdminChannel.getRMIClient(adminEvent.getInstanceName());
            adminEventResult = rMIClient.sendNotification(adminEvent);
        } else {
            String string = AdminService.getAdminService().getInstanceName();
            logger.log(Level.INFO, MULTICAST_NOT_SUPPORTED, new String[]{string, adminEvent.getInstanceName()});
            String string2 = localStrings.getString("admin.event.unable_to_multicast_events");
            throw new UnsupportedOperationException(string2);
        }
        return adminEventResult;
    }

    private static boolean isLocal(AdminEvent adminEvent) {
        String string = adminEvent.getInstanceName();
        String string2 = AdminService.getAdminService().getInstanceName();
        return string2 != null && string2.equals(string);
    }

    private static void sendPreNotifyReconfigSignal(AdminEvent adminEvent) {
        ConfigChangeEvent configChangeEvent;
        if (adminEvent instanceof ConfigChangeEvent && (configChangeEvent = (ConfigChangeEvent)adminEvent).isWebCoreReconfigNeeded()) {
            ReconfigHelper.sendReconfigMessage(adminEvent.getInstanceName());
        }
    }

    private static void sendPostNotifyReconfigSignal(AdminEvent adminEvent) {
        if (adminEvent instanceof ApplicationDeployEvent || adminEvent instanceof ModuleDeployEvent && ((ModuleDeployEvent)adminEvent).getModuleType().equals("web")) {
            ReconfigHelper.sendReconfigMessage(adminEvent.getInstanceName());
        }
    }

    public static void notifyFailure(AdminEvent adminEvent, String string) {
        AdminEventResult adminEventResult = AdminEventResult.getAdminEventResult(adminEvent);
        adminEventResult.setResultCode(string);
    }

    public static void addEventResultAttribute(AdminEvent adminEvent, String string, Object object) {
        AdminEventResult adminEventResult = AdminEventResult.getAdminEventResult(adminEvent);
        adminEventResult.addAttribute(string, object);
    }

    public static Object getEventResultAttribute(AdminEvent adminEvent, String string) {
        AdminEventResult adminEventResult = AdminEventResult.getAdminEventResult(adminEvent);
        return adminEventResult.getAttribute(string);
    }

    public static void removeEventResultAttribute(AdminEvent adminEvent, String string) {
        AdminEventResult adminEventResult = AdminEventResult.getAdminEventResult(adminEvent);
        adminEventResult.removeAttribute(string);
    }

    public static void addNotificationListener(NotificationListener notificationListener) {
    }

    public static void removeNotificationListener(NotificationListener notificationListener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addListener(String string, AdminEventListener adminEventListener) {
        ArrayList arrayList;
        AdminEventMulticaster adminEventMulticaster = AdminEventMulticaster.getInstance();
        ArrayList arrayList2 = arrayList = (ArrayList)adminEventMulticaster.listeners.get(string);
        synchronized (arrayList2) {
            arrayList.add(adminEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addListener(String string, ConfigChangeCategory configChangeCategory, ConfigChangeEventListener configChangeEventListener) {
        AdminEventMulticaster.addListener(string, configChangeEventListener);
        AdminEventMulticaster adminEventMulticaster = AdminEventMulticaster.getInstance();
        HashMap hashMap = adminEventMulticaster.configCategoryList;
        synchronized (hashMap) {
            adminEventMulticaster.configCategoryList.put(configChangeEventListener, configChangeCategory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeListener(AdminEventListener adminEventListener) {
        AdminEventMulticaster adminEventMulticaster = AdminEventMulticaster.getInstance();
        String[] stringArray = AdminEventMulticaster.getEventTypesFromListener(adminEventListener);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            ArrayList arrayList = (ArrayList)adminEventMulticaster.listeners.get(string);
            if (!arrayList.contains(adminEventListener)) continue;
            Cloneable cloneable = arrayList;
            synchronized (cloneable) {
                arrayList.remove(adminEventListener);
            }
            if (!string.equals(ConfigChangeEvent.eventType) || !adminEventMulticaster.configCategoryList.containsKey(adminEventListener)) continue;
            cloneable = adminEventMulticaster.configCategoryList;
            synchronized (cloneable) {
                adminEventMulticaster.configCategoryList.remove(adminEventListener);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeListenerPrevious(AdminEventListener adminEventListener) {
        ArrayList arrayList;
        AdminEventMulticaster adminEventMulticaster = AdminEventMulticaster.getInstance();
        String string = AdminEventMulticaster.getEventTypeFromListener(adminEventListener);
        if (string != null && (arrayList = (ArrayList)adminEventMulticaster.listeners.get(string)).contains(adminEventListener)) {
            Cloneable cloneable = arrayList;
            synchronized (cloneable) {
                arrayList.remove(adminEventListener);
            }
            if (string.equals(ConfigChangeEvent.eventType) && adminEventMulticaster.configCategoryList.containsKey(adminEventListener)) {
                cloneable = adminEventMulticaster.configCategoryList;
                synchronized (cloneable) {
                    adminEventMulticaster.configCategoryList.remove(adminEventListener);
                }
            }
        }
    }

    void processEvent(AdminEvent adminEvent) {
        String string = adminEvent.getType();
        boolean bl = this.initEventHandler(adminEvent);
        if (!bl) {
            return;
        }
        int n = 0;
        if (string.equals(ApplicationDeployEvent.eventType)) {
            n += this.handleApplicationDeployEvent(adminEvent);
            n += this.handleBaseDeployEvent(adminEvent);
        } else if (string.equals(ModuleDeployEvent.eventType)) {
            n += this.handleModuleDeployEvent(adminEvent);
            n += this.handleBaseDeployEvent(adminEvent);
        } else if (string.equals(ResourceDeployEvent.eventType)) {
            n += this.handleResourceDeployEvent(adminEvent);
            n += this.handleBaseDeployEvent(adminEvent);
        } else if (string.equals(BaseDeployEvent.eventType)) {
            n += this.handleBaseDeployEvent(adminEvent);
        } else if (string.equals(ConfigChangeEvent.eventType)) {
            n += this.handleConfigChangeEvent(adminEvent);
        } else if (string.equals(MonitoringEvent.eventType)) {
            n += this.handleMonitoringEvent(adminEvent);
        } else if (string.equals(ShutdownEvent.eventType)) {
            n += this.handleShutdownEvent(adminEvent);
        }
        if (n == 0) {
            this.handleNoListeners(adminEvent);
        }
        this.destroyEventHandler(adminEvent);
    }

    private boolean initEventHandler(AdminEvent adminEvent) {
        boolean bl = true;
        AdminEventResult adminEventResult = AdminEventResult.getAdminEventResult(adminEvent);
        ConfigContext configContext = AdminService.getAdminService().getContext().getConfigContext();
        ConfigContext configContext2 = null;
        if (adminEvent.configChangeList != null) {
            try {
                configContext2 = (ConfigContext)configContext.clone();
                this.applyChangesToContext(configContext2, adminEvent.configChangeList);
            }
            catch (ConfigException configException) {
                adminEventResult.setResultCode("config_snapshot_error");
                adminEventResult.addMessage(configException.getMessage());
                logger.log(Level.INFO, HANDLER_INIT_ERROR, configException.getMessage());
                AdminEventMulticaster.debug(AdminEventMulticaster.getStackTraceFromThrowable(configException));
                bl = false;
            }
            catch (Throwable throwable) {
                this.handleError(throwable, adminEventResult, HANDLER_INIT_ERROR);
                bl = false;
            }
        } else {
            configContext2 = configContext;
        }
        adminEvent.setOldContext(configContext);
        adminEvent.setContext(configContext2);
        return bl;
    }

    private void applyChangesToContext(ConfigContext configContext, ArrayList arrayList) throws ConfigException {
        ConfigChange configChange;
        Iterator iterator = arrayList.iterator();
        ArrayList<ConfigChange> arrayList2 = new ArrayList<ConfigChange>();
        while (iterator.hasNext()) {
            configChange = (ConfigChange)iterator.next();
            if (configChange instanceof ConfigUpdate) {
                arrayList2.add(configChange);
                continue;
            }
            configContext.updateFromConfigChange(configChange);
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            configChange = (ConfigUpdate)iterator.next();
            configContext.updateFromConfigChange(configChange);
        }
    }

    private void destroyEventHandler(AdminEvent adminEvent) {
        AdminEventResult adminEventResult = AdminEventResult.getAdminEventResult(adminEvent);
        if ("success".equals(adminEventResult.getResultCode())) {
            ServerContext serverContext = AdminService.getAdminService().getContext();
            if (serverContext instanceof ServerContextImpl) {
                ((ServerContextImpl)serverContext).setConfigContext(adminEvent.getConfigContext());
            } else {
                logger.log(Level.SEVERE, "event.unknown_serverctx_type", serverContext.getClass().getName());
            }
        }
    }

    private ArrayList getListeners(String string) {
        return (ArrayList)this.listeners.get(string);
    }

    private int handleApplicationDeployEvent(AdminEvent adminEvent) {
        ApplicationDeployEvent applicationDeployEvent = (ApplicationDeployEvent)adminEvent;
        ArrayList arrayList = this.getListeners(ApplicationDeployEvent.eventType);
        if (arrayList != null && !arrayList.isEmpty()) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ApplicationDeployEventListener applicationDeployEventListener = (ApplicationDeployEventListener)iterator.next();
                this.invokeApplicationDeployEventListener(applicationDeployEventListener, applicationDeployEvent);
            }
        }
        return arrayList != null ? arrayList.size() : 0;
    }

    private void invokeApplicationDeployEventListener(ApplicationDeployEventListener applicationDeployEventListener, ApplicationDeployEvent applicationDeployEvent) {
        AdminEventResult adminEventResult = AdminEventResult.getAdminEventResult(applicationDeployEvent);
        try {
            String string = applicationDeployEvent.getAction();
            if ("deploy".equals(string)) {
                applicationDeployEventListener.applicationDeployed(applicationDeployEvent);
            } else if ("undeploy".equals(string)) {
                applicationDeployEventListener.applicationUndeployed(applicationDeployEvent);
            } else if ("redeploy".equals(string)) {
                applicationDeployEventListener.applicationRedeployed(applicationDeployEvent);
            } else if ("enable".equals(string)) {
                applicationDeployEventListener.applicationEnabled(applicationDeployEvent);
            } else if ("disable".equals(string)) {
                applicationDeployEventListener.applicationDisabled(applicationDeployEvent);
            }
        }
        catch (Throwable throwable) {
            this.handleListenerError(throwable, adminEventResult);
        }
    }

    private int handleModuleDeployEvent(AdminEvent adminEvent) {
        ModuleDeployEvent moduleDeployEvent = (ModuleDeployEvent)adminEvent;
        ArrayList arrayList = this.getListeners(ModuleDeployEvent.eventType);
        if (arrayList != null && !arrayList.isEmpty()) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ModuleDeployEventListener moduleDeployEventListener = (ModuleDeployEventListener)iterator.next();
                this.invokeModuleDeployEventListener(moduleDeployEventListener, moduleDeployEvent);
            }
        }
        return arrayList != null ? arrayList.size() : 0;
    }

    private void invokeModuleDeployEventListener(ModuleDeployEventListener moduleDeployEventListener, ModuleDeployEvent moduleDeployEvent) {
        AdminEventResult adminEventResult = AdminEventResult.getAdminEventResult(moduleDeployEvent);
        try {
            String string = moduleDeployEvent.getAction();
            if ("deploy".equals(string)) {
                moduleDeployEventListener.moduleDeployed(moduleDeployEvent);
            } else if ("undeploy".equals(string)) {
                moduleDeployEventListener.moduleUndeployed(moduleDeployEvent);
            } else if ("redeploy".equals(string)) {
                moduleDeployEventListener.moduleRedeployed(moduleDeployEvent);
            } else if ("enable".equals(string)) {
                moduleDeployEventListener.moduleEnabled(moduleDeployEvent);
            } else if ("disable".equals(string)) {
                moduleDeployEventListener.moduleDisabled(moduleDeployEvent);
            }
        }
        catch (Throwable throwable) {
            this.handleListenerError(throwable, adminEventResult);
        }
    }

    private int handleResourceDeployEvent(AdminEvent adminEvent) {
        ResourceDeployEvent resourceDeployEvent = (ResourceDeployEvent)adminEvent;
        ArrayList arrayList = this.getListeners(ResourceDeployEvent.eventType);
        if (arrayList != null && !arrayList.isEmpty()) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ResourceDeployEventListener resourceDeployEventListener = (ResourceDeployEventListener)iterator.next();
                this.invokeResourceDeployEventListener(resourceDeployEventListener, resourceDeployEvent);
            }
        }
        return arrayList != null ? arrayList.size() : 0;
    }

    private void invokeResourceDeployEventListener(ResourceDeployEventListener resourceDeployEventListener, ResourceDeployEvent resourceDeployEvent) {
        AdminEventResult adminEventResult = AdminEventResult.getAdminEventResult(resourceDeployEvent);
        try {
            String string = resourceDeployEvent.getAction();
            if ("deploy".equals(string)) {
                resourceDeployEventListener.resourceDeployed(resourceDeployEvent);
            } else if ("undeploy".equals(string)) {
                resourceDeployEventListener.resourceUndeployed(resourceDeployEvent);
            } else if ("redeploy".equals(string)) {
                resourceDeployEventListener.resourceRedeployed(resourceDeployEvent);
            } else if ("enable".equals(string)) {
                resourceDeployEventListener.resourceEnabled(resourceDeployEvent);
            } else if ("disable".equals(string)) {
                resourceDeployEventListener.resourceDisabled(resourceDeployEvent);
            }
        }
        catch (Throwable throwable) {
            this.handleListenerError(throwable, adminEventResult);
        }
    }

    private int handleBaseDeployEvent(AdminEvent adminEvent) {
        BaseDeployEvent baseDeployEvent = (BaseDeployEvent)adminEvent;
        ArrayList arrayList = this.getListeners(BaseDeployEvent.eventType);
        if (arrayList != null && !arrayList.isEmpty()) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                BaseDeployEventListener baseDeployEventListener = (BaseDeployEventListener)iterator.next();
                this.invokeBaseDeployEventListener(baseDeployEventListener, baseDeployEvent);
            }
        }
        return arrayList != null ? arrayList.size() : 0;
    }

    private void invokeBaseDeployEventListener(BaseDeployEventListener baseDeployEventListener, BaseDeployEvent baseDeployEvent) {
        AdminEventResult adminEventResult = AdminEventResult.getAdminEventResult(baseDeployEvent);
        try {
            String string = baseDeployEvent.getJ2EEComponentType();
            String string2 = baseDeployEvent.getAction();
            if ("application".equals(string)) {
                if ("deploy".equals(string2)) {
                    baseDeployEventListener.applicationDeployed(baseDeployEvent);
                } else if ("undeploy".equals(string2)) {
                    baseDeployEventListener.applicationUndeployed(baseDeployEvent);
                } else if ("redeploy".equals(string2)) {
                    baseDeployEventListener.applicationRedeployed(baseDeployEvent);
                } else if ("enable".equals(string2)) {
                    baseDeployEventListener.applicationEnabled(baseDeployEvent);
                } else if ("disable".equals(string2)) {
                    baseDeployEventListener.applicationDisabled(baseDeployEvent);
                }
            } else if ("module".equals(string)) {
                if ("deploy".equals(string2)) {
                    baseDeployEventListener.moduleDeployed(baseDeployEvent);
                } else if ("undeploy".equals(string2)) {
                    baseDeployEventListener.moduleUndeployed(baseDeployEvent);
                } else if ("redeploy".equals(string2)) {
                    baseDeployEventListener.moduleRedeployed(baseDeployEvent);
                } else if ("enable".equals(string2)) {
                    baseDeployEventListener.moduleEnabled(baseDeployEvent);
                } else if ("disable".equals(string2)) {
                    baseDeployEventListener.moduleDisabled(baseDeployEvent);
                }
            } else if ("resource".equals(string)) {
                if ("deploy".equals(string2)) {
                    baseDeployEventListener.resourceDeployed(baseDeployEvent);
                } else if ("undeploy".equals(string2)) {
                    baseDeployEventListener.resourceUndeployed(baseDeployEvent);
                } else if ("redeploy".equals(string2)) {
                    baseDeployEventListener.resourceRedeployed(baseDeployEvent);
                } else if ("enable".equals(string2)) {
                    baseDeployEventListener.resourceEnabled(baseDeployEvent);
                } else if ("disable".equals(string2)) {
                    baseDeployEventListener.resourceDisabled(baseDeployEvent);
                }
            }
        }
        catch (Throwable throwable) {
            this.handleListenerError(throwable, adminEventResult);
        }
    }

    private int handleConfigChangeEvent(AdminEvent adminEvent) {
        Object object;
        int n = 0;
        ConfigChangeEvent configChangeEvent = (ConfigChangeEvent)adminEvent;
        ArrayList arrayList = this.getListeners(ConfigChangeEvent.eventType);
        if (arrayList != null && !arrayList.isEmpty()) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                ConfigChangeEventListener configChangeEventListener = (ConfigChangeEventListener)object.next();
                ConfigChangeCategory configChangeCategory = (ConfigChangeCategory)this.configCategoryList.get(configChangeEventListener);
                boolean bl = true;
                if (configChangeCategory != null) {
                    bl = configChangeEvent.matchXPathToPattern(configChangeCategory.getConfigXPathPattern());
                }
                if (!bl) continue;
                this.invokeConfigChangeEventListener(configChangeEventListener, configChangeEvent);
                ++n;
            }
        }
        if (!configChangeEvent.isAllXPathMatched()) {
            object = AdminEventResult.getAdminEventResult(configChangeEvent);
            ((AdminEventResult)object).setResultCode("restart");
        }
        return n;
    }

    private void invokeConfigChangeEventListener(ConfigChangeEventListener configChangeEventListener, ConfigChangeEvent configChangeEvent) {
        AdminEventResult adminEventResult = AdminEventResult.getAdminEventResult(configChangeEvent);
        try {
            configChangeEventListener.configChanged(configChangeEvent);
        }
        catch (Throwable throwable) {
            this.handleListenerError(throwable, adminEventResult);
        }
    }

    private int handleMonitoringEvent(AdminEvent adminEvent) {
        MonitoringEvent monitoringEvent = (MonitoringEvent)adminEvent;
        ArrayList arrayList = this.getListeners(MonitoringEvent.eventType);
        if (arrayList != null && !arrayList.isEmpty()) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                MonitoringEventListener monitoringEventListener = (MonitoringEventListener)iterator.next();
                this.invokeMonitoringEventListener(monitoringEventListener, monitoringEvent);
            }
        }
        return arrayList != null ? arrayList.size() : 0;
    }

    private void invokeMonitoringEventListener(MonitoringEventListener monitoringEventListener, MonitoringEvent monitoringEvent) {
        AdminEventResult adminEventResult = AdminEventResult.getAdminEventResult(monitoringEvent);
        try {
            String string = monitoringEvent.getActionCode();
            if ("start_monitoring".equals(string)) {
                monitoringEventListener.startMonitoring(monitoringEvent);
            } else if ("stop_monitoring".equals(string)) {
                monitoringEventListener.stopMonitoring(monitoringEvent);
            } else if ("get_monitoring".equals(string)) {
                monitoringEventListener.getMonitoringData(monitoringEvent);
            } else if ("list_monitorable".equals(string)) {
                monitoringEventListener.listMonitorable(monitoringEvent);
            } else if ("set_monitoring".equals(string)) {
                monitoringEventListener.setMonitoringData(monitoringEvent);
            }
        }
        catch (Throwable throwable) {
            this.handleListenerError(throwable, adminEventResult);
        }
    }

    private int handleShutdownEvent(AdminEvent adminEvent) {
        return 1;
    }

    private static String getEventTypeFromListener(AdminEventListener adminEventListener) {
        Class<?>[] classArray = adminEventListener.getClass().getInterfaces();
        String string = null;
        for (int i = 0; i < classArray.length; ++i) {
            String string2 = classArray[i].getName();
            if (string2.startsWith(ApplicationDeployEvent.eventType)) {
                string = ApplicationDeployEvent.eventType;
            } else if (string2.startsWith(ModuleDeployEvent.eventType)) {
                string = ModuleDeployEvent.eventType;
            } else if (string2.startsWith(ResourceDeployEvent.eventType)) {
                string = ResourceDeployEvent.eventType;
            } else if (string2.startsWith(BaseDeployEvent.eventType)) {
                string = BaseDeployEvent.eventType;
            } else if (string2.startsWith(ConfigChangeEvent.eventType)) {
                string = ConfigChangeEvent.eventType;
            } else if (string2.startsWith(MonitoringEvent.eventType)) {
                string = MonitoringEvent.eventType;
            } else if (string2.startsWith(ShutdownEvent.eventType)) {
                string = ShutdownEvent.eventType;
            } else if (string2.startsWith(AdminEvent.eventType)) {
                string = AdminEvent.eventType;
            }
            if (string != null) break;
        }
        return string;
    }

    private static String[] getEventTypesFromListener(AdminEventListener adminEventListener) {
        String[] stringArray;
        Class<?>[] classArray = adminEventListener.getClass().getInterfaces();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < classArray.length; ++i) {
            stringArray = classArray[i].getName();
            if (stringArray.startsWith(ApplicationDeployEvent.eventType)) {
                hashSet.add(ApplicationDeployEvent.eventType);
                continue;
            }
            if (stringArray.startsWith(ModuleDeployEvent.eventType)) {
                hashSet.add(ModuleDeployEvent.eventType);
                continue;
            }
            if (stringArray.startsWith(ResourceDeployEvent.eventType)) {
                hashSet.add(ResourceDeployEvent.eventType);
                continue;
            }
            if (stringArray.startsWith(BaseDeployEvent.eventType)) {
                hashSet.add(BaseDeployEvent.eventType);
                continue;
            }
            if (stringArray.startsWith(ConfigChangeEvent.eventType)) {
                hashSet.add(ConfigChangeEvent.eventType);
                continue;
            }
            if (stringArray.startsWith(MonitoringEvent.eventType)) {
                hashSet.add(MonitoringEvent.eventType);
                continue;
            }
            if (stringArray.startsWith(ShutdownEvent.eventType)) {
                hashSet.add(ShutdownEvent.eventType);
                continue;
            }
            if (!stringArray.startsWith(AdminEvent.eventType)) continue;
            hashSet.add(AdminEvent.eventType);
        }
        String[] stringArray2 = new String[hashSet.size()];
        stringArray = hashSet.toArray(stringArray2);
        return stringArray;
    }

    private void refreshConfigContext() {
        try {
            AdminService.getAdminService().getContext().getConfigContext().refresh(true);
        }
        catch (ConfigException configException) {
            AdminEventMulticaster.warn("Unable to refresh ConfigContext upon receiving ConfigChangeEvent.");
            AdminEventMulticaster.debug(configException);
        }
    }

    private void handleNoListeners(AdminEvent adminEvent) {
        AdminEventResult adminEventResult = AdminEventResult.getAdminEventResult(adminEvent);
        adminEventResult.setResultCode("restart");
    }

    private void handleListenerError(Throwable throwable, AdminEventResult adminEventResult) {
        this.handleError(throwable, adminEventResult, HANDLER_ERROR);
    }

    private void handleError(Throwable throwable, AdminEventResult adminEventResult, String string) {
        logger.log(Level.WARNING, string, throwable.getMessage());
        String string2 = AdminEventMulticaster.getStackTraceFromThrowable(throwable);
        AdminEventMulticaster.debug(string2);
        if ("success".equals(adminEventResult.getResultCode())) {
            if (throwable instanceof AdminEventListenerException) {
                adminEventResult.setResultCode("listener_error");
            } else if (throwable instanceof RuntimeException) {
                adminEventResult.setResultCode("runtime_exception");
            } else if (throwable instanceof Error) {
                adminEventResult.setResultCode("runtime_error");
            } else {
                adminEventResult.setResultCode("runtime_error");
            }
        }
        adminEventResult.addMessage(throwable.getMessage());
        adminEventResult.addMessage(string2);
    }

    private static String getStackTraceFromThrowable(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    static void warn(String string) {
        logger.warning(string);
    }

    static void debug(String string) {
        logger.fine(string);
    }

    static void debug(Throwable throwable) {
        logger.log(Level.FINE, throwable.getMessage(), throwable);
    }
}

