/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.clusterverifier;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.AvailabilityService;
import com.iplanet.ias.config.serverbeans.ConnectorModule;
import com.iplanet.ias.config.serverbeans.CustomResource;
import com.iplanet.ias.config.serverbeans.EjbContainer;
import com.iplanet.ias.config.serverbeans.EjbModule;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.ExternalJndiResource;
import com.iplanet.ias.config.serverbeans.IiopCluster;
import com.iplanet.ias.config.serverbeans.IiopEndpoint;
import com.iplanet.ias.config.serverbeans.IiopServerInstance;
import com.iplanet.ias.config.serverbeans.J2eeApplication;
import com.iplanet.ias.config.serverbeans.JdbcConnectionPool;
import com.iplanet.ias.config.serverbeans.JdbcResource;
import com.iplanet.ias.config.serverbeans.JmsResource;
import com.iplanet.ias.config.serverbeans.MailResource;
import com.iplanet.ias.config.serverbeans.ManagerProperties;
import com.iplanet.ias.config.serverbeans.PersistenceManagerFactoryResource;
import com.iplanet.ias.config.serverbeans.PersistenceStore;
import com.iplanet.ias.config.serverbeans.Resources;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.SessionConfig;
import com.iplanet.ias.config.serverbeans.SessionManager;
import com.iplanet.ias.config.serverbeans.SessionProperties;
import com.iplanet.ias.config.serverbeans.StoreProperties;
import com.iplanet.ias.config.serverbeans.WebContainer;
import com.iplanet.ias.config.serverbeans.WebModule;
import com.iplanet.ias.util.i18n.StringManager;

public class ClusterConfigsVerifier {
    static String debugOn = null;
    private static StringManager localStrings = StringManager.getManager(ClusterConfigsVerifier.class);
    static final int MISSING = 0;
    static final int EXTRA = 1;
    static final int DIFFERENT_ATTR_VAL = 2;
    static final int DIFFERENT = 3;
    static final int APP = 0;
    static final int RESOURCE = 1;
    static final int AVAILABILITY_SERVICE = 2;
    static final int EJB_CONTAINER = 3;
    static final int WEB_CONTAINER = 4;
    static final int ERROR = 0;
    static final int WARNING = 1;
    static int errors = 0;
    static int warnings = 0;

    public static void main(String[] stringArray) {
        boolean bl;
        if (stringArray.length < 2) {
            System.out.println("Usage : clusterConfigsVerifier <file 1> <file 2>");
        }
        if (bl = ClusterConfigsVerifier.compare(stringArray[0], stringArray[1])) {
            System.out.println("  SUCCESS configs homogeneous");
        } else {
            System.out.println("  FAILED configs NOT homogeneous");
        }
    }

    protected static boolean compare(String string, String string2) {
        try {
            debugOn = System.getProperties().getProperty("DEBUG_ON", null);
            ConfigContext configContext = ConfigFactory.createConfigContext(string);
            ConfigContext configContext2 = ConfigFactory.createConfigContext(string2);
            boolean bl = ClusterConfigsVerifier.compareApplications(configContext, configContext2);
            ClusterConfigsVerifier.printDebug(" Applications comparison = " + bl);
            boolean bl2 = ClusterConfigsVerifier.compareResources(configContext, configContext2);
            ClusterConfigsVerifier.printDebug(" Resources comparison = " + bl2);
            boolean bl3 = ClusterConfigsVerifier.compareClusterConfiguration(configContext, configContext2);
            ClusterConfigsVerifier.printDebug(" Cluster configuration comparison = " + bl3);
            return bl && bl2 && bl3;
        }
        catch (ConfigException configException) {
            ClusterConfigsVerifier.printError("config error", configException);
            return false;
        }
    }

    protected static boolean compareApplications(ConfigContext configContext, ConfigContext configContext2) {
        try {
            Server server = (Server)configContext.getRootConfigBean();
            Applications applications = server.getApplications();
            Server server2 = (Server)configContext2.getRootConfigBean();
            Applications applications2 = server2.getApplications();
            boolean bl = ClusterConfigsVerifier.compareJ2eeApplications(applications, applications2);
            ClusterConfigsVerifier.printDebug("\tJ2eeApplications comparison = " + bl);
            boolean bl2 = ClusterConfigsVerifier.compareWebModules(applications, applications2);
            ClusterConfigsVerifier.printDebug("\tWeb modules comparison = " + bl2);
            boolean bl3 = ClusterConfigsVerifier.compareEjbModules(applications, applications2);
            ClusterConfigsVerifier.printDebug("\tEJB modules comparison = " + bl3);
            boolean bl4 = ClusterConfigsVerifier.compareConnectorModules(applications, applications2);
            ClusterConfigsVerifier.printDebug("\tConnector modules comparison = " + bl4);
            return bl && bl2 && bl3 && bl4;
        }
        catch (ConfigException configException) {
            ClusterConfigsVerifier.printError("config error", configException);
            return false;
        }
    }

    protected static boolean compareJ2eeApplications(Applications applications, Applications applications2) {
        try {
            boolean bl;
            J2eeApplication[] j2eeApplicationArray = applications.getJ2eeApplication();
            J2eeApplication[] j2eeApplicationArray2 = applications2.getJ2eeApplication();
            boolean bl2 = true;
            if (j2eeApplicationArray.length != j2eeApplicationArray2.length) {
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.count_different", "Applications", "J2eeApplication"), 3, 0, 1);
            }
            J2eeApplication j2eeApplication = null;
            String string = null;
            for (int i = 0; i < j2eeApplicationArray.length; ++i) {
                String string2;
                String string3;
                string = j2eeApplicationArray[i].getName();
                j2eeApplication = applications2.getJ2eeApplicationByName(string);
                if (j2eeApplication == null) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.application", "J2eeApplication", string), 0, 0, 0);
                    continue;
                }
                bl = j2eeApplicationArray[i].isEnabled();
                boolean bl3 = j2eeApplication.isEnabled();
                if (!(!bl && !bl3 || bl && bl3)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.j2ee_application_attr_diff", string, "enabled", Boolean.toString(bl3), Boolean.toString(bl)), 2, 0, 0);
                }
                if ((string3 = j2eeApplicationArray[i].getAvailabilityEnabled()) == null) {
                    string3 = "false";
                }
                if ((string2 = j2eeApplication.getAvailabilityEnabled()) == null) {
                    string2 = "false";
                }
                if (string3.equalsIgnoreCase(string2)) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.j2ee_application_attr_diff", string, "availabilityEnabled", string2, string3), 2, 0, 0);
            }
            J2eeApplication j2eeApplication2 = null;
            for (bl = false; bl < j2eeApplicationArray2.length; bl += 1) {
                string = j2eeApplicationArray2[bl].getName();
                j2eeApplication2 = applications.getJ2eeApplicationByName(string);
                if (j2eeApplication2 != null) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.application", "J2eeApplications", string), 1, 0, 1);
            }
            return bl2;
        }
        catch (Exception exception) {
            ClusterConfigsVerifier.printError("Received Exception ", exception);
            ClusterConfigsVerifier.printDebug(" compareJ2eeApplications returning false at end.");
            return false;
        }
    }

    protected static boolean compareWebModules(Applications applications, Applications applications2) {
        try {
            boolean bl;
            WebModule[] webModuleArray = applications.getWebModule();
            WebModule[] webModuleArray2 = applications2.getWebModule();
            boolean bl2 = true;
            if (webModuleArray.length != webModuleArray2.length) {
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.count_different", "Applications", "WebModule"), 3, 0, 1);
            }
            WebModule webModule = null;
            String string = null;
            for (int i = 0; i < webModuleArray.length; ++i) {
                String string2;
                String string3;
                String string4;
                String string5;
                string = webModuleArray[i].getName();
                webModule = applications2.getWebModuleByName(string);
                if (webModule == null) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.application", "WebModule", string), 0, 0, 0);
                    continue;
                }
                bl = webModuleArray[i].isEnabled();
                boolean bl3 = webModule.isEnabled();
                if (!(!bl && !bl3 || bl && bl3)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.webmodule_attr_diff", string, "enabled", Boolean.toString(bl3), Boolean.toString(bl)), 2, 0, 0);
                }
                if ((string5 = webModuleArray[i].getAvailabilityEnabled()) == null) {
                    string5 = "false";
                }
                if ((string4 = webModule.getAvailabilityEnabled()) == null) {
                    string4 = "false";
                }
                if (!string5.equalsIgnoreCase(string4)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.webmodule_attr_diff", string, "availabilityEnabled", string4, string5), 2, 0, 0);
                }
                if ((string3 = webModuleArray[i].getContextRoot()) == null) {
                    string3 = "";
                }
                if ((string2 = webModule.getContextRoot()) == null) {
                    string2 = "";
                }
                if (string3.equals(string2)) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.j2ee_application_attr_diff", string, "contextRoot", string2, string3), 2, 0, 0);
            }
            WebModule webModule2 = null;
            for (bl = false; bl < webModuleArray2.length; bl += 1) {
                string = webModuleArray2[bl].getName();
                webModule2 = applications.getWebModuleByName(string);
                if (webModule2 != null) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.application", "WebModule", string), 1, 0, 1);
            }
            return bl2;
        }
        catch (Exception exception) {
            ClusterConfigsVerifier.printError("Received Exception ", exception);
            ClusterConfigsVerifier.printDebug(" compareWebModules returning false at end.");
            return false;
        }
    }

    protected static boolean compareEjbModules(Applications applications, Applications applications2) {
        try {
            boolean bl;
            EjbModule[] ejbModuleArray = applications.getEjbModule();
            EjbModule[] ejbModuleArray2 = applications2.getEjbModule();
            boolean bl2 = true;
            if (ejbModuleArray.length != ejbModuleArray2.length) {
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.count_different", "Applications", "EjbModule"), 3, 0, 1);
            }
            EjbModule ejbModule = null;
            String string = null;
            for (int i = 0; i < ejbModuleArray.length; ++i) {
                String string2;
                String string3;
                string = ejbModuleArray[i].getName();
                ejbModule = applications2.getEjbModuleByName(string);
                if (ejbModule == null) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.application", "EjbModule", string), 0, 0, 0);
                    continue;
                }
                bl = ejbModuleArray[i].isEnabled();
                boolean bl3 = ejbModule.isEnabled();
                if (!(!bl && !bl3 || bl && bl3)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.ejbmodule_attr_diff", string, "enabled", Boolean.toString(bl3), Boolean.toString(bl)), 2, 0, 0);
                }
                if ((string3 = ejbModuleArray[i].getAvailabilityEnabled()) == null) {
                    string3 = "false";
                }
                if ((string2 = ejbModule.getAvailabilityEnabled()) == null) {
                    string2 = "false";
                }
                if (string3.equalsIgnoreCase(string2)) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.ejbmodule_attr_diff", string, "availabilityEnabled", string2, string3), 2, 0, 0);
            }
            EjbModule ejbModule2 = null;
            for (bl = false; bl < ejbModuleArray2.length; bl += 1) {
                string = ejbModuleArray2[bl].getName();
                ejbModule2 = applications.getEjbModuleByName(string);
                if (ejbModule2 != null) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.application", "EjbModule", string), 1, 0, 1);
            }
            return bl2;
        }
        catch (Exception exception) {
            ClusterConfigsVerifier.printError("Received Exception ", exception);
            ClusterConfigsVerifier.printDebug(" compareEjbModules returning false at end.");
            return false;
        }
    }

    protected static boolean compareConnectorModules(Applications applications, Applications applications2) {
        try {
            boolean bl;
            ConnectorModule[] connectorModuleArray = applications.getConnectorModule();
            ConnectorModule[] connectorModuleArray2 = applications2.getConnectorModule();
            boolean bl2 = true;
            if (connectorModuleArray.length != connectorModuleArray2.length) {
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.count_different", "Applications", "ConnectorModule"), 3, 0, 1);
            }
            ConnectorModule connectorModule = null;
            String string = null;
            for (int i = 0; i < connectorModuleArray.length; ++i) {
                string = connectorModuleArray[i].getName();
                connectorModule = applications2.getConnectorModuleByName(string);
                if (connectorModule == null) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.application", "ConnectorModule", string), 0, 0, 0);
                    continue;
                }
                bl = connectorModuleArray[i].isEnabled();
                boolean bl3 = connectorModule.isEnabled();
                if (!bl && !bl3 || bl && bl3) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.connectormodule_attr_diff", string, "enabled", Boolean.toString(bl3), Boolean.toString(bl)), 2, 0, 0);
            }
            ConnectorModule connectorModule2 = null;
            for (bl = false; bl < connectorModuleArray2.length; bl += 1) {
                string = connectorModuleArray2[bl].getName();
                connectorModule2 = applications.getConnectorModuleByName(string);
                if (connectorModule2 != null) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.application", "ConnectorModule", string), 1, 0, 1);
            }
            return bl2;
        }
        catch (Exception exception) {
            ClusterConfigsVerifier.printError("Received Exception ", exception);
            ClusterConfigsVerifier.printDebug(" compareConnectorModules returning false at end.");
            return false;
        }
    }

    protected static boolean compareResources(ConfigContext configContext, ConfigContext configContext2) {
        try {
            Server server = (Server)configContext.getRootConfigBean();
            Resources resources = server.getResources();
            Server server2 = (Server)configContext2.getRootConfigBean();
            Resources resources2 = server2.getResources();
            boolean bl = ClusterConfigsVerifier.compareCustomResources(resources, resources2);
            ClusterConfigsVerifier.printDebug("\tCustomResources comparison = " + bl);
            boolean bl2 = ClusterConfigsVerifier.compareExternalJndiResources(resources, resources2);
            ClusterConfigsVerifier.printDebug("\tExternalJndiResources comparison = " + bl2);
            boolean bl3 = ClusterConfigsVerifier.compareJdbcResources(resources, resources2);
            ClusterConfigsVerifier.printDebug("\tJdbcResources comparison = " + bl3);
            boolean bl4 = ClusterConfigsVerifier.compareMailResources(resources, resources2);
            ClusterConfigsVerifier.printDebug("\tMailResources comparison = " + bl4);
            boolean bl5 = ClusterConfigsVerifier.compareJmsResources(resources, resources2);
            ClusterConfigsVerifier.printDebug("\tJmsResources comparison = " + bl5);
            boolean bl6 = ClusterConfigsVerifier.comparePersistenceManagerFactoryResources(resources, resources2);
            ClusterConfigsVerifier.printDebug("\tPersistenceManagerFactoryResources comparison = " + bl6);
            boolean bl7 = ClusterConfigsVerifier.compareJdbcConnectionPools(resources, resources2);
            ClusterConfigsVerifier.printDebug("\tjdbcConnectionPoolsRet comparison = " + bl7);
            return bl && bl2 && bl3 && bl4 && bl5 && bl6;
        }
        catch (ConfigException configException) {
            ClusterConfigsVerifier.printError("config error", configException);
            return false;
        }
    }

    protected static boolean compareCustomResources(Resources resources, Resources resources2) {
        try {
            boolean bl;
            CustomResource[] customResourceArray = resources.getCustomResource();
            CustomResource[] customResourceArray2 = resources2.getCustomResource();
            boolean bl2 = true;
            if (customResourceArray.length != customResourceArray2.length) {
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.count_different", "Resources", "CustomResource"), 3, 1, 1);
            }
            CustomResource customResource = null;
            String string = null;
            for (int i = 0; i < customResourceArray.length; ++i) {
                String string2;
                String string3;
                String string4;
                string = customResourceArray[i].getJndiName();
                customResource = resources2.getCustomResourceByJndiName(string);
                if (customResource == null) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.resource", "CustomResource", string), 0, 1, 0);
                    continue;
                }
                bl = customResourceArray[i].isEnabled();
                boolean bl3 = customResource.isEnabled();
                if (!(!bl && !bl3 || bl && bl3)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.customresource_attr_diff", string, "enabled", Boolean.toString(bl3), Boolean.toString(bl)), 2, 1, 0);
                }
                if ((string4 = customResourceArray[i].getResType()) == null) {
                    string4 = "";
                }
                String string5 = customResource.getResType();
                if (string4 == null) {
                    string4 = "";
                }
                if (!string4.equals(string5)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.customresource_attr_diff", string, "resType", string5, string4), 2, 1, 0);
                }
                if ((string3 = customResourceArray[i].getFactoryClass()) == null) {
                    string3 = "";
                }
                if ((string2 = customResource.getFactoryClass()) == null) {
                    string2 = "";
                }
                if (string3.equals(string2)) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.customresource_attr_diff", string, "factoryClass", string2, string3), 2, 1, 0);
            }
            CustomResource customResource2 = null;
            for (bl = false; bl < customResourceArray2.length; bl += 1) {
                string = customResourceArray2[bl].getJndiName();
                customResource2 = resources.getCustomResourceByJndiName(string);
                if (customResource2 != null) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.resource", "CustomResource", string), 1, 1, 1);
            }
            return bl2;
        }
        catch (Exception exception) {
            ClusterConfigsVerifier.printError("Received Exception ", exception);
            ClusterConfigsVerifier.printDebug(" compareCustomResources returning false at end.");
            return false;
        }
    }

    protected static boolean compareExternalJndiResources(Resources resources, Resources resources2) {
        try {
            boolean bl;
            ExternalJndiResource[] externalJndiResourceArray = resources.getExternalJndiResource();
            ExternalJndiResource[] externalJndiResourceArray2 = resources2.getExternalJndiResource();
            boolean bl2 = true;
            if (externalJndiResourceArray.length != externalJndiResourceArray2.length) {
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.count_different", "Resources", "ExternalJndiResource"), 3, 1, 1);
            }
            ExternalJndiResource externalJndiResource = null;
            String string = null;
            for (int i = 0; i < externalJndiResourceArray.length; ++i) {
                String string2;
                String string3;
                String string4;
                String string5;
                string = externalJndiResourceArray[i].getJndiName();
                externalJndiResource = resources2.getExternalJndiResourceByJndiName(string);
                if (externalJndiResource == null) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.resource", "ExternalJndiResource", string), 0, 1, 0);
                    continue;
                }
                bl = externalJndiResourceArray[i].isEnabled();
                boolean bl3 = externalJndiResource.isEnabled();
                if (!(!bl && !bl3 || bl && bl3)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.externaljndiresource_attr_diff", string, "enabled", Boolean.toString(bl3), Boolean.toString(bl)), 2, 1, 0);
                }
                if ((string5 = externalJndiResourceArray[i].getJndiLookupName()) == null) {
                    string5 = "";
                }
                String string6 = externalJndiResource.getJndiLookupName();
                if (string5 == null) {
                    string5 = "";
                }
                if (!string5.equals(string6)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.externaljndiresource_attr_diff", string, "jndiLookupName", string6, string5), 2, 1, 0);
                }
                if ((string4 = externalJndiResourceArray[i].getResType()) == null) {
                    string4 = "";
                }
                String string7 = externalJndiResource.getResType();
                if (string4 == null) {
                    string4 = "";
                }
                if (!string4.equals(string7)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.externaljndiresource_attr_diff", string, "resType", string7, string4), 2, 1, 0);
                }
                if ((string3 = externalJndiResourceArray[i].getFactoryClass()) == null) {
                    string3 = "";
                }
                if ((string2 = externalJndiResource.getFactoryClass()) == null) {
                    string2 = "";
                }
                if (string3.equals(string2)) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.externaljndiresource_attr_diff", string, "factoryClass", string2, string3), 2, 1, 0);
            }
            ExternalJndiResource externalJndiResource2 = null;
            for (bl = false; bl < externalJndiResourceArray2.length; bl += 1) {
                string = externalJndiResourceArray2[bl].getJndiName();
                externalJndiResource2 = resources.getExternalJndiResourceByJndiName(string);
                if (externalJndiResource2 != null) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.resource", "ExternalJndiResource", string), 1, 1, 1);
            }
            return bl2;
        }
        catch (Exception exception) {
            ClusterConfigsVerifier.printError("Received Exception ", exception);
            ClusterConfigsVerifier.printDebug(" compareExternalJndiResources returning false at end.");
            return false;
        }
    }

    protected static boolean compareJdbcResources(Resources resources, Resources resources2) {
        try {
            boolean bl;
            JdbcResource[] jdbcResourceArray = resources.getJdbcResource();
            JdbcResource[] jdbcResourceArray2 = resources2.getJdbcResource();
            boolean bl2 = true;
            if (jdbcResourceArray.length != jdbcResourceArray2.length) {
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.count_different", "Resources", "JdbcResource"), 3, 1, 1);
            }
            JdbcResource jdbcResource = null;
            String string = null;
            for (int i = 0; i < jdbcResourceArray.length; ++i) {
                String string2;
                string = jdbcResourceArray[i].getJndiName();
                jdbcResource = resources2.getJdbcResourceByJndiName(string);
                if (jdbcResource == null) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.resource", "JdbcResource", string), 0, 1, 0);
                    continue;
                }
                bl = jdbcResourceArray[i].isEnabled();
                boolean bl3 = jdbcResource.isEnabled();
                if (!(!bl && !bl3 || bl && bl3)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.jdbcresource_attr_diff", string, "enabled", Boolean.toString(bl3), Boolean.toString(bl)), 2, 1, 0);
                }
                if ((string2 = jdbcResourceArray[i].getPoolName()) == null) {
                    string2 = "";
                }
                String string3 = jdbcResource.getPoolName();
                if (string2 == null) {
                    string2 = "";
                }
                if (string2.equals(string3)) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.jdbcresource_attr_diff", string, "poolName", string3, string2), 2, 1, 0);
            }
            JdbcResource jdbcResource2 = null;
            for (bl = false; bl < jdbcResourceArray2.length; bl += 1) {
                string = jdbcResourceArray2[bl].getJndiName();
                jdbcResource2 = resources.getJdbcResourceByJndiName(string);
                if (jdbcResource2 != null) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.resource", "JdbcResource", string), 1, 1, 1);
            }
            return bl2;
        }
        catch (Exception exception) {
            ClusterConfigsVerifier.printError("Received Exception ", exception);
            ClusterConfigsVerifier.printDebug(" compareJdbcResources returning false at end.");
            return false;
        }
    }

    protected static boolean compareMailResources(Resources resources, Resources resources2) {
        try {
            boolean bl;
            MailResource[] mailResourceArray = resources.getMailResource();
            MailResource[] mailResourceArray2 = resources2.getMailResource();
            boolean bl2 = true;
            if (mailResourceArray.length != mailResourceArray2.length) {
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.count_different", "Resources", "MailResource"), 3, 1, 1);
            }
            MailResource mailResource = null;
            String string = null;
            for (int i = 0; i < mailResourceArray.length; ++i) {
                String string2;
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                String string8;
                string = mailResourceArray[i].getJndiName();
                mailResource = resources2.getMailResourceByJndiName(string);
                if (mailResource == null) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.resource", "MailResource", string), 0, 1, 0);
                    continue;
                }
                bl = mailResourceArray[i].isEnabled();
                boolean bl3 = mailResource.isEnabled();
                if (!(!bl && !bl3 || bl && bl3)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.mailresource_attr_diff", string, "enabled", Boolean.toString(bl3), Boolean.toString(bl)), 2, 1, 0);
                }
                if ((string8 = mailResourceArray[i].getStoreProtocol()) == null) {
                    string8 = "";
                }
                String string9 = mailResource.getStoreProtocol();
                if (string8 == null) {
                    string8 = "";
                }
                if (!string8.equals(string9)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.mailresource_attr_diff", string, "storeProtocol", string9, string8), 2, 1, 0);
                }
                if ((string7 = mailResourceArray[i].getStoreProtocolClass()) == null) {
                    string7 = "";
                }
                String string10 = mailResource.getStoreProtocolClass();
                if (string7 == null) {
                    string7 = "";
                }
                if (!string7.equals(string10)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.mailresource_attr_diff", string, "storeProtocolClass", string10, string7), 2, 1, 0);
                }
                if ((string6 = mailResourceArray[i].getTransportProtocol()) == null) {
                    string6 = "";
                }
                String string11 = mailResource.getTransportProtocol();
                if (string6 == null) {
                    string6 = "";
                }
                if (!string6.equals(string11)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.mailresource_attr_diff", string, "transportProtocol", string11, string6), 2, 1, 0);
                }
                if ((string5 = mailResourceArray[i].getTransportProtocolClass()) == null) {
                    string5 = "";
                }
                String string12 = mailResource.getTransportProtocolClass();
                if (string5 == null) {
                    string5 = "";
                }
                if (!string5.equals(string12)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.mailresource_attr_diff", string, "transportProtocolClass", string12, string5), 2, 1, 0);
                }
                if ((string4 = mailResourceArray[i].getHost()) == null) {
                    string4 = "";
                }
                String string13 = mailResource.getHost();
                if (string4 == null) {
                    string4 = "";
                }
                if (!string4.equals(string13)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.mailresource_attr_diff", string, "host", string13, string4), 2, 1, 0);
                }
                if ((string3 = mailResourceArray[i].getUser()) == null) {
                    string3 = "";
                }
                String string14 = mailResource.getUser();
                if (string3 == null) {
                    string3 = "";
                }
                if (!string3.equals(string14)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.mailresource_attr_diff", string, "user", string14, string3), 2, 1, 0);
                }
                if ((string2 = mailResourceArray[i].getFrom()) == null) {
                    string2 = "";
                }
                String string15 = mailResource.getFrom();
                if (string2 == null) {
                    string2 = "";
                }
                if (!string2.equals(string15)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.mailresource_attr_diff", string, "from", string15, string2), 2, 1, 0);
                }
                boolean bl4 = mailResourceArray[i].isDebug();
                boolean bl5 = mailResource.isDebug();
                if (!bl4 && !bl5 || bl4 && bl5) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.mailresource_attr_diff", string, "debug", Boolean.toString(bl5), Boolean.toString(bl4)), 2, 1, 0);
            }
            MailResource mailResource2 = null;
            for (bl = false; bl < mailResourceArray2.length; bl += 1) {
                string = mailResourceArray2[bl].getJndiName();
                mailResource2 = resources.getMailResourceByJndiName(string);
                if (mailResource2 != null) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.resource", "MailResource", string), 1, 1, 1);
            }
            return bl2;
        }
        catch (Exception exception) {
            ClusterConfigsVerifier.printError("Received Exception ", exception);
            ClusterConfigsVerifier.printDebug(" compareMailResources returning false at end.");
            return false;
        }
    }

    protected static boolean compareJmsResources(Resources resources, Resources resources2) {
        try {
            boolean bl;
            JmsResource[] jmsResourceArray = resources.getJmsResource();
            JmsResource[] jmsResourceArray2 = resources2.getJmsResource();
            boolean bl2 = true;
            if (jmsResourceArray.length != jmsResourceArray2.length) {
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.count_different", "Resources", "JmsResource"), 3, 1, 1);
            }
            JmsResource jmsResource = null;
            String string = null;
            for (int i = 0; i < jmsResourceArray.length; ++i) {
                String string2;
                string = jmsResourceArray[i].getJndiName();
                jmsResource = resources2.getJmsResourceByJndiName(string);
                if (jmsResource == null) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.resource", "JmsResource", string), 0, 1, 0);
                    continue;
                }
                bl = jmsResourceArray[i].isEnabled();
                boolean bl3 = jmsResource.isEnabled();
                if (!(!bl && !bl3 || bl && bl3)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.jmsresource_attr_diff", string, "enabled", Boolean.toString(bl3), Boolean.toString(bl)), 2, 1, 0);
                }
                if ((string2 = jmsResourceArray[i].getResType()) == null) {
                    string2 = "";
                }
                String string3 = jmsResource.getResType();
                if (string2 == null) {
                    string2 = "";
                }
                if (string2.equals(string3)) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.jmsresource_attr_diff", string, "resType", string3, string2), 2, 1, 0);
            }
            JmsResource jmsResource2 = null;
            for (bl = false; bl < jmsResourceArray2.length; bl += 1) {
                string = jmsResourceArray2[bl].getJndiName();
                jmsResource2 = resources.getJmsResourceByJndiName(string);
                if (jmsResource2 != null) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.resource", "JmsResource", string), 1, 1, 1);
            }
            return bl2;
        }
        catch (Exception exception) {
            ClusterConfigsVerifier.printError("Received Exception ", exception);
            ClusterConfigsVerifier.printDebug(" compareJmsResources returning false at end.");
            return false;
        }
    }

    protected static boolean comparePersistenceManagerFactoryResources(Resources resources, Resources resources2) {
        try {
            boolean bl;
            PersistenceManagerFactoryResource[] persistenceManagerFactoryResourceArray = resources.getPersistenceManagerFactoryResource();
            PersistenceManagerFactoryResource[] persistenceManagerFactoryResourceArray2 = resources2.getPersistenceManagerFactoryResource();
            boolean bl2 = true;
            if (persistenceManagerFactoryResourceArray.length != persistenceManagerFactoryResourceArray2.length) {
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.count_different", "Resources", "PersistenceManagerFactoryResource"), 3, 1, 1);
            }
            PersistenceManagerFactoryResource persistenceManagerFactoryResource = null;
            String string = null;
            for (int i = 0; i < persistenceManagerFactoryResourceArray.length; ++i) {
                String string2;
                String string3;
                string = persistenceManagerFactoryResourceArray[i].getJndiName();
                persistenceManagerFactoryResource = resources2.getPersistenceManagerFactoryResourceByJndiName(string);
                if (persistenceManagerFactoryResource == null) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.resource", "PersistenceManagerFactoryResource", string), 0, 1, 0);
                    continue;
                }
                bl = persistenceManagerFactoryResourceArray[i].isEnabled();
                boolean bl3 = persistenceManagerFactoryResource.isEnabled();
                if (!(!bl && !bl3 || bl && bl3)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.persistencemanagerfactoryresource_attr_diff", string, "enabled", Boolean.toString(bl3), Boolean.toString(bl)), 2, 1, 0);
                }
                if ((string3 = persistenceManagerFactoryResourceArray[i].getFactoryClass()) == null) {
                    string3 = "";
                }
                String string4 = persistenceManagerFactoryResource.getFactoryClass();
                if (string3 == null) {
                    string3 = "";
                }
                if (!string3.equals(string4)) {
                    bl2 = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.persistencemanagerfactoryresource_attr_diff", string, "factoryClass", string4, string3), 2, 1, 0);
                }
                if ((string2 = persistenceManagerFactoryResourceArray[i].getJdbcResourceJndiName()) == null) {
                    string2 = "";
                }
                String string5 = persistenceManagerFactoryResource.getJdbcResourceJndiName();
                if (string2 == null) {
                    string2 = "";
                }
                if (string2.equals(string5)) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.persistencemanagerfactoryresource_attr_diff", string, "jdbcResourceJndiName", string5, string2), 2, 1, 0);
            }
            PersistenceManagerFactoryResource persistenceManagerFactoryResource2 = null;
            for (bl = false; bl < persistenceManagerFactoryResourceArray2.length; bl += 1) {
                string = persistenceManagerFactoryResourceArray2[bl].getJndiName();
                persistenceManagerFactoryResource2 = resources.getPersistenceManagerFactoryResourceByJndiName(string);
                if (persistenceManagerFactoryResource2 != null) continue;
                bl2 = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.resource", "PersistenceManagerFactoryResource", string), 1, 1, 1);
            }
            return bl2;
        }
        catch (Exception exception) {
            ClusterConfigsVerifier.printError("Received Exception ", exception);
            ClusterConfigsVerifier.printDebug(" comparePersistenceManagerFactoryResources returning false at end.");
            return false;
        }
    }

    protected static boolean compareJdbcConnectionPools(Resources resources, Resources resources2) {
        try {
            JdbcConnectionPool[] jdbcConnectionPoolArray = resources.getJdbcConnectionPool();
            JdbcConnectionPool[] jdbcConnectionPoolArray2 = resources2.getJdbcConnectionPool();
            boolean bl = true;
            if (jdbcConnectionPoolArray.length != jdbcConnectionPoolArray2.length) {
                bl = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.count_different", "Resources", "JdbcConnectionPool"), 3, 1, 1);
            }
            JdbcConnectionPool jdbcConnectionPool = null;
            String string = null;
            for (int i = 0; i < jdbcConnectionPoolArray.length; ++i) {
                string = jdbcConnectionPoolArray[i].getName();
                jdbcConnectionPool = resources2.getJdbcConnectionPoolByName(string);
                if (jdbcConnectionPool == null) {
                    bl = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.jdbc_connection_pool", string), 0, 1, 0);
                    continue;
                }
                String string2 = "Resources/JdbcConnectionPool[name=" + string + "].";
                bl = ClusterConfigsVerifier.compareStringAttr(ServerTags.DATASOURCE_CLASSNAME, jdbcConnectionPoolArray[i], jdbcConnectionPool, "", string2, 1, bl);
                bl = ClusterConfigsVerifier.compareStringAttr(ServerTags.RES_TYPE, jdbcConnectionPoolArray[i], jdbcConnectionPool, "", string2, 1, bl);
                bl = ClusterConfigsVerifier.compareStringAttr(ServerTags.STEADY_POOL_SIZE, jdbcConnectionPoolArray[i], jdbcConnectionPool, "", string2, 1, bl);
                bl = ClusterConfigsVerifier.compareStringAttr(ServerTags.MAX_POOL_SIZE, jdbcConnectionPoolArray[i], jdbcConnectionPool, "", string2, 1, bl);
                bl = ClusterConfigsVerifier.compareStringAttr(ServerTags.MAX_WAIT_TIME_IN_MILLIS, jdbcConnectionPoolArray[i], jdbcConnectionPool, "", string2, 1, bl);
                bl = ClusterConfigsVerifier.compareStringAttr(ServerTags.POOL_RESIZE_QUANTITY, jdbcConnectionPoolArray[i], jdbcConnectionPool, "", string2, 1, bl);
                bl = ClusterConfigsVerifier.compareStringAttr(ServerTags.IDLE_TIMEOUT_IN_SECONDS, jdbcConnectionPoolArray[i], jdbcConnectionPool, "", string2, 1, bl);
                bl = ClusterConfigsVerifier.compareBooleanAttr(ServerTags.IS_ISOLATION_LEVEL_GUARANTEED, jdbcConnectionPoolArray[i], jdbcConnectionPool, false, string2, 1, bl);
                bl = ClusterConfigsVerifier.compareBooleanAttr(ServerTags.IS_CONNECTION_VALIDATION_REQUIRED, jdbcConnectionPoolArray[i], jdbcConnectionPool, false, string2, 1, bl);
                bl = ClusterConfigsVerifier.compareStringAttr(ServerTags.CONNECTION_VALIDATION_METHOD, jdbcConnectionPoolArray[i], jdbcConnectionPool, "", string2, 1, bl);
                bl = ClusterConfigsVerifier.compareStringAttr(ServerTags.VALIDATION_TABLE_NAME, jdbcConnectionPoolArray[i], jdbcConnectionPool, "", string2, 1, bl);
                bl = ClusterConfigsVerifier.compareBooleanAttr(ServerTags.FAIL_ALL_CONNECTIONS, jdbcConnectionPoolArray[i], jdbcConnectionPool, true, string2, 1, bl);
                boolean bl2 = ClusterConfigsVerifier.compareProperties("jdbc-connection-pool:", jdbcConnectionPoolArray[i].getElementProperty(), jdbcConnectionPool.getElementProperty(), 1);
                bl = bl && bl2;
            }
            JdbcConnectionPool jdbcConnectionPool2 = null;
            for (int i = 0; i < jdbcConnectionPoolArray2.length; ++i) {
                string = jdbcConnectionPoolArray2[i].getName();
                jdbcConnectionPool2 = resources.getJdbcConnectionPoolByName(string);
                if (jdbcConnectionPool2 != null) continue;
                bl = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.resource", "JdbcConnectionPool", string), 1, 1, 1);
            }
            return bl;
        }
        catch (Exception exception) {
            ClusterConfigsVerifier.printError("Received Exception ", exception);
            ClusterConfigsVerifier.printDebug(" compareJdbcConnectionPools returning false at end.");
            return false;
        }
    }

    protected static boolean compareProperties(String string, ElementProperty[] elementPropertyArray, ElementProperty[] elementPropertyArray2, int n) {
        return ClusterConfigsVerifier.compareProperties(string, elementPropertyArray, elementPropertyArray2, n, 0);
    }

    protected static boolean compareProperties(String string, ElementProperty[] elementPropertyArray, ElementProperty[] elementPropertyArray2, int n, int n2) {
        String string2;
        String string3;
        int n3;
        boolean bl = true;
        if (elementPropertyArray.length != elementPropertyArray2.length) {
            bl = false;
            ClusterConfigsVerifier.printDiff(string + " Property count different", 3, n, n2);
        }
        for (n3 = 0; n3 < elementPropertyArray.length; ++n3) {
            string3 = elementPropertyArray[n3].getValue();
            string2 = ClusterConfigsVerifier.getProperty(elementPropertyArray[n3].getName(), elementPropertyArray2);
            if (string2 == null) {
                bl = false;
                ClusterConfigsVerifier.printDiff(string + " Property " + elementPropertyArray[n3].getName() + " missing.", 0, n, n2);
                continue;
            }
            if (string3.equals(string2)) continue;
            bl = false;
            ClusterConfigsVerifier.printDiff(string + " Property value different for property " + elementPropertyArray[n3].getName() + "." + " Value is " + string2 + " instead of " + string3, 3, n, n2);
        }
        for (n3 = 0; n3 < elementPropertyArray2.length; ++n3) {
            string3 = elementPropertyArray2[n3].getValue();
            string2 = ClusterConfigsVerifier.getProperty(elementPropertyArray2[n3].getName(), elementPropertyArray);
            if (string2 != null) continue;
            bl = false;
            ClusterConfigsVerifier.printDiff(string + " Property " + elementPropertyArray2[n3].getName() + " extra.", 1, n, n2);
        }
        return bl;
    }

    protected static String getProperty(String string, ElementProperty[] elementPropertyArray) {
        if (elementPropertyArray == null) {
            return null;
        }
        for (int i = 0; i < elementPropertyArray.length; ++i) {
            if (!elementPropertyArray[i].getName().equals(string)) continue;
            return elementPropertyArray[i].getValue();
        }
        return null;
    }

    protected static boolean compareClusterConfiguration(ConfigContext configContext, ConfigContext configContext2) {
        try {
            boolean bl = ClusterConfigsVerifier.compareAvailabilityServiceConfiguration(configContext, configContext2);
            ClusterConfigsVerifier.printDebug(" Availability Service comparison = " + bl);
            boolean bl2 = ClusterConfigsVerifier.compareEjbContainerConfiguration(configContext, configContext2);
            ClusterConfigsVerifier.printDebug(" Ejb container comparison = " + bl2);
            boolean bl3 = ClusterConfigsVerifier.compareWebContainerConfiguration(configContext, configContext2);
            ClusterConfigsVerifier.printDebug(" Web container comparison = " + bl3);
            return bl && bl2 && bl3;
        }
        catch (Exception exception) {
            ClusterConfigsVerifier.printError("Cluster configuration check error", exception);
            return false;
        }
    }

    protected static boolean compareAvailabilityServiceConfiguration(ConfigContext configContext, ConfigContext configContext2) {
        try {
            boolean bl = true;
            Server server = (Server)configContext.getRootConfigBean();
            AvailabilityService availabilityService = server.getAvailabilityService();
            Server server2 = (Server)configContext2.getRootConfigBean();
            AvailabilityService availabilityService2 = server2.getAvailabilityService();
            if (availabilityService.isAvailabilityEnabled() && !availabilityService2.isAvailabilityEnabled() || !availabilityService.isAvailabilityEnabled() && availabilityService2.isAvailabilityEnabled()) {
                bl = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.availability_service_attr_diff", "availabilityEnabled", Boolean.toString(availabilityService2.isAvailabilityEnabled()), Boolean.toString(availabilityService.isAvailabilityEnabled())), 3, 2, 0);
            }
            boolean bl2 = ClusterConfigsVerifier.compareProperties("availability-service:", availabilityService.getElementProperty(), availabilityService2.getElementProperty(), 2);
            boolean bl3 = ClusterConfigsVerifier.compareIiopClusters(availabilityService.getIiopCluster(), availabilityService2.getIiopCluster());
            PersistenceStore persistenceStore = availabilityService.getPersistenceStore();
            PersistenceStore persistenceStore2 = availabilityService2.getPersistenceStore();
            if (persistenceStore == null || persistenceStore2 == null) {
                bl = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.availability_service_pers_store_not_configured"), 3, 2, 0);
            } else {
                String string;
                String string2;
                String string3;
                ElementProperty[] elementPropertyArray = persistenceStore.getElementProperty();
                ElementProperty[] elementPropertyArray2 = persistenceStore2.getElementProperty();
                String string4 = ClusterConfigsVerifier.getProperty("cluster-id", elementPropertyArray);
                if (string4 == null) {
                    bl = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.availability_service_pers_store_not_configured") + "," + localStrings.getString("cladmin.availability_service_cluster_id_not_configured"), 3, 2, 0);
                }
                if ((string3 = ClusterConfigsVerifier.getProperty("cluster-id", elementPropertyArray2)) == null) {
                    bl = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.availability_service_pers_store_not_configured") + "," + localStrings.getString("cladmin.availability_service_cluster_id_not_configured"), 3, 2, 0);
                }
                if (string4 != null && string3 != null && !string4.equals(string3)) {
                    bl = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.availability_service_cluster_id_incorrect", string4, string3), 3, 2, 0);
                }
                if ((string2 = ClusterConfigsVerifier.getProperty("store-pool-jndi-name", elementPropertyArray)) == null) {
                    bl = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.store_jndi_pool_name_not_configured"), 3, 2, 0);
                }
                if ((string = ClusterConfigsVerifier.getProperty("store-pool-jndi-name", elementPropertyArray2)) == null) {
                    bl = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.store_jndi_pool_name_not_configured"), 3, 2, 0);
                }
                if (string2 != null && string != null && !string2.equals(string)) {
                    bl = false;
                    ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.availability_service_hadb_poolname_incorrect", string2, string), 3, 2, 0);
                }
                bl = bl && ClusterConfigsVerifier.compareProperties("persistence-store:", elementPropertyArray, elementPropertyArray2, 2);
            }
            return bl && bl2 && bl3;
        }
        catch (Exception exception) {
            ClusterConfigsVerifier.printError(" Clusters comparison exception ", exception);
            return false;
        }
    }

    protected static boolean compareEjbContainerConfiguration(ConfigContext configContext, ConfigContext configContext2) {
        try {
            boolean bl = true;
            Server server = (Server)configContext.getRootConfigBean();
            EjbContainer ejbContainer = server.getEjbContainer();
            Server server2 = (Server)configContext2.getRootConfigBean();
            EjbContainer ejbContainer2 = server2.getEjbContainer();
            if (ejbContainer == null || ejbContainer2 == null) {
                bl = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.ejb_container_not_configured"), 3, 3, 0);
                return bl;
            }
            String string = "ejb-container.availabilityEnabled ";
            bl = ClusterConfigsVerifier.compareStringAttr(ServerTags.AVAILABILITY_ENABLED, ejbContainer, ejbContainer2, "false", string, 3, bl);
            return bl;
        }
        catch (Exception exception) {
            ClusterConfigsVerifier.printError(" Ejb configuration comparison error ", exception);
            return false;
        }
    }

    protected static boolean compareIiopClusters(IiopCluster iiopCluster, IiopCluster iiopCluster2) {
        try {
            int n;
            boolean bl = true;
            if (iiopCluster != null && iiopCluster2 == null) {
                bl = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.iiop_cluster_not_configured"), 3, 2, 0);
                return bl;
            }
            if (iiopCluster == null && iiopCluster2 == null) {
                bl = true;
                return bl;
            }
            if (iiopCluster2 != null && iiopCluster == null) {
                bl = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.iiop_cluster_not_configured"), 3, 2, 0);
                return bl;
            }
            if (iiopCluster == null || iiopCluster2 == null) {
                bl = false;
                return bl;
            }
            IiopServerInstance[] iiopServerInstanceArray = iiopCluster.getIiopServerInstance();
            IiopServerInstance[] iiopServerInstanceArray2 = iiopCluster2.getIiopServerInstance();
            if (iiopServerInstanceArray == null || iiopServerInstanceArray2 == null) {
                bl = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.iiop_cluster_not_configured"), 3, 2, 0);
                return bl;
            }
            if (iiopServerInstanceArray.length != iiopServerInstanceArray2.length) {
                bl = false;
                ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.iiop_cluster_instances_different"), 3, 2, 0);
            }
            IiopServerInstance iiopServerInstance = null;
            IiopServerInstance iiopServerInstance2 = null;
            for (n = 0; n < iiopServerInstanceArray.length; ++n) {
                String string;
                int n2;
                iiopServerInstance = iiopServerInstanceArray[n];
                iiopServerInstance2 = iiopCluster2.getIiopServerInstanceByName(iiopServerInstance.getName());
                if (iiopServerInstance2 == null) {
                    bl = false;
                    ClusterConfigsVerifier.printDiff("availability-service.iiop-cluster.iiop-server-instance[name=" + iiopServerInstance.getName() + "] ", 0, 2, 0);
                    continue;
                }
                IiopEndpoint[] iiopEndpointArray = iiopServerInstance.getIiopEndpoint();
                IiopEndpoint[] iiopEndpointArray2 = iiopServerInstance2.getIiopEndpoint();
                IiopEndpoint iiopEndpoint = null;
                IiopEndpoint iiopEndpoint2 = null;
                for (n2 = 0; n2 < iiopEndpointArray.length; ++n2) {
                    iiopEndpoint = iiopEndpointArray[n2];
                    iiopEndpoint2 = iiopServerInstance2.getIiopEndpointById(iiopEndpoint.getId());
                    if (iiopEndpoint2 == null) {
                        bl = false;
                        ClusterConfigsVerifier.printDiff("availability-service.iiop-cluster.iiop-server-instance[name=" + iiopServerInstance.getName() + "].iiop-endpoint[id=" + iiopEndpoint.getId() + "] ", 0, 2, 0);
                        continue;
                    }
                    string = "availability-service.iiop-cluster.iiop-server-instance[name=" + iiopServerInstance.getName() + "].iiop-endpoint[id=" + iiopEndpoint.getId() + "]";
                    bl = ClusterConfigsVerifier.compareStringAttr(ServerTags.HOST, iiopEndpoint, iiopEndpoint2, "", string, 2, bl);
                    bl = ClusterConfigsVerifier.compareStringAttr(ServerTags.PORT, iiopEndpoint, iiopEndpoint2, "", string, 2, bl);
                }
                for (n2 = 0; n2 < iiopEndpointArray2.length; ++n2) {
                    iiopEndpoint2 = iiopEndpointArray2[n2];
                    string = iiopEndpoint2.getId();
                    iiopEndpoint = iiopServerInstance.getIiopEndpointById(string);
                    if (iiopEndpoint != null) continue;
                    bl = false;
                    ClusterConfigsVerifier.printDiff("availability-service.iiop-cluster.iiop-server-instance[name=" + iiopServerInstance.getName() + "].iiop-endpoint[id=" + string + "] ", 1, 0, 1);
                }
            }
            for (n = 0; n < iiopServerInstanceArray2.length; ++n) {
                iiopServerInstance2 = iiopServerInstanceArray2[n];
                iiopServerInstance = iiopCluster.getIiopServerInstanceByName(iiopServerInstance2.getName());
                if (iiopServerInstance != null) continue;
                bl = false;
                ClusterConfigsVerifier.printDiff("availability-service.iiop-cluster.iiop-server-instance[name=" + iiopServerInstance2.getName() + "] ", 1, 2, 0);
            }
            return bl;
        }
        catch (Exception exception) {
            ClusterConfigsVerifier.printError(" IIOP Cluster comparison exception ", exception);
            return false;
        }
    }

    protected static boolean compareWebContainerConfiguration(ConfigContext configContext, ConfigContext configContext2) {
        try {
            boolean bl = true;
            Server server = (Server)configContext.getRootConfigBean();
            WebContainer webContainer = server.getWebContainer();
            Server server2 = (Server)configContext2.getRootConfigBean();
            WebContainer webContainer2 = server2.getWebContainer();
            boolean bl2 = true;
            if (webContainer == null || webContainer2 == null) {
                bl = false;
                ClusterConfigsVerifier.printDiff("web-container not configured . ", 3, 4, 0);
                return bl;
            }
            String string = "web-container";
            bl2 = ClusterConfigsVerifier.compareStringAttr(ServerTags.AVAILABILITY_ENABLED, webContainer, webContainer2, "", string, 4, bl);
            bl = bl && bl2;
            bl2 = ClusterConfigsVerifier.compareProperties("web-container:", webContainer.getElementProperty(), webContainer2.getElementProperty(), 4);
            bl = bl && bl2;
            SessionConfig sessionConfig = webContainer.getSessionConfig();
            SessionConfig sessionConfig2 = webContainer2.getSessionConfig();
            if (sessionConfig == null) {
                if (sessionConfig2 != null) {
                    bl = false;
                    ClusterConfigsVerifier.printDiff("web-container/session-config not configured in master . ", 3, 4, 0);
                    return bl;
                }
            } else {
                if (sessionConfig2 == null) {
                    bl = false;
                    ClusterConfigsVerifier.printDiff("web-container/session-config not configured . ", 3, 4, 0);
                    return bl;
                }
                SessionProperties sessionProperties = sessionConfig.getSessionProperties();
                SessionProperties sessionProperties2 = sessionConfig2.getSessionProperties();
                if (sessionProperties == null) {
                    if (sessionProperties2 != null) {
                        bl = false;
                        ClusterConfigsVerifier.printDiff("web-container/session-config/session-properties not configured in master. ", 3, 4, 0);
                    }
                } else if (sessionProperties2 == null) {
                    bl = false;
                    ClusterConfigsVerifier.printDiff("web-container/session-config/session-properties not configured . ", 3, 4, 0);
                } else {
                    bl2 = ClusterConfigsVerifier.compareProperties("web-container/session-config/session-properties: ", sessionProperties.getElementProperty(), sessionProperties2.getElementProperty(), 4);
                    bl = bl && bl2;
                }
                SessionManager sessionManager = sessionConfig.getSessionManager();
                SessionManager sessionManager2 = sessionConfig2.getSessionManager();
                if (sessionManager == null) {
                    if (sessionManager2 != null) {
                        bl = false;
                        ClusterConfigsVerifier.printDiff("web-container/session-config/session-manager not configured in master. ", 3, 4, 0);
                        return bl;
                    }
                } else if (sessionManager2 == null) {
                    bl = false;
                    ClusterConfigsVerifier.printDiff("web-container/session-config/session-manager not configured . ", 3, 4, 0);
                } else {
                    String string2 = sessionManager.getPersistenceType();
                    String string3 = sessionManager2.getPersistenceType();
                    if (string2 == null) {
                        if (string3 != null) {
                            bl = false;
                            ClusterConfigsVerifier.printDiff("web-container/session-config/session-manager[persistenceType]  not configured in master. ", 3, 4, 0);
                        }
                    } else if (string3 == null) {
                        if (string2 != null) {
                            bl = false;
                            ClusterConfigsVerifier.printDiff("web-container/session-config/session-manager[persistenceType]  not configured in master. ", 3, 4, 0);
                        }
                    } else if (!string2.equals(string3)) {
                        bl = false;
                        ClusterConfigsVerifier.printDiff("web-container/session-config/session-manager[persistenceType] incorrectly set.  ", 3, 4, 0);
                    }
                    ManagerProperties managerProperties = sessionManager.getManagerProperties();
                    ManagerProperties managerProperties2 = sessionManager2.getManagerProperties();
                    if (managerProperties != null && managerProperties2 != null) {
                        bl2 = ClusterConfigsVerifier.compareProperties("web-container/session-manager/manager-properties: ", managerProperties.getElementProperty(), managerProperties2.getElementProperty(), 4);
                        bl = bl && bl2;
                    } else if (managerProperties == null && managerProperties2 != null) {
                        bl = false;
                        ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.properties_not_configured", "web-container/session-manager/manager-properties"), 3, 4, 0);
                    } else if (managerProperties != null && managerProperties2 == null) {
                        bl = false;
                        ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.properties_not_configured", "web-container/session-manager/manager-properties"), 3, 4, 0);
                    }
                    StoreProperties storeProperties = sessionManager.getStoreProperties();
                    StoreProperties storeProperties2 = sessionManager2.getStoreProperties();
                    if (storeProperties != null && storeProperties2 != null) {
                        bl2 = ClusterConfigsVerifier.compareProperties("web-container/session-manager/store-properties: ", storeProperties.getElementProperty(), storeProperties2.getElementProperty(), 4);
                        bl = bl && bl2;
                    } else if (storeProperties == null && storeProperties2 != null) {
                        bl = false;
                        ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.properties_not_configured", "web-container/session-manager/store-properties"), 3, 4, 0);
                    } else if (storeProperties != null && storeProperties2 == null) {
                        bl = false;
                        ClusterConfigsVerifier.printDiff(localStrings.getString("cladmin.properties_not_configured", "web-container/session-manager/store-properties"), 3, 4, 0);
                    }
                }
            }
            return bl;
        }
        catch (Exception exception) {
            ClusterConfigsVerifier.printError(" Web container configuration comparison error ", exception);
            return false;
        }
    }

    protected static boolean compareStringAttr(String string, ConfigBean configBean, ConfigBean configBean2, String string2, String string3, int n, boolean bl) {
        String string4;
        String string5;
        boolean bl2 = bl;
        String string6 = string5 = configBean.getAttributeValue(string);
        if (string5 == null) {
            string5 = string2;
            string6 = string2 + " (default value) ";
        }
        String string7 = string4 = configBean2.getAttributeValue(string);
        if (string4 == null) {
            string4 = string2;
            string7 = string2 + " (default value) ";
        }
        if (!string5.equals(string4)) {
            bl2 = false;
            ClusterConfigsVerifier.printDiff(string3 + "." + string + " is incorrectly set to " + string7 + " instead of " + string6, 2, n, 0);
        }
        return bl2;
    }

    protected static boolean compareBooleanAttr(String string, ConfigBean configBean, ConfigBean configBean2, boolean bl, String string2, int n, boolean bl2) {
        boolean bl3 = bl2;
        boolean bl4 = ConfigBean.toBoolean(configBean.getAttributeValue(string));
        boolean bl5 = ConfigBean.toBoolean(configBean2.getAttributeValue(string));
        if (!(!bl4 && !bl5 || bl4 && bl5)) {
            bl3 = false;
            ClusterConfigsVerifier.printDiff(string2 + string + " is incorrectly set to " + bl5, 2, n, 0);
        }
        return bl3;
    }

    public int getErrorsCount() {
        return errors;
    }

    public int getWarningsCount() {
        return warnings;
    }

    protected static void printDiff(String string, int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                ClusterConfigsVerifier.printDiff("  ERROR   :   ");
                ++errors;
                break;
            }
            case 1: {
                ClusterConfigsVerifier.printDiff("  WARNING : ");
                ++warnings;
                break;
            }
            default: {
                ClusterConfigsVerifier.printDiff(" UNKNOWN_SEVERITY_TYPE : ");
            }
        }
        ClusterConfigsVerifier.printDiff(string);
        ClusterConfigsVerifier.printDiff(" ( ");
        switch (n) {
            case 0: {
                ClusterConfigsVerifier.printDiff(" MISSING_CONFIGURATION ");
                break;
            }
            case 1: {
                ClusterConfigsVerifier.printDiff(" EXTRA_CONFIGURATION ");
                break;
            }
            case 2: {
                ClusterConfigsVerifier.printDiff(" ATTR_VALUE_DIFFERS ");
                break;
            }
            case 3: {
                ClusterConfigsVerifier.printDiff(" DIFFERENT_CONFIGURATION ");
                break;
            }
            default: {
                ClusterConfigsVerifier.printDiff(" UNKNOWN_CONFIGURATION_DIFF_TYPE ");
            }
        }
        switch (n2) {
            case 0: {
                ClusterConfigsVerifier.printDiff(" APPLICATION ");
                break;
            }
            case 1: {
                ClusterConfigsVerifier.printDiff(" RESOURCE ");
                break;
            }
            case 2: {
                ClusterConfigsVerifier.printDiff(" AVAILABILITY-SERVICE ");
                break;
            }
            case 3: {
                ClusterConfigsVerifier.printDiff(" EJB-CONTAINER ");
                break;
            }
            case 4: {
                ClusterConfigsVerifier.printDiff(" WEB-CONTAINER ");
                break;
            }
            default: {
                ClusterConfigsVerifier.printDiff(" UNKNOWN_J2EE_OBJECT_TYPE ");
            }
        }
        ClusterConfigsVerifier.printDiff(" ) ");
        ClusterConfigsVerifier.printDiff("\n");
    }

    protected static void printDiff(String string) {
        System.out.print(string);
    }

    protected static void printError(String string, Exception exception) {
        System.out.println(string);
        System.out.println("\t" + exception);
        System.out.println("\t" + exception.getMessage());
        exception.printStackTrace();
    }

    protected static void printDebug(String string) {
        if (debugOn == null || debugOn.length() == 0) {
            return;
        }
        System.out.println("\t\tDEBUG O/P\t" + string);
    }
}

