/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.clusterutil;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public class ClResourceFileReader {
    String resourceFile = null;
    Hashtable sections;
    String dbName = null;
    String poolName = null;
    String resourceName = null;

    public ClResourceFileReader(String string) {
        this.resourceFile = string;
        this.sections = new Hashtable();
        this.setResourcesInfo(string);
    }

    private String parseSection(BufferedReader bufferedReader, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = null;
        String string2 = null;
        String string3 = null;
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("[") && string2.endsWith("]")) {
                    string3 = string2;
                    break;
                }
                if (string2.startsWith("#") || (stringArray = this.splitString(string2)) == null) continue;
                hashMap.put(stringArray[0], stringArray[1]);
                if (string.equals("hadbInfo")) {
                    this.dbName = stringArray[0];
                }
                if (string.equals("jdbcPool")) {
                    this.poolName = stringArray[0];
                }
                if (!string.equals("jdbcResource")) continue;
                this.resourceName = stringArray[0];
            }
            this.sections.put(string, hashMap);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string3;
    }

    private void setResourcesInfo(String string) {
        String string2 = null;
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf("[HADBINFO]") != -1) {
                    string2 = this.parseSection(bufferedReader, "hadbInfo");
                }
                if (string2.indexOf("[SESSION_STORE]") != -1) {
                    string2 = this.parseSection(bufferedReader, "sessionStore");
                }
                if (string2.indexOf("[JDBC_CONNECTION_POOL]") != -1) {
                    string2 = this.parseSection(bufferedReader, "jdbcPool");
                    System.out.println("::pool name is " + this.poolName);
                }
                if (string2.indexOf("[JDBC_RESOURCE]") != -1) {
                    string2 = this.parseSection(bufferedReader, "jdbcResource");
                }
                if (string2.indexOf("[SESSION_PERSISTENCE]") != -1) {
                    string2 = this.parseSection(bufferedReader, "sessionPersistence");
                }
                if (string2.indexOf("[EJB_FAILOVER]") != -1) {
                    string2 = this.parseSection(bufferedReader, "ejbFailover");
                }
                if (string2.indexOf("[RMI_IIOP_FAILOVER]") != -1) {
                    string2 = this.parseSection(bufferedReader, "rmiIiopFO");
                }
                if (string2.indexOf("[CLUSTER_ID]") == -1) continue;
                string2 = this.parseSection(bufferedReader, "clusterId");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File Not Found: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.err.println("IO Exception raised: " + iOException);
        }
    }

    public String getAttributeValue(String string, String string2) {
        Hashtable hashtable = this.getSections();
        HashMap hashMap = (HashMap)hashtable.get(string);
        return (String)hashMap.get(string2);
    }

    private String[] splitString(String string) {
        if (string != null && !string.equals("")) {
            String[] stringArray = string.split("[\\s]+");
            if (stringArray.length == 1) {
                return new String[]{stringArray[0], ""};
            }
            if (stringArray[1].equals("REPLACEDIR")) {
                stringArray[1] = System.getProperty("java.io.tmpdir");
            }
            return stringArray;
        }
        return null;
    }

    private Hashtable getSections() {
        return this.sections;
    }

    private String getDbName() {
        return this.dbName;
    }

    private String getPoolName() {
        return this.poolName;
    }

    private String getResourceName() {
        return this.resourceName;
    }

    private String getSectionInfo(String string) {
        Hashtable hashtable = this.getSections();
        HashMap hashMap = (HashMap)hashtable.get(string);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)hashMap.get(string2);
            if (string.equals("hadbInfo")) {
                if (!string3.equals("")) {
                    stringBuffer.append("--" + string2 + "=" + string3);
                } else if (!string2.equals(this.dbName)) {
                    stringBuffer.append(string2);
                }
            } else {
                System.out.println("::key = " + string2 + " value = " + string3);
                if (string2.startsWith("--")) {
                    stringBuffer.append(string2);
                } else if (!string3.equals("")) {
                    stringBuffer.append("--" + string2 + " " + string3);
                } else if (!string2.equals(this.poolName)) {
                    System.out.println("::appending to " + stringBuffer + " value " + string2);
                    stringBuffer.append(string2);
                }
            }
            stringBuffer.append(" ");
        }
        if (string.equals("hadbInfo")) {
            stringBuffer.append(this.dbName);
        }
        if (string.equals("jdbcPool")) {
            stringBuffer.append(this.poolName);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        ClResourceFileReader clResourceFileReader = new ClResourceFileReader(stringArray[0]);
        System.out.println("set hadbInfo=" + clResourceFileReader.getSectionInfo("hadbInfo"));
        System.out.println("set sessionStoreInfo=" + clResourceFileReader.getSectionInfo("sessionStore"));
        System.out.println("set jdbcPool=" + clResourceFileReader.getSectionInfo("jdbcPool"));
        System.out.println("set sessionPersistence=" + clResourceFileReader.getSectionInfo("sessionPersistence"));
        System.out.println("set dbName=" + clResourceFileReader.getDbName());
        System.out.println("set poolName=" + clResourceFileReader.getPoolName());
        System.out.println("set resourceName=" + clResourceFileReader.getResourceName());
        System.out.println("set sessionStoreresourceName=" + clResourceFileReader.getResourceName());
        System.out.println("set sfsb=" + clResourceFileReader.getAttributeValue("ejbFailover", "sfsb"));
        System.out.println("set clusterId=" + clResourceFileReader.getAttributeValue("clusterId", "cluster_id"));
        System.out.println("set rmiIiop=" + clResourceFileReader.getAttributeValue("rmiIiopFO", "rmi_iiop"));
        System.out.println("set hosts=" + clResourceFileReader.getAttributeValue("hadbInfo", "hosts"));
        System.out.println("set HADBM_ADMINPASSWORD=" + clResourceFileReader.getAttributeValue("hadbInfo", "adminpassword"));
    }
}

