/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.clusterutil;

import com.iplanet.ias.admin.clusterutil.ClInstance;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ClInstanceFileReader {
    String instanceConf = null;
    Vector instances;
    ClInstance clinstance;
    int count = 0;

    public ClInstanceFileReader(String string) {
        this.instanceConf = string;
        this.instances = new Vector();
        this.setInstancesInfo(string);
    }

    private Vector getInstances() {
        return this.instances;
    }

    private void setInstanceAsMaster(String string) {
        ClInstance clInstance = new ClInstance(string);
        clInstance.setMaster();
    }

    private void setInstancesInfo(String string) {
        String string2 = null;
        ClInstance clInstance = null;
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf("instancename ") == -1) continue;
                clInstance = new ClInstance(string2.replaceAll("instancename\\s+", ""));
                clInstance.setInstanceName(string2.replaceAll("instancename\\s+", ""));
                for (int i = 0; i < 5; ++i) {
                    String string3 = bufferedReader.readLine();
                    if (string3.indexOf("user ") != -1) {
                        clInstance.setUser(string3.replaceAll("user\\s+", ""));
                    }
                    if (string3.indexOf("host ") != -1) {
                        clInstance.setHost(string3.replaceAll("host\\s+", ""));
                    }
                    if (string3.matches("^port.*")) {
                        clInstance.setPort(string3.replaceAll("port\\s+", ""));
                    }
                    if (string3.indexOf("domain ") != -1) {
                        clInstance.setDomain(string3.replaceAll("domain\\s+", ""));
                    }
                    if (string3.indexOf("instanceport ") != -1) {
                        clInstance.setInstancePort(string3.replaceAll("instanceport\\s+", ""));
                    }
                    if (string3.indexOf("master ") == -1) continue;
                    clInstance.setMaster();
                }
                this.addInstance(clInstance);
            }
            System.out.println("reached end of line");
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File Not Found: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.err.println("IO Exception raised: " + iOException);
        }
    }

    private void addInstance(ClInstance clInstance) {
        if (clInstance != null) {
            this.instances.add(clInstance);
        }
    }

    private void createInstancesConfFile(String string) {
        try {
            Vector vector = this.getInstances();
            Enumeration enumeration = vector.elements();
            FileWriter fileWriter = new FileWriter(string);
            while (enumeration.hasMoreElements()) {
                ClInstance clInstance = (ClInstance)enumeration.nextElement();
                String string2 = clInstance.getInstanceInfo();
                fileWriter.write(string2);
                fileWriter.write(System.getProperty("line.separator"));
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File Not Found: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.err.println("IO Exception raised: " + iOException);
        }
    }

    private void createMasterConfFile(String string) {
        boolean bl = false;
        try {
            ClInstance clInstance;
            Vector vector = this.getInstances();
            Enumeration enumeration = vector.elements();
            FileWriter fileWriter = new FileWriter(string);
            while (enumeration.hasMoreElements()) {
                clInstance = (ClInstance)enumeration.nextElement();
                if (!clInstance.isMaster()) continue;
                bl = true;
                fileWriter.write(clInstance.getInstanceInfo());
            }
            if (!bl) {
                clInstance = (ClInstance)vector.elementAt(0);
                clInstance.setMaster();
                fileWriter.write(clInstance.getInstanceInfo());
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File Not Found: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.err.println("IO Exception raised: " + iOException);
        }
    }

    public static void main(String[] stringArray) {
        ClInstanceFileReader clInstanceFileReader = new ClInstanceFileReader(stringArray[0]);
        if (stringArray[1].equals("createInstancesConfFile")) {
            clInstanceFileReader.createInstancesConfFile(stringArray[2]);
        }
        if (stringArray[1].equals("createMasterConfFile")) {
            clInstanceFileReader.createMasterConfFile(stringArray[2]);
        }
    }
}

