/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.audit;

import com.iplanet.ias.admin.audit.ASAuditEvent;
import com.iplanet.ias.admin.audit.ASAuditException;
import com.iplanet.ias.admin.audit.ASAuditSession;
import com.sun.audit.AuditSession;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class SolarisAuditSession
implements ASAuditSession {
    static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final String[] EVENT_TABLE_IF = new String[]{"com.iplanet.ias.admin.audit.ASAuditEvent_Login", "com.iplanet.ias.admin.audit.ASAuditEvent_Logout", "com.iplanet.ias.admin.audit.ASAuditEvent_Modify"};
    private static final String[] EVENT_TABLE_IMPL = new String[]{"com.iplanet.ias.admin.audit.SolarisAuditEvent_Login", "com.iplanet.ias.admin.audit.SolarisAuditEvent_Logout", "com.iplanet.ias.admin.audit.SolarisAuditEvent_Modify"};
    private static final String USER_ROLE_PRINCIPAL_CLASS_NAME = "com.sun.management.services.authentication.UserRolePrincipal";
    private static final String AUDIT_TYPE_SOLARIS = "Solaris";
    private static final String UNKNOWN = "unknown";
    private AuditSession auditSession = null;
    private String prefix = "Audit(Solaris): ";
    private String username = null;
    private String rolename = null;
    private String hostname = null;
    private int portnum = 0;

    public SolarisAuditSession() {
        this(AUDIT_TYPE_SOLARIS, null);
    }

    public SolarisAuditSession(String string) {
        this(string, null);
    }

    public SolarisAuditSession(String string, byte[] byArray) {
        try {
            this.auditSession = new AuditSession(byArray);
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, this.prefix + "error creating audit session: " + throwable.getMessage());
        }
        if (this.auditSession != null && !this.auditSession.auditOn()) {
            this.auditSession = null;
            logger.log(Level.INFO, this.prefix + "auditing subsystem unavailable");
        }
    }

    public Object getPlatformAuditSession() throws ASAuditException {
        return this.auditSession;
    }

    public String getSessionId() throws ASAuditException {
        if (this.auditSession == null) {
            return null;
        }
        String string = null;
        try {
            string = this.auditSession.getSessionId();
        }
        catch (Exception exception) {
            throw new ASAuditException("audit_err_09", exception.getLocalizedMessage());
        }
        return string;
    }

    public boolean isAuditOn() {
        if (this.auditSession == null) {
            return false;
        }
        return this.auditSession.auditOn();
    }

    public byte[] exportSession() throws ASAuditException {
        if (this.auditSession == null) {
            return null;
        }
        byte[] byArray = null;
        try {
            byArray = this.auditSession.exportSession();
        }
        catch (Exception exception) {
            throw new ASAuditException("audit_err_10", exception.getLocalizedMessage());
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentity(Subject subject, String string, int n) {
        if (this.auditSession == null) {
            return;
        }
        Object var4_4 = null;
        Object var5_5 = null;
        int n2 = 0;
        int n3 = 1;
        int n4 = -1;
        int n5 = -1;
        SolarisAuditSession solarisAuditSession = this;
        synchronized (solarisAuditSession) {
            this.auditSession.setUser(n2, n3, n2, n3, string, 0);
            if (var5_5 != null) {
                this.auditSession.setUser(n4, n5, n4, n5, string, 1);
            }
            this.username = var4_4;
            this.rolename = var5_5;
            this.hostname = string;
            this.portnum = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserName() {
        String string;
        String string2;
        SolarisAuditSession solarisAuditSession = this;
        synchronized (solarisAuditSession) {
            string2 = this.username;
            string = this.rolename;
        }
        if (string2 != null) {
            if (string != null) {
                string2 = string + "(" + string2 + ")";
            }
        } else {
            string2 = UNKNOWN;
        }
        return string2;
    }

    public ASAuditEvent getAuditEvent(String string) throws ASAuditException {
        Class clazz = this.getAuditEventClass(string);
        ASAuditEvent aSAuditEvent = null;
        try {
            Class[] classArray = new Class[]{ASAuditSession.class};
            Object[] objectArray = new Object[]{this};
            Constructor constructor = clazz.getConstructor(classArray);
            aSAuditEvent = (ASAuditEvent)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            logger.log(Level.WARNING, this.prefix + "new event constructor error: " + throwable.getMessage());
            throw new ASAuditException("audit_err_06", string, throwable.getMessage());
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, this.prefix + "new event unexpected error: " + exception.getMessage());
            throw new ASAuditException("audit_err_06", string, exception.getMessage());
        }
        return aSAuditEvent;
    }

    public void setLabel(String string) throws ASAuditException {
        logger.log(Level.FINE, this.prefix + "setting security label!");
    }

    public void dispose() {
        logger.log(Level.FINE, this.prefix + "clean up session");
        this.auditSession = null;
    }

    private Class getAuditEventClass(String string) throws ASAuditException {
        String string2 = null;
        if (string != null) {
            for (int i = 0; i < EVENT_TABLE_IF.length; ++i) {
                if (!string.equals(EVENT_TABLE_IF[i])) continue;
                string2 = EVENT_TABLE_IMPL[i];
                break;
            }
        }
        if (string2 == null) {
            String string3 = string == null ? "null" : string;
            logger.log(Level.WARNING, this.prefix + "unsupported event: " + string3);
            throw new ASAuditException("audit_err_07", string3);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, this.prefix + "event class not found: " + string2);
            throw new ASAuditException("audit_err_08", string2);
        }
        return clazz;
    }
}

