/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.audit;

import com.iplanet.ias.admin.audit.ASAuditEvent;
import com.iplanet.ias.admin.audit.ASAuditException;
import com.iplanet.ias.admin.audit.ASAuditSession;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class LogAuditSession
implements ASAuditSession {
    private static final String UNKNOWN = "unknown";
    private static final String HEADER = "asadmin_audit_event";
    private static final String SUCCESS = "succeeded";
    private static final String FAILURE = "failed";
    private static final String SEPARATOR = " : ";
    private static final String RESOURCE_BUNDLE = "com.iplanet.ias.admin.audit.resources.Resources";
    private static final String AUDIT_TYPE_LOG = "Log";
    private static final String AUDIT_TYPE_NONE = "None";
    private static long auditbase = System.currentTimeMillis();
    private static final String[] EVENT_TABLE_IF = new String[]{"com.iplanet.ias.admin.audit.ASAuditEvent_Login", "com.iplanet.ias.admin.audit.ASAuditEvent_Logout", "com.iplanet.ias.admin.audit.ASAuditEvent_Modify"};
    private static final String[] EVENT_TABLE_IMPL = new String[]{"com.iplanet.ias.admin.audit.LogAuditEvent_Login", "com.iplanet.ias.admin.audit.LogAuditEvent_Logout", "com.iplanet.ias.admin.audit.LogAuditEvent_Modify"};
    private String audittype = null;
    private Logger logger = null;
    private ResourceBundle auditprb = null;
    private String auditid = null;
    private String prefix = null;
    private String username = null;
    private String rolename = null;
    private String hostname = null;
    private int portnum = 0;
    private boolean auditon = false;

    public LogAuditSession() {
        this(AUDIT_TYPE_LOG);
    }

    public LogAuditSession(String string) {
        this.audittype = string;
        if (string == null) {
            this.audittype = AUDIT_TYPE_NONE;
        }
        this.auditon = true;
        this.auditid = this.getNextAuditId();
        this.auditprb = this.getResourceBundle(null);
        this.prefix = "Audit(" + this.audittype + "): ";
        this.logger = Logger.getLogger("javax.enterprise.system.tools.admin");
        if (this.logger == null) {
            this.auditon = false;
            this.logger.log(Level.WARNING, this.prefix + "logging subsytem unavailable");
        }
    }

    public Object getPlatformAuditSession() throws ASAuditException {
        return this.logger;
    }

    public String getSessionId() throws ASAuditException {
        String string = null;
        if (this.auditon) {
            string = this.auditid;
        }
        return string;
    }

    public boolean isAuditOn() {
        return this.auditon;
    }

    public byte[] exportSession() throws ASAuditException {
        byte[] byArray = null;
        if (this.auditon) {
            String string = this.getAuditInfo();
            try {
                byArray = string.getBytes("UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentity(Subject subject, String string, int n) {
        if (!this.auditon) {
            return;
        }
        String string2 = "root";
        Object var5_5 = null;
        LogAuditSession logAuditSession = this;
        synchronized (logAuditSession) {
            this.username = string2;
            this.rolename = var5_5;
            this.hostname = string;
            this.portnum = n;
        }
        this.logger.log(Level.FINE, this.prefix + "set identity: " + this.getAuditInfo());
    }

    public ASAuditEvent getAuditEvent(String string) throws ASAuditException {
        Class clazz = this.getAuditEventClass(string);
        ASAuditEvent aSAuditEvent = null;
        try {
            Class[] classArray = new Class[]{ASAuditSession.class};
            Object[] objectArray = new Object[]{this};
            Constructor constructor = clazz.getConstructor(classArray);
            aSAuditEvent = (ASAuditEvent)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            this.logger.log(Level.WARNING, this.prefix + "new event constructor error: " + throwable.getMessage());
            throw new ASAuditException("audit_err_06", string, throwable.getMessage());
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, this.prefix + "new event unexpected error: " + exception.getMessage());
            throw new ASAuditException("audit_err_06", string, exception.getMessage());
        }
        return aSAuditEvent;
    }

    public void setLabel(String string) throws ASAuditException {
        this.logger.log(Level.FINE, this.prefix + "wrote a security label!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserName() {
        String string;
        String string2;
        LogAuditSession logAuditSession = this;
        synchronized (logAuditSession) {
            string2 = this.username;
            string = this.rolename;
        }
        if (string2 != null) {
            if (string != null) {
                string2 = string + "(" + string2 + ")";
            }
        } else {
            string2 = UNKNOWN;
        }
        return string2;
    }

    public void dispose() {
        this.logger.log(Level.FINE, this.prefix + "clean up session " + this.auditid);
    }

    public void putEvent(String string, String string2, int n) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(this.getLocalizedResource(HEADER));
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.auditid);
        stringBuffer.append(SEPARATOR);
        if (string == null) {
            stringBuffer.append(UNKNOWN);
        } else {
            stringBuffer.append(string);
        }
        stringBuffer.append(" ");
        if (n == 0) {
            stringBuffer.append(this.getLocalizedResource(SUCCESS));
        } else {
            stringBuffer.append(this.getLocalizedResource(FAILURE));
        }
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.getUserName());
        stringBuffer.append(SEPARATOR);
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        String string3 = stringBuffer.toString();
        if (this.audittype.equals(AUDIT_TYPE_LOG)) {
            this.logger.log(Level.INFO, string3);
        } else {
            this.logger.log(Level.FINE, this.prefix + string3);
        }
    }

    String getLocalizedMessage(String string, String[] stringArray) {
        String string2 = null;
        string2 = string != null ? MessageFormat.format(this.getLocalizedResource(string), stringArray) : "null";
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNextAuditId() {
        long l = 0L;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            l = auditbase++;
        }
        return Long.toString(l);
    }

    private Class getAuditEventClass(String string) throws ASAuditException {
        String string2 = null;
        if (string != null) {
            for (int i = 0; i < EVENT_TABLE_IF.length; ++i) {
                if (!string.equals(EVENT_TABLE_IF[i])) continue;
                string2 = EVENT_TABLE_IMPL[i];
                break;
            }
        }
        if (string2 == null) {
            String string3 = string == null ? "null" : string;
            this.logger.log(Level.WARNING, this.prefix + "unsupported event: " + string3);
            throw new ASAuditException("audit_err_07", string3);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, this.prefix + "event class not found: " + string2);
            throw new ASAuditException("audit_err_08", string2);
        }
        return clazz;
    }

    private String getLocalizedResource(String string) {
        String string2 = null;
        try {
            string2 = this.auditprb.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle resourceBundle = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ClassLoader classLoader = this.getResourceClassLoader();
        try {
            resourceBundle = classLoader == null ? ResourceBundle.getBundle(RESOURCE_BUNDLE, locale) : ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, classLoader);
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, this.prefix + "error getting resources: " + exception.getMessage());
        }
        return resourceBundle;
    }

    private ClassLoader getResourceClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = this.getClass().getClassLoader();
        }
        catch (Exception exception) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    private String getAuditInfo() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(this.auditid);
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.getUserName());
        stringBuffer.append(SEPARATOR);
        if (this.hostname != null) {
            stringBuffer.append(this.hostname);
        } else {
            stringBuffer.append(UNKNOWN);
        }
        stringBuffer.append(SEPARATOR);
        if (this.portnum > 0) {
            stringBuffer.append(this.portnum);
        } else {
            stringBuffer.append(UNKNOWN);
        }
        return stringBuffer.toString();
    }
}

