/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.audit;

import com.iplanet.ias.admin.audit.ASAuditException;
import com.iplanet.ias.admin.audit.ASAuditSession;
import com.iplanet.ias.admin.common.ASConfiguration;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ASAuditService {
    static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    public static String GLOBAL_AUDITSESS = "s1asauditkey";
    private static final String AUDIT_DEFAULT_TYPE_PROP = "audit.default.type";
    private static final String AUDIT_CLASS_FAIL_PROP = "audit.class.fail";
    private static final String AUDIT_CLASS_NAME_PART1 = "audit.";
    private static final String AUDIT_CLASS_NAME_PART2 = ".class";
    private static final String AUDIT_FAIL_FAIL = "fail";
    private static final String AUDIT_TYPE_DFLT = "None";
    private static final String AUDIT_CLASS_DFLT = "com.iplanet.ias.admin.audit.LogAuditSession";
    private static final String AUDIT_FAIL_DFLT = "default";
    private static HashMap auditTable = new HashMap();
    private static String auditType = null;
    private static String auditFail = null;
    private static boolean auditDflt = false;
    private static String auditSessionClassName = null;
    private static Class auditSessionClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ASAuditSession getAuditSession(String string) throws ASAuditException {
        ASAuditService.getAuditSessionType();
        ASAuditService.getAuditSessionFail();
        Class clazz = ASAuditService.getAuditSessionClass(auditType, auditFail);
        ASAuditSession aSAuditSession = null;
        HashMap hashMap = auditTable;
        synchronized (hashMap) {
            if (string != null && (aSAuditSession = (ASAuditSession)auditTable.get(string)) != null) {
                return aSAuditSession;
            }
            aSAuditSession = ASAuditService.createAuditSession(auditType, clazz);
            if (string != null) {
                auditTable.put(string, aSAuditSession);
            }
        }
        return aSAuditSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAuditSession(String string) {
        HashMap hashMap = auditTable;
        synchronized (hashMap) {
            if (string != null) {
                auditTable.remove(string);
            }
        }
    }

    private static synchronized void getAuditSessionType() {
        if (auditType == null && (auditType = ASConfiguration.getProperty((String)AUDIT_DEFAULT_TYPE_PROP)) == null) {
            auditType = AUDIT_TYPE_DFLT;
            auditDflt = true;
        }
    }

    private static synchronized void getAuditSessionFail() {
        if (auditFail == null && (auditFail = ASConfiguration.getProperty((String)AUDIT_CLASS_FAIL_PROP)) == null) {
            auditFail = AUDIT_FAIL_DFLT;
        }
    }

    private static ASAuditSession createAuditSession(String string, Class clazz) throws ASAuditException {
        ASAuditSession aSAuditSession = null;
        try {
            Class[] classArray = new Class[]{String.class};
            Object[] objectArray = new Object[]{string};
            Constructor constructor = clazz.getConstructor(classArray);
            aSAuditSession = (ASAuditSession)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            logger.log(Level.FINE, "Audit: session constructor error: " + throwable.getMessage());
            ASAuditException aSAuditException = new ASAuditException("audit_err_02", throwable.getLocalizedMessage());
            logger.log(Level.WARNING, aSAuditException.getLocalizedMessage());
            throw aSAuditException;
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Audit: error creating session: " + exception.getMessage());
            ASAuditException aSAuditException = new ASAuditException("audit_err_02", exception.getLocalizedMessage());
            logger.log(Level.WARNING, aSAuditException.getLocalizedMessage());
            throw aSAuditException;
        }
        return aSAuditSession;
    }

    private static synchronized Class getAuditSessionClass(String string, String string2) throws ASAuditException {
        Object object;
        if (auditSessionClass != null) {
            return auditSessionClass;
        }
        if (!auditDflt && (auditSessionClassName = ASConfiguration.getProperty((String)(object = AUDIT_CLASS_NAME_PART1 + string + AUDIT_CLASS_NAME_PART2))) == null) {
            logger.log(Level.FINE, "Audit: error reading " + string + " audit session class name");
            ASAuditException aSAuditException = new ASAuditException("audit_err_03", string);
            logger.log(Level.WARNING, aSAuditException.getLocalizedMessage());
            if (string2 != null && string2.equals(AUDIT_FAIL_FAIL)) {
                throw aSAuditException;
            }
        }
        if (auditSessionClassName == null) {
            auditDflt = true;
            auditType = AUDIT_TYPE_DFLT;
            auditSessionClassName = AUDIT_CLASS_DFLT;
        }
        if (ASAuditService.loadAuditSessionClass(auditSessionClassName, string2)) {
            return auditSessionClass;
        }
        if (!auditDflt) {
            auditDflt = true;
            auditType = AUDIT_TYPE_DFLT;
            auditSessionClassName = AUDIT_CLASS_DFLT;
            if (ASAuditService.loadAuditSessionClass(auditSessionClassName, AUDIT_FAIL_FAIL)) {
                return auditSessionClass;
            }
        }
        logger.log(Level.FINE, "Audit: error loading any audit session class");
        object = new ASAuditException("audit_err_04");
        logger.log(Level.WARNING, object.getLocalizedMessage());
        throw object;
    }

    private static boolean loadAuditSessionClass(String string, String string2) throws ASAuditException {
        boolean bl;
        block2: {
            bl = false;
            try {
                auditSessionClass = Class.forName(string);
                bl = true;
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "Audit: audit session class " + string + " not found");
                ASAuditException aSAuditException = new ASAuditException("audit_err_05", string);
                logger.log(Level.WARNING, aSAuditException.getLocalizedMessage());
                if (string2 == null || !string2.equals(AUDIT_FAIL_FAIL)) break block2;
                throw aSAuditException;
            }
        }
        return bl;
    }
}

