function Startup()
{
  DoEnabling();
}

function DoEnabling()
{
  var i;
  var ftp = document.getElementById("networkProxyFTP");
  var ftpPort = document.getElementById("networkProxyFTP_Port");
  var gopher = document.getElementById("networkProxyGopher");
  var gopherPort = document.getElementById("networkProxyGopher_Port");
  var http = document.getElementById("networkProxyHTTP");
  var httpPort = document.getElementById("networkProxyHTTP_Port");
  var socks = document.getElementById("networkProxySOCKS");
  var socksPort = document.getElementById("networkProxySOCKS_Port");
  var socksVersion = document.getElementById("networkProxySOCKSVersion");
  var socksVersion4 = document.getElementById("networkProxySOCKSVersion4");
  var socksVersion5 = document.getElementById("networkProxySOCKSVersion5");
  var ssl = document.getElementById("networkProxySSL");
  var sslPort = document.getElementById("networkProxySSL_Port");
  var noProxy = document.getElementById("networkProxyNone");
  var autoURL = document.getElementById("networkProxyAutoconfigURL");
  var autoReload = document.getElementById("autoReload");
  var sysProxy = document.getElementById("systemProxyCheck");

  // convenience arrays
  var manual = [ftp, ftpPort, gopher, gopherPort, http, httpPort, socks, socksPort, socksVersion, socksVersion4, socksVersion5, ssl, sslPort, noProxy];
  var auto = [autoURL, autoReload];

  // radio buttons
  var radiogroup = document.getElementById("networkProxyType");
  var radioDirect = document.getElementById("networkProxyType_Direct");
  var radioManual = document.getElementById("networkProxyType_Manual");
  var radioAuto = document.getElementById("networkProxyType_Auto");
  var radios = [radioDirect, radioManual, radioAuto];

  var prefstring;
  var sysPrefAvailable = sysPrefCheck();
  var useSysProxy;

  if (!sysPrefAvailable) {
    if (sysProxy.checked)
      sysProxy.setAttribute ("checked", "false");
    sysProxy.setAttribute ("disabled", "true");
    useSysProxy = false;
  }
  else
    useSysProxy = sysProxy.checked;

  if (useSysProxy) {
    for (i = 0; i< radios.length; i++)
      radios[i].setAttribute ("disabled", "true");
    for (i = 0; i < manual.length; i++)
      manual[i].setAttribute( "disabled", "true" );
    for (i = 0; i < auto.length; i++)
      auto[i].setAttribute( "disabled", "true" );
    return;
  }
  
  var proxyType = radiogroup.getAttribute( "prefstring" );
  if (!parent.hPrefWindow.getPrefIsLocked(proxyType)) {
    radiogroup.removeAttribute ("disabled");
    for (i = 0; i< radios.length; i++)
      radios[i].removeAttribute ("disabled", "true");
  }

  switch ( radiogroup.value ) {
    case "0":
      for (i = 0; i < manual.length; i++)
        manual[i].setAttribute( "disabled", "true" );
      for (i = 0; i < auto.length; i++)
        auto[i].setAttribute( "disabled", "true" );
      break;
    case "1":
      for (i = 0; i < auto.length; i++)
        auto[i].setAttribute( "disabled", "true" );
      for (i = 0; i < manual.length; i++) {
        prefstring = manual[i].getAttribute( "prefstring" );
        if (!parent.hPrefWindow.getPrefIsLocked(prefstring))
          manual[i].removeAttribute( "disabled" );
      }
      break;
    case "2":
    default:
      for (i = 0; i < manual.length; i++)
        manual[i].setAttribute( "disabled", "true" );
      if (!radiogroup.disabled)
        for (i = 0; i < auto.length; i++) {
          prefstring = auto[i].getAttribute( "prefstring" );
          if (!parent.hPrefWindow.getPrefIsLocked(prefstring))
            auto[i].removeAttribute( "disabled" );
        }
      break;
  }
  if (socksVersion.disabled) {
    socksVersion4.setAttribute("disabled","true");
    socksVersion5.setAttribute("disabled","true");
  }
}

const nsIProtocolProxyService = Components.interfaces.nsIProtocolProxyService;
const kPROTPROX_CID = '{e9b301c0-e0e4-11D3-a1a8-0050041caf44}';

function ReloadPAC() {
  var autoURL = document.getElementById("networkProxyAutoconfigURL");
  var pps = Components.classesByID[kPROTPROX_CID]
                       .getService(nsIProtocolProxyService);
  pps.configureFromPAC(autoURL.value);
}   

function sysProxyUpdate() {
  var checkObj = document.getElementById("systemProxyCheck");
  var prefstring = checkObj.getAttribute( "prefstring" );
  parent.hPrefWindow.pref.SetBoolPref(prefstring, checkObj.checked);
  parent.hPrefWindow.pagePrefChanged = true;
  parent.hPrefWindow.pagePrefUpdated = [];

  parent.hPrefWindow.onpageload("chrome://communicator/content/pref/pref-proxies.xul");
}

function sysPrefCheck() {
  try {
    var appShell = Components.classes["@mozilla.org/system-preference-service;1"].getService(Components.interfaces.nsIPrefBranch);
  }
  catch(e) 
    {
      return false;
    }
  return true;
}
