// set the state of components in Preferences-->Colors-->Text and Background
// and Preferences-->Colors-->Link Colors
// according to their locking state
function CheckLock(preString,elementId)
{
  const pref = Components.classes["@mozilla.org/preferences;1"].
		getService(Components.interfaces.nsIPref);
  if(pref.PrefIsLocked(preString))
  {
    var colorPicker = document.getElementById(elementId);
    colorPicker.setAttribute("disabled","true");
  }
}

function DoEnabling()
{
  CheckLock("browser.display.foreground_color","foregroundtextmenu");
  CheckLock("browser.display.background_color","backgroundmenu");
  CheckLock("browser.anchor_color","unvisitedlinkmenu");
  CheckLock("browser.visited_color","visitedlinkmenu");
}

function setColorWell(aPicker)
{
  var colorRef = aPicker.nextSibling;                // colour value is held here
  colorRef.setAttribute( "value", aPicker.color );
}

  function setColorWellSr(menu,otherId,setbackground)
  {
    // Find the colorWell and colorPicker in the hierarchy.
    var colorWell = menu.firstChild;
    var colorPicker = menu.firstChild.nextSibling.nextSibling.firstChild;
    var colorRef = menu.nextSibling;                // colour value is held here
  
    // Extract color from colorPicker and assign to colorWell.
    var color = colorPicker.getAttribute('color');
    // set colour values in the display 
    setColorFromPicker( colorWell, color );
    // set the colour value internally for use in prefwindow
    colorRef.setAttribute( "value", color );
  }

  function getColorFromWellAndSetValue(aPickerId)
  {
    var picker = document.getElementById(aPickerId);
    var colorRef  = picker.nextSibling;
    var color = colorRef.getAttribute("value");
    picker.color = color;
    return color;
  }     

  function Startup()
  {
    getColorFromWellAndSetValue("foregroundtextmenu");
    getColorFromWellAndSetValue("backgroundmenu");
    getColorFromWellAndSetValue("unvisitedlinkmenu");
    getColorFromWellAndSetValue("visitedlinkmenu");

    return true;
  }                   
  
