/*
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 *  All rights reserved.
 */

#ifndef __IMSDK_RFC822_H
#define __IMSDK_RFC822_H

#include "rfc822_header.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Address property types for use with imta_get_add_ressProperty */
typedef enum {
  IMADR_ADDRESS              = 1,
  IMADR_DOMAIN               = 2,
  IMADR_LOCAL                = 4,
  IMADR_PHRASE               = 5,
  IMADR_PROPER               = 6,
  IMADR_ROUTE                = 7
} imadr_prop_t;
  
#define IMADR_ADDRESS_LEN         255
#define IMADR_PROPER_LEN         1023

/*
 * Data types definitions.
 */
typedef struct im_hdr_s *imhdr_t;
typedef struct im_adr_s *imadr_t;


/* RFC 822 header API */
int  imhdr_alloc( imhdr_t *h);
int  imhdr_add_line( imhdr_t *h, int type, char *line, int insert);
int  imhdr_delete_line( imhdr_t h, int type);
int  imhdr_get_line( imhdr_t h, int type, char **line);
void imhdr_free_line( imhdr_t h, char *line);
void imhdr_free( imhdr_t h);


/* RFC 822 address parsing API */
int  imadr_parse_one( char *result, imadr_prop_t property, const char *address);
int  imadr_parse_list( imadr_t *adr, char *line);
int  imadr_get( imadr_t adr, int index, char **address);
int  imadr_get_property( imadr_t adr, int index, imadr_prop_t property, char **result);
void imadr_free( imadr_t adr);

#ifdef __cplusplus
	   }
#endif

#endif  /* __IMSDK_RFC822_H */
