function psStartTrimHelper( aString, aRegExp )
{
    if( aString == null )
    {
    	return aString;
    }

    var lResult = "";
    for( var i = 0; i < aString.length; i++ )
    {
	var c = aString.charAt(i);
	if( !aRegExp.test( c ) )
	{
	    lResult = aString.substring( i );
	    break;
	}
    }

    return lResult;
}//psStartTrimHelper()

function psEndTrimHelper( aString, aRegExp )
{
    if( aString == null )
    {
    	return aString;
    }

    var lResult = "";
    for( var i = aString.length-1; i >= 0 ; i-- )
    {
	var c = aString.charAt(i);
	if( !aRegExp.test( c ) )
	{
	    lResult = aString.substring( 0, i + 1 );
	    break;
	}
    }

    return lResult;
}//psEndTrimHelper()

function psTrim( aString )
{
    var re = /[\s]/;
    return psEndTrimHelper( psStartTrimHelper( aString, re ), re );
}//psTrim()

function psEquals( aSource, aMatch )
{
    var index = aSource.lastIndexOf( aMatch );
    if( index == 0 )
    {
    	if( aSource.length == aMatch.length )
    	{
	    return true;
	}
    }

    return false;
}//psEquals()

function psEndsWith( aSource, aMatch )
{
    var index = aSource.lastIndexOf( aMatch );
    if( ( index != -1 ) &&
    	( index + aMatch.length == aSource.length ) )
    {
	return true;
    }

    return false;
}//psEndsWith()

function psSplit( aURI )
{
    var arrayResult = new Array( aURI, "", "" );
    var re = /[\s\"\'\\]/;

    var lTrimResult = psEndTrimHelper( psStartTrimHelper( aURI, re ), re );
    if( lTrimResult.length == 0 )
    {
       return arrayResult;
    }

    var index = aURI.indexOf( lTrimResult );
    arrayResult[0] = aURI.substring( 0, index );
    arrayResult[1] = lTrimResult;
    arrayResult[2] = aURI.substring( lTrimResult.length + index );
    return arrayResult;
}//psSplit()

function psGetProtocol( aURI )
{
    var i = aURI.indexOf( '://' );

    if ( i != -1 )
    {
	var protocol = aURI.substr( 0, i )
	var arrayOfStrings = protocol.split(/[^\w]/);

	if( arrayOfStrings != null && arrayOfStrings.length == 1 )
	{
	    return protocol;
	}
    }

    return "";
}//psGetProtocol()

function psGetDefaultPort( aProtocol )
{
    var lProtocol = aProtocol.toLowerCase();

    if ( lProtocol.indexOf( 'https' ) == 0 )
    {
	return 443;
    }

    if ( lProtocol.indexOf( 'http' ) == 0 )
    {
	return 80;
    }

    return "";
}//psGetDefaultPort()

function psGetHostAndPort( aString )
{
    //hostName, host, port
    var arrayResult = new Array( "", "", "" );

    var bSearchPart = aString;

    //search for / or ? or # in the order & take the least one
    var bIndex =  bSearchPart.indexOf( '/' );
    if ( bIndex != -1 )
    {
	bSearchPart = bSearchPart.substr( 0, bIndex );

	var bQueryIndex = bSearchPart.indexOf( '?' );
	if( bQueryIndex != -1 )
	{
	    bIndex = bQueryIndex;
	}
	else
	{
	    var bReferenceIndex = bSearchPart.indexOf( '#' );
	    if( bReferenceIndex != -1 )
	    {
		bIndex = bReferenceIndex;
	    }
	}
    }
    else
    {
	var bQueryIndex = bSearchPart.indexOf( '?' );
	if( bQueryIndex != -1 )
	{
	    bIndex = bQueryIndex;
	}
	else
	{
	    var bReferenceIndex = bSearchPart.indexOf( '#' )
	    if( bReferenceIndex != -1 )
	    {
		bIndex = bReferenceIndex;
	    }
	}
    }

    //if / or ? or # not present, entire thing is host name
    if ( bIndex == -1 )
    {
	bIndex = aString.length;
    }

    var hostName = aString.substr(0, bIndex);
    arrayResult[0] = hostName;

    bIndex = hostName.indexOf(':');
    if( bIndex == -1 )
    {
	arrayResult[1] = hostName;
    }
    else
    {
	arrayResult[1] = hostName.substr( 0,bIndex );
	arrayResult[2] = hostName.substr( bIndex + 1 );
    }

    return arrayResult;
}//psGetHostAndPort()

function psGetPath( aString )
{
    var lIndex = aString.indexOf('#');

    if( lIndex == -1 )
    {
	lIndex = aString.indexOf('?');
    }

    if( lIndex == -1 )
    {
	lIndex = aString.length;
    }

    return aString.substr( 0, lIndex );
}//psGetPath()

function psGetReference( aString )
{
    if( aString.charAt( 0 ) == '#' )
    {
	var bIndex = aString.indexOf('?');
	if( bIndex != -1 )
	{
	    return aString.substr( 1, bIndex-1 );
	}
	else
	{
            return aString.substr( 1 );
	}
    }

    return "";
}//psGetReference()

function psGetQuery( aString )
{
    if( aString.charAt( 0 ) == '?' )
    {
	return aString.substr( 1 );
    }

    return "";
}//psGetQuery();

function psNormalizePort( aURI, aDefaultPort, aNetworkURI )
{
    var bDefaultPortString = ':' + aDefaultPort;
    var bRest = aURI.substr( aNetworkURI.length );
    var bPortIndex = aNetworkURI.indexOf( bDefaultPortString );
    var bCalPortIndex = aNetworkURI.length - bDefaultPortString.length;

    if (  ( bPortIndex != -1 ) &&
	  ( bPortIndex == bCalPortIndex ) )
    {
	return aNetworkURI.substr( 0, bPortIndex ) + bRest;
    }

    return aURI;
}//psNormalizePort()

function URIObject( aAbsoluteURI )
{
    this.input = aAbsoluteURI;

    var lString = aAbsoluteURI;
    this.protocol = psGetProtocol( lString );
    this.defaultPort = psGetDefaultPort( this.protocol );

    lString = lString.substring( this.protocol.length + '://'.length );
    var lResult = psGetHostAndPort( lString );
    this.hostName = lResult[0];
    this.host = lResult[1];
    this.port = lResult[2];

    lString = lString.substring( this.hostName.length );
    this.path = psGetPath( lString );

    lString = lString.substring( this.path.length );
    this.reference = psGetReference( lString );

    this.query = '';
    if( this.reference.length != 0 )
    {
	lString = lString.substring( '#'.length + this.reference.length );
    }
    this.query = psGetQuery( lString );

    this.networkURI = '';
    if( this.protocol.length !=  0 )
    {
	this.networkURI = this.protocol + '://' + this.hostName;
    }

    this.normalizedURI = psNormalizePort( this.input, this.defaultPort, this.networkURI );
}//URIObject()

function CustomLocation( aAbsoluteURI )
{
    var lURIObject = new URIObject( aAbsoluteURI );
    this.protocol = lURIObject.protocol + ':';
    this.hostname = lURIObject.hostName;
    this.host = lURIObject.host;
    this.port = lURIObject.port;
    this.pathname = lURIObject.path;

    this.hash = '';
    if(lURIObject.reference.length != 0 )
    {
	this.hash = '#' + lURIObject.reference;
    }

    this.search = '';
    if(lURIObject.query.length != 0 )
    {
	this.search = '?' + lURIObject.query;
    }
}//CustomLocation()