/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.servlet;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netlet.econnection.Base64;
import com.sun.portal.netlet.servlet.Rules;
import com.sun.portal.netlet.util.NetletConstants;
import com.sun.portal.netlet.util.UrlDecoder;
import com.sun.portal.netlet.util.UserAttributes;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NetletConfig
extends HttpServlet
implements SSOTokenListener,
NetletConstants {
    private static final String sccsID = "@(#)NetletConfig.java\t1.37 01/07/16 Sun Microsystems, Inc.";
    private Debug debug = null;
    private String serverName = null;
    private String serverPort = null;
    private String serverProtocol = null;
    private String serverDomain = null;
    private boolean logCreated = false;
    private Hashtable sessionHash = new Hashtable();
    private Hashtable clientPorts = new Hashtable();
    private final int STATUS_LOADING = 1;
    private final int STATUS_LOADED = 2;
    private final int STATUS_NOT_LOADED = 3;
    private final int STATUS_UNLOADED = 4;
    private SecureRandom sRandom = null;

    public NetletConfig() {
        this.debug = Debug.getInstance((String)"srapNetlet");
        try {
            this.sRandom = SecureRandom.getInstance("SHA1PRNG");
            byte[] byArray = this.sRandom.generateSeed(32);
            this.sRandom.setSeed(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.sRandom = new SecureRandom();
        }
    }

    private String getCommand(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("func");
        try {
            String string2 = httpServletRequest.getQueryString();
            int n = string2.indexOf("func=");
            if (n == -1) {
                return UrlDecoder.decode(string);
            }
            int n2 = (string2 = string2.substring(n + 5)).indexOf("&");
            string2 = n2 == -1 ? string2 : string2.substring(0, n2);
            return UrlDecoder.decode(string2);
        }
        catch (Exception exception) {
            this.debug.error("NetletConfig: Exception in getting the command -> " + exception);
            return UrlDecoder.decode(string);
        }
    }

    private boolean isNetletAvailable(NetletUser netletUser) {
        String string;
        HttpServletRequest httpServletRequest = netletUser.getReq();
        HttpServletResponse httpServletResponse = netletUser.getRes();
        String string2 = httpServletRequest.getHeader("PS-Netlet");
        if (string2 == null) {
            this.debug.error("Netlet can not be accessed in open portal mode.");
            this.redirectToPage(httpServletResponse, "noGateway", null, netletUser.getLocale(), netletUser.getHTMLcharsetname());
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        if (stringTokenizer.hasMoreTokens() && !"enabled=true".equals(string = stringTokenizer.nextToken().trim())) {
            this.debug.error("Gateway does not allow Netlet connections.");
            this.redirectToPage(httpServletResponse, "netletDisabled", null, netletUser.getLocale(), netletUser.getHTMLcharsetname());
            return false;
        }
        return true;
    }

    private void doGetPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, FileNotFoundException {
        String string;
        if (this.serverName == null || this.serverPort == null || this.serverProtocol == null) {
            this.serverName = httpServletRequest.getServerName();
            if (this.serverName != null && this.serverName.trim().length() != 0 && this.serverName.indexOf(".") != -1) {
                this.serverDomain = this.serverName.substring(this.serverName.indexOf(".") + 1);
            }
            this.serverProtocol = httpServletRequest.getScheme();
            int n = httpServletRequest.getServerPort();
            this.serverPort = "" + n;
        }
        if ((string = this.getCommand(httpServletRequest)) == null || string.trim().length() == 0) {
            this.debug.error("Error no function specified");
            return;
        }
        NetletUser netletUser = null;
        String string2 = null;
        try {
            netletUser = new NetletUser(httpServletRequest);
            netletUser.setRes(httpServletResponse);
            string2 = new String(netletUser.getSSOTokenID().toString());
            if (!SSOTokenManager.getInstance().isValidToken(netletUser.getSSOToken())) {
                this.debug.error("Invalid SSOToken");
                this.redirectToPage(httpServletResponse, "invalidsession", null, null, null);
                return;
            }
            if (!this.isNetletAvailable(netletUser)) {
                return;
            }
            if (!netletUser.isAllowed()) {
                this.redirectToPage(httpServletResponse, "noprivilege", null, netletUser.getLocale(), netletUser.getHTMLcharsetname());
                return;
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("Command -> " + string);
            }
            if (string.equals("makepage") || string.equals("load")) {
                if (this.getStatus(string2) == 2) {
                    this.debug.message("Netlet already loaded for " + netletUser.getClientID());
                    httpServletResponse.setStatus(204);
                    return;
                }
                this.setStatus(string2, 1);
                this.makeNetletPage(netletUser);
            } else if (string.equals("makeNetletFrame")) {
                netletUser.getUserAttributes();
                this.printRules(netletUser);
                this.makeNetletFrame(netletUser);
            } else if (string.equals("makeInfoFrame")) {
                this.makeInfoFrame(netletUser);
            } else if (string.equals("makeDetectFrame")) {
                this.makeDetectNetletFrame(netletUser);
            } else if (string.equals("setLoaded")) {
                this.setStatus(string2, 2);
                httpServletResponse.setStatus(200);
                this.readClientPorts(netletUser);
            } else if (string.equals("setLoading")) {
                this.setStatus(string2, 1);
                httpServletResponse.setStatus(200);
            } else if (string.equals("isLoaded")) {
                if (this.getStatus(string2) == 2 || this.getStatus(string2) == 1) {
                    httpServletResponse.setStatus(200);
                } else {
                    httpServletResponse.setStatus(204);
                }
            } else if (string.equals("unload")) {
                this.setStatus(string2, 4);
                httpServletResponse.sendRedirect(netletUser.getDefaultRedirectURL());
                this.removeClientPort(netletUser.getSSOTokenID().toString());
            } else if (string.equals("loadResources")) {
                this.setStatus(string2, 1);
                this.outputResources(netletUser);
            } else if (string.equals("parsePacFile")) {
                this.parsePacFile(netletUser);
            } else if (string.equals("storeProxySettings")) {
                this.storeProxySettings(netletUser);
            } else if (string.equals("doReauth")) {
                this.doReauth(netletUser);
            } else {
                if (this.getStatus(string2) == 4) {
                    String string3 = httpServletRequest.getHeader("user-agent");
                    if (string3.indexOf("Mac_PowerPC") != -1 && string3.indexOf("MSIE") != -1) {
                        this.makeErrorMsg(netletUser, "macLoadErr");
                        this.setStatus(string2, 3);
                    } else {
                        this.makeErrorMsg(netletUser, "nc2");
                    }
                    return;
                }
                if (this.getStatus(string2) != 2) {
                    this.makeLoadingPage(netletUser, httpServletRequest);
                    return;
                }
                netletUser.getUserAttributes();
                this.printRules(netletUser);
                if (!this.openDynamic(netletUser, string)) {
                    this.debug.error("Error processsing dynamic rule for " + string);
                }
            }
        }
        catch (SSOException sSOException) {
            this.debug.error("Error in NetletConfig - doGetPost() ", (Throwable)sSOException);
            this.redirectToPage(httpServletResponse, "invalidsession", null, null, null);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            this.debug.error("Error in NetletConfig - doGetPost() ", (Throwable)missingResourceException);
            return;
        }
    }

    private void addClientPort(String string, Hashtable hashtable) {
        this.clientPorts.put(string, hashtable);
    }

    private void removeClientPort(String string) {
        this.clientPorts.remove(string);
    }

    private void readClientPorts(NetletUser netletUser) {
        HttpServletRequest httpServletRequest = netletUser.getReq();
        String string = httpServletRequest.getParameter("clientPorts");
        String string2 = httpServletRequest.getContentType();
        if (string2 != null && string2.indexOf("multipart/form-data") != -1) {
            string = this.extractParameter(httpServletRequest, "clientPorts");
        }
        this.addClientPort(netletUser.getSSOTokenID().toString(), this.unformatClientPorts(string));
        this.debug.message("Client ports for " + netletUser.getClientID() + " : " + this.clientPorts);
    }

    private Hashtable unformatClientPorts(String string) {
        Hashtable hashtable = new Hashtable();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            Vector<String> vector = new Vector<String>();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "->");
            String string3 = stringTokenizer2.nextToken().trim();
            String string4 = stringTokenizer2.nextToken().trim();
            StringTokenizer stringTokenizer3 = new StringTokenizer(string4, ",");
            while (stringTokenizer3.hasMoreTokens()) {
                String string5 = stringTokenizer3.nextToken();
                vector.addElement(string5);
            }
            hashtable.put(string3, vector);
        }
        return hashtable;
    }

    private String getClientPort(String string, String string2, String string3) {
        String string4 = null;
        Hashtable hashtable = (Hashtable)this.clientPorts.get(string);
        Vector vector = (Vector)hashtable.get(string2);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            StringTokenizer stringTokenizer = new StringTokenizer(string5, ":");
            String string6 = null;
            if (!stringTokenizer.hasMoreElements() || !(string6 = (String)stringTokenizer.nextElement()).equals(string3) || !stringTokenizer.hasMoreElements()) continue;
            string4 = (String)stringTokenizer.nextElement();
            break;
        }
        this.debug.message("Rule name -> " + string2 + ", Administrator configured client port -> " + string3 + ", Actual client port -> " + string4);
        return string4;
    }

    private void addLoopbackRule(NetletUser netletUser) {
        Rules rules = new Rules();
        rules.name = "loopback";
        rules.url = "";
        rules.lport = new Vector();
        rules.lport.add(new String("" + netletUser.getDefaultLBPort()));
        rules.dport = new Vector();
        rules.dport.add(this.serverPort);
        rules.dhost = new Vector();
        rules.dhost.add(this.serverName);
        netletUser.addRule(rules);
    }

    void makeLoadingPage(NetletUser netletUser, HttpServletRequest httpServletRequest) throws IOException {
        HttpServletResponse httpServletResponse = netletUser.getRes();
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), netletUser.getHTMLcharsetname())));
        httpServletResponse.setContentType("text/html; charset=" + netletUser.getHTMLcharsetname());
        httpServletResponse.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        httpServletResponse.setHeader("Pragma", "no-cache");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDynamicUrl() + httpServletRequest.getServletPath()).append("?").append(httpServletRequest.getQueryString());
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("<html>\n");
        stringBuffer2.append("<head>\n");
        stringBuffer2.append("<script language=javascript>\n");
        stringBuffer2.append("\tfunction doRedirect() {\n");
        stringBuffer2.append("\t\twindow.location='" + stringBuffer.toString() + "';\n");
        stringBuffer2.append("\t}\n");
        stringBuffer2.append("</script>\n");
        stringBuffer2.append("<title>");
        stringBuffer2.append(netletUser.getBundle().getString("ntitle2"));
        stringBuffer2.append("</title></head>\n");
        stringBuffer2.append("<BODY TEXT=\"" + netletUser.getBundle().getString("ntxcolor") + "\" BGCOLOR=\"" + netletUser.getBundle().getString("nbgcolor") + "\">\n");
        stringBuffer2.append("<p>" + netletUser.getBundle().getString("nc3") + "\n");
        stringBuffer2.append("<form>\n");
        stringBuffer2.append("<input type=button name=continue value='" + netletUser.getBundle().getString("contButton") + "'" + " onClick='doRedirect()'" + ">\n");
        stringBuffer2.append("</form>\n");
        stringBuffer2.append("</body></html>\n");
        printWriter.print(stringBuffer2.toString());
        printWriter.close();
    }

    void makeErrorMsg(NetletUser netletUser, String string) throws IOException {
        HttpServletResponse httpServletResponse = netletUser.getRes();
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), netletUser.getHTMLcharsetname())));
        httpServletResponse.setContentType("text/html; charset=" + netletUser.getHTMLcharsetname());
        httpServletResponse.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        httpServletResponse.setHeader("Pragma", "no-cache");
        printWriter.print("<html>\n");
        printWriter.print("<head><title>");
        printWriter.print(netletUser.getBundle().getString("ntitle"));
        printWriter.print("</title></head>\n");
        printWriter.print("<BODY TEXT=\"" + netletUser.getBundle().getString("ntxcolor") + "\" BGCOLOR=\"" + netletUser.getBundle().getString("nbgcolor") + "\">\n");
        printWriter.print("<p>" + netletUser.getBundle().getString(string) + "</body></html>\n");
        printWriter.close();
    }

    void makeNetletPage(NetletUser netletUser) throws ServletException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        HttpServletResponse httpServletResponse = netletUser.getRes();
        String string = netletUser.getReq().getServletPath();
        string = this.getDynamicUrl() + string;
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), netletUser.getHTMLcharsetname())));
        httpServletResponse.setContentType("text/html; charset=" + netletUser.getHTMLcharsetname());
        httpServletResponse.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        httpServletResponse.setHeader("Pragma", "no-cache");
        stringBuffer.append("<html>\n");
        stringBuffer.append("<head><title>");
        stringBuffer.append(netletUser.getBundle().getString("ntitle"));
        stringBuffer.append("</title></head>\n");
        Object[] objectArray = new Object[]{"info", string + "?func=makeInfoFrame", "netlet", string + "?func=makeDetectFrame"};
        String string2 = netletUser.getBundle().getString("frameset");
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.applyPattern(string2);
        stringBuffer.append(messageFormat.format(objectArray).toString());
        stringBuffer.append("</html>\n");
        printWriter.print(stringBuffer.toString());
        printWriter.close();
    }

    void makeNetletFrame(NetletUser netletUser) throws ServletException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        HttpServletResponse httpServletResponse = netletUser.getRes();
        HttpServletRequest httpServletRequest = netletUser.getReq();
        String string = netletUser.getEncryptionType();
        this.debug.message("Netlet encryption type -> " + string);
        boolean bl = false;
        if ("SSL".equals(string)) {
            bl = true;
        }
        boolean bl2 = false;
        String string2 = httpServletRequest.getParameter("JSSE");
        if (string2 == null) {
            bl2 = false;
        } else {
            bl2 = true;
            bl = false;
        }
        boolean bl3 = false;
        String string3 = httpServletRequest.getHeader("PS-GW-PDC");
        if (string3 != null) {
            bl3 = Boolean.getBoolean(string3);
        }
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), netletUser.getHTMLcharsetname())));
        httpServletResponse.setContentType("text/html; charset=" + netletUser.getHTMLcharsetname());
        httpServletResponse.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        httpServletResponse.setHeader("Pragma", "no-cache");
        stringBuffer.append("<html>\n");
        stringBuffer.append("<head><title>");
        stringBuffer.append(netletUser.getBundle().getString("ntitle"));
        stringBuffer.append("</title></head>\n");
        stringBuffer.append("\t<script language=javascript>\n");
        stringBuffer.append("\t\tvar needToSleep = true;\n");
        stringBuffer.append("\t</script>\n");
        stringBuffer.append("</head>\n");
        stringBuffer.append("<BODY TEXT=\"").append(netletUser.getBundle().getString("ntxcolor"));
        stringBuffer.append("\" BGCOLOR=\"").append(netletUser.getBundle().getString("nbgcolor")).append("\">\n");
        String string4 = netletUser.getReq().getHeader("user-agent");
        if (string4.indexOf("Mac_PowerPC") != -1 && string4.indexOf("MSIE") != -1) {
            if (bl) {
                stringBuffer.append("<p><applet name=\"netapp\" codebase=\"").append(this.getStaticUrl()).append("/netlet\" archive=\"netlet.mac.jar, kssl.jar\" code=\"SServer.class\" width=1 height=1 MAYSCRIPT>\n");
            } else if (bl2) {
                stringBuffer.append("<p><applet name=\"netapp\" codebase=\"").append(this.getStaticUrl()).append("/netlet\" archive=\"netlet.mac.jar, netletjsse.jar\" code=\"SServer.class\" width=1 height=1 MAYSCRIPT>\n");
            } else {
                stringBuffer.append("<p><applet name=\"netapp\" codebase=\"").append(this.getStaticUrl()).append("/netlet\" archive=\"netlet.mac.jar\" code=\"SServer.class\" width=1 height=1 MAYSCRIPT>\n");
            }
        } else if (bl) {
            stringBuffer.append("<p><applet name=\"netapp\" codebase=\"").append(this.getStaticUrl()).append("/netlet\" archive=\"netlet.jar, kssl.jar\" code=\"SServer.class\" width=1 height=1 MAYSCRIPT>\n");
        } else if (bl2) {
            stringBuffer.append("<p><applet name=\"netapp\" codebase=\"").append(this.getStaticUrl()).append("/netlet\" archive=\"netlet.jar, netletjsse.jar\" code=\"SServer.class\" width=1 height=1 MAYSCRIPT>\n");
        } else {
            stringBuffer.append("<p><applet name=\"netapp\" codebase=\"").append(this.getStaticUrl()).append("/netlet\" archive=\"netlet.jar\" code=\"SServer.class\" width=1 height=1 MAYSCRIPT>\n");
        }
        if (bl) {
            stringBuffer.append("<param name=\"cabbase\" value=\"netlet.cab, kssl.cab\">\n");
        } else if (bl2) {
            stringBuffer.append("<param name=\"cabbase\" value=\"netlet.cab, netletjsse.cab\">\n");
        } else {
            stringBuffer.append("<param name=\"cabbase\" value=\"netlet.cab\">\n");
        }
        stringBuffer.append("<param name=\"cookiename\" value=\"" + SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro") + "\">\n");
        stringBuffer.append("<param name=\"configURL\" value=\"").append(this.getDynamicUrl()).append("/NetletConfig\">\n");
        stringBuffer.append("<param name=\"resourcesURL\" value=\"").append(this.getDynamicUrl()).append("/NetletConfig?func=loadResources\">\n");
        int n = 0;
        this.addLoopbackRule(netletUser);
        Enumeration enumeration = netletUser.getRules();
        while (enumeration.hasMoreElements()) {
            Rules rules = (Rules)enumeration.nextElement();
            int n2 = 0;
            while (n2 < rules.lport.size()) {
                stringBuffer.append("<param name=ruleName_" + n + " value=" + rules.name + ">\n");
                stringBuffer.append("<param name=listenPort_" + n + " value=" + (String)rules.lport.elementAt(n2) + ">\n");
                stringBuffer.append("<param name=serverPort_" + n + " value=" + (String)rules.dport.elementAt(n2) + ">\n");
                stringBuffer.append("<param name=serverHost_" + n + " value=" + (String)rules.dhost.elementAt(n2) + ">\n");
                stringBuffer.append("<param name=cipher_" + n + " value=" + netletUser.getAlgorithm(rules) + ">\n");
                ++n;
                ++n2;
            }
        }
        stringBuffer.append("<param name=sessionId value=" + netletUser.getSSOTokenID().toString() + ">\n");
        stringBuffer.append("<param name=encryptionType value=" + string + ">\n");
        stringBuffer.append("<param name=numParms value=" + n + ">\n");
        stringBuffer.append("<param name=doPortWarning value=" + netletUser.getPortWarn() + ">\n");
        stringBuffer.append("<param name=doReauth value=" + netletUser.getReauth() + ">\n");
        stringBuffer.append("<param name=showPortWarnCheckbox value=" + netletUser.getPortWarnCheckbox() + ">\n");
        stringBuffer.append("<param name=defaultCipher value=" + netletUser.getDefaultCipher() + ">\n");
        stringBuffer.append("<param name=proxytype value=" + netletUser.getNetletUserAttributes().getString("sunPortalNetletProxyType", "") + ">\n");
        stringBuffer.append("<param name=proxyhost value=" + netletUser.getNetletUserAttributes().getString("sunPortalNetletProxyHost", "") + ">\n");
        stringBuffer.append("<param name=proxyport value=" + netletUser.getNetletUserAttributes().getString("sunPortalNetletProxyPort", "") + ">\n");
        stringBuffer.append("<param name=proxyoverride value=" + netletUser.getNetletUserAttributes().getString("sunPortalNetletProxyOverride", "") + ">\n");
        if (bl2) {
            stringBuffer.append("<param name=isJSSEEnabled value=true>\n");
        }
        if (bl3) {
            stringBuffer.append("<param name=isPDCEnabled value=true>\n");
        }
        stringBuffer.append("</applet>\n");
        stringBuffer.append("</body>\n");
        stringBuffer.append("</html>\n");
        printWriter.print(stringBuffer.toString());
        printWriter.close();
    }

    void makeInfoFrame(NetletUser netletUser) throws ServletException, IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        HttpServletResponse httpServletResponse = netletUser.getRes();
        HttpServletRequest httpServletRequest = netletUser.getReq();
        String string2 = httpServletRequest.getParameter("stat");
        if (string2 == null || string2.equals("")) {
            string2 = "nc4";
        }
        if ((string = netletUser.getReq().getHeader("user-agent")).indexOf("Mac_PowerPC") != -1 && string.indexOf("MSIE") != -1) {
            string2 = "nc1";
        }
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), netletUser.getHTMLcharsetname())));
        httpServletResponse.setContentType("text/html; charset=" + netletUser.getHTMLcharsetname());
        httpServletResponse.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        httpServletResponse.setHeader("Pragma", "no-cache");
        stringBuffer.append("<html>\n");
        stringBuffer.append("<head>\n");
        stringBuffer.append(netletUser.getBundle().getString("showClientPorts"));
        stringBuffer.append("\n</head>\n");
        stringBuffer.append("<BODY TEXT=\"").append(netletUser.getBundle().getString("ntxcolor"));
        stringBuffer.append("\" BGCOLOR=\"").append(netletUser.getBundle().getString("nbgcolor")).append("\">\n");
        stringBuffer.append("<p>").append(netletUser.getBundle().getString(string2));
        stringBuffer.append("</body>\n");
        stringBuffer.append("</html>\n");
        printWriter.print(stringBuffer.toString());
        printWriter.close();
    }

    void makeDetectNetletFrame(NetletUser netletUser) throws ServletException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        HttpServletResponse httpServletResponse = netletUser.getRes();
        HttpServletRequest httpServletRequest = netletUser.getReq();
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), netletUser.getHTMLcharsetname())));
        httpServletResponse.setContentType("text/html; charset=" + netletUser.getHTMLcharsetname());
        httpServletResponse.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        httpServletResponse.setHeader("Pragma", "no-cache");
        stringBuffer.append("<html>\n");
        stringBuffer.append("<head>\n");
        stringBuffer.append("\n</head>\n");
        stringBuffer.append("<BODY TEXT=\"").append(netletUser.getBundle().getString("ntxcolor"));
        stringBuffer.append("\" BGCOLOR=\"").append(netletUser.getBundle().getString("nbgcolor")).append("\">\n");
        stringBuffer.append("<applet name=\"netapp\" codebase=\"").append(this.getStaticUrl()).append("/netlet\" archive=\"netletdetect.jar\" code=\"NetletEnvDetect.class\" width=1 height=1>\n");
        stringBuffer.append("<param name=\"configURL\" value=\"").append(this.getDynamicUrl()).append("/NetletConfig\">\n");
        stringBuffer.append("</applet>");
        stringBuffer.append("</body>\n");
        stringBuffer.append("</html>\n");
        printWriter.print(stringBuffer.toString());
        printWriter.close();
    }

    void outputResources(NetletUser netletUser) throws ServletException, IOException {
        HttpServletResponse httpServletResponse = netletUser.getRes();
        PrintWriter printWriter = httpServletResponse.getWriter();
        httpServletResponse.setContentType("text/plain");
        Enumeration<String> enumeration = netletUser.getAppletBundle().getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = netletUser.getAppletBundle().getString(string);
            printWriter.println(string + "=" + NetletConfig.encodeJavaString(string2));
        }
        try {
            printWriter.println("_sessionKey=" + this.getKey(netletUser));
        }
        catch (SSOException sSOException) {
            sSOException.printStackTrace();
            this.redirectToPage(netletUser.getRes(), "invalidsession", null, netletUser.getLocale(), netletUser.getHTMLcharsetname());
            return;
        }
        printWriter.close();
    }

    public static String encodeJavaString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            int n2 = string.charAt(n);
            int n3 = n2;
            if (n3 >= 32 && n3 <= 127) {
                stringBuffer.append((char)n2);
            } else {
                stringBuffer.append("\\u");
                int n4 = 4;
                while (n4 > 0) {
                    stringBuffer.append(Character.forDigit((n3 & 0xF000) >> 12, 16));
                    n3 <<= 4;
                    --n4;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private boolean isIPAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                int n2 = Integer.parseInt(string2);
                if (n2 > 255) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            ++n;
        }
        return n == 4;
    }

    public boolean isValidHost(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        String string2 = inetAddress.getHostName();
        return !this.isIPAddress(string) || !string.equals(string2);
    }

    public String getIPAddress(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        return inetAddress.getHostAddress();
    }

    public String getHostName(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        String string2 = inetAddress.getHostName();
        if (string2.indexOf(".") == -1 && this.serverDomain != null) {
            string2 = string2 + ".";
            string2 = string2 + this.serverDomain;
        }
        return string2;
    }

    private boolean containsString(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string2.length();
        int n2 = string.length();
        int n3 = 0;
        while (n2 - n3 >= n) {
            String string3 = string.substring(n3, n3 + n);
            if (string2.equals(string3)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    boolean openDynamic(NetletUser netletUser, String string) throws IOException {
        String string2;
        this.debug.message("openDynanic " + string);
        Rules rules = netletUser.getRule(string);
        if (rules == null) {
            this.debug.message("Error No rule for " + string);
            return false;
        }
        String string3 = null;
        if (!rules.loopback) {
            string3 = rules.url;
        } else {
            string2 = this.getClientPort(netletUser.getSSOTokenID().toString(), string, rules.clientLoopbackPort);
            if (string2 == null) {
                string2 = this.getClientPort(netletUser.getSSOTokenID().toString(), "loopback", rules.clientLoopbackPort);
            }
            string3 = this.serverProtocol + "://localhost:" + string2 + rules.url;
        }
        this.debug.message("Open dynamic port url " + string3);
        string2 = netletUser.getReq();
        HttpServletResponse httpServletResponse = netletUser.getRes();
        String string4 = string2.getParameter("machine");
        string4 = URLEncoder.encode(string4);
        if (string4 == null || string4.equals("")) {
            this.debug.message("Error: no target host specified for " + string);
            return false;
        }
        if (netletUser.inPrivilegeList("sunPortalNetletDenyRules", string, false, false)) {
            this.redirectToPage(netletUser.getRes(), "noprivilege.rule", string, netletUser.getLocale(), netletUser.getHTMLcharsetname());
            return false;
        }
        if (!netletUser.inPrivilegeList("sunPortalNetletAccessRules", string, false, false)) {
            this.redirectToPage(netletUser.getRes(), "noprivilege.rule", string, netletUser.getLocale(), netletUser.getHTMLcharsetname());
            return false;
        }
        String string5 = new String(string4);
        StringTokenizer stringTokenizer = new StringTokenizer(string5, "+");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            if (!this.isValidHost(string6)) continue;
            if (string6.indexOf(".") == -1 && this.serverDomain != null) {
                string6 = string6 + ".";
                string6 = string6 + this.serverDomain;
            }
            vector.add(string6);
        }
        if (vector.size() == 0) {
            this.redirectToPage(netletUser.getRes(), "invalidhost", null, netletUser.getLocale(), netletUser.getHTMLcharsetname());
            return false;
        }
        int n = 0;
        while (n < vector.size()) {
            boolean bl;
            String string7 = (String)vector.get(n);
            boolean bl2 = bl = netletUser.inPrivilegeList("sunPortalNetletDenyHosts", this.getHostName(string7), true, true) || netletUser.inPrivilegeList("sunPortalNetletDenyHosts", this.getIPAddress(string7), true, true);
            if (bl) {
                vector.remove(string7);
                --n;
            }
            ++n;
        }
        if (vector.size() == 0) {
            this.redirectToPage(netletUser.getRes(), "noprivilege.host", string4.replace('+', ','), netletUser.getLocale(), netletUser.getHTMLcharsetname());
            return false;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            boolean bl;
            String string8 = (String)vector.get(n2);
            boolean bl3 = bl = netletUser.inPrivilegeList("sunPortalNetletAccessHosts", this.getHostName(string8), true, true) || netletUser.inPrivilegeList("AccessHosts", this.getIPAddress(string8), true, true);
            if (!bl) {
                vector.remove(string8);
                --n2;
            }
            ++n2;
        }
        if (vector.size() == 0) {
            this.redirectToPage(netletUser.getRes(), "noprivilege.host", string4.replace('+', ','), netletUser.getLocale(), netletUser.getHTMLcharsetname());
            return false;
        }
        String string9 = "";
        String string10 = "";
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((AbstractList)vector).iterator();
        if (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuffer.append("+");
            stringBuffer.append((String)iterator.next());
        }
        string4 = stringBuffer.toString();
        this.debug.message("Server domain -> " + this.serverDomain + " Valid and allowed targets -> " + string4);
        int n3 = 0;
        while (n3 < rules.ruleCount) {
            string10 = (String)rules.dport.elementAt(n3);
            String string11 = (String)rules.lport.elementAt(n3);
            string9 = this.getClientPort(netletUser.getSSOTokenID().toString(), string, string11);
            this.debug.message("Client port in rule -> " + string11 + " Actual client port ->" + string9);
            if (string9 == null) {
                this.debug.error("NetletConfig: No clientport corresponding to " + string10);
            } else {
                String string12;
                if (!string9.equals(string11) && this.containsString(string3, string11)) {
                    string12 = string3;
                    string3 = string12.substring(0, string12.indexOf(string11));
                    string3 = string3 + string9;
                    string3 = string3 + string12.substring(string12.indexOf(string11) + string11.length());
                    this.debug.message("URL -> " + string3);
                }
                if (rules.loopback) {
                    if (n3 == 0) {
                        string3 = string3 + "?";
                    }
                    string3 = string3 + "clientPort['" + string10 + "']=" + string9;
                    if (n3 + 1 < rules.ruleCount) {
                        string3 = string3 + "&";
                    }
                }
                if ((string12 = (String)rules.dhost.elementAt(n3)).equals("TARGET")) {
                    try {
                        netletUser.getSSOToken().setProperty(string9, string4 + "^" + string10);
                    }
                    catch (SSOException sSOException) {
                        this.debug.error("Error setting session " + (Object)((Object)sSOException));
                        return false;
                    }
                }
            }
            ++n3;
        }
        this.openPage(netletUser, httpServletResponse, string3);
        return true;
    }

    void openPage(NetletUser netletUser, HttpServletResponse httpServletResponse, String string) throws IOException {
        String string2 = netletUser.getReq().getHeader("user-agent");
        if (string2.indexOf("Mac_PowerPC") != -1 && string2.indexOf("MSIE") != -1) {
            httpServletResponse.sendRedirect(string);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), netletUser.getHTMLcharsetname())));
            httpServletResponse.setContentType("text/html; charset=" + netletUser.getHTMLcharsetname());
            stringBuffer.append("<html>\n");
            if (string == null || string.equals("")) {
                stringBuffer.append("<body onload=window.close()>\n");
            } else {
                stringBuffer.append("<body onload=window.location.replace(\"" + string + "\")>\n");
            }
            stringBuffer.append("</body></html>\n\n");
            printWriter.print(stringBuffer.toString());
            printWriter.close();
        }
    }

    void printRules(NetletUser netletUser) {
        Enumeration enumeration = netletUser.getRules();
        while (enumeration.hasMoreElements()) {
            Rules rules = (Rules)enumeration.nextElement();
            int n = 0;
            while (n < rules.lport.size()) {
                ++n;
            }
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    private synchronized int getStatus(String string) {
        Integer n = (Integer)this.sessionHash.get(string);
        if (n == null) {
            return 3;
        }
        return n;
    }

    private synchronized void removeSession(SSOTokenID sSOTokenID) {
        this.sessionHash.remove(sSOTokenID);
        this.removeClientPort(sSOTokenID.toString());
    }

    private synchronized void setStatus(String string, int n) {
        Integer n2 = this.sessionHash.put(string, new Integer(n));
        if (n2 != null) {
            return;
        }
        try {
            SSOToken sSOToken = SSOTokenManager.getInstance().createSSOToken(string.toString());
            sSOToken.addSSOTokenListener((SSOTokenListener)this);
        }
        catch (SSOException sSOException) {
            sSOException.printStackTrace();
        }
    }

    public void ssoTokenChanged(SSOTokenEvent sSOTokenEvent) {
        try {
            int n = sSOTokenEvent.getType();
            this.removeSession(sSOTokenEvent.getToken().getTokenID());
        }
        catch (SSOException sSOException) {
            // empty catch block
        }
    }

    void parsePacFile(NetletUser netletUser) throws ServletException, IOException {
        HttpServletResponse httpServletResponse = netletUser.getRes();
        PrintWriter printWriter = httpServletResponse.getWriter();
        httpServletResponse.setContentType("text/plain");
        HttpServletRequest httpServletRequest = netletUser.getReq();
        String string = "FAILED";
        try {
            String string2;
            Enumeration enumeration;
            String string3 = httpServletRequest.getParameter("PacFileUrl");
            String string4 = httpServletRequest.getParameter("ServerURL");
            String string5 = httpServletRequest.getParameter("PacFileBody");
            String string6 = httpServletRequest.getParameter("ClientIPAddr");
            Cookie[] cookieArray = httpServletRequest.getCookies();
            int n = 0;
            while (n < cookieArray.length) {
                enumeration = cookieArray[n];
                if (enumeration.getName().equals("iPlanetUserId")) {
                    string2 = enumeration.getValue();
                    try {
                        string6 = string2.substring(0, string2.indexOf(":"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n;
            }
            enumeration = httpServletRequest.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
            }
            string2 = httpServletRequest.getContentType();
            if (string2 != null && string2.indexOf("multipart/form-data") != -1) {
                string5 = this.extractParameter(httpServletRequest, "PacFileBody");
            }
            Vector<String> vector = new Vector<String>();
            vector.add(string4);
            String string7 = "localhost";
            int n2 = string4.indexOf("//");
            if (n2 > -1) {
                int n3 = string4.indexOf("/", n2 + 2);
                int n4 = string4.indexOf(":", n2 + 2);
                string7 = n4 > -1 && n4 < n3 ? string4.substring(n2 + 2, n4) : string4.substring(n2 + 2, n3);
            }
            vector.add(string7);
            try {
                Runtime runtime = Runtime.getRuntime();
                String string8 = System.getProperty("java.home", "/usr/java1.2/jre");
                String string9 = string8 + "/bin/java com.sun.portal.netlet.servlet.EvalPAC " + URLEncoder.encode(string5) + " " + vector.elementAt(0) + " " + vector.elementAt(1) + " " + string6;
                Object object = this.getServletContext().getAttribute("com.ibm.websphere.servlet.application.classpath");
                String string10 = object == null ? null : object.toString();
                String string11 = System.getProperty("java.class.path", ".");
                String[] stringArray = new String[1];
                if (string10 != null && string10.trim().length() != 0) {
                    string11 = string10;
                }
                stringArray[0] = new String("CLASSPATH=" + string11);
                Process process = runtime.exec(string9, stringArray);
                DataInputStream dataInputStream = new DataInputStream(process.getInputStream());
                string = dataInputStream.readLine();
                this.debug.message("Proxy from PAC file -> " + string);
            }
            catch (Exception exception) {
                this.debug.error("Exception in processing PAC file: ", (Throwable)exception);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        printWriter.println(string);
        printWriter.close();
    }

    private String getSessionKey(byte[] byArray, SSOTokenID sSOTokenID) {
        String string = sSOTokenID.toString();
        byte[] byArray2 = new byte[string.length()];
        byArray2 = string.getBytes();
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        byArray3[0] = byArray[1];
        byArray3[1] = byArray[3];
        byArray3[2] = byArray2[3];
        byArray3[3] = byArray[2];
        byArray3[4] = byArray2[1];
        byArray3[5] = byArray[0];
        byArray3[6] = byArray2[2];
        byArray3[7] = byArray[4];
        byArray3[8] = byArray[14];
        byArray3[9] = byArray[5];
        byArray3[10] = byArray[6];
        byArray3[11] = byArray2[4];
        byArray3[12] = byArray[8];
        byArray3[13] = byArray[9];
        byArray3[14] = byArray[10];
        byArray3[15] = byArray2[5];
        byArray3[16] = byArray[12];
        byArray3[17] = byArray[13];
        byArray3[18] = byArray2[6];
        byArray3[19] = byArray2[7];
        byArray3[20] = byArray[11];
        byArray3[21] = byArray2[8];
        byArray3[22] = byArray2[9];
        byArray3[23] = byArray2[10];
        byArray3[24] = byArray[15];
        byArray3[25] = byArray[7];
        byArray3[26] = byArray[18];
        byArray3[27] = byArray[23];
        byArray3[28] = byArray[21];
        byArray3[29] = byArray2[4];
        byArray3[30] = byArray[26];
        byArray3[31] = byArray[25];
        byArray3[32] = byArray[22];
        byArray3[33] = byArray2[5];
        byArray3[34] = byArray[20];
        byArray3[35] = byArray[24];
        byArray3[36] = byArray2[6];
        byArray3[37] = byArray2[7];
        byArray3[38] = byArray[16];
        byArray3[39] = byArray2[8];
        byArray3[40] = byArray[19];
        byArray3[41] = byArray2[10];
        byArray3[42] = byArray[17];
        byArray3[43] = byArray2[7];
        byArray3[44] = byArray[28];
        byArray3[45] = byArray2[1];
        byArray3[46] = byArray2[0];
        byArray3[47] = byArray2[4];
        byArray3[48] = byArray[31];
        byArray3[49] = byArray2[11];
        byArray3[50] = byArray[27];
        byArray3[51] = byArray2[5];
        byArray3[52] = byArray2[8];
        byArray3[53] = byArray2[32];
        byArray3[54] = byArray2[6];
        byArray3[55] = byArray2[7];
        byArray3[56] = byArray2[24];
        byArray3[57] = byArray2[8];
        byArray3[58] = byArray[30];
        byArray3[59] = byArray2[10];
        byArray3[60] = byArray2[12];
        byArray3[61] = byArray[29];
        int n = 61;
        int n2 = 0;
        while (n < byArray3.length) {
            if (n2 < byArray2.length - 1) {
                byArray3[n] = byArray2[n2++];
            } else {
                n2 = 0;
                byArray3[n] = byArray2[0];
            }
            ++n;
        }
        byte[] byArray4 = Base64.encode(byArray3);
        return new String(byArray4);
    }

    private String getKey(NetletUser netletUser) throws ServletException, IOException, SSOException {
        String string = netletUser.getSSOToken().getProperty("_sessionKey");
        if (string == null) {
            byte[] byArray = new byte[32];
            this.sRandom.nextBytes(byArray);
            string = this.getSessionKey(byArray, netletUser.getSSOTokenID());
            netletUser.getSSOToken().setProperty("_sessionKey", string);
        }
        return string;
    }

    public String getStaticUrl() {
        try {
            return this.getServletConfig().getServletContext().getInitParameter("staticContext");
        }
        catch (NullPointerException nullPointerException) {
            this.debug.error("Cannot find init parameter - staticContext");
            return new String("/ips-static");
        }
    }

    public String getDynamicUrl() {
        try {
            return this.getServletConfig().getServletContext().getInitParameter("dynamicContext");
        }
        catch (NullPointerException nullPointerException) {
            this.debug.error("Cannot find init parameter - dynamicContext");
            return new String("/ips");
        }
    }

    public void redirectToPage(HttpServletResponse httpServletResponse, String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (string4 != null && string4.trim().length() != 0) {
                httpServletResponse.setContentType("text/html; charset=" + string4);
            } else {
                httpServletResponse.setContentType("text/html");
            }
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), string4)));
            ResourceBundle resourceBundle = null;
            resourceBundle = string3 == null || string3.trim().length() == 0 ? Locale.getInstallResourceBundle((String)"srapNetletServlet") : Locale.getResourceBundle((String)"srapNetletServlet", (String)string3);
            stringBuffer.append("<html>\n");
            stringBuffer.append("<BODY TEXT=\"").append(resourceBundle.getString("ntxcolor"));
            stringBuffer.append("\" BGCOLOR=\"").append(resourceBundle.getString("nbgcolor")).append("\">\n");
            stringBuffer.append("<p>").append(resourceBundle.getString(string));
            if (string2 != null && string2.trim().length() != 0) {
                stringBuffer.append(string2);
            }
            stringBuffer.append("</body>\n");
            stringBuffer.append("</html>\n");
            printWriter.print(stringBuffer.toString());
            printWriter.close();
        }
        catch (IOException iOException) {
            this.debug.error("Error redirecting to session invalid page." + iOException);
        }
    }

    public void storeProxySettings(NetletUser netletUser) {
        HttpServletRequest httpServletRequest = netletUser.getReq();
        UserAttributes userAttributes = netletUser.getNetletUserAttributes();
        try {
            userAttributes.setString("sunPortalNetletProxyType", httpServletRequest.getParameter("proxytype"));
            userAttributes.setString("sunPortalNetletProxyHost", httpServletRequest.getParameter("proxyhost"));
            userAttributes.setString("sunPortalNetletProxyPort", httpServletRequest.getParameter("proxyport"));
            userAttributes.setString("sunPortalNetletProxyOverride", httpServletRequest.getParameter("proxyoverride"));
        }
        catch (Exception exception) {
            this.debug.error("Exception in setting attribute: " + exception);
        }
        netletUser.setNetletUserAttributes(userAttributes);
        HttpServletResponse httpServletResponse = netletUser.getRes();
        try {
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("");
            printWriter.close();
        }
        catch (IOException iOException) {
            this.debug.error("Exception in sending respose : " + iOException);
        }
    }

    public void doReauth(NetletUser netletUser) {
        HttpServletRequest httpServletRequest = netletUser.getReq();
        String string = httpServletRequest.getParameter("password");
        String string2 = httpServletRequest.getContentType();
        if (string2 != null && string2.indexOf("multipart/form-data") != -1) {
            string = this.extractParameter(httpServletRequest, "password");
        }
        String string3 = this.verifyPassword(netletUser, string);
        this.writeResult(netletUser, string3);
    }

    public String verifyPassword(NetletUser netletUser, String string) {
        if (string == null || string.trim().length() == 0) {
            return "FAILED";
        }
        UserAttributes userAttributes = netletUser.getNetletUserAttributes();
        String string2 = userAttributes.getString("sunPortalNetletPassword", "srap-netlet");
        return string2.equals(string) ? "SUCCESS" : "FAILED";
    }

    public void writeResult(NetletUser netletUser, String string) {
        HttpServletResponse httpServletResponse = netletUser.getRes();
        try {
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println(string);
            printWriter.close();
        }
        catch (IOException iOException) {
            this.debug.error("Exception in sending respose : " + iOException);
        }
    }

    public String extractParameter(HttpServletRequest httpServletRequest, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            DataInputStream dataInputStream = new DataInputStream((InputStream)httpServletRequest.getInputStream());
            int n = httpServletRequest.getContentLength();
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            String string2 = new String(byArray, "ISO-8859-1");
            byArray = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                int n2 = string3.indexOf("=");
                if (n2 <= -1) continue;
                String string4 = string3.substring(0, n2);
                String string5 = string3.substring(n2 + 1);
                hashMap.put(string4, string5);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return URLDecoder.decode(hashMap.get(string).toString());
    }

    class NetletUser {
        private Hashtable netletRules = new Hashtable();
        private HttpServletRequest req = null;
        private HttpServletResponse res = null;
        private boolean portWarn = false;
        private boolean portwarnCheckbox = true;
        private boolean doReauth = false;
        private int defaultLoopbackPort = 8000;
        private String enc = null;
        private ResourceBundle bundle = null;
        private ResourceBundle appletBundle = null;
        private String HTMLcharsetname = null;
        private SSOToken ssoToken = null;
        private UserAttributes userAttrs = null;
        private Hashtable userCipherPreference = new Hashtable();
        private String defaultCipher = null;

        private SSOToken createSSOToken(HttpServletRequest httpServletRequest) {
            SSOToken sSOToken = null;
            String string = SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro");
            Cookie[] cookieArray = httpServletRequest.getCookies();
            if (cookieArray != null) {
                int n = 0;
                while (n < cookieArray.length) {
                    String string2 = cookieArray[n].getName();
                    if (string2 != null && string2.equals(string)) {
                        String string3 = cookieArray[n].getValue();
                        try {
                            sSOToken = SSOTokenManager.getInstance().createSSOToken(string3);
                        }
                        catch (SSOException sSOException) {
                            try {
                                sSOToken = SSOTokenManager.getInstance().createSSOToken(URLDecoder.decode(string3));
                            }
                            catch (SSOException sSOException2) {}
                        }
                        break;
                    }
                    ++n;
                }
            }
            return sSOToken;
        }

        public NetletUser(HttpServletRequest httpServletRequest) throws SSOException {
            this.req = httpServletRequest;
            this.ssoToken = this.createSSOToken(this.req);
            if (this.ssoToken == null) {
                throw new SSOException("NetletUser.java Can't get ssoToken");
            }
            this.userAttrs = new UserAttributes(this.ssoToken);
            this.enc = this.userAttrs.getUserAttribute("preferredlocale", Locale.getDefaultLocale().toString());
            this.HTMLcharsetname = this.findHTMLCharset(this.req);
            NetletConfig.this.debug.message("Netlet using encoding : " + this.enc + "  charset : " + this.HTMLcharsetname);
            this.bundle = Locale.getResourceBundle((String)"srapNetletServlet", (String)this.enc);
            this.appletBundle = Locale.getResourceBundle((String)"srapNetletApplet", (String)this.enc);
            this.defaultCipher = this.userAttrs.getString("sunPortalNetletKSSLDefaultCipher", "KSSL_SSL3_RSA_WITH_RC4_128_MD5") + "|" + this.userAttrs.getString("sunPortalNetletJSSEDefaultCipher", "SSL_RSA_WITH_RC4_128_MD5");
            List list = this.userAttrs.getStringList("sunPortalNetletUserCipher");
            int n = 0;
            while (n < list.size()) {
                String string = (String)list.get(n);
                int n2 = string.indexOf("|");
                if (n2 != -1) {
                    NetletConfig.this.debug.error("\nRule name -> " + string.substring(0, n2));
                    NetletConfig.this.debug.error("Cipher -> " + string.substring(n2 + 1));
                    this.userCipherPreference.put(string.substring(0, n2), string.substring(n2 + 1));
                }
                ++n;
            }
        }

        public String findHTMLCharset(HttpServletRequest httpServletRequest) {
            String string = null;
            AMClientDetector aMClientDetector = new AMClientDetector();
            String string2 = aMClientDetector.getClientType(httpServletRequest);
            try {
                Client client = Client.getInstance((String)string2);
                string = client.getCharset(Locale.getLocale((String)this.getLocale()));
            }
            catch (ClientException clientException) {
                NetletConfig.this.debug.error("NetletConfig: ClientException in determining charset, reading charset from properties file.");
                try {
                    string = this.getBundle().getString("HTMLcharset");
                }
                catch (Exception exception) {
                    NetletConfig.this.debug.error("NetletConfig: Exception in reading HTMLcharset from properties file, using ISO-8859-1.");
                    string = "ISO-8859-1";
                }
            }
            return string;
        }

        public String getAlgorithm(Rules rules) {
            String string = rules.name;
            if (string == null || string.trim().length() == 0) {
                return "SSL_RSA_WITH_RC4_128_MD5";
            }
            if (rules.algorithms == null || rules.algorithms.size() == 0) {
                return this.defaultCipher;
            }
            if (rules.algorithms.size() == 1) {
                return (String)rules.algorithms.get(0);
            }
            Object v = this.userCipherPreference.get(string);
            if (v == null || v.equals("null") || !rules.algorithms.contains(v)) {
                return (String)rules.algorithms.get(0);
            }
            return v.toString();
        }

        public String getDefaultCipher() {
            return this.defaultCipher;
        }

        public void getUserAttributes() throws SSOException {
            this.portWarn = this.userAttrs.getBoolean("sunPortalNetletPortWarn", true);
            this.doReauth = this.userAttrs.getBoolean("sunPortalNetletDoReauth", false);
            this.portwarnCheckbox = this.userAttrs.getBoolean("sunPortalNetletPortWarnCheckBox", true);
            this.defaultLoopbackPort = this.userAttrs.getInt("sunPortalNetletClientLoopbackPort", 8000);
            this.parseRules(new ArrayList(this.userAttrs.getStringList("sunPortalNetletRules")));
        }

        public boolean isAllowed() {
            return this.userAttrs == null ? false : this.userAttrs.isAllowed();
        }

        public String getDefaultRedirectURL() {
            String string = this.userAttrs.getUserAttribute("iplanet-am-auth-default-url");
            return string;
        }

        public int getDefaultLBPort() {
            return this.defaultLoopbackPort;
        }

        public boolean getPortWarn() {
            return this.portWarn;
        }

        public boolean getPortWarnCheckbox() {
            return this.portwarnCheckbox;
        }

        public boolean getReauth() {
            return this.doReauth;
        }

        public void addRule(Rules rules) {
            if (rules == null) {
                return;
            }
            this.netletRules.put(rules.name, rules);
        }

        public Enumeration getRules() {
            return this.netletRules.elements();
        }

        public Rules getRule(String string) {
            return (Rules)this.netletRules.get(string);
        }

        private void parseRules(ArrayList arrayList) {
            StringTokenizer stringTokenizer = null;
            String string = null;
            int n = 0;
            while (n < arrayList.size()) {
                block18: {
                    String string2 = (String)arrayList.get(n);
                    boolean bl = string2.endsWith("EXTEND");
                    if (bl) {
                        string2 = string2.substring(0, string2.lastIndexOf("|"));
                    }
                    Rules rules = new Rules();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "|");
                    try {
                        while (stringTokenizer2.hasMoreElements()) {
                            String string3;
                            string = (String)stringTokenizer2.nextElement();
                            stringTokenizer = new StringTokenizer(string, "^");
                            try {
                                rules.name = stringTokenizer.nextElement().toString();
                                string = stringTokenizer.nextElement().toString();
                                if (string.startsWith("ALGO")) {
                                    rules.isAlgoUserConfigurable = true;
                                    try {
                                        string = stringTokenizer.nextElement().toString();
                                    }
                                    catch (NoSuchElementException noSuchElementException) {
                                        string = this.defaultCipher;
                                    }
                                }
                                stringTokenizer = new StringTokenizer(string, "+");
                                while (stringTokenizer.hasMoreElements()) {
                                    rules.algorithms.add(stringTokenizer.nextElement());
                                }
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                rules.name = string;
                                rules.algorithms.add(this.defaultCipher);
                            }
                            rules.url = (String)stringTokenizer2.nextElement();
                            if (rules.url.equalsIgnoreCase("null")) {
                                rules.url = "";
                            }
                            if ((string3 = (String)stringTokenizer2.nextElement()).equalsIgnoreCase("false")) {
                                rules.loopback = false;
                            } else if (string3.equalsIgnoreCase("true")) {
                                rules.loopback = true;
                                rules.clientLoopbackPort = new String("" + this.defaultLoopbackPort + "");
                                rules.loopbackServer = NetletConfig.this.serverName;
                                rules.serverLoopbackPort = NetletConfig.this.serverPort;
                            } else {
                                StringTokenizer stringTokenizer3 = new StringTokenizer(string3, ":");
                                rules.loopback = true;
                                rules.clientLoopbackPort = (String)stringTokenizer3.nextElement();
                                rules.loopbackServer = (String)stringTokenizer3.nextElement();
                                rules.serverLoopbackPort = (String)stringTokenizer3.nextElement();
                                rules.lport.add(rules.clientLoopbackPort);
                                rules.dhost.add(rules.loopbackServer);
                                rules.dport.add(rules.serverLoopbackPort);
                                ++rules.ruleCount;
                            }
                            while (stringTokenizer2.hasMoreElements()) {
                                ++rules.ruleCount;
                                rules.lport.add(this.expandAttributes((String)stringTokenizer2.nextElement()));
                                rules.dhost.add(this.expandAttributes((String)stringTokenizer2.nextElement()));
                                rules.dport.add(this.expandAttributes((String)stringTokenizer2.nextElement()));
                            }
                            rules.isExtend = bl;
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        break block18;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.addRule(rules);
                }
                ++n;
            }
        }

        private String expandAttributes(String string) {
            int n = string.indexOf(36);
            if (n == -1) {
                return string;
            }
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = null;
            char[] cArray = string.toCharArray();
            while (n < cArray.length) {
                char c = cArray[n++];
                switch (n2) {
                    case 0: {
                        if (c == '$') {
                            n2 = 1;
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case 1: {
                        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                            stringBuffer2 = new StringBuffer();
                            stringBuffer2.append(c);
                            n2 = 2;
                            break;
                        }
                        if (c == '{') {
                            stringBuffer2 = new StringBuffer();
                            n2 = 3;
                            break;
                        }
                        n2 = 0;
                        break;
                    }
                    case 2: {
                        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-') {
                            stringBuffer2.append(c);
                            break;
                        }
                        stringBuffer.append(this.getAttr(stringBuffer2.toString()));
                        stringBuffer.append(c);
                        n2 = 0;
                        break;
                    }
                    case 3: {
                        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-') {
                            stringBuffer2.append(c);
                            break;
                        }
                        if (c == '}') {
                            stringBuffer.append(this.getAttr(stringBuffer2.toString()));
                            n2 = 0;
                            break;
                        }
                        n2 = 0;
                    }
                }
            }
            switch (n2) {
                case 1: {
                    break;
                }
                case 2: {
                    stringBuffer.append(this.getAttr(stringBuffer2.toString()));
                    break;
                }
            }
            String string2 = stringBuffer.toString();
            return string2;
        }

        private String getAttr(String string) {
            return this.userAttrs.getUserAttribute(string);
        }

        public void setReq(HttpServletRequest httpServletRequest) {
            this.req = httpServletRequest;
        }

        public HttpServletRequest getReq() {
            return this.req;
        }

        public void setRes(HttpServletResponse httpServletResponse) {
            this.res = httpServletResponse;
        }

        public HttpServletResponse getRes() {
            return this.res;
        }

        public String getLocale() {
            return this.enc;
        }

        public ResourceBundle getBundle() {
            return this.bundle;
        }

        public ResourceBundle getAppletBundle() {
            return this.appletBundle;
        }

        public String getHTMLcharsetname() {
            return this.HTMLcharsetname;
        }

        public SSOToken getSSOToken() {
            return this.ssoToken;
        }

        public SSOTokenID getSSOTokenID() {
            return this.ssoToken.getTokenID();
        }

        public UserAttributes getNetletUserAttributes() {
            return this.userAttrs;
        }

        public void setNetletUserAttributes(UserAttributes userAttributes) {
            this.userAttrs = userAttributes;
        }

        public String getClientHostName() throws SSOException {
            return this.ssoToken.getHostName();
        }

        public String getClientID() {
            if (this.ssoToken != null) {
                try {
                    String string = this.ssoToken.getPrincipal().getName();
                    String string2 = string.substring(string.indexOf("=") + 1, string.indexOf(","));
                    return string2;
                }
                catch (Exception exception) {
                    NetletConfig.this.debug.error("NetletConfig: Unable to get client ID -> " + exception);
                }
            }
            return "";
        }

        public boolean inPrivilegeList(String string, String string2, boolean bl, boolean bl2) {
            if (string2 == null) {
                return false;
            }
            boolean bl3 = false;
            ArrayList arrayList = new ArrayList(this.userAttrs.getStringList(string));
            if (arrayList != null) {
                int n = 0;
                while (n < arrayList.size()) {
                    String string3 = (String)arrayList.get(n);
                    if (string3.equals("*")) {
                        return true;
                    }
                    if (bl2 && !NetletConfig.this.isIPAddress(string3) && string3.indexOf(".") == -1 && NetletConfig.this.isValidHost(string3) && NetletConfig.this.serverDomain != null) {
                        string3 = string3 + ".";
                        string3 = string3 + NetletConfig.this.serverDomain;
                    }
                    if (bl3 = bl ? this.wildcardMatch(string2.toLowerCase(), string3.toLowerCase()) : this.wildcardMatch(string2, string3)) {
                        return true;
                    }
                    ++n;
                }
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        private boolean wildcardMatch(String var1_1, String var2_2) {
            block11: {
                var3_3 = 0;
                var4_4 = 0;
                var5_5 = 0;
                var6_6 = 0;
                var7_7 = var1_1.length();
                var8_8 = var2_2.length();
                var9_9 = null;
                if (var1_1 == null || var2_2 == null) {
                    return false;
                }
                var6_6 = var2_2.indexOf(42, var5_5);
                if (var6_6 == -1) break block11;
                var9_9 = var2_2.substring(var5_5, var6_6);
                if (var6_6 > var5_5) {
                    if ((var3_3 = var1_1.indexOf(var9_9, var3_3)) == -1) {
                        return false;
                    }
                    if (var3_3 != var5_5) {
                        return false;
                    }
                }
                var3_3 += var6_6 - var5_5;
                if (var6_6 >= var8_8 - 1) {
                    return true;
                }
                var5_5 = var6_6 + 1;
                if (true) ** GOTO lbl36
            }
            var3_3 = var1_1.indexOf(var2_2);
            if (var3_3 == -1) {
                return false;
            }
            return var7_7 == var8_8;
            do {
                var9_9 = var2_2.substring(var5_5, var6_6);
                if (var6_6 > var5_5 && (var3_3 = var1_1.indexOf(var9_9, var3_3)) == -1) {
                    return false;
                }
                var3_3 += var6_6 - var5_5;
                if (var6_6 >= var8_8 - 1) {
                    return true;
                }
                var5_5 = var6_6 + 1;
lbl36:
                // 2 sources

            } while ((var6_6 = var2_2.indexOf(42, var5_5)) != -1);
            var9_9 = var2_2.substring(var5_5, var8_8);
            var4_4 = var1_1.lastIndexOf(var9_9, var7_7 - 1);
            if (var4_4 == -1) {
                return false;
            }
            if (var3_3 > var4_4) {
                return false;
            }
            var3_3 = var4_4;
            return var7_7 - var3_3 == var8_8 - var5_5;
        }

        public String getEncryptionType() {
            StringTokenizer stringTokenizer;
            HttpServletRequest httpServletRequest = this.getReq();
            String string = httpServletRequest.getHeader("PS-Netlet");
            if (string != null && (stringTokenizer = new StringTokenizer(string, ";")).countTokens() == 2) {
                String string2 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken().trim();
                if ("encryption=ssl".equals(string2)) {
                    return "SSL";
                }
            }
            return "PLAIN";
        }
    }
}

