/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav.util.xml;

import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.xml.DOMWriter;
import com.aligo.pim.exchangewebdav.util.xml.DOMXMLable;
import com.aligo.pim.exchangewebdav.util.xml.DocumentFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtilities {
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$com$aligo$pim$exchangewebdav$util$xml$DOMXMLable;
    static /* synthetic */ Class class$java$lang$String;

    public static Element getFirstMatch(Element element, String tagName) {
        return XMLUtilities.getFirstMatch(element, tagName, false);
    }

    public static Element getFirstMatch(Element element, String tagName, boolean deep) {
        Element firstMatch = null;
        if (element != null) {
            if (deep) {
                NodeList list = element.getElementsByTagName(tagName);
                if (list != null && list.getLength() > 0) {
                    firstMatch = (Element)list.item(0);
                }
            } else {
                NodeList list = element.getChildNodes();
                if (list != null && list.getLength() > 0) {
                    int i = 0;
                    while (i < list.getLength()) {
                        Node next = list.item(i);
                        if (next instanceof Element && tagName.equals(((Element)next).getTagName())) {
                            firstMatch = (Element)next;
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
        return firstMatch;
    }

    public static Element getFirstElement(Element element) {
        NodeList list;
        Element firstMatch = null;
        if (element != null && (list = element.getChildNodes()) != null && list.getLength() > 0) {
            int i = 0;
            while (i < list.getLength() && firstMatch == null) {
                Node next = list.item(i);
                if (next instanceof Element) {
                    firstMatch = (Element)next;
                }
                ++i;
            }
        }
        return firstMatch;
    }

    public static String getPCData(Element element, String textElementTagName) {
        Element child;
        String text = null;
        if (element != null && (child = XMLUtilities.getFirstMatch(element, textElementTagName)) != null) {
            text = XMLUtilities.getPCData(child);
        }
        return text;
    }

    public static String getPCData(Element element) {
        NodeList list;
        String text = null;
        if (element != null && (list = element.getChildNodes()) != null && list.getLength() > 0) {
            int i = 0;
            while (i < list.getLength()) {
                Node next = list.item(i);
                if (next instanceof Text) {
                    text = ((Text)next).getData();
                    break;
                }
                ++i;
            }
        }
        return text;
    }

    public static void setPCData(Document document, Element parent, String text) {
        if (document != null && parent != null) {
            CharacterData textNode = null;
            NodeList list = parent.getChildNodes();
            if (list != null && list.getLength() > 0) {
                int i = 0;
                while (textNode == null && i < list.getLength()) {
                    Node next = list.item(i);
                    if (next instanceof Text) {
                        textNode = (Text)next;
                    }
                    ++i;
                }
            }
            if (textNode == null) {
                textNode = document.createTextNode(text);
                parent.appendChild(textNode);
            } else {
                textNode.setData(text);
            }
        }
    }

    public static Text createPCData(Document document, Element parent, String tagName, String text) {
        Text textNode = null;
        if (document != null && parent != null && tagName != null) {
            Element element = document.createElement(tagName);
            parent.appendChild(element);
            if (text != null) {
                textNode = document.createTextNode(text);
                element.appendChild(textNode);
            }
        }
        return textNode;
    }

    public static List getMatchingChildren(Element element, String tagName) {
        NodeList list;
        ArrayList<Node> matches = new ArrayList<Node>();
        if (element != null && tagName != null && (list = element.getChildNodes()) != null && list.getLength() > 0) {
            int i = 0;
            while (i < list.getLength()) {
                Node next = list.item(i);
                if (next != null && next instanceof Element && tagName.equals(((Element)next).getTagName())) {
                    matches.add(next);
                }
                ++i;
            }
        }
        return matches;
    }

    public static void printItem(Node node, String fileName) {
        try {
            FileOutputStream fout = new FileOutputStream(fileName);
            XMLUtilities.printItem(node, fout);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void printItem(Node node, File file) {
        try {
            FileOutputStream fout = new FileOutputStream(file);
            XMLUtilities.printItem(node, fout);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void printItem(Node node) {
        XMLUtilities.printItem(node, System.out);
    }

    public static void printItem(Node node, OutputStream output) {
        try {
            DOMWriter writer = new DOMWriter(output, false);
            writer.setIgnoreMessyText(true);
            writer.print(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void printItem(Node node, Writer writer) {
        try {
            DOMWriter domWriter = new DOMWriter(writer, false);
            domWriter.setIgnoreMessyText(true);
            domWriter.print(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String toXMLString(DOMXMLable xmlObject) {
        return XMLUtilities.toXMLString(xmlObject.toXMLElement());
    }

    public static String toXMLString(Node node) {
        String xmlString = null;
        try {
            StringWriter writer = new StringWriter();
            XMLUtilities.printItem(node, writer);
            xmlString = writer.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xmlString;
    }

    public static void fromXMLList(String tag, String classNameToInstantiate, Element masterElement, Object thisClass, Method methodToCall) {
        try {
            Iterator items = XMLUtilities.getMatchingChildren(masterElement, tag).iterator();
            boolean i = false;
            while (items.hasNext()) {
                Element next = (Element)items.next();
                Constructor<?> constr = Class.forName(classNameToInstantiate).getConstructor(class$org$w3c$dom$Element == null ? XMLUtilities.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element);
                Object act = constr.newInstance(next);
                methodToCall.invoke(thisClass, act);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static List fromXMLList(String childTag, Class childClass, Element listElement) {
        ArrayList childList = new ArrayList();
        try {
            Iterator items = XMLUtilities.getMatchingChildren(listElement, childTag).iterator();
            Constructor constructor = null;
            while (items.hasNext()) {
                Element next = (Element)items.next();
                try {
                    constructor = childClass.getConstructor(class$org$w3c$dom$Element == null ? XMLUtilities.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element);
                }
                catch (Exception e) {
                    constructor = null;
                }
                if (constructor != null) {
                    childList.add(constructor.newInstance(next));
                    continue;
                }
                if ((class$com$aligo$pim$exchangewebdav$util$xml$DOMXMLable == null ? XMLUtilities.class$("com.aligo.pim.exchangewebdav.util.xml.DOMXMLable") : class$com$aligo$pim$exchangewebdav$util$xml$DOMXMLable).isAssignableFrom(childClass)) {
                    Object obj = childClass.newInstance();
                    ((DOMXMLable)obj).fromXMLElement(next);
                    childList.add(obj);
                    continue;
                }
                try {
                    constructor = childClass.getConstructor(class$java$lang$String == null ? XMLUtilities.class$("java.lang.String") : class$java$lang$String);
                }
                catch (Exception e) {
                    constructor = null;
                }
                if (constructor != null) {
                    String pcData = XMLUtilities.getPCData(next);
                    childList.add(constructor.newInstance(pcData));
                    continue;
                }
                throw new IllegalArgumentException("The Class passed into the fromXMLList method does not implement  DOMXMLable.  This can therfore not be fromXMLed....");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return childList;
    }

    public static Element toXMLList(Collection list, Document document, String masterTag) {
        Element masterElement = null;
        try {
            masterElement = document.createElement(masterTag);
            XMLUtilities.toXMLList(list, document, masterElement);
        }
        catch (Exception e) {
            // empty catch block
        }
        return masterElement;
    }

    public static void toXMLList(Collection list, Document document, Element masterElement) {
        try {
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                Object next;
                if (!(class$com$aligo$pim$exchangewebdav$util$xml$DOMXMLable == null ? XMLUtilities.class$("com.aligo.pim.exchangewebdav.util.xml.DOMXMLable") : class$com$aligo$pim$exchangewebdav$util$xml$DOMXMLable).isAssignableFrom((next = itr.next()).getClass())) continue;
                Element childElement = ((DOMXMLable)next).toXMLElement(document);
                masterElement.appendChild(childElement);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Element toXMLList(Collection list, Document document, String masterTag, String childTag) {
        Element masterElement = null;
        try {
            masterElement = document.createElement(masterTag);
            XMLUtilities.toXMLList(list, document, masterElement, childTag);
        }
        catch (Exception e) {
            // empty catch block
        }
        return masterElement;
    }

    public static void toXMLList(Collection list, Document document, Element masterElement, String childTag) {
        try {
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                Object next;
                if ((class$com$aligo$pim$exchangewebdav$util$xml$DOMXMLable == null ? XMLUtilities.class$("com.aligo.pim.exchangewebdav.util.xml.DOMXMLable") : class$com$aligo$pim$exchangewebdav$util$xml$DOMXMLable).isAssignableFrom((next = itr.next()).getClass())) {
                    Element childElement = ((DOMXMLable)next).toXMLElement(document);
                    masterElement.appendChild(childElement);
                    continue;
                }
                XMLUtilities.createPCData(document, masterElement, childTag, next.toString());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static String toXMLStringNS(Node node) {
        try {
            String str = XMLUtilities.toXMLString(node);
            return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n" + str;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getValue(String responseText, WebDavField webDavField) throws ExWebDavPimException {
        return XMLUtilities.getValue(responseText, webDavField.getNameSpace().getActualNameSpace(), webDavField.getPropertyName());
    }

    public static Element getValueAsElement(String responseText, WebDavField webDavField) throws ExWebDavPimException {
        return XMLUtilities.getValueAsElement(responseText, webDavField, 0);
    }

    public static Element getValueAsElement(String responseText, WebDavField webDavField, int itemNumber) throws ExWebDavPimException {
        return XMLUtilities.getValueAsElement(DocumentFactory.openStringAsDom(responseText), webDavField.getNameSpace().getActualNameSpace(), webDavField.getPropertyName(), itemNumber);
    }

    public static String getValue(Document doc, WebDavField webDavField) throws ExWebDavPimException {
        return XMLUtilities.getValue(doc, webDavField.getNameSpace().getActualNameSpace(), webDavField.getPropertyName());
    }

    public static String getValue(String responseText, WebDavField webDavField, int itemNumber) throws ExWebDavPimException {
        return XMLUtilities.getValue(responseText, webDavField.getNameSpace().getActualNameSpace(), webDavField.getPropertyName(), itemNumber);
    }

    public static String getValue(Document doc, WebDavField webDavField, int itemNumber) throws ExWebDavPimException {
        return XMLUtilities.getValue(doc, webDavField.getNameSpace().getActualNameSpace(), webDavField.getPropertyName(), itemNumber);
    }

    public static String getValue(Element element, WebDavField webDavField, int itemNumber) throws ExWebDavPimException {
        try {
            return XMLUtilities.getValue(element, webDavField.getNameSpace().getActualNameSpace(), webDavField.getPropertyName(), itemNumber);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public static String getValue(Element element, WebDavField webDavField) throws ExWebDavPimException {
        try {
            return XMLUtilities.getValue(element, webDavField.getNameSpace().getActualNameSpace(), webDavField.getPropertyName(), 0);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public static String getValue(Element element, String namespace, String localName, int itemNumber) throws ExWebDavPimException {
        try {
            NodeList nodeList = element.getElementsByTagNameNS(namespace, localName);
            if (nodeList.getLength() >= 1) {
                Element actualelement = (Element)nodeList.item(itemNumber);
                if (actualelement == null) {
                    return null;
                }
                return XMLUtilities.getPCData(actualelement);
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public static int getNumOfElements(String responseText, WebDavField webDavField) throws ExWebDavPimException {
        try {
            Document document = DocumentFactory.openStringAsDom(responseText);
            return XMLUtilities.getNumOfElements(document, webDavField);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public static int getNumOfElements(Element element, WebDavField webDavField) throws ExWebDavPimException {
        try {
            NodeList nodeList = element.getElementsByTagNameNS(webDavField.getNameSpace().getActualNameSpace(), webDavField.getPropertyName());
            if (nodeList != null) {
                return nodeList.getLength();
            }
            return 0;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public static int getNumOfElements(Document doc, WebDavField webDavField) throws ExWebDavPimException {
        try {
            NodeList nodeList = doc.getElementsByTagNameNS(webDavField.getNameSpace().getActualNameSpace(), webDavField.getPropertyName());
            if (nodeList != null) {
                return nodeList.getLength();
            }
            return 0;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public static Element getValueAsElement(Element element, WebDavField webDavField, int itemNumber) throws ExWebDavPimException {
        return XMLUtilities.getValueAsElement(element, webDavField.getNameSpace().getActualNameSpace(), webDavField.getPropertyName(), 0);
    }

    public static Element getValueAsElement(Element melement, String namespace, String localName, int itemNumber) throws ExWebDavPimException {
        try {
            NodeList nodeList = melement.getElementsByTagNameNS(namespace, localName);
            if (nodeList.getLength() >= 1) {
                Element element = (Element)nodeList.item(itemNumber);
                return element;
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public static Element getValueAsElement(Element element, WebDavField webDavField) throws ExWebDavPimException {
        return XMLUtilities.getValueAsElement(element, webDavField, 0);
    }

    public static Element getValueAsElement(Document doc, WebDavField webDavField, int itemNumber) throws ExWebDavPimException {
        return XMLUtilities.getValueAsElement(doc, webDavField.getNameSpace().getActualNameSpace(), webDavField.getPropertyName(), itemNumber);
    }

    public static Element getValueAsElement(Document doc, String namespace, String localName, int itemNumber) throws ExWebDavPimException {
        try {
            NodeList nodeList = doc.getElementsByTagNameNS(namespace, localName);
            if (nodeList.getLength() >= 1) {
                Element element = (Element)nodeList.item(itemNumber);
                return element;
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public static String getValue(Document doc, String namespace, String localName, int itemNumber) throws ExWebDavPimException {
        try {
            Element element = XMLUtilities.getValueAsElement(doc, namespace, localName, itemNumber);
            if (element == null) {
                return null;
            }
            return XMLUtilities.getPCData(element);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public static String getValue(String responseText, String namespace, String localName, int itemNumber) throws ExWebDavPimException {
        try {
            return XMLUtilities.getValue(DocumentFactory.openStringAsDom(responseText), namespace, localName, itemNumber);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public static String getValue(String responseText, String namespace, String localName) throws ExWebDavPimException {
        return XMLUtilities.getValue(responseText, namespace, localName, 0);
    }

    public static String getValue(Document doc, String namespace, String localName) throws ExWebDavPimException {
        return XMLUtilities.getValue(doc, namespace, localName, 0);
    }

    public static Element getValue(Document doc, String tagname) throws ExWebDavPimException {
        try {
            Element element;
            NodeList nodeList = doc.getElementsByTagName(tagname);
            if (nodeList.getLength() >= 1 && (element = (Element)nodeList.item(0)) != null) {
                return element;
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public static List getElements(Document doc, String tagname, String attributeName, String withValue) throws ExWebDavPimException {
        try {
            NodeList nodeList = doc.getElementsByTagName(tagname);
            ArrayList<Element> listOfElements = new ArrayList<Element>();
            int i = 0;
            while (i < nodeList.getLength()) {
                Element element = (Element)nodeList.item(0);
                String elementAttrName = element.getAttribute(attributeName);
                if (elementAttrName != null && elementAttrName.equals(withValue)) {
                    listOfElements.add(element);
                }
                ++i;
            }
            return listOfElements;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

