/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav.util.xml;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HtmlNode {
    private String name = "";
    private String text = "";
    private Vector children = new Vector();
    private Hashtable attributes = new Hashtable();
    boolean end = false;
    boolean visible = true;

    public void setName(String inName) {
        this.name = inName;
    }

    public void addNode(HtmlNode node) {
        if (node != null) {
            this.children.addElement(node);
        }
    }

    public void addAttribute(String name, String value) {
        if (name != null && !name.equals("")) {
            if (value == null) {
                value = "";
            }
            this.attributes.put(name, value);
        }
    }

    public void setText(String inText) {
        this.text = inText;
    }

    public void setEnd(boolean inEnd) {
        this.end = inEnd;
    }

    public void setVisible(boolean inVisible) {
        this.visible = inVisible;
    }

    public String print() {
        StringBuffer contents = new StringBuffer("");
        int number = this.children.size();
        boolean endTag = false;
        if (this.visible && !this.name.equals("")) {
            contents.append("<").append(this.name);
            Enumeration keys = this.attributes.keys();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                String value = (String)this.attributes.get(name);
                contents.append(" ").append(name).append("=").append("\"").append(value).append("\"");
            }
            if (number == 0 || !this.end) {
                endTag = true;
                contents.append("/>");
            } else {
                contents.append(">");
            }
        }
        if (this.visible && !this.text.equals("")) {
            contents.append(this.text);
        }
        int i = 0;
        while (i < number) {
            HtmlNode node = (HtmlNode)this.children.elementAt(i);
            contents.append(node.print());
            ++i;
        }
        if (this.visible && !this.name.equals("") && !endTag) {
            contents.append("</").append(this.name).append(">");
        }
        return contents.toString();
    }
}

