/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav.util;

import HTTPClient.HTTPResponse;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimRequestResponse;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.xml.DocumentFactory;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExWebDavPimMessageItemsCache {
    private ExWebDavPimSession m_oPimSession;
    private ExWebDavPimRequestResponse m_oCountReqRes;
    private ExWebDavPimRequestResponse m_oAllItemsReqRes;
    private String m_szXmlResponse;
    private Document m_oDocument;
    private boolean m_bCanItBeLoaded;

    public ExWebDavPimMessageItemsCache(ExWebDavPimSession pimSession) {
        this.m_oPimSession = pimSession;
    }

    public void setCountReqRes(ExWebDavPimRequestResponse reqres) {
        this.m_oCountReqRes = reqres;
    }

    public ExWebDavPimSession getPimSession() {
        return this.m_oPimSession;
    }

    public void setAllItemsReqRes(ExWebDavPimRequestResponse reqres) {
        this.m_oAllItemsReqRes = reqres;
        this.m_bCanItBeLoaded = true;
    }

    public int getNumOfElements() throws ExWebDavPimException {
        if (!this.m_bCanItBeLoaded) {
            return -1;
        }
        this.load();
        return XMLUtilities.getNumOfElements(this.m_oDocument, WebDavField.RESPONSE);
    }

    public void load() throws ExWebDavPimException {
        try {
            if (this.m_bCanItBeLoaded && (this.m_szXmlResponse == null || this.m_oDocument == null)) {
                HTTPResponse response = this.getPimSession().getHttpConnector().sendRequest(this.m_oAllItemsReqRes.getRequestMethod(), this.m_oAllItemsReqRes.getRequestFolder(), this.m_oAllItemsReqRes.getRequestXml());
                String str = response.getHeader("Content-Type");
                if (str != null && str.indexOf("charset") == -1) {
                    byte[] b = response.getData();
                    this.m_szXmlResponse = new String(b, "UTF-8");
                } else {
                    this.m_szXmlResponse = response.getText();
                }
                this.m_oDocument = DocumentFactory.openStringAsDom(this.m_szXmlResponse);
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public Element getElement(int itemNumber) throws ExWebDavPimException {
        try {
            this.load();
            return XMLUtilities.getValueAsElement(this.m_oDocument, WebDavField.RESPONSE, itemNumber);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getID(int itemNumber) throws ExWebDavPimException {
        try {
            if (this.m_szXmlResponse == null || this.m_oDocument == null) {
                HTTPResponse response = this.getPimSession().getHttpConnector().sendRequest(this.m_oAllItemsReqRes.getRequestMethod(), this.m_oAllItemsReqRes.getRequestFolder(), this.m_oAllItemsReqRes.getRequestXml());
                this.m_szXmlResponse = response.getText();
                this.m_oDocument = DocumentFactory.openStringAsDom(this.m_szXmlResponse);
            }
            return XMLUtilities.getValue(this.m_oDocument, WebDavField.UID, itemNumber);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }
}

