/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.lotus.LotusPimAddressEntryItem;
import com.aligo.pim.lotus.LotusPimDummyAddressEntryItem;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Vector;
import lotus.domino.Document;
import lotus.domino.Session;
import lotus.domino.View;
import lotus.domino.ViewEntry;
import lotus.domino.ViewEntryCollection;

public class LotusPimUtility {
    private static String getFullName(String string) {
        if (string.indexOf("=") == -1) {
            return null;
        }
        return string.substring(string.indexOf("=") + 1, string.indexOf("/"));
    }

    private static View getLotusPublicAddressBookView(Session session, LotusPimSession lotusPimSession, Recycle recycle) throws LotusPimException {
        try {
            return lotusPimSession.getLotusPublicAddressBookPeopleView();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private static View getLotusPersonalAddressBookView(LotusPimSession lotusPimSession, Recycle recycle) throws LotusPimException {
        try {
            return lotusPimSession.getLotusPersonalAddressBookView();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public static PimAddressEntryItem getAddressEntryItem(Session session, LotusPimSession lotusPimSession, Recycle recycle) throws LotusPimException {
        try {
            return LotusPimUtility.getAddressEntryItem(session, session.getUserName(), lotusPimSession, recycle);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public static PimAddressEntryItem getAddressEntryItem(Session session, String string, String string2, LotusPimSession lotusPimSession, Recycle recycle) throws LotusPimException {
        try {
            View view;
            if (string2.indexOf("CN=") != -1) {
                return LotusPimUtility.getAddressEntryItem(session, string2, lotusPimSession, recycle);
            }
            if (string2.indexOf("<") != -1) {
                string2 = string2.substring(string2.indexOf("<") + 1, string2.indexOf(">"));
            }
            if ((view = LotusPimUtility.getLotusPublicAddressBookView(session, lotusPimSession, recycle)) == null) {
                return new LotusPimDummyAddressEntryItem(string2, lotusPimSession, recycle);
            }
            ViewEntryCollection viewEntryCollection = view.getAllEntries();
            recycle.add(viewEntryCollection);
            ViewEntry viewEntry = null;
            try {
                viewEntryCollection.FTSearch("FIELD " + string + " CONTAINS " + string2);
                viewEntry = viewEntryCollection.getFirstEntry();
                recycle.add(viewEntry);
            }
            catch (Exception exception) {
                return new LotusPimDummyAddressEntryItem(string2, lotusPimSession, recycle);
            }
            if (viewEntry == null) {
                return new LotusPimDummyAddressEntryItem(string2, lotusPimSession, recycle);
            }
            LotusPimAddressEntryItem lotusPimAddressEntryItem = new LotusPimAddressEntryItem(viewEntry, lotusPimSession, recycle);
            return lotusPimAddressEntryItem;
        }
        catch (Exception exception) {
            return new LotusPimDummyAddressEntryItem(string2, lotusPimSession, recycle);
        }
    }

    public static PimAddressEntryItem getAddressEntryItem(Session session, String string, LotusPimSession lotusPimSession, Recycle recycle) throws LotusPimException {
        try {
            LotusPimAddressEntryItem lotusPimAddressEntryItem;
            View view = LotusPimUtility.getLotusPublicAddressBookView(session, lotusPimSession, recycle);
            if (view == null) {
                return null;
            }
            String string2 = LotusPimUtility.getFullName(string);
            if (string2 == null) {
                return new LotusPimDummyAddressEntryItem(string, lotusPimSession, recycle);
            }
            ViewEntryCollection viewEntryCollection = view.getAllEntries();
            recycle.add(viewEntryCollection);
            viewEntryCollection.FTSearch("FIELD FullName CONTAINS " + string2);
            ViewEntry viewEntry = viewEntryCollection.getFirstEntry();
            while (viewEntry != null) {
                String string3;
                Vector vector;
                recycle.add(viewEntry);
                if (viewEntry.isDocument() && (lotusPimAddressEntryItem = viewEntry.getDocument()).hasItem("FullName") && (vector = lotusPimAddressEntryItem.getItemValue("FullName")).size() > 0 && (string3 = (String)vector.elementAt(0)).equals(string)) break;
                viewEntry = viewEntryCollection.getNextEntry();
            }
            if (viewEntry == null) {
                return new LotusPimDummyAddressEntryItem(string2, lotusPimSession, recycle);
            }
            lotusPimAddressEntryItem = new LotusPimAddressEntryItem(viewEntry, lotusPimSession, recycle);
            return lotusPimAddressEntryItem;
        }
        catch (Exception exception) {
            return new LotusPimDummyAddressEntryItem(string, lotusPimSession, recycle);
        }
    }

    public static boolean checkIfCanonicalName(String string) {
        return string.indexOf("=") != -1;
    }

    public static ViewEntry checkIfInPersonalAddressBook(String string, LotusPimSession lotusPimSession, Recycle recycle) throws LotusPimException {
        try {
            View view = LotusPimUtility.getLotusPersonalAddressBookView(lotusPimSession, recycle);
            if (view == null) {
                return null;
            }
            if (LotusPimUtility.checkIfCanonicalName(string)) {
                return null;
            }
            ViewEntryCollection viewEntryCollection = view.getAllEntries();
            recycle.add(viewEntryCollection);
            if (LotusPimUtility.checkIfEmailAddress(string)) {
                viewEntryCollection.FTSearch("FIELD InternetAddress CONTAINS " + string);
            } else {
                viewEntryCollection.FTSearch("FIELD FullName CONTAINS " + string);
            }
            ViewEntry viewEntry = viewEntryCollection.getFirstEntry();
            if (viewEntry != null) {
                recycle.add(viewEntry);
            }
            return viewEntry;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean checkIfEmailAddress(String string) {
        return string.indexOf("@") != -1;
    }

    public static ViewEntry checkIfInPublicAddressBook(String string, LotusPimSession lotusPimSession, Recycle recycle) throws LotusPimException {
        try {
            View view = LotusPimUtility.getLotusPublicAddressBookView(lotusPimSession.getLotusSession(), lotusPimSession, recycle);
            if (view == null) {
                return null;
            }
            String string2 = string;
            boolean bl = LotusPimUtility.checkIfCanonicalName(string);
            if (bl) {
                string2 = LotusPimUtility.getFullName(string);
            }
            ViewEntryCollection viewEntryCollection = view.getAllEntries();
            recycle.add(viewEntryCollection);
            if (LotusPimUtility.checkIfEmailAddress(string2)) {
                viewEntryCollection.FTSearch("FIELD InternetAddress CONTAINS " + string);
            } else {
                viewEntryCollection.FTSearch("FIELD FullName CONTAINS " + string2);
            }
            if (bl) {
                ViewEntry viewEntry = viewEntryCollection.getFirstEntry();
                while (viewEntry != null) {
                    String string3;
                    Vector vector;
                    Document document;
                    recycle.add(viewEntry);
                    if (viewEntry.isDocument() && (document = viewEntry.getDocument()).hasItem("FullName") && (vector = document.getItemValue("FullName")).size() > 0 && (string3 = (String)vector.elementAt(0)).equals(string)) break;
                    viewEntry = viewEntryCollection.getNextEntry();
                }
                return viewEntry;
            }
            ViewEntry viewEntry = viewEntryCollection.getFirstEntry();
            if (viewEntry != null) {
                recycle.add(viewEntry);
            }
            return viewEntry;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

